; bc.xm: Binary file Compare unicum
; /AJK 10.Aug.81, 27.Aug.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

BufSiz	equ	8192		; input buffer size
PerLin	equ	16		; bytes per line to write

	db	'BC V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

	entry bc
bc:
	HEAhea [hl=0100h]	; initialize stack and heap
	USKini []		; scan command
	USKgna []->[(file1)=hl]+C-a ; get first file name
	jr	c,bc1
	USKgna []->[(file2)=hl]+C-a ; get second file name
	jr	nc,bc2
bc1:
	EPUTF [stk="Usage: bc file1 file2^m^j"]
	SHLexi [a=1]
bc2:

; Open the files.
	ld	hl,(file1)	; open the first file
	BBIopn [stk=hl,stk=RO+Binary+OldOnly,stk=BufSiz]->[(chan1)=a]+C
	jp	c,bc14		; branch if unsuccessful open
	ld	hl,(file2)	; open the second file
	BBIopn [stk=hl,stk=RO+Binary+OldOnly,stk=BufSiz]->[(chan2)=a]+C
	jp	c,bc14

; Initialize counters and flags
	xor	a
	ld	(eof1),a	; indicate no EOF yet on first file
	ld	(eof2),a	; no EOF yet on second file
	ld	h,a
	ld	l,a
	ld	(pos),hl	; pos is (long) current position in file
	ld	(pos+2),hl

; Loop for each mouthful of data.
; Read two chunks and compare.
bc3:
	ld	a,(eof1)	; see if we can read from file 1
	and	a
	jr	nz,bc5		; if not, don't bother trying
	BBIrea [stk=(chan1),stk=buf1,stk=PerLin]->[hl]+C-a
	jr	c,bc4		; branch if EOF
	ld	de,PerLin	; check for short read from first file
	sbc	hl,de		; (carry is clear from IO.rea)
	jr	z,bc5		; branch if buffer filled
bc4:
	ld	a,1		; treat all short reads as EOF
	ld	(eof1),a
bc5:
	ld	a,(eof2)	; see if we can read from file 2
	and	a
	jr	nz,bc7
	BBIrea [stk=(chan2),stk=buf2,stk=PerLin]->[hl]+C-a
	jr	c,bc6		; branch if EOF
	ld	de,PerLin	; check for short read from second file
	sbc	hl,de
	jr	z,bc7		; branch if buffer filled
bc6:
	ld	a,1		; treat short reads as EOF
	ld	(eof2),a

; Here after reads.
; If EOF has occurred on both files, finish up.
; If EOF has occurred on only one file, publish the other file's data.
; Otherwise publish the data from both files, with exclusive-or.
bc7:
	ld	a,(eof1)
	ld	b,a		; B has file 1 EOF flag
	ld	a,(eof2)
	ld	c,a		; C has file 2 EOF flag
	and	b		; A is nonzero if both files finished
	jp	nz,bc13		; branch if all done
	ld	a,b
	or	c		; A is nonzero if either file finished
	jr	nz,bc9		; branch if so, must publish

; Here if we were able to read data from both files.
; Compare the data; if there's no difference, there's nothing here to publish.
	ld	b,PerLin	; B counts bytes
	ld	de,buf1		; DE points within first buffer
	ld	hl,buf2		; HL points within second buffer
bc8:
	ld	a,(de)		; get next byte from first buffer
	inc	de
	cp	(hl)		; compare with next byte from second buffer
	inc	hl
	jr	nz,bc9		; branch if they aren't equal
	djnz	bc8		; loop for all bytes
	jr	bc12		; branch if no difference, skip this bufferful

; Here to publish.
; Start with data from first file.
bc9:
	ld	a,(eof1)	; A = EOF flag
	ld	hl,buf1		; HL -> data
	call	pub		; publish data for this file

; Now to data from second file.
	ld	a,(eof2)	; A = EOF flag
	ld	hl,buf2		; HL -> data
	call	pub		; publish data for this file

; If neither file has encountered EOF, then publish the exclusive-or of
; the data from both files.
	ld	a,(eof1)
	ld	b,a
	ld	a,(eof2)
	or	b
	jr	nz,bc11		; branch if an EOF has occurred
	OPUTF [stk="       "]	; skip over address portion
	ld	b,PerLin	; bytes per line to publish
	ld	de,buf1		; DE -> first buffer
	ld	hl,buf2		; HL -> second buffer
bc10:
	ld	a,(de)
	inc	de
	xor	(hl)		; A = exclusive-or of corresponding bytes
	inc	hl
	OPUTF [stk=" %pb",stk=af]
	djnz	bc10
	OPUTF [stk="^m^j"]	; end line

; Here when done with a line of output.
bc11:
	OPUTF [stk="^m^j"]	; throw a blank line

; Here when done with two buffers, whether they've been printed or not.
bc12:
	ld	de,PerLin	; advance "pos" to next line
	ld	hl,(pos+2)
	add	hl,de
	ld	(pos+2),hl
	ld	hl,(pos)
	ld	de,0
	adc	hl,de
	ld	(pos),hl
	jp	bc3		; go do next mouthful

; Here when EOF has occurred for both files.
bc13:
	SHLexi [a=1]

; Here on error.
bc14:
	ERRMSG [a=a,b=1,c=1,hl=hl]

; Routine to publish data for one line.
; Enter with A = eof flag, HL -> buffer.
pub:
	OPUTF [stk="%6lh:",stk=(pos),stk=(pos+2)] ; publish address
	ld	b,PerLin	; B = bytes to publish
	and	a		; see if EOF has occurred
	jr	z,pub2		; branch if it hasn't
pub1:
	OPUTF [stk=" .."]	; publish eof indicator
	djnz	pub1
	jr	pub3		; go throw carriage return
pub2:				; here if there's data to do
	ld	a,(hl)		; A = next byte
	inc	hl
	OPUTF [stk=" %pb",stk=af] ; publish it
	djnz	pub2
pub3:
	OPUTF [stk="^m^j"]	; finish line
	ret

pos:	ds	4		; (long) current position, byte number
file1:	ds	2		; file 1 name
file2:	ds	2		; file 2 name
chan1:	ds	1		; file 1 channel
chan2:	ds	1		; file 2 channel
eof1:	ds	1		; file 1 EOF flag
eof2:	ds	1		; file 2 EOF flag
buf1:	ds	PerLin		; file 1 buffer
buf2:	ds	PerLin		; file 2 buffer

	end bc
