; cp.xm: file CoPy unicum
; /AJK 19.Jul.81, 27.Aug.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'CP V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

FCBSIZ	equ	37		; FCB size (includes user number)

; We manipulate a singly-linked list structure which looks like this:
STnxt	equ	0		; (word) pointer to next, or zero
STsts	equ	2		; (byte) status, bits defined below
STattr	equ	3		; (byte) oldfile attributes
STsecs	equ	4		; (word) number of sectors in the buffer
SToldf	equ	6		; (string) old filename
STnewf	equ	SToldf+FNPmfn+1	; (string) new filename
STofcb	equ	STnewf+FNPmfn+1	; (array) old FCB
STnfcb	equ	STofcb+FCBSIZ	; (array) new FCB
STLEN	equ	STnfcb+FCBSIZ	; size of structure

; Bits in status word (STsts):
STSopn	equ	0		; file is open for input (was found)
STScre	equ	1		; file is open for output (was created)
STSeof	equ	2		; input end-of-file has occurred
STSdon	equ	3		; output is complete
STSerr	equ	4		; error occurred (couldn't create or write)

; The following are the interpretations placed on combinations of the
; status bits (* means don't care):
; STSopn
; | STScre
; | | STSeof
; | | | STSdon
; | | | | STSerr
; | | | | |
; 0 0 0 0 0  -- file has not yet been opened or was not successfully opened
; 1 0 0 0 0  -- file has been opened but not created.  It has been read if
;               STsecs is nonzero.
; 1 1 0 0 0  -- file has been opened and created.  It has been read if
;               STsecs is nonzero.
; 1 1 1 0 0  -- file has been read to completion.
; 1 1 1 1 0  -- file has been read and written to completion.
; 1 0 * 0 1  -- file could not be created.  If STsecs is nonzero, there is
;               data in the buffer to be discarded.
; 0 0 0 0 1  -- Either file could not be created and any buffered data has been
;               discarded, or a write error occurred for file and it has been
;               deleted and the buffered data discarded.

; TALK procedure: if -t was specified, do a OPUTF, else do nothing.
	proc TALK [FORMAT:stk,VALS:stk*]
	begin
	push	af		; save A and condition codes
	ld	a,(tflg)	; see if -t was specified
	and	a
	jr	z,talk1		; branch if it wasn't
	pop	af		; restore A and condition codes
	jp	OPUTF##		; go do the OPUTF and return
talk1:				; here if -t wasn't specified
	pop	af		; restore A and condition codes
	end TALK		; just return

	entry cp
cp:
	HEAhea [hl=0100h]	; initialize stack and heap
	USKini []		; scan command
	USKflg [hl=flgtbl]	; interpret flags

; Make a list of pairs of files to copy, and allocate the input and
; output FCBs for each.
	ld	hl,0		; zero the list header
	ld	(listhd),hl
	ld	hl,listhd	; set end-of-list pointer to point to header
	ld	(eol),hl
cp1:
	USKbnf [stk=(nflg),stk=(vflg),stk=0]->[ix=stk,bc=stk,de=stk,iy=stk]+C-a
				; IX -> old filename
				; C = attributes
				; BDE = size in sectors
				; IY -> new filename
	jr	c,cp2		; branch when files exhausted
	USKall [hl=STLEN]->[hl]	; allocate a structure
	ex	de,hl		; DE -> structure
	ld	hl,(eol)	; HL -> last element in list
	SLLins [de=de,hl=hl]	; insert new element at end of list
	ex	de,hl		; now HL -> new structure
	ld	(eol),hl	; that's new end-of-list
	inc	hl
	inc	hl		; HL -> status field
	ld	(hl),0		; turn off all status bits
	inc	hl		; HL -> attribute field
	ld	(hl),c		; store attributes
	inc	hl		; HL -> "sectors in buffer" count
	ld	(hl),0		; zero it for now
	inc	hl
	ld	(hl),0
	inc	hl		; HL -> "old filename string" field
	ld	bc,FNPmfn+1	; BC = max filename length, plus 1 for null
	STRcpy [de=ix,hl=hl,bc=bc] ; copy in the old filename
	add	hl,bc		; HL -> "new filename string" field
	STRcpy [de=iy,hl=hl,bc=bc] ; copy in the new filename
	jr	cp1		; loop for next filename pair

; Here when all file pairs have been loaded into the list.
; Check for empty list (no file pairs).
cp2:
	ld	hl,(listhd)	; HL -> first list element
	ld	a,h
	or	l
	jr	nz,cp3		; branch if list isn't empty
	EPUTF [stk="no files to copy^m^j"]
	SHLexi [a=1]
cp3:

; If -s was specified, rearrange the list to put all system files before
; all non-system files.  Do this by creating two lists, one for system
; files and one for user files, and then tacking the user list onto the
; end of the system list.
	ld	a,(sflg)	; see if -s was specified
	and	a
	jr	z,cp7		; branch if list should not be resorted
	ld	hl,0		; make empty lists for system and user files
	ld	(slist),hl
	ld	(ulist),hl
	ld	hl,slist	; set system end-of-list pointer
	ld	(seol),hl
	ld	hl,ulist	; set user end-of-list pointer
	ld	(ueol),hl
cp4:				; here to move one structure
	SLLdel [hl=listhd]->[de,bc]+C ; remove next list element
				; DE -> next structure, or 0 for end of list
	ld	a,d		; check for end of list
	or	e
	jr	z,cp6		; branch when encountered
	ld	hl,STattr
	add	hl,de		; HL -> attribute byte in structure
	bit	1,(hl)		; is this a system file or a user file?
	jr	z,cp5		; branch for user file
	SLLins [de=de,hl=(seol)]; insert structure into system list
	ld	(seol),de	; store new system end-of-list pointer
	jr	cp4		; loop for next structure
cp5:				; here if user file
	SLLins [de=de,hl=(ueol)]; insert structure into user list
	ld	(ueol),de	; store new user end-of-list pointer
	jr	cp4		; loop for next structure
cp6:				; here when the two separate lists are complete
	SLLatt [hl=(seol),de=(ulist)] ; tack the user list onto the system list
	ld	hl,(slist)	; HL -> system list + user list
	ld	(listhd),hl	; make that the new operative list

; Here when the list is organized as desired.
; Open the input files.
cp7:
	ld	bc,(listhd)	; BC -> first list element
cp8:				; here to open a file, BC -> structure
	ld	hl,SToldf
	add	hl,bc		; HL -> input filename
	ld	ix,STofcb
	add	ix,bc		; IX -> input FCB
	DIOopn [stk=ix,stk=hl,stk=RO+OldOnly]->[a]+C ; try to open the file
	TALK [stk="opening %t^m^j",stk=hl] ; mention file open
	jr	nc,cp9		; branch on successful open
	ld	(code),a	; store error code
	push	bc
	ERRMSG [a=a,b=1,c=0,hl=hl] ; publish an error message
	pop	bc
	jr	cp10		; go open the next file
cp9:				; here on successful open
	ld	hl,STsts
	add	hl,bc		; HL -> status byte
	ld	(hl),0+(1 SHL STSopn) ; mark file open
cp10:				; here to advance to next file
	SLLnxt [hl=bc]->[bc=de]	; advance BC to next structure
	ld	a,b		; check for end-of-list
	or	c
	jr	nz,cp8		; branch to open next file

; The files are open.  Allocate as large a buffer as possible.  It must
; be at least one sector big.
	HEAall [de=128,hl=0FFFFh]->[de,hl]+C
	jr	nc,cp11		; branch if allocation is successful
	EPUTF [stk="not enough memory^m^j"]
	SHLexi [a=1]
cp11:				; here with HL -> buffer, DE = length
	ld	a,e		; round length down to a multiple of
	and	080h		;   sector lengths
	ld	e,a		; DE = truncated length
	ld	(buf),hl	; "buf" always points to start of buffer
	ld	(rdptr),hl	; "rdptr" is where next to read to
	ld	(wrptr),hl	; "wrptr" is whence next to write
	add	hl,de		; HL -> first byte beyond buffer
	ld	(bufend),hl	; "bufend" marks the end of the buffer

; Clear "output files open" flag: we have not yet created the output files.
	xor	a
	ld	(ofoflg),a

; "Nxtrd" points to the first file which has not been completely read.
; "Nxtwr" points to the first file which has not been completely written.
	ld	hl,(listhd)
	ld	(nxtrd),hl
	ld	(nxtwr),hl

; Top of outer transput loop.
; Come here to begin or resume reading.
cp12:
	ld	hl,(buf)
	ld	(rdptr),hl	; reset read pointer to start of buffer

; Top of read loop.
; Find the next file that hasn't experienced input EOF or an error, and begin
; reading from it.
cp13:
	ld	bc,(nxtrd)	; BC -> first file not completely read
	ld	a,b		; see if we're all done reading
	or	c
	jp	z,cp19		; branch if all done reading, go finish writing
	ld	hl,STsts
	add	hl,bc		; HL -> status byte
	bit	STSopn,(hl)	; were we able to open this file?
	jr	z,cp14		; branch if not, skip over it
	bit	STSerr,(hl)	; has this file experienced an error?
	jr	nz,cp14		; branch if so, skip over it
	bit	STSeof,(hl)	; has this file experienced EOF?
	jr	z,cp15		; branch if not, go read from it
cp14:
	SLLnxt [hl=bc]->[(nxtrd)=de] ; skip over this file
	jr	cp13		; go look at the next file
cp15:				; here with BC -> structure for next file
				; from which to read
	ld	hl,STsecs
	add	hl,bc		; HL -> count of sectors in buffer
	ld	(hl),0		; set count to zero
	inc	hl
	ld	(hl),0
	ld	a,1		; set first read flag
	ld	(frsflg),a

; Top of sector read loop for a single file.
cp16:
	ld	hl,STofcb
	add	hl,bc		; HL -> old FCB
	DIOrea [stk=hl,stk=(rdptr)]->[a]+C
	push	af		; save A and carry
	ld	hl,frsflg	; HL -> first read flag
	ld	a,(hl)
	and	a		; first read this file this buffer?
	jr	z,cp17		; branch if not
	ld	(hl),0		; clear flag
	ld	hl,SToldf
	add	hl,bc		; HL -> input file name
	TALK [stk="reading %t: ",stk=hl] ; announce the read
cp17:
	pop	af		; restore A and C from DIOrea
	jr	c,cp18		; branch on unsuccessful read, assume EOF
	ld	hl,STsecs
	add	hl,bc		; HL -> count of sectors in buffer
	ld	e,(hl)
	inc	hl
	ld	d,(hl)		; DE = sector count
	inc	de		; bump the sector count
	ld	(hl),d		; put it back
	dec	hl
	ld	(hl),e
	ld	hl,(rdptr)	; HL -> sector just read
	ld	de,128		; advance read pointer to next sector
	add	hl,de
	ld	(rdptr),hl
	ld	de,(bufend)	; check for buffer full
	sbc	hl,de		; (carry still clear from "add hl,de")
	jr	nz,cp16		; branch if buffer not yet full, read some more

; Here if buffer full.
	ld	hl,STsecs
	add	hl,bc		; HL -> number of sectors read this pass
	ld	e,(hl)
	inc	hl
	ld	d,(hl)		; DE = number of sectors read
	TALK [stk="%u sectors^m^j",stk=de]
	jr	cp19		; branch to begin writing

; Here at file EOF.
; Mark this file all read and advance to the next file.
cp18:
	ld	hl,STsts
	add	hl,bc		; HL -> status
	set	STSeof,(hl)	; turn on the EOF bit
	ld	hl,STsecs
	add	hl,bc		; HL -> number of sectors read this pass
	ld	e,(hl)
	inc	hl
	ld	d,(hl)		; DE = number of sectors read
	TALK [stk="%u sectors^m^j",stk=de]
	jp	cp13		; go read from the next file

; Here when the buffer is full or all files have been read; write them out.
; Reset the write pointer to the beginning of the buffer.
cp19:
	ld	hl,(buf)
	ld	(wrptr),hl

; If we haven't yet created the output files, do so.
	ld	hl,ofoflg	; HL -> "output files open" flag
	ld	a,(hl)
	and	a		; test the flag
	jp	nz,cp25		; branch if output files have been opened
	inc	(hl)		; set the flag
	ld	bc,(listhd)	; BC -> first list element
cp20:				; here to create a file, BC -> structure
	ld	hl,STnewf
	add	hl,bc		; HL -> output filename
	ld	ix,STnfcb
	add	ix,bc		; IX -> output FCB
	ld	de,WO+Replace	; assume -p not specified: replace old file
	ld	a,(pflg)	; was -p given?
	and	a
	jr	z,cp21		; branch if not
	ld	de,WO+NewOnly	; don't replace old file
cp21:
	DIOopn [stk=ix,stk=hl,stk=de]->[a]+C ; try to create the file
	TALK [stk="creating %t^m^j",stk=hl] ; mention the open
	jr	nc,cp23		; branch on successful create
	cp	IoFRO		; did it fail because the file is read/only ?
	jr	nz,cp22		; no, something else, go give error message
	ld	a,(fflg)	; are we forcing copies?
	and	a
	ld	a,IoFRO		; (restore error code in case we're not)
	jr	z,cp22		; branch if not, this one failed
	DUTslk [stk=hl,stk=0]->[a]+C ; -f specified, try to clear write lock
	jr	c,cp22		; if that failed, give up on this file
	DUTdel [stk=hl]->[a]+C	; let DUT erase the file
	jr	c,cp22		; branch if it still can't
	DIOopn [stk=ix,stk=hl,stk=WO+Replace]->[a]+C ; try it again
	jr	nc,cp23		; branch on successful open
cp22:				; here if we can't open a file for output
	ld	(code),a	; store error code
	push	bc
	ERRMSG [a=a,b=1,c=0,hl=hl] ; publish an error message
	pop	bc
	ld	hl,STsts
	add	hl,bc		; HL -> status byte
	set	STSerr,(hl)	; mark this file in error
	jr	cp24		; go create the next file
cp23:				; here on successful create
	ld	hl,STsts
	add	hl,bc		; HL -> status byte
	set	STScre,(hl)	; mark file created
cp24:				; here to advance to next file
	SLLnxt [hl=bc]->[bc=de]	; advance BC to next structure
	ld	a,b		; check for end-of-list
	or	c
	jp	nz,cp20		; branch to open next file

; Top of write loop.
; Find the next file that hasn't been completed, and begin writing to it.
cp25:
	ld	bc,(nxtwr)	; BC -> first file not completely written
	ld	a,b		; see if we're all done writing
	or	c
	jp	z,cp34		; branch if all done writing, go close files
	ld	hl,STsts
	add	hl,bc		; HL -> status byte
	bit	STSopn,(hl)	; were we able to open this file?
	jr	z,cp26		; branch if not, skip it
	bit	STSdon,(hl)	; are we done with this file?
	jr	z,cp27		; branch if not
cp26:
	SLLnxt [hl=bc]->[(nxtwr)=de] ; we are, advance past it
	jr	cp25		; go look at the next file
cp27:				; here with BC -> structure for next file
				; to which to write
	bit	STSerr,(hl)	; did an error occur with this file?
	jp	nz,cp33		; branch if so
	ld	a,1		; set "first time this file this buffer" flag
	ld	(frsflg),a

; Top of sector write loop to a single file.
cp28:
	ld	hl,STsecs	; see if we have completed this file
	add	hl,bc		; HL -> count of sectors to write in buffer
	ld	a,(hl)		; check whether count has gone to zero
	inc	hl
	or	(hl)
	jr	z,cp30		; branch if no sectors to write, file done
	ld	hl,STnfcb
	add	hl,bc		; HL -> new FCB
	DIOwri [stk=hl,stk=(wrptr)]->[a]+C
	push	af		; save A and carry
	ld	hl,frsflg	; HL -> first write flag
	ld	a,(hl)
	and	a		; first write this file this buffer?
	jr	z,cp29		; branch if not
	ld	(hl),0		; clear flag
	ld	hl,STnewf
	add	hl,bc
	TALK [stk="writing %t^m^j",stk=hl] ; announce the write
cp29:
	pop	af		; restore A and C from DIOwri
	jr	c,cp32		; branch on unsuccessful write
	ld	hl,STsecs
	add	hl,bc		; HL -> count of sectors in buffer
	ld	e,(hl)
	inc	hl
	ld	d,(hl)		; DE = remaining sector count
	dec	de		; decrement the sector count
	ld	(hl),d		; put it back
	dec	hl
	ld	(hl),e
	ld	hl,(wrptr)	; HL -> sector just written
	ld	de,128		; advance write pointer to next sector
	add	hl,de
	ld	(wrptr),hl
	ld	de,(rdptr)	; check for buffer all used up
	sbc	hl,de		; (carry still clear from "add hl,de")
	jr	nz,cp28		; branch if not end of buffer, write some more

; Here when file successfully written out.
; If the file was completely read, mark this file all written.
; Then if data remains in the buffer, go on to write the next file,
; otherwise go back and do some more reading.
cp30:
	ld	hl,STsts
	add	hl,bc		; HL -> status
	bit	STSeof,(hl)	; have we finished reading from the file?
	jr	z,cp31		; branch if not
	set	STSdon,(hl)	; we have, turn on the done bit
cp31:
	ld	hl,(wrptr)	; see (again) if we're done with this buffer
	ld	de,(rdptr)
	and	a		; (clear carry for subtract)
	sbc	hl,de		; sets Z if buffer done
	jp	nz,cp25		; if buffer not done, go write to the next file
	jp	cp12		; buffer full, branch to resume reading

; Here if an error occurs while writing the file.
; Delete the file and mark it in error.
cp32:
	ld	(code),a
	ld	hl,STnewf
	add	hl,bc		; HL -> new file name
	push	bc
	ERRMSG [a=a,b=1,c=0,hl=hl]
	pop	bc
	DUTdel [stk=hl]->[a]+C	; delete the file, ignore any error

; Here after an error occurs.  Skip over any buffered data.
cp33:
	ld	hl,STsts
	add	hl,bc		; HL -> status for file
	ld	(hl),STSerr	; turn off all status bits except error
	ld	hl,STsecs
	add	hl,bc		; HL -> count of sectors in buffer
	ld	d,(hl)
	inc	hl
	ld	a,(hl)		; AD = number of sectors in buffer
	ld	e,0		; ADE = (number of sectors in buffer)*256
	rra			; rotate ADE right one bit
	rr	d
	rr	e		; now DE = (number of sectors)*128 = bytes
	ld	hl,(wrptr)	; advance the write pointer past those bytes
	add	hl,de
	ld	(wrptr),hl
	jp	cp25		; proceed to the next file

; Here when all I/O done, close the output files.
cp34:
	ld	bc,(listhd)	; BC -> first file to process.

; Top of loop to close a file.
cp35:
	ld	a,b		; check for end of files
	or	c
	jp	z,cp39		; branch when all done
	ld	hl,STsts
	add	hl,bc		; HL -> file status
	bit	STSopn,(hl)	; did file remain open?
	jr	z,cp38		; branch if not, there's nothing to close
	ld	hl,STnewf
	add	hl,bc		; HL -> new file name
	ex	de,hl		; now DE -> new file name
	ld	hl,STnfcb
	add	hl,bc		; HL -> output FCB
	DIOcls [stk=hl]->[a]+C	; close the file
	TALK [stk="closing %t^m^j",stk=de]
	jr	nc,cp36		; branch if no error occurred
	push	bc
	ERRMSG [a=a,b=1,c=0,hl=de] ; publish error message and ignore error
	pop	bc
cp36:
	ld	a,(rflg)	; see if we're retaining attributes
	and	a
	jr	z,cp38		; branch if not, we're done with this file
	ld	hl,STattr
	add	hl,bc
	ld	e,(hl)		; E = attribute byte
	ld	hl,STnewf
	add	hl,bc		; HL -> output file name
	bit	0,e		; see if file should be Read/Only
	jr	z,cp37		; branch if not
	DUTslk [stk=hl,stk=1]->[a]+C ; try to set the lock
	jr	nc,cp37
	ld	(code),a	; store error code
	push	bc
	ERRMSG [a=a,b=1,c=0,hl=hl]
	pop	bc
cp37:
	bit	1,e		; see if file should be System
	jr	z,cp38		; branch if not
	DUTssf [stk=hl,stk=1]->[a]+C ; try to make it a system file
	jr	nc,cp38
	ld	(code),a	; store error code
	push	bc
	ERRMSG [a=a,b=1,c=0,hl=hl]
	pop	bc

; Done with one output file, advance to the next.
cp38:
	SLLnxt [hl=bc]->[bc=de]	; advance to next structure
	jp	cp35

; Here when all done.
cp39:
	ld	a,(code)
	SHLexi [a=(code)]

; Flag table.
flgtbl:
	db 'f',0,0,0,0,0,0,0,0,0,0,0,0
fflg:	dw 0
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'p',0,0,0,0,0,0,0,0,0,0,0,0
pflg:	dw 0
	db 'r',0,0,0,0,0,0,0,0,0,0,0,0
rflg:	dw 0
	db 's',0,0,0,0,0,0,0,0,0,0,0,0
sflg:	dw 0
	db 't',0,0,0,0,0,0,0,0,0,0,0,0
tflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 0

code:	db	0		; return code

; Data
ofoflg:	ds	1		; "output files open" flag
frsflg:	ds	1		; "first time this file this buffer" flag
listhd:	ds	2		; -> file structure list
eol:	ds	2		; -> last element in file structure list
slist:	ds	2		; -> list of system file structures
ulist:	ds	2		; -> list of user file structures
seol:	ds	2		; -> last element in slist
ueol:	ds	2		; -> last element in ulist
buf:	ds	2		; -> large buffer
bufend:	ds	2		; -> end of large buffer
rdptr:	ds	2		; -> where next to read
wrptr:	ds	2		; -> where next to write
nxtrd:	ds	2		; -> next file in list to examine for reading
nxtwr:	ds	2		; -> next file in list to examine for writing

	end cp
