; dm.xm: Disk Map unicum
; /AJK 11.May.81, 19.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'DM V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

; Disk Parameter Block definitions
DpbSPT	equ	0		; (word) sectors per track
DpbBSH	equ	2		; (byte) block shift factor
DpbBLM	equ	3		; (byte) block mask
DpbEXM	equ	4		; (byte) extent mask
DpbDSM	equ	5		; (word) maximum data block number
DpbDRM	equ	7		; (word) maximum directory entry number
DpbAL0	equ	9		; (byte) directory allocation byte
DpbAL1	equ	10		; (byte) directory allocation byte
DpbCKS	equ	11		; (word) size of directory check vector
DpbOFF	equ	13		; (word) number of reserved tracks

; File Control Block definitions
FcbDR	equ	0		; DRive code
FcbFN	equ	1		; FileName
FcbFT	equ	9		; FileType
FcbFT1	equ	9		; first byte of file type (high bit=RO flag)
FcbFT2	equ	10		; second byte of file type (high bit=SYS flag)
FcbFT3	equ	11		; third byte of file type (high bit undefined)
FcbEX	equ	12		; current EXtent number
FcbS1	equ	13		; reserved for internal system use
FcbS2	equ	14		; reserved for internal system use
FcbRC	equ	15		; Record Count for extent FcbEX
FcbD	equ	16		; 16 bytes of Directory information
FcbCR	equ	32		; Current Record for sequential I/O
FcbR0	equ	33		; low byte of Random record number
FcbR1	equ	34		; high byte of Random record number
FcbR2	equ	35		; overflow from Random record number
FcbUSR	equ	36		; user number (not supported by FDOS)
FCBSIZ	equ	37		; size of FCB in bytes

; FDOS function code definitions
SysRes	equ	0		; System Reset (warm boot)
ConIn	equ	1		; Console Input (with line editing)
ConOut	equ	2		; Console Output
RdrIn	equ	3		; RDR: input
PunOut	equ	4		; PUN: output
LstOut	equ	5		; LST: output
ConIO	equ	6		; direct Console I/O
GetIOB	equ	7		; Get I/O Byte
SetIOB	equ	8		; Set I/O Byte
PrStr	equ	9		; Print String
RdCon	equ	10		; Read Console buffer
ConSt	equ	11		; get Console Status
RetVer	equ	12		; Return Version number
ResDsk	equ	13		; Reset Disk system
SelDsk	equ	14		; Select Disk
OpnFil	equ	15		; Open File
ClsFil	equ	16		; Close File
SrchF	equ	17		; Search for First
SrchN	equ	18		; Search for Next
DelFil	equ	19		; Delete File
RdSeq	equ	20		; Read Sequential
WrSeq	equ	21		; Write Sequential
MakFil	equ	22		; Make (and then open) File
RenFil	equ	23		; Rename File
RetLog	equ	24		; Return Login vector
RetCur	equ	25		; Return Current disk
SetDMA	equ	26		; Set DMA address
GetAlc	equ	27		; Get addr(Alloc)
WrProt	equ	28		; Write Protect disk
GetROV	equ	29		; Get Read/Only Vector
SetAtt	equ	30		; Set file Attributes
GetPrm	equ	31		; Get addr(disk Parms)
SetUsr	equ	32		; Set/get User code
RdRnd	equ	33		; Read Random
WrRnd	equ	34		; Write Random
CmpSiz	equ	35		; Compute file Size
SetRec	equ	36		; Set random Record

; Low memory definitions
Boot	equ	0		; Warm Boot entry
IOByte	equ	Boot+3		; I/O byte: logical device assignment
CDisk	equ	Boot+4		; Currently logged-on (CCP) disk (A=0,B=1)
FDOS	equ	Boot+5		; FDOS function entry
DefFCB	equ	Boot+05Ch	; Default File Control Block
DefDMA	equ	Boot+080h	; Default DMA buffer
TBASE	equ	Boot+0100h	; Transient program area Base

Users	equ	32		; max number of users

; Notes on the structure of a directory entry:
;
; A directory entry resembles the first 32 bytes of a File Control Block.
; The following differences are germane to this program:
;   FcbDR, the drive field, contains 0E5h if the directory entry is unused.
;     If the directory entry is in use, this byte contains the owner's user
;     number.
;   The contents of D0, D1, ..., D16 are interpreted as follows:  if there are
;     256 or less data blocks on the volume, then they are sixteen separate
;     one-byte block indices; if there are more than 256 data blocks, then
;     they are eight separate two-byte block indices.  The flag "ldflg" (large
;     disk flag) is set if there are more than 256 data blocks.

	entry	dm
dm:

; --- Command decoding and processing ---

; If no flags are specified, -f defaults.
	HEAhea [hl=0100h]	; initialize heap and stack
	USKini []		; scan the command
	USKflg [hl=flgtbl]	; interpret flags
	ld	a,(mflg)	; A = -m flag
	ld	hl,sflg		; HL -> -s flag
	or	(hl)		; see if either -m or -s was specified
	jr	nz,dm1		; branch if so
	inc	a		; neither -m nor -s, set -f
	ld	(fflg),a
dm1:

; Check for a disk argument, verify it, and select the desired disk.
	USKgna []->[hl]+C-a	; look for an argument
	jr	c,dm5		; branch if no disk specified
	ex	de,hl		; get first argument into DE
	USKgna []->[hl]+C-a	; make sure there's no second argument
	jr	nc,dm3		; branch if so, error
	ld	a,(de)		; A = disk letter
	inc	de		; step to second character
	STRcmp [de=de,hl=""]->[]+C+Z ; check for disk letter without colon
	jr	z,dm2		; branch if that's it
	STRcmp [de=de,hl=":"]->[]+C+Z ; check for disk letter with colon
	jr	nz,dm3		; branch if that's not it, error
dm2:				; here for "x" or "x:", disk letter in A
	sub	'a'		; convert disk letter to (A=0,B=1,..)
	jr	c,dm3		; branch if bad letter
	cp	'p'-'a'+1	; must be letter P or less
	jr	c,dm4		; branch if OK
dm3:				; here for bad arguments
	EPUTF [stk="Usage: dm [-f] [-m] [-s] [d:]^m^j"]
	SHLexi [a=1]
dm4:				; here for good disk argument
	ld	e,a		; E = disk number
	ld	c,SelDsk	; tell BDOS to select that disk
	call	FDOS

; --- Initial statistic gathering ---

; Initialize statistics to zero.
dm5:
	ld	hl,stats
	ld	de,stats+1
	ld	bc,staten-stats-1
	ld	(hl),0
	ldir

; Get disk parameter block.
	ld	c,GetPrm	; get addr(disk parms)
	call	FDOS		; returns HL -> BIOS DPB
	push	hl
	pop	ix		; set IX -> DPB

; Glean some data from the DPB.
	ld	l,(ix+DpbBLM)	; get blocks/sector in HL
	inc	l
	ld	h,0
	ld	(secblk),hl	; store blocks/sector
	ld	l,(ix+DpbDRM)	; get number of directory slots in HL
	ld	h,(ix+DpbDRM+1)
	inc	hl
	ld	(drtot),hl	; store total directory slot count
	ld	l,(ix+DpbDSM)	; get number of blocks in HL
	ld	h,(ix+DpbDSM+1)
	inc	hl
	ld	(bltot),hl	; store total block count

; Set "ldflg" (large disk flag) if there are more than 256 blocks on the disk.
	ld	de,256		; perform a sixteen bit compare
	scf
	sbc	hl,de		; set carry if less than 256 blocks
	jr	c,dm6		; branch if small disk
	ld	a,1		; set ldflg
	ld	(ldflg),a
dm6:

; Compute bblog2 = log2(bytes per block)
	ld	a,(secblk)	; A = number of sectors per block
	ld	b,7-1		; count log2 in B (include bytes/sector bias=7)
dm7:
	inc	b		; bump log2 and halve A
	srl	a
	jr	nz,dm7		; loop until A goes zero
	ld	a,b
	ld	(bblog2),a	; store log2(bytes per block)

; --- Block map initialization ---

; Allocate a block map: one byte for each data block.
; Format of each byte:
; If bit 7 is on, then the block is allocated, and 
;   bit 6 is on if block is in a system file
;   bit 5 is on if block is in a read/only file
; otherwise if bit 7 is off, the block isn't allocated, and
;   bit 6 is on if block is within the directory
;   bit 6 is off if block is free
; bits 4-0 are the smallest owning user number
BMall	equ	7		; block allocated
BMsys	equ	6		; block is in a system file
BMro	equ	5		; block is in a read/only file
BMdir	equ	6		; block is in directory
BMusrm	equ	01Fh		; user mask

	USKall [hl=(bltot)]->[hl]
	ld	(mapadr),hl

; Zero the map (set all blocks to "free" until we know otherwise).
	ld	bc,(bltot)
	dec	bc		; BC = (number of bytes in map) - 1
	ld	d,h
	ld	e,l
	inc	de		; DE -> map + 1
	ld	(hl),0
	ldir

; Premark directory blocks within the map.
	ld	h,(ix+DpbAL0)	; set HL = directory allocation vector
	ld	l,(ix+DpbAL1)
	ld	de,(mapadr)	; DE -> first block within map
	ld	a,0+(1 SHL BMdir) ; A = "directory block" code
	ld	bc,0		; count directory blocks in BC
dm8:
	add	hl,hl		; shift next directory block bit into carry
	jr	nc,dm9		; exit loop if that's all
	ld	(de),a		; mark this a directory block
	inc	de
	inc	bc		; count it
	jr	dm8		; loop
dm9:
	ld	(bldir),bc	; store directory block count

; --- Directory scan ---

; Allocate and set a DMA sector buffer for search first/search next.
	USKall [hl=128]->[hl]
	ld	(dmaadr),hl	; save DMA buffer address
	ex	de,hl		; DE -> DMA buffer
	ld	c,SetDMA
	call	FDOS		; set the DMA buffer address

; Start scanning the directory.
	ld	c,SrchF		; "search for first"
	ld	de,FCB		; FCB template
	call	FDOS

; Loop to process a directory slot.
; Here with A = code from last SrchF/SrchN.
dm10:
	cp	255		; see if we've hit end-of-directory
	jp	z,dm22		; exit loop if so

; Locate the directory slot.
	rrca			; multiply A by 32
	rrca
	rrca			; A = offset into DMA buffer to new slot
	ld	e,a
	ld	d,0		; DE = offset
	ld	ix,(dmaadr)
	add	ix,de		; IX -> directory slot

; See if this directory slot is in use.
	ld	a,(ix+FcbDR)	; check "drive code": E5 means free slot
	cp	0E5h
	jp	z,dm21		; branch if free slot, no information

; Slot is in use, update slots used statistic.
	ld	hl,(druse)
	inc	hl
	ld	(druse),hl

; Check that user number is valid.
	cp	Users		; clear carry if user number is too high
	jr	c,dm11		; branch if okay
	EPUTF [stk="bad user number %pu^m^j",stk=af]
	xor	a		; clear user number and proceed with user 0
dm11:

; Compute the block byte.
; The low bits of A already contain the user number.
	or	(1 SHL BMall)	; mark block allocated
	bit	7,(ix+FcbFT2)	; see if this is a system file
	jr	z,dm12
	or	(1 SHL BMsys)	; if so, set "system file" bit
dm12:
	bit	7,(ix+FcbFT1)	; see if this is a read/only file
	jr	z,dm13
	or	(1 SHL BMro)	; if so, set "read/only file" bit
dm13:
	ld	(blbyte),a	; store block byte

; For each block in extent: update the block map.
	ld	a,(ldflg)	; A = large disk flag
	ld	b,16		; assume small disk: 16 blocks per extent
	and	a
	jr	z,dm14		; branch if that's right
	ld	b,8		; for large disk, 8 blocks per extent
dm14:				; here with B = number of blocks in extent
	ld	de,FcbD
	add	ix,de		; IX -> first block number
dm15:
	ld	l,(ix+0)	; get low byte of block number
	ld	h,0
	inc	ix
	ld	a,(ldflg)	; A = large disk flag
	and	a		; see if we should get two bytes
	jr	z,dm16
	ld	h,(ix+0)	; get high byte of block number
	inc	ix
dm16:
	ld	a,h		; see if this block is allocated
	or	l
	jr	z,dm20		; branch if it isn't
	ld	(blno),hl	; save block number for error messages
	ex	de,hl		; DE = block number
	ld	hl,(bltot)	; make sure block number is not too great
	and	a		; (clear carry for subtract)
	sbc	hl,de		; clear carry if block number is too big
	jr	nc,dm17		; branch if block number is reasonable
	EPUTF [stk="bad block number %u^m^j",stk=hl]
	jr	dm20
dm17:
	ld	hl,(mapadr)	; HL -> block map
	add	hl,de		; HL -> position within map for this block
	ld	a,(blbyte)	; get block byte in A
	bit	BMall,(hl)	; see if block is already allocated
	jr	nz,dm19		; branch if it is
	bit	BMdir,(hl)	; it's not, see if block is in directory
	jr	z,dm18		; branch if it isn't, it's just free
	EPUTF [stk="directory block %u is allocated^m^j",stk=(blno)]
	jr	dm20
dm18:				; here if block was free
	ld	(hl),a		; just store block byte
	jr	dm20
dm19:				; here if block already allocated
	and	(NOT BMusrm)	; isolate attributes by masking off user number
	or	(hl)		; combine old attributes with new
	ld	(hl),a
	and	BMusrm		; isolate old user number
	ld	c,a		; C = old user number
	ld	a,(blbyte)
	and	BMusrm		; A = new user number
	cp	c		; see if new one is smaller
	jr	nc,dm20		; branch if not
	ld	c,a		; it is, store new number in C
	ld	a,(hl)		; get old attributes
	and	(NOT BMusrm)	; clear out old user number
	or	c		; load in new user number
	ld	(hl),a		; store it
dm20:
	djnz	dm15		; loop for each block

; End of processing for this directory slot.
; Find another.
dm21:
	ld	c,SrchN		; search for next slot
	call	FDOS
	jp	dm10		; loop

; Here when all directory slots examined.
; Free the DMA buffer.
dm22:
	HEAfre [hl=(dmaadr)]

; --- User allocation table creation ---

; Allocate and zero the user allocation table: two words per user.
; First word is the number of system blocks; the second word is the
; number of user blocks.
	USKall [hl=4*Users]->[hl] ; four bytes per user
	ld	(usradr),hl
	ld	d,h
	ld	e,l
	inc	de		; DE -> table+1
	ld	bc,4*Users-1	; BC = size of table -1
	ld	(hl),0
	ldir			; zero the table

; Examine the block map and fill in the user table.
	ld	bc,(bltot)	; BC = total number of blocks
	ld	ix,(mapadr)	; IX -> next byte in block map
dm23:				; here to process one block map byte
	ld	a,(ix+0)	; A = next byte
	bit	BMall,a		; is block allocated?
	jr	z,dm25		; branch if not, skip this block
	ld	hl,(bluse)	; bump number of allocated blocks
	inc	hl
	ld	(bluse),hl
	and	BMusrm		; A = next user
	ld	l,a
	ld	h,0		; HL = user number
	add	hl,hl		; multiply HL by 4
	add	hl,hl
	ld	de,(usradr)	; DE -> user table
	add	hl,de		; HL -> specific user
	bit	BMsys,(ix+0)	; see if this block is in a system file
	jr	nz,dm24		; branch if it is
	inc	hl		; otherwise advance HL to second word
	inc	hl		;   in table element
dm24:				; here with HL -> word to increment
	ld	e,(hl)
	inc	hl
	ld	d,(hl)		; DE = word to increment
	inc	de
	ld	(hl),d		; store incremented word
	dec	hl
	ld	(hl),e		; appropriate user count updated
dm25:				; here to advance to next block
	inc	ix		; IX -> next block byte
	dec	bc		; count down number of blocks
	ld	a,b
	or	c
	jr	nz,dm23		; branch to do next block byte

; --- Complete global statistics ---

; Compute remaining 16-bit statistics.
	ld	hl,(bltot)	; HL = total number of blocks
	ld	de,(bldir)	; discount the data blocks
	and	a
	sbc	hl,de		; HL = total number of data blocks
	ld	(bldat),hl
	ld	de,(bluse)	; DE = blocks in use
	and	a
	sbc	hl,de		; HL = number of free blocks
	ld	(blfre),hl
	ld	hl,(drtot)	; HL = total number of directory slots
	ld	de,(druse)	; DE = slots in use
	and	a
	sbc	hl,de		; HL = number of free slots
	ld	(drfre),hl

; Compute long statistics.
	ld	hl,(blfre)	; compute free bytes
	call	b2b
	ld	(byfre),de
	ld	(byfre+2),hl
	ld	hl,(bluse)	; compute bytes in use
	call	b2b
	ld	(byuse),de
	ld	(byuse+2),hl
	ld	hl,(bldat)	; compute total data bytes
	call	b2b
	ld	(bytot),de
	ld	(bytot+2),hl

; --- Map output ---

; See if the map was requested.
	ld	a,(mflg)	; see if map was requested
	and	a
	jp	z,dm36		; branch to not print map

; Print the map.
	ld	de,(bltot)	; DE = number of blocks to map
	ld	hl,0		; zero current block
	ld	(blno),hl
	ld	b,h		; clear B: blocks done this line
	ld	hl,(mapadr)	; HL -> current position in map

; Here to describe another block.
; If we've done 20 blocks, start a new line.
dm26:
	ld	a,b		; A = number of blocks done this line
	cp	20		; have we done 20?
	jr	c,dm27
	OPUTF [stk="^m^j"]	; done 20, do CRLF
	xor	a		; clear count
	ld	b,a
dm27:
	and	a		; starting new line?
	jr	nz,dm28
	OPUTF [stk="%5u:",stk=(blno)] ; publish block number
dm28:

; Publish info about one block.
	bit	BMall,(hl)	; see if block is in use
	jr	nz,dm30		; branch if so
	bit	BMdir,(hl)	; see if block is directory
	jr	z,dm29		; branch if not
	OPUTF [stk=" dd"]	; indicate directory block
	jr	dm35		; move on
dm29:				; here if not allocated and not directory
	OPUTF [stk=" --"]	; indicate block free
	jr	dm35		; move on
dm30:
	ld	a,'u'		; assume a user block
	bit	BMsys,(hl)	; see if it's a system block
	jr	z,dm31		; branch if not, user is correct
	ld	a,'s'		; otherwise make it a system block
dm31:
	bit	BMro,(hl)	; see if block is Read/Only
	jr	z,dm32		; branch if not
	sub	'a'-'A'		; convert character to upper case
dm32:	
	OPUTF [stk=" %pc",stk=af] ; print attribute letter
	ld	a,(hl)		; get block byte
	and	BMusrm		; A = user number
	cp	10		; see if user number will be a digit
	jr	nc,dm33		; branch if letter
	add	a,'0'		; convert user number to digit
	jr	dm34
dm33:				; here for user number letter
	add	a,'a'-10
dm34:
	OPUTF [stk="%pc",stk=af] ; publish user number

; Step to next block.
dm35:
	inc	hl		; HL -> next position in map
	ld	ix,(blno)	; bump block number
	inc	ix
	ld	(blno),ix
	inc	b		; increment blocks this line
	dec	de		; decrement count left
	ld	a,d
	or	e
	jp	nz,dm26		; branch to do more blocks

; Done with map.
	OPUTF [stk="^m^j"]	; end the current line
dm36:

; --- Print long summary ---

; See about producing a long summary.
	ld	a,(sflg)	; "-s" means produce summary
	and	a
	jp	z,dm40		; branch if statistics not required
	ld	a,(mflg)	; see if we did a map
	and	a
	jr	z,dm37		; if not, don't put extra blank line
	OPUTF [stk="^m^j"]	; throw a line
dm37:

; Print statistics.
	OPUTF [stk=msg1a,stk=(byfre),stk=(byfre+2),stk=(byuse),stk=(byuse+2)]
	OPUTF [stk=msg1b,stk=(bytot),stk=(bytot+2)]
	OPUTF [stk=msg2,stk=(blfre),stk=(bluse),stk=(bldat),stk=(secblk)]
	OPUTF [stk=msg3,stk=(drfre),stk=(druse),stk=(drtot),stk=(bldir)]

; Print one line per active user.
	ld	hl,0		; start with user 0
	ld	(user),hl
	ld	ix,(usradr)	; IX -> user table
dm38:				; here to do one user
	ld	l,(ix+0)
	ld	h,(ix+1)	; HL = number of system blocks
	ld	(syblks),hl
	ld	e,(ix+2)
	ld	d,(ix+3)	; DE = number of user blocks
	ld	(usblks),de
	and	a		; (clear carry for adc)
	adc	hl,de		; HL = total number of blocks
	jp	z,dm39		; branch if this user isn't active
	ld	(toblks),hl
	call	b2b		; compute total bytes
	ld	(tobyts),de
	ld	(tobyts+2),hl
	ld	hl,(syblks)	; compute system bytes
	call	b2b
	ld	(sybyts),de
	ld	(sybyts+2),hl
	ld	hl,(usblks)	; compute user bytes
	call	b2b
	ld	(usbyts),de
	ld	(usbyts+2),hl
	OPUTF [stk=msg4a,stk=(user),stk=(sybyts),stk=(sybyts+2),stk=(usbyts),stk=(usbyts+2)]
	OPUTF [stk=msg4b,stk=(tobyts),stk=(tobyts+2),stk=(syblks),stk=(usblks),stk=(toblks)]
dm39:				; here to advance to next user
	ld	bc,4		; advance IX to next user
	add	ix,bc
	ld	hl,(user)
	inc	hl
	ld	(user),hl
	ld	de,Users	; DE = number of users
	and	a		; (clear carry for subtract)
	sbc	hl,de
	jp	c,dm38		; branch to do another user

; --- Fast summary ---

; Here after detailed summary.
dm40:
	ld	a,(fflg)	; see if fast statistics are called for
	and	a
	jr	z,dm42		; branch if not
	ld	a,(mflg)	; A = -m flag
	ld	hl,sflg		; HL -> -s flag
	or	(hl)		; see if a map or a summary has been done
	jr	z,dm41		; branch if not
	OPUTF [stk="^m^j"]	; it has, produce a blank line
dm41:
	OPUTF [stk=msg5,stk=(byfre),stk=(byfre+2),stk=(drfre)]

; --- All done ---

dm42:
	SHLexi [a=0]		; successful exit

; --- Auxiliary routines ---

; Routine to convert blocks to bytes.
; Enter with HL = number of blocks.
; Exit with DE,HL = (long) number of bytes.
; Destroys AF, BC
b2b:
	ld	a,(bblog2)	; A = log2(bytes per block)
	ld	b,a
	ld	de,0		; clear upper word
b2b1:
	add	hl,hl		; multiply DEHL by 2
	ex	de,hl
	adc	hl,hl
	ex	de,hl
	djnz	b2b1		; loop
	ret

; --- Data ---

; Messages.
msg1a:	db	'%mlu free bytes, %mlu in use,',0
msg1b:	db	' %mlu total (128 bytes/sector)',13,10,0
msg2:	db	'%mu free blocks, %mu in use, %mu total data blocks'
	db	' (%mu sectors/block)',13,10,0
msg3:	db	'%mu free directory slots, %mu in use, %mu total'
	db	' (%mu directory blocks)',13,10,0
msg4a:	db	'user %u: %mlu system, %mlu user,',0
msg4b:	db	' %mlu total bytes (%mu+%mu=%mu blocks)',13,10,0
msg5:	db	'%mlu free bytes, %mu free directory slots',13,10,0

; Template FCB.
FCB:	db	'????????????????'

; Flags table.
flgtbl:
	db 'f',0,0,0,0,0,0,0,0,0,0,0,0
fflg:	dw 0
	db 'm',0,0,0,0,0,0,0,0,0,0,0,0
mflg:	dw 0
	db 's',0,0,0,0,0,0,0,0,0,0,0,0
sflg:	dw 0
	db 0

blbyte:	ds	1		; block byte
blno:	ds	2		; current block number
mapadr:	ds	2		; -> block map
dmaadr:	ds	2		; -> DMA sector buffer
usradr:	ds	2		; -> user totals, organized as follows:
				; the first two words are user 0, the second
				; two words are user 1, etc.  The first of
				; a user's two words are the number of system
				; files; the second is the number of user
				; files.

; Start of statistics to zero.
stats:
ldflg:	ds	1		; large disk flag: true if more than 256 blocks
bblog2:	ds	1		; log2(bytes per block)
bltot:	ds	2		; total blocks

; The following statistics correspond in order to the long summary.
byfre:	ds	4		; (long) free bytes
byuse:	ds	4		; (long) used bytes
bytot:	ds	4		; (long) total bytes
				; there are always 128 bytes/sector
blfre:	ds	2		; free blocks
bluse:	ds	2		; used blocks
bldat:	ds	2		; total data blocks
secblk:	ds	2		; sectors per block
drfre:	ds	2		; free directory slots
druse:	ds	2		; used directory slots
drtot:	ds	2		; total directory slots
bldir:	ds	2		; directory blocks

; Statistics for the per/user line.
user:	ds	2		; user number
sybyts:	ds	4		; (long) system bytes
usbyts:	ds	4		; (long) user bytes
tobyts:	ds	4		; (long) total bytes
syblks:	ds	2		; system blocks
usblks:	ds	2		; user blocks
toblks:	ds	2		; total blocks

; End of statistics to zero.
staten:

	end	dm
