; ls.xm: directory LiSting unicum
; /AJK 15.Jun.81, 11.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'LS V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

MaxCol	equ	20		; max number of columns
Wid1	equ	13		; filename.typ_
Wid2	equ	19		; d:filename.typ;nn__
Wid3	equ	26		; rs_n,nnn,nnn_filename.typ_
Wid4	equ	33		; rs_n,nnn,nnn_d:filename.typ;usr__
WidAtt	equ	13		; rs_n,nnn,nnn_
StdOut	equ	1		; standard output channel

	entry ls
ls:

; Initialize, scan command, interpret flags, set default command.
	HEAhea [hl=0100h] 	; initialize stack and heap
	USKini []	 	; scan command
	USKflg [hl=flgtbl]	; scan flags
	USKdef [stk="*",stk=0]	; default command is "ls *"

; Get a homogenous list of all files that match the pattern(s).
	USKmaf [stk=0,stk=0,stk=list]->[]+C-a

; Scan the list once to prune files.
; First, check the "-arsw" flags to see if the file qualifies;
; then if it does, check "-nv" to see if it should be announced or verified.
; At the end of this scan, the list will contain all filenames to be published.
; Register usage through this scan: IX -> list element under consideration,
;   and IY -> its predecessor.
	ld	iy,list		; IY -> list head
ls1:				; top of loop to scan list
	SLLnxt [hl=iy]->[de]	; set DE -> current list element
	ld	a,d		; check for end-of-list
	or	e
	jp	z,ls10		; branch when list exhausted
	push	de		; set IX -> list element
	pop	ix
	bit	0,(ix+6)	; check read/only flag
	jr	z,ls2		; branch if off
	ld	a,(wflg)	; file is read/only, disinclude if "-w"
	and	a
	jr	nz,ls8		; branch to skip this file
	jr	ls3		; branch to check system flag
ls2:				; here if file is read/write
	ld	a,(rflg)	; disinclude read/write file if "-r"
	and	a
	jr	nz,ls8		; branch to skip this file
ls3:				; here if R/O or R/W status checked
	bit	1,(ix+6)	; check SYSTEM flag status
	jr	z,ls4		; branch if off
	ld	a,(sflg)	; "-s" flag overrides "-a"
	and	a
	jr	nz,ls5
	ld	a,(aflg)	; otherwise disinclude if no "-a"
	and	a
	jr	z,ls8		; branch to skip this file
	jr	ls5		; branch if file seems ok
ls4:				; here if file is DIR
	ld	a,(sflg)	; disinclude if "-s"
	and	a
	jr	nz,ls8		; branch to skip this file
ls5:

; File passes tests based on read/write and system/dir status.
; See if we should announce and/or verify the file.
	push	ix
	pop	hl
	ld	de,8
	add	hl,de		; HL = filename string address
	ld	a,(nflg)	; get announce flag
	and	a
	jr	nz,ls6		; branch if it's on
	ld	a,(vflg)	; get verify flag
	and	a
	jr	z,ls9		; branch if both flags off
ls6:
	ld	c,(ix+6)
	ld	b,(ix+7)	; BC = file attributes and file size overflow
	ld	e,(ix+4)
	ld	d,(ix+5)	; DE = file size in sectors
	USKann [stk=hl,stk=bc,stk=de,stk=2] ; announce the file
	ld	a,(vflg)	; see if we're verifying
	and	a
	jr	nz,ls7		; branch if so
	EPUTF [stk="^m^j"]	; no verifying, finish announcement
	jr	ls9		; preserve file
ls7:				; here to continue verifying
	USKver [stk=2,stk=0]->[]+C-a ; get user's response
	jr	nc,ls9		; branch to not remove the file

; Here if file should be removed from list: either it failed the
; attribute test, or operator verification indicates that it should
; not be processed.
ls8:
	SLLdel [hl=iy]->[de,bc]+C
	ex	de,hl		; set HL -> list element to deallocate
	HEAfre [hl=hl]		; deallocate the element
	jp	ls1		; go examine the next list element

; Here if file should not be removed.
; Advance to next element.
ls9:
	push	ix		; make the current list element into
	pop	iy		;   the previous list element
	jp	ls1		; loop for next element

; Here when restrictions, announcement, and verification complete for
; all files which match the pattern.
ls10:

; If "-f" has not been specified, examine the list to see whether each
; filename has the same device and user number.  If so, we can leave off
; this information.

; The common device name is kept at "comdev", and the common user number
; string is kept at "comusr".  When comdev contains a null string, it means
; the first file hasn't been seen yet.

	ld	a,(fflg)	; see if full filenames are indicated
	and	a
	jr	nz,ls15		; if so, no need to scan the list
	xor	a
	ld	(comdev),a	; set comdev to a null string
	ld	ix,list		; IX -> previous list element
ls11:				; top of loop to check each filename
	SLLnxt [hl=ix]->[de]	; DE -> next list element
	ld	a,d		; check for end-of-list
	or	e
	jr	z,ls15		; branch when filename list exhausted
	push	de
	pop	ix		; IX -> current list element
	ld	hl,8
	add	hl,de
	ex	de,hl		; DE -> filename
	STRcpy [de=de,hl=newdev,bc=3] ; get new device into "newdev"
ls12:				; find the user number in filename
	ld	a,(de)		; by searching for the semicolon
	inc	de
	cp	';'
	jr	nz,ls12
	dec	de
	STRcpy [de=de,hl=newusr,bc=5] ; get new user number
	ld	a,(comdev)	; see if this is the first file
	and	a
	jr	nz,ls13		; branch if not
	STRcpy [de=newdev,hl=comdev,bc=3] ; it is, copy in device and user
	STRcpy [de=newusr,hl=comusr,bc=5]
	jr	ls11		; proceed with next filename
ls13:				; here to compare device and user number
	STRcmp [de=comdev,hl=newdev]->[]+Z+C ; see if devices match
	j	nz,ls14		 branc i the don't
	STRcmp [de=comusr,hl=newusr]->[]+Z+C ; see if users match
	jr	z,ls11		; branch if they do, continue loop
ls14:				; here if a device or user number doesn't match
	ld	a,1		; force full filename mode
	ld	(fflg),a
ls15:				; here when filename device/user scan complete

; Determine columnization: if either "-m" or "-c nn" is specified, we're
; going to columnize.
	ld	hl,lbk		; zero out lbk[0] through lbk[15]
	ld	de,lbk+1
	ld	(hl),0
	ld	bc,0+((MaxCol+1)*2)-1
	ldir
	ld	a,(mflg)	; A = "-m" flag
	ld	hl,cflg		; HL -> "-c nn" flag
	or	(hl)		; combine the two flags
	jr	nz,ls16		; branch if columnization
	ld	hl,(list)	; get list header
	ld	(lbk),hl	; store as first column bucket
	jp	ls27		; carry on
ls16:				; here to figure number of columns
	ld	a,(lflg)	; see if we're giving long descriptions
	and	a
	ld	a,(fflg)	; (get -f flag into A)
	jr	z,ls17		; branch if not long descriptions
	ld	de,Wid4		; guess at width for full filenames
	and	a
	jr	nz,ls18		; got it
	ld	de,Wid3		; long descriptions, short filenames
	jr	ls18
ls17:				; here if not long descriptions
	ld	de,Wid2		; guess at width for full filenames
	and	a
	jr	nz,ls18
	ld	de,Wid1		; short descriptions, short filenames
ls18:
	ld	(colwid),de	; remember column width
	ld	hl,(cval+2)	; HL = width of each line
	ld	b,-1		; count columns in B
ls19:
	inc	b		; count off a column
	and	a
	sbc	hl,de
	jr	nc,ls19
	ld	a,b		; store number of columns
	ld	(nolbk),a

; For each column, extract that column from the wild list and set its
; list bucket header (array "lbk") top point to the list.  If there is
; no columnization, this degenerates to setting "lbk[0]" to the entire list.
	ld	hl,list		; count number of files in the wild list
	ld	bc,0		; in BC
ls20:
	SLLnxt [hl=hl]->[de]
	ld	a,d		; check for end of list
	or	e
	jr	z,ls21		; exit loop when files counted
	inc	bc		; count this file
	ex	de,hl
	jr	ls20
ls21:				; here with number of files in BC

; Divide total number of files by number of columns to get number of files
; in first (leftmost) column.  Round any fraction up.
	ld	h,b
	ld	l,c		; HL = total number of files
	ld	a,(nolbk)
	ld	e,a
	ld	d,0		; DE = number of columns
	add	hl,de		; round up
	dec	hl
	ld	bc,0		; divide HL by DE, put quotient in BC
ls22:
	and	a
	sbc	hl,de		; try subtracting one more time
	jr	c,ls23		; exit loop when subtract overflows
	inc	bc		; bump quotient
	jr	ls22
ls23:				; here with files/column in BC

; Split the primal wild list into separate lists, one per column.  Each list
; has at most (BC) files.
	ld	ix,lbk		; IX -> next list bucket
ls24:				; loop once per column
	ld	iy,list		; IY -> predecessor of first list element
	ld	d,b
	ld	e,c		; DE = (max) number of files to get
	ld	l,(iy+0)
	ld	h,(iy+1)	; HL-> first list element
	ld	a,h		; stop when list exhausted
	or	l
	jr	z,ls27
	ld	(ix+0),l	; store list element pointer in list bucket
	ld	(ix+1),h
	inc	ix		; advance IX to next list bucket
	inc	ix
ls25:				; loop once for each list element, or list end
	push	hl
	pop	iy		; IY -> next list element predecessor
	ld	l,(iy+0)
	ld	h,(iy+1)	; HL -> next list element
	ld	a,h		; check for list end
	or	l
	jr	z,ls26		; exit loop if list end encountered
	dec	de		; count down
	ld	a,d
	or	e
	jr	nz,ls25		; loop
ls26:				; here if end of list, IY -> last element
	ld	(iy+0),0	; cut the list here
	ld	(iy+1),0
	ld	(list),hl	; next list starts with succeeding element
	jr	ls24
ls27:

; Here when the file list has been columnized.  Begin publishing.
; Set up filename format string.
	ld	hl,fmt		; HL -> format string
	ld	(hl),'%'
	ld	hl,(colwid)	; HL = column width
	ld	a,(lflg)	; see if we're giving long descriptions
	and	a
	jr	z,ls28		; branch if not
	ld	de,-WidAtt	; subtract width of attribute description
	add	hl,de
ls28:
	ex	de,hl		; DE = filename width
	UTOA [de=de,hl=fmt+1]
	STRcat [de="t",hl=hl,bc=4] ; "%nnt"

; Initialize totals: number of files and number of sectors.  The sector
; count is a long (32 bit) integer.
	ld	hl,0
	ld	(filtot),hl	; file total = 0
	ld	(sectot),hl
	ld	(sectot+2),hl	; sector total = 0

; Publish the files in the list, while computing the totals.
ls29:				; here to write one line (one or more columns)
	ld	iy,lbk		; IY -> first list bucket
	ld	a,(iy+0)	; check: is the first column exhausted?
	or	(iy+1)
	jp	z,ls36		; branch if so, files are all done
ls30:				; here to do one filename on one line
	ld	l,(iy+0)
	ld	h,(iy+1)	; HL -> next list element for this column
	ld	a,l		; make sure column isn't empty
	or	h
	jp	z,ls35		; branch if column empty, this line is done
	SLLnxt [hl=hl]->[de]	; set DE -> subsequent list element
	ld	(iy+0),e	; that's new "first element", this column
	ld	(iy+1),d
	inc	iy		; bump IY to next list bucket
	inc	iy
	push	hl
	pop	ix		; set IX -> current list element
	ld	de,8
	add	hl,de		; HL = filename string address

; If we're not publishing full filenames (-f wasn't specified and all
; devices and user numbers are equal), strip the device and user number
; from the filename.
	ld	a,(fflg)	; are we publishing full filenames?
	and	a
	jr	nz,ls31		; branch if so
	ex	de,hl
	ld	hl,2
	add	hl,de
	ex	de,hl		; DE = string+2, HL = string
	STRcpy [de=de,hl=hl,bc=FNPmfn] ; eliminate device name
	ex	de,hl		; DE -> filename string
	push	ix
	push	iy
	MATrep [hl="*;*",de=de,ix="*",iy=de]->[]+Z-a ; cut off user number
	pop	iy
	pop	ix
	ex	de,hl		; HL -> filename string again
ls31:

; Load up the file attributes and publish if necessary.
	ld	e,(ix+4)
	ld	d,(ix+5)	; DE = file size in sectors
	ld	c,(ix+6)	; C = file attributes
	ld	b,(ix+7)	; B = high byte of file size
	ld	a,(zflg)	; see if we're summarizing only
	and	a
	jr	nz,ls34		; branch if so, just update totals
	ld	a,(lflg)	; see if we're giving long descriptions
	and	a
	jr	z,ls32		; branch if not
	USKann [stk=0,stk=bc,stk=de,stk=StdOut] ; publish attributes and size
ls32:
	ld	a,(iy+0)	; see if any columns follow this one
	or	(iy+1)
	jr	z,ls33		; branch if no more columns
	OPUTF [stk=fmt,stk=hl]	; publish filename with trailing blanks
	jr	ls34		; go update totals
ls33:				; here if this is the last column
	OPUTF [stk="%t",stk=hl]	; publish filename, no trailing blanks
ls34:				; here to update totals
	ld	hl,(filtot)
	inc	hl		; bump file count
	ld	(filtot),hl
	ld	hl,(sectot+2)	; get low word of sector total
	add	hl,de		; add new sector count
	ld	(sectot+2),hl
	ld	hl,(sectot)	; add carry to high word
	ld	c,b
	ld	b,0		; BC = high word of sector count
	adc	hl,bc
	ld	(sectot),hl
	jp	ls30		; proceed with next column, this line
ls35:				; here when one entire line done
	ld	a,(zflg)	; see if we're just summarizing
	and	a
	jp	nz,ls29		; if so, just go do another line
	OPUTF [stk="^m^j"]	; finish this line
	jp	ls29		; go do another line

; Here when file publishing done.  Publish totals if desired.
ls36:
	ld	a,(zflg)	; z flag means give summary
	and	a		; (totals without file list)
	jr	nz,ls37		; branch if summary only requested
	ld	a,(tflg)	; t flag means give totals
	and	a
	jr	z,ls38		; branch if neither, no totals
	OPUTF [stk="^m^j"]	; provide a blank line before totals
				; (but not if just summarizing)
ls37:				; here to give totals

; Convert the sector total to a byte total by multiplying by 128.
; This is equivalent to shifting left seven bits, which in turn
; is equivalent to shifting left one byte then right one bit.
	ld	de,(sectot)
	ld	hl,(sectot+2)	; DEHL = total sector count
	ld	d,e		; shift DEHL left one byte
	ld	e,h
	ld	h,l
	ld	l,0
	srl	d		; shift DEHL right one bit
	rr	e
	rr	h
	rr	l
	OPUTF [stk="Total of %mu files occupying %mlu bytes^m^j",stk=(filtot),stk=de,stk=hl]

; Here when all done.
ls38:
	SHLexi [a=0]

; Flag table.
flgtbl:
	db 'a',0,0,0,0,0,0,0,0,0,0,0,0
aflg:	dw 0
	db 'c',1
	dw 0,30			; lower bound
	dw 0,256		; upper bound
cflg:	db 0
cval:	dw 0,80			; default column margin
	db 'f',0,0,0,0,0,0,0,0,0,0,0,0
fflg:	dw 0
	db 'l',0,0,0,0,0,0,0,0,0,0,0,0
lflg:	dw 0
	db 'm',0,0,0,0,0,0,0,0,0,0,0,0
mflg:	dw 0
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'r',0,0,0,0,0,0,0,0,0,0,0,0
rflg:	dw 0
	db 's',0,0,0,0,0,0,0,0,0,0,0,0
sflg:	dw 0
	db 't',0,0,0,0,0,0,0,0,0,0,0,0
tflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0
	db 'w',0,0,0,0,0,0,0,0,0,0,0,0
wflg:	dw 0
	db 'z',0,0,0,0,0,0,0,0,0,0,0,0
zflg:	dw 0
	db 0

list:	ds	2		; wildcard list pointer
colwid:	ds	2		; column width
filtot:	ds	2		; total number of files
sectot:	ds	4		; (long) total number of sectors
nolbk:	ds	1		; number of columns (bucket headers)
lbk:	ds	(MaxCol+1)*2	; list bucket headers
fmt:	ds	5		; short format string
comdev:	ds	3		; common device string
comusr:	ds	5		; common user string
newdev:	ds	3		; new device string
newusr:	ds	5		; new user string

	end ls
