; mv.xm: file MoVe (rename) Unicum
; /AJK 18.Jun.81, 18.Jul.81

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1981 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\

	uses LIB2800
	uses LIB2801

	db	'MV V1: COPYRIGHT (C) 1981 BY KNOWLOGY',13,10,26,0

	entry mv
mv:
	HEAhea [hl=0100h]	; initialize stack and heap
	USKini []		; scan command
	USKflg [hl=flgtbl]	; interpret flags

; Loop for each file.
mv1:
	USKbnf [stk=(nflg),stk=(vflg),stk=1]->[hl=stk,bc=stk,de=stk,ix=stk]+C-a
				; default replacement disk is that of source
				; HL -> old file name
				; BC = current attributes
				; DE = size
				; IX -> new file name
	jr	c,mv6		; branch when no more names

; If the file is Read/Only and -f wasn't specified, skip the move and
; produce an error message.
	bit	0,c		; check for R/O
	jr	z,mv2		; branch if not
	ld	a,(fflg)
	and	a		; check for -f
	ld	a,IoFRO		; if no -f, give "File Read Only" error
	jr	z,mv5		; branch if can't rename because of R/O

; Try a simple rename.
mv2:
	DUTren [stk=hl,stk=ix,stk=(rflg)]->[a]+C
	jr	nc,mv1		; branch if it worked

; The rename didn't work.  If the old file was read/only or we're trying
; to rename across users, resort to forging a link and deleting the original.
	cp	IoFRO		; check for File Read Only
	jr	z,mv3
	cp	IoCCU		; check for Can't Cross Users
	jr	nz,mv5		; branch if neither of those, issue an error

; That's the case.  Forge a link.
mv3:
	LINK [stk=hl,stk=ix,stk=(rflg)]->[a]+C
	jr	c,mv5		; branch if the link failed

; The link was successfully made.  Delete the original.
	bit	0,c		; is original file read/only?
	jr	z,mv4		; branch if not
	DUTslk [stk=hl,stk=0]->[a]+C ; make the original file read/write
	jr	c,mv5		; branch if error
mv4:
	DUTdel [stk=hl]->[a]+C	; delete the original file
	jr	nc,mv1		; if successful, go to next file

; Here if something went wrong, publish an error message.
mv5:
	ld	(code),a	; remember the error code
	EPUTF [stk="%t -> %t: ",stk=hl,stk=ix]
	ERRMSG [a=a,b=0,c=0,hl=hl]
	jp	mv1		; loop for next file

; Here when done.
mv6:
	ld	a,(code)	; A = any error code
	SHLexi [a=a]

; Flag table
flgtbl:
	db 'f',0,0,0,0,0,0,0,0,0,0,0,0
fflg:	dw 0
	db 'n',0,0,0,0,0,0,0,0,0,0,0,0
nflg:	dw 0
	db 'r',0,0,0,0,0,0,0,0,0,0,0,0
rflg:	dw 0
	db 'v',0,0,0,0,0,0,0,0,0,0,0,0
vflg:	dw 0

; Return code
code:	db 0

	end mv
