; wl.xm: Word Lookup unicum
; /AJK 12.Sep.82, 24.Oct.82

;    _______
;   |      /
;   |     /
;   |    /    Copyright (c) 1982 by Knowlogy
;   |   //\                         PO Box 283
;   |  //  \                        Wilsonville, Oregon  97070
;   | //    \
;   |//______\


	uses LIB2800		; Z80 components
	uses LIB2801		; CP/M components

	db	13,'WL V1: COPYRIGHT (C) 1982 BY KNOWLOGY',13,10,26,0

WrdSiz	equ	11		; max word size (includes terminal null)
BufSiz	equ	8192		; input buffer size

	entry wl
wl:
	HEAhea [hl=0100h]		; set up heap and stack
	USKini []			; initialize command scan
	USKflg [hl=flgtbl]		; interpret flags

; Get the pattern and compile it.
	USKgna []->[hl]+C-a		; HL -> pattern string
	jr	c,wl2			; branch if not supplied
	PATac [hl,a=0]->[(pat)=hl,a]+C	; compile the pattern
	jr	nc,wl1			; branch if no pattern error
	EPUTF [stk="Bad pattern^m^j"]
	SHLexi [a=1]
wl1:
	USKgna []->[hl]+C-a		; ensure no second argument
	jr	c,wl3
wl2:					; here if wrong number of arguments
	EPUTF [stk="Usage: wl [-lrtz] [-d dict.file] pattern^m^j"]
	SHLexi [a=1]
wl3:

; Open the dictionary.
	DICTo [hl=(dfile),de=BufSiz]->[a]+C
	jr	nc,wl4
	ERRMSG [a,b=1,c=1,hl]
wl4:

; Clear totals and line number.
	ld	hl,0
	ld	(lineno),hl		; low word of lineno
	ld	(lineno+2),hl		; high word of lineno
	ld	(matches),hl		; low word of matches
	ld	(matches+2),hl		; high word of matches

; Loop:
; Read a word and run the pattern matcher.
wl5:
	DICTr [hl=wordbuf]->[]+C-a	; read a word
	jr	c,wl9			; branch at EOF
	ld	hl,(lineno)		; increment lineno
	ld	de,1
	add	hl,de
	ld	(lineno),hl
	ld	hl,(lineno+2)
	dec	de
	adc	hl,de
	ld	(lineno+2),hl
	PATm [hl=wordbuf,de=(pat)]->[hl,de]+C-a
	ld	a,(rflg)		; a = -r flag
	jr	c,wl6			; branch if it didn't match
	and	a			; it matched; was -r specified?
	jr	nz,wl5			; if so, skip this word
	jr	wl7			; else go publish match
wl6:					; here if pattern didn't match
	and	a			; it didn't match; was -r specified?
	jr	z,wl5			; if not, skip this word
wl7:

; Here if a word registers.
; Increment the count of matches.
	ld	hl,(matches)
	ld	de,1
	add	hl,de
	ld	(matches),hl
	ld	hl,(matches+2)
	dec	de
	adc	hl,de
	ld	(matches+2),hl

; If we're only summarizing, don't display the word.
	ld	a,(zflg)
	and	a
	jr	nz,wl5

; If line numbers are requested, display it.
	ld	a,(lflg)
	and	a
	jr	z,wl8
	OPUTF [stk="%6mlu: ",stk=(lineno+2),stk=(lineno)]
wl8:

; Display the word.
	OPUTF [stk="%t^m^j",stk=wordbuf]

	jr	wl5			; loop for next word

; Here when words are exhausted.
; Summarize.
wl9:
	ld	a,(tflg)		; see if -t was specified
	ld	hl,zflg			; or -z
	or	(hl)
	jr	z,wl10			; if neither, don't summarize
	OPUTF [stk="%mlu words^m^j",stk=(matches+2),stk=(matches)]
wl10:
	SHLexi [a=0]

; Flag table
flgtbl:
	db 'd',3,0,0,0,0,0,0,0,0,0
dfile:	dw filenm,0
	db 'l',0,0,0,0,0,0,0,0,0,0,0,0
lflg:	dw 0
	db 'r',0,0,0,0,0,0,0,0,0,0,0,0
rflg:	dw 0
	db 't',0,0,0,0,0,0,0,0,0,0,0,0
tflg:	dw 0
	db 'z',0,0,0,0,0,0,0,0,0,0,0,0
zflg:	dw 0
	db 0

filenm:	db	'maindict',0

pat:	ds	2		; -> compiled pattern
lineno:	ds	4		; (long) current line number
matches:ds	4		; (long) number of matches
wordbuf:ds	WRDSIZ		; word buffer

	end wl
