
VERSION:  EQU	712	;MDM712 (08/01/83)  --  CP/M MODEM PROGRAM
;
;		COPYRIGHT 1983 BY IRV HOFF W6FFC
;		--------------------------------
; 
; THIS TELEPHONE MODEM PROGRAM USES THE CHRISTENSEN PROTOCOL.  IT HAS
; BOTH CHECKSUM AND 'CRC' CAPABILITY FOR ERROR-DETECTION.  THROUGH THE
; YEARS IT HAS SUPPORTED DIALING AND AUTO-REDIALING FOR THE S-100 PMMI
; 103 PLUG-IN MODEM.  IT NOW ALSO SUPPORTS THE HAYES SMARTMODEM 300 AND
; 1200 AND U.S. ROBOTICS MODEMS.
;
; OTHER EXTERNAL MODEMS MAY BE READILY USED, ALTHOUGH  MANUAL DIALING
; WOULD BE NECESARY.  OVERLAYS HAVE BEEN MADE ALLOWING RAPID ADAPTATION
; TO VARIOUS COMPUTERS.  THE PROGRAM CONFORMS READILY TO NUMEROUS I/O
; DEVICES INCLUDING THE 2661, 8250, 8251, Z80-SIO, ETC.
;
;
;   GENERAL INTEREST:  When transferring files modem-to-modem, the batch
;   mode is extremely useful.  It allows automatic transmission of nu-
;   merous files while the operator at the receiving end does virtually
;   nothing.  It can be used for single files or with wildcards.  With
;   normal single program transfer, the receiving end switches from CRC
;   to checksum in one minute and times out completely in 100 seconds.
;   (In batch mode it times out in 3 minutes for receive.)  This offers
;   ample opportunity to transfer programs between individuals.  Many
;   outstanding optional features have been added by various people dur-
;   ing its development.  Our thanks to all those who have (and will)
;   contribute.				- Irv Hoff, W6FFC
;
;***********************************************************************
;
; 08/01/83  Added two alternate dialing routines such as MCI and SPRINT.
;	    Slight change in batch transfer area.  Prevented CTL-Y and
;  MDM712   CTL-R from outputting to the modem while saving for disk.
;	    Fixed "disk space remaining" to read correctly with CP/M+.
;	    Renamed all overlays to conform with 6-character filename
;	    limit on Compuserve.	- Irv Hoff
;
; 07/01/83  Changed TERM to allow use of printer port for modem use.
;	    Needed by the Morrow MD and NEC 8001 computers.  Changed all
;  MDM711   overlays to allow overprinting the PMMI parity routines as
;	    the Applecat overlay was not working properly.  Removed the
;	    short break tone during disconnect as Smartmodem 1200 were
;	    locking up.  (Smartmodem 300 were operating normally.)
;					- Irv Hoff
;
; 06/22/83  At last.  Program now has autodialing and auto-continuous
;	    redialing for Hayes Smartmodem 300 or 1200, PMMI 103 modem
;  MDM710   or U.S.Robotics.  After first unsuccessful try, asks if you
;	    want to quit, try once again, or continuously redial.  Also
;	    changed the BYE routine to be compatible with systems other
;	    than RCP/M.  Now trap 87H and 7H which are sometimes used by
;	    mainframes to signify "do not send any more sectors at this
;	    time".  This keeps the original Christensen protocol when
;	    ACKNAK is set YES.  (ACKNAK can of course be set to NO if
;	    the results seem preferable to the user.  Some problems have
;	    been noticed in batch transfers and modem-to-modem use with
;	    ACKNAK set NO.)		- Irv Hoff
;
; 05/27/83  Corrected a phone number in the library.  Added a CR/LF for
;	    the quiet mode if using batch transfer.  Simplified initial-
;  MDM709   ization at startup.  Two minor mods to assist in adding an
;	    overlay for Hayes 300/1200 Smartmodem later.
;					- Irv Hoff
;
; 05/15/83  Extensive revisions on many parts of the program.  Relocated
;	    most of the PMMI routines near the start to facilitate using
;  MDM708   the new 300/1200 PMMI board or the Hayes Smartmodem.  Some
;	    of the more ambitious changes include:
;		a) CRC system replaced with the high-speed lookup tables
;		   similar to those used in CHEK15.
;		b) Separate printer buffer.  Can now print regardless of
;		   input speed even when saving for a disk file.
;		c) Printer buffer and disk buffer each can accept up to
;		   128 characters after an X-OFF to compensate for line-
;		   oriented systems and satellite linking.
;		d) Saving to disk made far more user-friendly.  'NOL' no
;		   longer used.  File automatically closed upon exit.
;		e) Sector count shown before "ACK" is sent, allowing
;		   high-speed transfers (to 19,200 baud) without errors.
;		f) BYE typed on command line or CTL-D in terminal mode
;		   sends BYE to host station, disconnects and returns to
;		   CP/M.  Also closes any disk files that may be open.
;		   "X" (secondary option) does the same thing, allowing
;		   automatic terminate at completion of file transfer.
;		g) Improved the "E" (echo) mode, also half duplex mode.
;		h) Control characters above ^M not passed to the CRT, an
;		   optional feature.
;		i) Handling of command line options greatly modernized.
;		j) For PMMI users, program automatically comes up in
;		   originate mode at default speed.  No need to ever say
;		   TO.300 unless a baudrate change is desired.
;		k) Simlified and changed numerous flags to be consistent
;		   with others.
;		l) Object code is now slightly less than 16k.
;		m) Several improvements in error handling and detection.
;	    Numerous other changes.  We attempted to incorporate all the
;	    suggestions forwarded from various users in addition to some
;	    features I wanted myself.   - Irv Hoff
;
; 01/01/83  First version.  Can be assembled with ASM.COM.  MDM700 was
;	    selected to commence a new series of version numbers.  This
;	    can be readily used on data bank systems that limit file
;	    names to a total of 6 characters.
;					- Irv Hoff
;
;***********************************************************************
;
;
PORT:		EQU	0C0H	;your base port (data or status)
;
BAUDRP:		EQU	PORT+2	;modem baud rate port
MODCTL1:	EQU	PORT	;modem control port
MODDATP:	EQU	PORT+1	;modem data port
MODRCVB:	EQU	02H	;modem receive bit (DAV)
MODRCVR:	EQU	02H	;modem receive ready
MODSNDB:	EQU	01H	;modem send bit
MODSNDR:	EQU	01H	;modem send ready bit
;
;
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;		     SPECIAL EQUATES FOR PMMI
;
MODCTL2:	EQU	PORT+3	;modem status port
;
BRKMSK:		EQU	0FBH	;mask to set break
EVPARMSK:	EQU	20H	;mask to set even parity
NOPARMSK:	EQU	10H	;mask to reset to no parity
ODPARMSK:	EQU	0CFH	;mask to set odd parity
;
ANSWMOD:	EQU	1EH	;answer mode
ORIGMOD:	EQU	1DH	;originate mode
WAITCTS:	EQU	150	;number of seconds (x5) to wait for the
				;computer to answer after PMMI auto-dial
				;100=20 sec, 150=30 sec, 255=51 sec.
				;any number 0-255 acceptable
;
;		  (END OF SPECIAL PMMI EQUATES)
;+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;
BDNMCH:		EQU	75H	;bad name match
BUFSIZ:		EQU	16	;buffer size for file transfer in Kbytes
ERRCRC:		EQU	6	;CRC tries, then switches to CHECKSUM
LIBLEN:		EQU	34	;length of each phone library entry
RUB:		EQU	7FH	;rub
;
YES:		EQU	0FFH
NO:		EQU	0
;
CRC:		EQU	'C'	;requests 'CRC' instead of 'CKSUM'
ESC:		EQU	'['-40H	;^[ = escape
SOH:		EQU	'A'-40H	;^A = start of header
EOT:		EQU	'D'-40H	;^D = end of text
EXITCHR:	EQU	'E'-40H	;^E = exit character
ACK:		EQU	'F'-40H	;^F = acknowledge
OKNMCH:		EQU	'F'-40H	;^F = ok name match
BELL:		EQU	'G'-40H	;^G = bell character
BKSP:		EQU	'H'-40H	;^H = backspace
LF:		EQU	'J'-40H	;^J = linefeed
CR:		EQU	'M'-40H	;^M = carriage return
XON:		EQU	'Q'-40H	;^Q = XON character
XOFF:		EQU	'S'-40H	;^S = XOFF character
NAK:		EQU	'U'-40H	;^U = not acknowledge
CANCEL		EQU	'X'-40H	;^X = cancel send or receive
EOFCHAR:	EQU	'Z'-40H	;^Z = end of file
;
;
		ORG	0100H
;
;
		JMP	START	;skip the data area below
;
;
; THESE ROUTINES AND EQUATES ARE AT THE BEGINNING OF THE PROGRAM SO
; THEY CAN BE PATCHED BY A MONITOR OR OVERLAY FILE WITHOUT RE-ASSEMBLING
; THE PROGRAM.
;
PMMIMODEM:	DB	YES	;yes=PMMI modem, no=non-PMMI modem
SMARTMODEM:	DB	NO	;yes=HAYES Smartmodem, no=non-Hayes
TOUCHPULSE:	DB	'T'	;T=touch, P=pulse (Smartmodem-only)
;
CLOCK:		DB	40	;clock speed x10, up to 25.5 mhz.

				;2 MHz=20, 3.68 MH=37, 4 MHz=40, etc.
MSPEED:		DB	1	;sets display time for sending a file
				;0=110  1=300  2=450  3=600  4=710
				;5=1200 6=2400 7=4800 8=9600 9=19200
BYTDLY:		DB	5	;default time to send character in
				;terminal mode file transfer (0-9)
				;0=0 delay, 1=10 ms, 5=50 ms, 9=90 ms
CRDLY:		DB	5	;end-of-line delay after CRLF in terminal
				;mode file transfer for slow BBS systems
				;0=0 delay, 1=100 ms, 5=500 ms, 9=900 ms
NOOFCOL:	DB	5	;number of directory columns
SETUPTST:	DB	NO	;yes=non-PMMI setup routine
SCRNTEST:	DB	NO	;yes=if home cursor and clear screen
				;routine at CLRSCRN
ACKNAK:		DB	YES	;yes=resend a record after any non-ACK
				;no=resend a record after a valid NAK
BAKUPBYTE:	DB	NO	;yes=make .BAK file
CRCDFLT:	DB	YES	;yes=default to CRC checking
				;no=default to Checksum checking
TOGGLECRC:	DB	YES	;yes=allow toggling of Checksum to CRC
CONVBKSP:	DB	NO	;yes=convert backspace to rub
TOGGLEBK:	DB	YES	;yes=allow toggling of bksp to rub
ADDLF:		DB	NO	;no=no LF after CR to send file in
				;terminal mode (added by remote echo)
TOGGLELF:	DB	YES	;yes=allow toggling of LF after CR
TRANLOGON:	DB	NO	;yes=allow transmission of logon
				;write logon sequence at location LOGON
SAVCCP:		DB	YES	;yes=do not overwrite CCP
LOCONEXTCHR:	DB	NO	;yes=local cmd if EXTCHR precedes
				;no=not local cmd if EXTCHR precedes
TOGGLELOC:	DB	YES	;yes=allow toggling of LOCONEXTCHR
LSTTST:		DB	YES	;yes=allow toggling of printer on/off
				;in terminal mode. Set to no if using
				;the printer port for the modem
XOFFTST:	DB	NO	;yes=allow testing of XOFF from remote
				;while sending a file in terminal mode
XONWAIT:	DB	NO	;yes=wait for XON aftersending CR while
				;transmitting a file in terminal mode	
TOGXOFF:	DB	YES	;yes=allow toggling of XOFF testing
IGNORCTL:	DB	YES	;yes=do not send control characters
				;above CTL-M to CRT in terminal mode
				;no=send any incoming CTL-char to CRT
EXTRA1:		DB	0	;for future expansion
EXTRA2:		DB	0	;for future expansion
BRKCHR:		DB	'@'-40H	;^@ = Send a 300 ms. break tone
NOCONNCT:	DB	'N'-40H	;^N = Disconnect from phone line
LOGCHR:		DB	'L'-40H	;^L = Send logon
LSTCHR:		DB	'P'-40H	;^P = Toggle printer
UNSAVECHR:	DB	'R'-40H	;^R = Close input text buffer
TRANCHR:	DB	'T'-40H ;^T = Transmit file to remote
SAVECHR:	DB	'Y'-40H	;^Y = Open input text buffer
EXTCHR:		DB	'^'-40H	;^^ = Send next character
;
;
; Equates used only by PMMI routines grouped together here.
;
PULSERATE	DB	200	;125=20pps dialing, 250=10pps
CHGBAUD:	DB	'B'-40H	;^B = Used with PMMIMODEM in terminal
				; mode to change baud rate on fly
;
;
; Handles in/out ports for data and status
;
IN$MODCTL1:	IN	MODCTL1 ! RET	;in modem control port
		DB	0,0,0,0,0,0,0	;spares if needed for non-PMMI
OUT$MODDATP:	OUT	MODDATP	! RET	;out modem data port
		DB	0,0,0,0,0,0,0	;spares if needed for non=PMMI
IN$MODDATP:	IN	MODDATP ! RET	;in modem data port
		DB	0,0,0,0,0,0,0	;spares if needed for non-PMMI
ANI$MODRCVB:	ANI	MODRCVB ! RET	;bit to test for receive ready
CPI$MODRCVR:	CPI	MODRCVR ! RET	;value of receive bit when ready
ANI$MODSNDB:	ANI	MODSNDB ! RET	;bit to test for send ready
CPI$MODSNDR:	CPI	MODSNDR ! RET	;value of send bit when ready
;
;
;====================== SPECIAL PMMI PORTS =============================
;
IN$BAUDRP:	IN	BAUDRP   ! RET	;in baudrate port
OUT$BAUDRP:	OUT	BAUDRP   ! RET	;out baudrate port
OUT$MODCTL1:	OUT	MODCTL1	 ! RET	;out modem control port #1
OUT$MODCTL2:	OUT	MODCTL2  ! RET	;out modem control port #2
;
;================== END OF SPECIAL PMMI PORTS ==========================
;
;
LOGONPTR:	DW	LOGON
JMP$DIAL:	JMP	DIAL
JMP$DISCONNT:	JMP	DISCONNT
JMP$GOODBYE:	JMP	GOODBYE
JMP$INITMOD:	JMP	INITMOD
JMP$NEWBAUD:	JMP	NEWBAUD
JMP$NOPARITY:	JMP	NOPARITY
JMP$PARITY:	JMP	PARITY
JMP$SETUPR:	JMP	SETUPR
JMP$SPCLMENU:	JMP	SPCLMENU
JMP$SYSVER:	JMP	SYSVER
JMP$BREAK	JMP	SENDBRK
;
;
; NEXT SIX LINES SHOULD NOT BE CHANGED BY USER OVERLAY AS THESE GO TO
; SPECIFIC LOCATIONS IN THE MAIN PROGRAM, NOT IN THE OVERLAY.
;
JMP$ILPRT:	JMP	ILPRT
JMP$INBUF:	JMP	INBUF
JMP$INLNCOMP:	JMP	INLNCOMP
JMP$INMODEM:	JMP	INMODEM
JMP$NXTSCRN:	JMP	NXTSCRN
JMP$TIMER:	JMP	TIMER
;
;
; Clear sequences are for Televideo, Lear Siegler, etc.  Change to match
; your terminal.  (Heath uses ESC 4AH for clear to end of screen, ESC 45H
; to clear screen.  Lear Siegler and others use ESC 79H for clear to end
; of screen and ESC 3AH to clear screen.)  Room allowed for four bytes.
; (Last zero needed for stopping the string display.  Any extra 0's just
; act as NOP's.)
;
CLREOS:		CALL	ILPRT
		DB	ESC,79H,0,0,0
		RET
;.....
;
;
CLRSCRN:	CALL	ILPRT
		DB	ESC,3AH,0,0,0
		RET
;.....
;
;
;======================= SIGN-ON MESSAGE ==============================	
;
; Send version number and date
;
SYSVER:	  LDA	PMMIMODEM	;USING THE PMMI S-100 MODEM?
	  ORA	A
	  JZ	SYSVER1		;GO IF NOT
	  CALL	ILPRT
	  DB	'Version for PMMI S-100 modem starting at port: ',0
	  LDA	IN$MODCTL1+1
	  CALL	HEXO		;PUT IN PMMI CONTROL PORT NUMBER
	  CALL	ILPRT
	  DB	'H',CR,LF,0
	  RET
;.....
;
;
SYSVER1:  CALL	ILPRT		;IF NOT USING THE PMMI S-100 BOARD
	  DB	'Version for Non-PMMI modem',CR,LF,0
	  RET
;.....
;
;
;==================== LOGON MESSAGE (IF ANY) ===========================
;
; Insert your logon message here.  End with a 0 (for "CALL ILPRT").
; PMMIusers have 59 bytes available, non-PMMI users have approximately
; 2K bytes available as they can overwrite all the following PMMI rou-
; tines if they wish.  This method allows the external overlays to have
; plenty of room.  It keeps the phone number library at a fixed location.
;
LOGON:	  DS	59		;UP TO 59 CHARACTERS ALLOWED
	  DB	0		;TO TERMINATE THE LOGON MESSAGE
;.....
;
;
;=============== NON-PMMI INITIALIZATION (IF ANY) ======================
;
; Insert your initialization routine here if needed.  Can replace the
; following special PMMI area to set speed and auto-dial.  Over 950
; bytes are available for this purpose.  (End your routine with a RET.)
;
;
INITMOD:  RET
;
;========== NON-PMMI SETUP (SPEED CHANGE, ETC.) IF ANY ==============
;
; Insert your speed change and/or auto-dialing routines here.  Oover950
; BYTES (INCLUDING ANYTHING ADDED FOR 'INITMOD').  (END YOUR ROUTINE
; WITH A RET.)
;
SETUPR:	  RET
;
;
; Not needed if using the PMMI board, as it has its own break routine
;
SENDBRK:  RET
;
;
;**************** START OF SPECIAL PMMI ROUTINES **********************
;
;
;=======================================================================
;
;		        SETS THE BAUD RATE
;
;=======================================================================
;
;
SETBAUD:  LDA	ANSWFLG		
	  ORA	A		
	  JZ	FIXBAUD		
	  LDA	ORIGFLG		
	  ORA	A		
	  RNZ			
;
FIXBAUD:  CALL	GETBAUD		
	  CALL	SETMSPD		
	  CALL	OUT$BAUDRP	
	  CPI	52
	  MVI	A,5FH		
	  JC	GT300		
	  MVI	A,7FH		
;
GT300:	  CALL	OUT$MODCTL2
	  STA	MODCTLB		
;
OFFHOOK:  LXI	H,7500		
;
OFFDLY:   DCR	L
	  JNZ	OFFDLY
	  DCR	H
	  JNZ	OFFDLY
	  LDA	UARTCTLB	
	  CALL	OUT$MODCTL1	
	  MOV	A,C
	  STA	MSPEED		
	  XRA	A		
	  RET
;.....
;
;
;=======================================================================
;		 CALCULATES THE BAUD RATE DIVISOR
;
; Returns with current baud rate intact if a blank or null in the speed
; field (extent area).
;
GETBAUD:  LDA	FCB+9		
	  CPI	' '		
	  LDA	CURRENT
	  RZ
	  LDA	FCB+9
	  ORA	A		
	  LDA	CURRENT
	  RZ
;
	  LXI	D,FCB+9		
	  LXI	H,0
;
DECLP:	  LDAX	D		
	  INX	D
	  CPI	' '
	  JZ	DECLP
	  CPI	'0'		
	  JC	BADRATE
	  CPI	'9'+1
	  JNC	BADRATE
	  SUI	'0'
	  MOV	B,H
	  MOV	C,L
	  DAD	H
	  DAD	H
	  DAD	B
	  DAD	H
	  ADD	L
	  MOV	L,A
	  JNZ	DIGNC
	  INR	H
;
DIGNC:	  MOV	A,E
	  CPI	FCB+12
	  JNZ	DECLP
	  MOV	A,H
	  CMA
	  MOV	D,A
 	  MOV	A,L
	  CMA
	  MOV	E,A
	  INX	D
	  LXI	H,15625		
	  LXI	B,-1
;
DIVLP:	  INX	B
	  DAD	D
	  JC 	DIVLP
	  MOV	A,B
	  ORA	A
	  MOV	A,C
	  STA	CURRENT		
	  RZ
;
BADRATE:  CALL	ERXIT
	  DB	'++ INVALID BAUDRATE ++$'
;.....
;
;
;=======================================================================
;		    SETS 'MSPEED' TO BAUD RATE
;
;
SETMSPD:  MVI	C,0		
	  CPI	100		
	  RNC
	  INR	C		
	  CPI	40		
	  RNC
	  INR	C		
	  CPI	30		
	  RNC
	  INR	C		
	  CPI	24		
	  RNC
	  INR	C		
	  RET
;.....
;
;	
; Change baudrate on-the-fly with CTL-B (while in terminal mode)
;
NEWBAUD:  LDA	PMMIMODEM
	  ORA	A
	  RZ
	  CALL	ILPRT
	  DB	CR,LF,'Enter new Baudrate: ',0
	  LXI	H,FCB+9
	  MVI	M,' '		
;
NEWBAUD1: CALL	KEYIN		
	  CPI	CR		
	  CZ	CRLF		
	  JZ	FIXBAUD		
;.....
;
;
NEWBAUD2: CPI	'0'		
	  JC	NEWBAUD1
	  CPI	'9'+1
	  JNC	NEWBAUD1	
	  MOV	M,A		
	  CALL	TYPE		
	  INX	H		
	  JMP	NEWBAUD1	
;.....
;
;
;======================= PARITY ROUTINES ===============================
;
;--->PARITY: Routine to setup PMMI for odd/even parity.
;
PARITY:	  LDA	PMMIMODEM	
	  ORA	A		
	  RZ			
	  LDA	OPARITY		
	  ORA	A		
	  JNZ	EVENPAR		
	  LDA	UARTCTLB	
	  ANI	ODPARMSK
	  JMP	PARITY1
;...
;
;
EVENPAR:  LDA	EPARITY 	
	  ORA	A         	
	  RNZ               	
	  LDA	UARTCTLB  	
	  ANI	ODPARMSK  	
	  ORI	EVPARMSK  	
;
PARITY1:  STA	UARTCTLB	  
	  JMP	OUT$MODCTL1	
;				;WHEN OUT$MODCTL1 DOES RET IT
;.....				;WILL GO BACK TO CALLING ROUTINE
;
;
NOPARITY: LDA	PMMIMODEM
	  ORA	A
	  RZ
	  LDA	UARTCTLB	
	  ORI	NOPARMSK	
	  JMP	OUT$MODCTL1
;.....
;
;
;==================== END OF PARITY ROUTINES ===========================
;
;
;=======================================================================
;
;		   HAYES/PMMI DIALING ROUTINES
;
;=======================================================================
;
;
	  DS	128		
;	
; Modem control command words
;
BRKMASK:  EQU	0		
CLEAR:	  EQU	3FH		
DTMSK:	  EQU	1		
MAKEM:	  EQU	1		
RBLMT:	  EQU	35		
RBWAIT:	  EQU	50		
TMPUL:	  EQU	80H		
TRATE:	  EQU	250		
;.....
;
;
; Dialing routine
;
DIAL:	  LDA	PMMIMODEM	
	  ORA	A
	  JNZ	DIAL0
	  LDA	SMARTMODEM	
	  ORA	A
	  RZ			
;
DIAL0:	  XRA	A
	  STA	CRFLAG		
	  STA	RINGBKFL	
	  LXI	H,0
	  SHLD	DIALCT		
	  LXI	H,CMDBUF+1	
	  MOV	A,M		
	  CPI	3+1		
	  JC	DIAL1		
;
;
; If there were only 3 characters, then "CAL<RET>" was typed -- the user
; obviously expecting to get a phone number (or letter) from the library
; file.  If 4 or more, a number (or letter) was typed in from the menu
; command line, so move the characters down 4 to compensate.  Needed for
; auto-redialing of menu command line entries.
;
	  MOV	C,A		
	  MVI	B,0		
	  SUI	4		
	  MOV	M,A		
	  INX	H		
	  XCHG			
	  LXI	H,CMDBUF+6	
	  CALL	MOVER		
	  JMP	DIAL4		
;...
;
;
; Comes here if no phone number was manually entered after "CAL" and if
; no phone library letter was entered.  Displays the phone number library
; then asks for an entry.
;
DIAL1:	  MVI	C,13		
	  LXI	H,NUMBLIB	
	  LXI	D,BUFFER	
	  CALL	NEWLINE		
	  STAX	D		
	  INX	D		
;
DIAL2:	  MVI	B,LIBLEN	
	  CALL	MOVE		
	  CALL	SPACES		
	  MVI	B,LIBLEN
	  CALL	MOVE
	  CALL	NEWLINE
	  DCR	C		
	  JNZ	DIAL2		
;
DIAL3:	  MVI	A,'$'		
	  STAX	D		
	  CALL	CLRTST
	  MVI	C,PRINT
	  LXI	D,BUFFER	
	  CALL	BDOS
	  CALL	ILPRT		
	  DB	CR,LF,'Enter library letter or phone number,',CR,LF
	  DB	'CTL-X quits while dialing or ringing: ',0
	  LXI	D,CMDBUF
	  CALL	INBUF
;
; You now have either a library letter or a manually entered phone num-
; ber.  These either came from the menu command line or from the library
; command line.  Next we see if a letter, if so, get the corresponding
; line with phone number from the library.  If a number we ignore the
; library look-up.  (Ringback numbers must end with letter 'R'.)
;
DIAL4:	  LXI	H,CMDBUF+1	
	  MOV	A,M
	  ORA	A		
	  JZ	DIALEXIT	
	  INX	H		
	  PUSH	H		
	  CALL	DIALBGN		
	  POP	H		
	  JC	DIALEXIT	
	  MVI	B,'A'		
	  MVI	E,0		
	  MVI	C,26		
	  MOV	A,M		
;
DIAL5:	  CMP	B		
	  JZ	DIAL6
	  INR	B		
	  INR	E		
	  DCR	C		
	  JZ	DIAL9		
	  JMP	DIAL5		
;
;
; Now have a match between the requested letter and one in the library
; E-reg. holds the decimal equivalent (1-26) of the letter (A-Z).
;
DIAL6:	  LXI	H,NUMBLIB	
	  LXI	B,LIBLEN	
	  MOV	A,E		
	  ORA	A		
	  JZ	DIAL8
;
DIAL7:	  MOV	A,M		
	  ORA	A		
	  JZ	DIALBAD		
	  DAD	B		
	  DCR	E		
	  JNZ	DIAL7		
;
;
; Now have the line in the phone number library matching the requested
; letter so store that line starting at 'CMDBUF+1'
;
DIAL8:	  MVI	B,LIBLEN	
	  LXI	D,CMDBUF+1	
	  XCHG			
	  MOV	M,B		
	  XCHG			
	  INX	D		
	  CALL	MOVE		
;
;
; Now have the full line including phone number in 'CMDBUF' area.
;
DIAL9:	  LDA	SMARTMODEM
	  ORA	A
   	  CNZ	SMINIT
;	
DIAL10:	  LXI	H,CMDBUF+1
	  MOV	E,M		
	  INX	H		
;
DIAL11:	  MOV	A,M		
	  ORA	A		
	  JZ	DIALBAD		
;
;
; Dial a digit, check keyboard for abort
;
	  CALL	DIALA		
	  CALL	STAT		
	  JZ	DIAL13		
	  CALL	KEYIN		
	  CPI	CANCEL		
	  JNZ	DIAL13		
	  LDA	SMARTMODEM	
	  ORA	A
	  JZ	DIALEXIT	
;
;
; If using a Smartmodem, backspace 20 times to make sure the entire
; number plus "DT" part of "ATDT" is erased.
;
	  MVI	C,30
;
DIAL12:   MVI	B,BKSP
	  CALL	SENDCHR		
	  DCR	C
	  JNZ	DIAL12		
	  MVI	B,CR		
	  CALL	SENDCHR
	  MVI	A,' '
	  CALL	TYPE		
	  JMP	DIALEXIT	
;
DIAL13:	  INX	H		
	  DCR	E		
	  JNZ	DIAL11		
;
;
; Show the number of dial attempts
;
	  CALL	ILPRT
	  DB	' - try #',0
	  LHLD	DIALCT		
	  INX	H
	  SHLD	DIALCT
	  CALL	DECOUT		
	  MVI	A,' '		
	  CALL	TYPE
;
	  LDA	SMARTMODEM
	  ORA	A
	  JZ	DIAL15		
	  MVI	B,CR		
	  CALL	SENDCHR		
;
DIAL14:	  CALL	JMP$INMODEM	
	  JNC	DIAL14
	  JMP	SMRESULT	
;
;
; Dialing is all done
;
DIAL15:	  MVI	A,07FH		
	  CALL	OUT$MODCTL2	
	  MVI	B,1		
	  CALL	TIMER		
	  MVI	A,5DH		
	  CALL	OUT$MODCTL1	
	  MVI	D,4		
	  MVI	C,WAITCTS	
	  CALL	WAIT		
;				;..UP TO 51 SECONDS FOR EUROPEAN USE)
;
; If connection made, go get options for starting communications
;
	  JNC	CONMADE		
;
;
; Connection not made, see if a redial is desired
;
	  CALL	DISCONNT	
;
DIALAGN:  LDA	CRFLAG		
	  ORA	A
	  JNZ	DIALAGN1	
	  CALL	ILPRT		
	  DB	CR,LF,LF,'No answer.  Redial? '
	  DB	'(Y/N/C): ',BELL,0
	  CALL	KBDCHR
	  CALL	CRLF		
	  CPI	'N'		
	  JZ	MENU		
	  CPI	'Y'		
	  JZ	DIALAGN1	
	  CPI	'C'		
	  JNZ	DIALAGN		
	  MVI	A,1
	  STA	CRFLAG		
;
DIALAGN1: MVI	B,RBWAIT	
	  CALL	TIMER		
	  CALL	CRLF		
	  LDA	RINGBKFL	
	  ORA	A
	  JZ	DIAL4		
	  STA	CMDBUF+1	
	  JMP	DIAL4		
;.....
;
;
; Connection has been made
;
CONMADE:  LDA	CURRENT		
	  CALL	OUT$BAUDRP	
;
CONMADE1: CALL	ILPRT
	  DB	CR,LF,LF,'CONNECTED',BELL,0
	  LDA	CRFLAG		
	  ORA	A
	  JZ	RETURN		
	  CALL	ILPRT
	  DB	' - hit any key to stop the bell ',0
;
CONMADE2:
	  CALL	STAT		
	  JZ	CONMADE3
	  CALL	KEYIN
	  XRA	A
	  JMP	RETURN		
;
CONMADE3: MVI	B,10
	  CALL	TIMER
	  MVI	A,BELL
	  CALL	TYPE		
	  JMP	CONMADE2
;.....
;
;
; Automatic dialing routine, prints the number being dialed
;
DIALA:	  CALL	TYPE		
	  CPI	'R'		
	  JNZ	DIALA1		
	  PUSH	PSW		
	  MOV	A,E		
	  CPI	1		
	  JZ	RINGBK		
	  POP	PSW		
;
DIALA1:	  MOV	B,A		
	  CALL	DIALAD		
	  MOV	A,B		
	  CPI	','		
	  JZ	DIALA2
	  CPI	'0'		
	  RC			
	  CPI	'9'+1
	  RNC			
	  SUI	'0'		
	  JNZ	DIALA2
	  MVI	A,10		
;
;
; Sends the digit to the modem.  If PMMI, converts it to correct number
; of pulses.  Program does not support touch-tone dialing for PMMI.
; Waits 200 ms. after each PMMI digit dialed.
;
DIALA2:	  MOV	C,A		
	  LDA	SMARTMODEM	
	  ORA	A
	  JNZ	SENDCHR			
	  LDA	PULSERATE	
	  CALL	OUT$BAUDRP
;
DIALA3:	  CALL	IN$BAUDRP
	  ANI	TMPUL
	  JNZ	DIALA3
;
DIALA4:	  CALL	IN$BAUDRP
	  ANI	TMPUL
	  JZ	DIALA4
;
DIALA5:	  MVI	A,MAKEM
	  CALL	OUT$MODCTL1
;
DIALA6:	  CALL	IN$BAUDRP
	  ANI	TMPUL
	  JNZ	DIALA6
	  MVI	A,BRKMASK
	  CALL	OUT$MODCTL1
;
DIALA7:	  CALL	IN$BAUDRP
	  ANI	TMPUL
	  JZ	DIALA7
	  DCR	C
	  JNZ	DIALA5
	  MVI	A,MAKEM
	  CALL	OUT$MODCTL1
	  MVI	B,2		
	  JMP	TIMER		
;.....
;
;
; Print bad library number message and abort if a null is encountered.
;
DIALBAD:  CALL	ILPRT
	  DB	CR,LF,'++ Bad library number called ++',CR,LF,0
;
DIALEXIT: CALL	DISCONNT	
;
DIALEXT1: CALL	CRLF		
	  XRA	A		
	  STA	CRFLAG
;
DIALEXT2: CALL	JMP$INMODEM	
	  JNC	DIALEXT2
	  CALL	JMP$GOODBYE	
	  JMP	MENU
;.....
;
;
; Disconnect from the line, reconnect and wait for the dialtone.
;
DIALBGN:  LDA	SMARTMODEM
	  ORA	A
	  RNZ			
	  CALL	DISCONNT
	  MVI	A,MAKEM		
	  CALL	OUT$MODCTL1	
	  MVI	D,DTMSK		
	  MVI	C,50		
	  CALL	WAIT		
;
;
; Wait subroutine will return with carry set if unable to get dialtone.
; If carry is not set, the dialtone was received.
;
	  RNC			
	  CALL	ILPRT		
	  DB	CR,LF,LF,'++ NO DIAL TONE ++',CR,LF,0
	  CALL	DISCONNT
	  STC			
	  RET
;.....
;
;
; Do any alternate dialing such as 'MCI' or 'SPRINT'
;
DIALAD:	  LDA	SMARTMODEM	
	  ORA	A
	  RZ			
	  LDA	TOUCHPULSE	
	  CPI	'T'
	  RNZ					
	  MOV	A,B		
	  CPI	'<'		
	  JNZ	DIALAD1		
	  PUSH	H		
	  LXI	H,ALTDIAL1	
	  JMP	DIALAD2
;
DIALAD1:  CPI	'>'		
	  RNZ			
	  PUSH	H		
	  LXI	H,ALTDIAL2
;
DIALAD2:  MOV	A,M
	  CPI	'$'		
	  JZ	DIALAD3		
	  CALL	TYPE		
	  MOV	B,A
	  CALL	SENDCHR		
	  INX	H		
	  CALL	STAT		
	  JZ	DIALAD2		
	  CALL	KEYIN		
	  CPI	CANCEL		
	  JZ	DIALEXIT	
	  JMP	DIALAD2		
;
DIALAD3:  MVI	A,' '
	  CALL	TYPE			
	  POP	H		
	  RET	
;.....
;
;
GOODBYE:
DISCONNT: LDA	SMARTMODEM	
	  ORA	A
	  JNZ	DISCONN1
	  XRA	A		
	  CALL	OUT$MODCTL1 	
	  CALL	OUT$MODCTL2 	
	  PUSH	B
	  MVI	B,10		
	  CALL	TIMER		
	  POP	B
	  RET
;...
;	
;
; Disconnect the Smartmodem from the phone line
;
DISCONN1: MVI	B,20		
	  CALL	TIMER
	  LXI	H,SM$DISC
	  CALL	SENDOUT
	  MVI	B,20		
	  CALL	TIMER
	  MVI	A,' '
	  CALL	TYPE
	  LXI	H,SM$DISC1
	  CALL	SENDOUT
;
DISCONN2: MVI	B,2		
	  CALL	RECV
	  JNC	DISCONN2
	  RET
;...
;
;
SM$DISC:  DB	'+++$'
;
SM$DISC1: DB	'ATH',CR,'$'
;.....
;
;
; Set Smartmodem for pulse dialing
; 
SMINIT:	  LDA	TOUCHPULSE	
	  STA	SM$DIAL+3	
	  LXI	H,SM$DIAL
	  CALL	SENDOUT
;
SMINIT1:  CALL	JMP$INMODEM
	  JNC	SMINIT1		
	  RET
;...
;
;
SM$DIAL:  DB	'ATDT $'	
;.....
;
;
; Send the string pointed to by 'HL' to both the CRT and the modem.
;
SENDOUT:  CALL	SENDNOW		
	  MOV	A,M		
	  CPI	'$'
	  RZ			
	  MOV	A,M
	  CALL	OUT$MODDATP	
	  CALL	TYPE		
	  INX	H
	  JMP	SENDOUT	
;.....	  
;
;
; Checks for answer from Smartmodem
;
SMRESULT: CALL	RCVREADY	
	  JZ	SMRESUL1	
	  CALL	STAT		
	  JZ	SMRESULT	
	  CALL	KEYIN		
	  CPI	CANCEL		
	  JNZ	SMRESULT	
	  MVI	B,CR
	  CALL	SENDCHR		
	  JMP	DIALEXT1	
;
SMRESUL1: CALL	IN$MODDATP	
	  ANI	7FH		
	  MOV	B,A		
	  CPI	'C'
	  JZ	CONMADE1	
	  CPI	'E'
	  JZ	GIVLF		
	  CPI	'N'
	  JNZ	SMRESULT	
;
SMDM1:	  CALL	INMODEM		
	  JNC	SMDM1		
	  JMP	DIALAGN		
;.....
;
;
; Handles the special ringback numbers.  Dials, lets it ring only once,
; hangs up and then redials.
;
RINGBK:	  POP	PSW		
	  LDA	SMARTMODEM
	  ORA	A
	  JNZ	RINGBK2
	  LDA	CMDBUF+1	
	  STA	RINGBKFL	
	  SUI	1		
	  STA	CMDBUF+1	
	  MVI	D,DTMSK		
	  MVI	C,RBLMT		
	  CALL	WAIT
	  JC	RBTIME		
	  MVI	B,25		
	  CALL	TIMER
	  CALL	IN$BAUDRP	
	  ANA	D
	  JZ	DIALAGN		
;.....
;
;
; Hang up, redial and listen for dial tone
;
RINGBK1:  CALL	HANGUP		
	  MVI	B,RBWAIT	
	  CALL	TIMER		
	  CALL	DIALBGN		
	  JNC	DIAL9		
	  JMP	DIALAGN		
;.....
;
;
RINGBK2:  CALL	ILPRT
	  DB	CR,LF,'++ No ringback for Smartmodem ++',0
	  POP	H		
	  JMP	DIALEXT1	
;.....
;
;	
RBTIME:	  CALL	CRLF
	  JMP	RINGBK1		
;.....
;
;
HANGUP:   MVI	A,CLEAR
	  CALL	OUT$MODCTL2
	  XRA	A
	  CALL	OUT$MODCTL1	
	  RET
;.....
;
;
; Time-out routine.  Must be called with mask in 'D' reg. for input at
; relative port 2 and number of seconds (times 10) in 'C' reg.
;
WAIT:	  MVI	B,2	
	  CALL	TIMER		
	  CALL	IN$BAUDRP	
	  ANA	D		
	  RZ			
	  PUSH	B		
	  PUSH	D		
	  CALL	STAT		
	  JZ	WAIT1		
	  CALL	KEYIN		
	  CPI	CANCEL		
	  JZ	WAIT2		
;
WAIT1:	  POP	D		
	  POP	B		
	  DCR	C		
	  JNZ	WAIT
	  STC			
	  RET
;.....
;
;
WAIT2:	  POP	D		
	  POP	B		
	  JMP	DONETCD		
;.....
;
;	       (END OF HAYES/PMMI DIALING ROUTINE)
;=======================================================================
;			SPECIAL PMMI MENU
;
SPCLMENU: LDA	PMMIMODEM
	  ORA	A
	  RZ
	  CALL	JMP$NXTSCRN
	  CALL	ILPRT
	  DB	'        Additional Subcommands for PMMI Modems'
	  DB	CR,LF,LF
	  DB	'  Modem control:',CR,LF
	  DB	'    A - Answer tone for send or receive',CR,LF
	  DB	'    O - Originate tone for send or receive',CR,LF,LF
	  DB	'  Parity option:',CR,LF
	  DB	'    1 - Set and check for odd parity',CR,LF
	  DB	'    0 - Set and check for even parity',CR,LF
	  DB	'           Both ends must be capable of these options'
	  DB	CR,LF
	  DB	'           which are available only in R and S modes.'
	  DB	CR,LF
	  DB	'           The parity checking will be part of the'
	  DB	CR,LF
	  DB	'           file transfer protocol.',CR,LF,LF
	  DB	'  Speed Options:',CR,LF
	  DB	'        After entering your primary and secondary '
	  DB	'options,',CR,LF
	  DB	'        you can set the modem speed by placing a '
	  DB	' "." after',CR,LF
	  DB	'        the options followed by the speed e.g., '
	  DB	'300, 600.',CR,LF,LF
	  DB	'        EXAMPLE:  SBOT.600 will set the modem for '
 	  DB	'600 baud',CR,LF,0
	  DB	RET		

;.....
;			(END OF PMMI MENU)
;=======================================================================
;
; Timer routine.  Waits 0.1 seconds for each unit in 'B' reg.
;
TIMER:	  PUSH	H
;
TIMER1:	  PUSH	B
;
TIMER2:	  CALL	JMP$INMODEM	
	  JNC	TIMER2
	  POP	B
	  DCR	B
	  JNZ	TIMER1
	  POP	H		
	  RET
;.....
;			
;
;
;************** END OF SPECIAL HAYES/PMMI ROUTINES *********************
;
;
;=======================================================================
;
; CALCULATES DISK SPACE REMAINING IF CP/M+
;
CKCPM3:   CALL	CRLF
	  MVI 	C,CPMVER	
	  CALL	BDOS
	  MOV	A,L		
	  CPI	30H		
	  RC			
	  POP	H		
	  MVI	C,CURDSK
	  CALL	BDOS
	  MOV	E,A
	  MVI	C,46		
	  CALL	BDOS
	  MVI	C,3		
;
FREE30:   LXI	H,TBUF+2	
	  MVI	B,3		
	  ORA	A
;
FREE31:   MOV	A,M
	  RAR
	  MOV	M,A
	  DCX	H
	  DCR	B
	  JNZ	FREE31		
	  DCR	C
	  JNZ	FREE30		
	  LHLD	TBUF		
	  JMP	PRTFREE		
;.....
;
;
;=======================================================================
;
;
	  DS	15		
;
;
; Long distance alternate dialing such as MCI, SPRINT, etc.  Must end
; with a '$', use as many commas (2 seconds delay, each) as needed to
; let the alternate dialing code return with a new dial tone.  Fill in
; any character (periods are fine) after the $ to keep number of columns
; to 24, i.e.,  '1234567,,,,12345,,$.....'   --   the first group is the
; MCI or SPRINT access number, the second group is the user number.  A
; small delay is usually required after the billing number also.
;
ALTDIAL1: DB	'xxxxxxx,,,,,,xxxxxxxx,,$'   ;accessed by a < character
;
ALTDIAL2: DB	'xxxxxxx,,,,,,xxxxxxxx,,$'   ;accessed by a > character
;......
;
;
; Phone number library table for auto-dialing.  Each number must be as
; long as "LIBLEN" (EQU at start of program).  Some areas require extra
; characters such as:   1-313-846-7127.  Room is left for those.  Use
; a (<) for alternate dialing system #1, and a (>) for alternate dialing
; sSystem #2.  Either would preceed the acutal number, for example:
;
;	  DB    'A=Alan Alda..........<123-456-7890'    ;'A'
;
; -     -     -     -     -     -     -     -     -     -     -     -
;
;		'----5---10---15---20---25---30--34'
NUMBLIB:  DB	'A=Bob Robesky.......1-209-227-2083'	
	  DB	'B=Byron McKay.......1-415-965-4097'	
	  DB	'C=Tim Cannon........1-312-359-8080'	
	  DB	'D=Dave Morgan.......1-503-641-7276'	
	  DB	'E=Bill Ernest.......1-215-398-3937'	
	  DB	'F=Chuck Fosberg.....1-503-621-7276'	
	  DB	'G=Thomas Hill.......1-907-337-1984'	
	  DB	'H=Dave Hardy........1-313-846-6127'	
	  DB	'I=Wayne Hammerly....1-301-953-3753'	
	  DB	'J=RBBS Pasadena.....1-213-577-9947'	
	  DB	'K=Brian Kamor.......1-619-541-2503'	
	  DB	'L=Sigi Kluger.......1-915-598-1668'	
	  DB	'M=Dick Mead.........1-213-799-1632'	
	  DB	'N=Arnie McGall......1-716-425-1785'	
	  DB	'O=Jud Newell........1-416-231-9538'	
	  DB	'P=Keith Petersen...1-313-759-6569R'	
	  DB	'Q=Mark Pulver.......1-312-789-0499'	
	  DB	'R=Bruce Ratoff......1-201-272-1874'	
	  DB	'S=Ken Stritzel......1-201-584-9227'	
	  DB	'T=TCBBS, Dearborn...1-313-846-6127'	
	  DB	'U=Paul Traina.......1-408-867-1243'	
	  DB	'V=Edward Svoboda....1-408-732-9190'	
	  DB	'W=Ward Christensen..1-312-545-8086'	
	  DB	'X=Ron Fowler........1-414-563-9932'	
	  DB	'Y=                                '	
	  DB	'Z=                                '	
	  DB	0					
;		'----5---10---15---20---25---30--34'
;.....
;
;
;
;***********************************************************************
;
;
; P - R - O - G - R - A - M    S - T - A - R - T - S    H - E - R - E
;
;
;***********************************************************************
;
;
START:	  LXI	H,0
	  DAD	SP		
	  SHLD	STACK
	  LXI	SP,STACK	
	  CALL	ILPRT
	  DB	CR,LF,'MDM',VERSION/100+'0',VERSION MOD 100/10+'0'
	  DB	VERSION MOD 10+'0',' - (type M for Menu)',CR,LF,0
	  CALL	JMP$SYSVER	
	  CALL	CRCGEN		
	  CALL	INITADR		
	  CALL	PROCOPT		
	  LDA	OPTION		
	  CPI	' '+1
	  JC	MENU		
;
;
; Comes here from menu once the options have been set
;
RESTART:  LXI	SP,STACK	
	  CALL	CKCHAR		
	  LDA	PMMIMODEM
	  ORA	A
	  JNZ	RESTART0	
	  LDA	SMARTMODEM	
	  ORA	A
	  JZ	RESTART1	
;
RESTART0: LDA	OPTION		
	  CPI	'C'		
	  JZ	JMP$DIAL	
	  LDA	PMMIMODEM
	  ORA	A
	  CNZ	SETBAUD		
;
RESTART1: CALL	MOVEFCB
	  XRA	A
	  STA	ECHOFLG		
	  STA	LOCFLG		
	  LDA	OPTION		
	  CPI	'D'		
	  JZ	DONETCD		
	  CPI	'M'		
	  JZ	MENU2		
	  CPI	'R'		
	  JZ	RCVFIL		
	  CPI	'S'		
	  JZ	SENDFIL		
	  CPI	'T'		
	  JZ	DSKSAVE		
	  CPI	'E'		
	  JNZ	NOECHO		
	  STA	ECHOFLG		
	  JMP	DSKSAVE
;
NOECHO:	  CPI	'L'		
	  JNZ	NOLOCAL		
	  STA	LOCFLG		
	  JMP	DSKSAVE
;	 
NOLOCAL:  CALL	NTVLDMSG	
	  JMP	MENU		
;.....
;
;
INITADR:  LHLD	0000H+1		
	  LXI	D,3
	  DAD	D
	  SHLD	VSTAT+1		
	  DAD	D
	  SHLD	VKEYIN+1	
	  DAD	D
	  SHLD	VTYPE+1		
	  DAD	D
	  SHLD	VLIST+1		
	  LXI	D,30
	  DAD	D
	  SHLD	GOLIST+1	
	  CALL	GETUSER		
	  STA	OLDUSER		
	  CALL	GETMAX		
	  JMP	JMP$INITMOD	
;.....
;
;
; Process any options - put 0 in appropriate place in option table if
; option is selected
;
PROCOPT:  LXI	D,FCB+1
 	  LDAX	D
	  STA	OPTION
	  CPI	' '		
	  RZ
;
OPTLP:	  INX	D
	  LDAX	D
	  CPI	' '
	  JZ	ENDOPT
	  LXI	H,OPTBL
	  MVI	B,OPTBE-OPTBL
;
OPTCK:	  CMP	M
	  JNZ	OPTNO
	  CPI	'O'		
	  MOV	B,A		
	  MVI	A,ORIGMOD
	  JZ	OPTCK1
	  MOV	A,B		
	  CPI	'A'		
	  JNZ	OPTCK2		
	  MVI	A,ANSWMOD
;
OPTCK1:	  STA	UARTCTLB
;
OPTCK2:	  MVI	M,0
	  JMP	OPTLP
;
OPTNO:	  INX	H
	  DCR	B
	  JNZ	OPTCK
	  CALL	NTVLDMSG
	  POP	H		
	  JMP	MENU
;
ENDOPT:	  LDA	VSEEFLG
	  ORA	A
	  JNZ	CKOPTN
	  STA	QFLG		
;
CKOPTN:	  LDA	OPTION		
	  CPI	'D'		
	  RZ
	  CPI	'E'		
	  RZ
	  CPI	'M'		
	  RZ
	  CPI	'L'		
	  RZ
	  CPI	'T'
	  RZ
	  MOV	B,A		
	  LDA	PMMIMODEM	
	  ORA	A
	  JNZ	CKOPTN0		
	  LDA	SMARTMODEM	
	  ORA	A
	  JZ	CKOPTN1		
;
CKOPTN0:  MOV	A,B			
	  CPI	'C'		
	  RZ
;
CKOPTN1:  LDA	NFILFLG		
	  ORA	A
	  JZ	CKOPTN2		
	  POP	H		
	  JMP	MENU0		
;
CKOPTN2:  MOV	A,B			
	  CPI	'S'
	  JZ	CKFILE
	  CPI	'R'
	  JNZ	BDOPT		
	  LDA	BATCHFLG	
	  ORA	A
	  RZ			
;
CKFILE:	  LDA	FCB+17		
	  CPI	' '
	  RNZ			
;
REENT:	  CALL	ILPRT
	  DB	'++ Enter primary option plus file name ++'
	  DB	CR,LF,BELL,0
	  POP	H		
	  JMP	MENU		
;.....
;
;
BDOPT:	  CALL	ILPRT
	  DB	CR,LF,'++ Bad option ++',CR,LF,LF,0
;.....
;
;
; Check for any garbage characters on line - catch and ignore
;
CKCHAR:	  CALL	RCVREADY	
	  RNZ			
	  CALL	IN$MODDATP	
	  JMP	CKCHAR		
;.....
;
;
; Revised terminal routine allowing memory save.  First checks for bad
; options, to prevent wiping out the disk with accidental memory save.
;
DSKSAVE:  LDA	BATCHFLG	
	  ORA	A
	  JNZ	DSKSAVE1	
	  MVI	A,'B'		
	  STA	BATCHFLG
	  JMP	NOTVLD		
;
DSKSAVE1: LDA	NFILFLG		
	  ORA	A
	  JZ	DSKSAVE2	
	  CALL	BUFMSG		
	  JMP	TERM
;
DSKSAVE2: LDA	FCB+1		
	  CPI	' '		
	  JNZ	GOODNM		
	  XRA	A
	  STA	NFILFLG		
	  STA	SAVEFLG		
	  JMP	TERM
;...
;
;
GOODNM:	  CALL	ERASFIL
	  LXI	H,FCB3
	  CALL	INITFCB
	  LXI	H,FCB		
	  LXI	D,FCB3
	  MVI	B,12
	  CALL	MOVE
	  LXI	D,FCB3		
	  MVI	C,MAKE
	  CALL	BDOS
	  LXI	D,FCB3		
	  MVI	C,OPEN
	  CALL	BDOS
	  LXI	H,BUFFER	
	  SHLD	HLSAVE
	  MVI	A,1
	  STA	NFILFLG		
	  CALL	BUFMSG2		
;
TERM:	  LDA	LSTTST		
	  ORA	A
	  CNZ	GOLIST		
	  CALL	STAT		
	  JZ	TERML		
	  CALL	KEYIN		
	  MOV	B,A		
 	  CPI	BKSP		
	  JNZ	NOTBKSP
	  LDA	CONVBKSP	
	  ORA	A
	  JZ	NOTBKSP		
	  MVI	B,RUB
	  JMP	NOTOG
;...
;
;
NOTBKSP:  LDA	EXACFLG
	  ORA	A		
	  MVI	A,0		
	  STA	EXACFLG		
	  JZ	NTEXAFLG	
	  LDA	LOCONEXTCHR
	  ORA	A		
	  JZ	NOTOG		
	  LDA	EXTCHR		
	  CMP	B
	  JZ	NOTOG		
	  JMP	LOCCHK		
;...
;
;
NTEXAFLG: LDA	EXTCHR		
	  CMP	B		
	  JNZ	NTEXA1		
	  MVI	A,1
	  STA	EXACFLG		
	  JMP	TERM		
;
NTEXA1	  LDA	LOCONEXTCHR
	  ORA	A		
	  JNZ	NOTOG		
;
LOCCHK:	  CALL	EXITTST1	
	  LDA	NOCONNCT	
	  CMP	B
	  JZ	DONETCD		
	  LDA	TRANCHR		
	  CMP	B
	  JZ	TRANSFER
	  LDA	TRANLOGON
	  ORA	A
	  JZ	SKPLOGON
	  LDA	LOGCHR		
	  CMP	B
	  JZ	SENDLOG
;
SKPLOGON: LDA	LSTTST		
	  ORA	A
	  JZ	NOLST		
	  LDA	LSTCHR		
	  CMP	B		
	  JNZ	NOLST		
	  LDA	LISTFLG		
	  CMA
	  STA	LISTFLG		
	  CALL	CRLF
	  CALL	CRLF
	  CALL	LSTMSG		
	  CALL	CRLF
	  JMP	TERML		
;.....
;
;
NOLST:	  LDA	BRKCHR		
	  CMP	B
	  JZ	BREAK
	  LDA	PMMIMODEM	
	  ORA	A
	  JZ	NOLST1		
	  LDA	CHGBAUD		
	  CMP	B
	  PUSH	PSW
	  PUSH	H
	  CZ	JMP$NEWBAUD
  	  POP	H
	  POP	PSW
	  JZ	TERML
;...
;
;
NOLST1:	  LDA	UNSAVECHR	
	  CMP	B
	  JZ	NOLST2		
	  LDA	SAVECHR		
	  CMP	B
	  JNZ	NOTOG
	  LDA	NFILFLG		
	  ORA	A
	  JZ	TERML		
	  JMP	NOLST3
;
NOLST2:	  XRA	A		
;
NOLST3:	  STA	SAVEFLG
	  CALL	BUFMSG
	  JMP	TERM		
;.....
;
;	
;***********************************************************************
;
;			 SEND A CP/M FILE
;
;***********************************************************************
;
;
SENDFIL:  XRA	A		
	  STA	CRCFLAG		
	  CALL	CKCHAR		
;
SENDFIL1: LDA	BATCHFLG	
	  ORA	A		
	  JNZ	SENDC1
	  CALL	ILPRT
	  DB	'Ready to send in the batch mode',CR,LF
	  DB	'(Use RBT when ready to receive)',CR,LF,0
;
SENDFIL2: CALL	JMP$PARITY	
	  MVI	A,1		
	  STA	SENDFLG
	  LDA	FSTFLG		
	  ORA	A		
	  CZ	TNMBUF		
	  CALL	SENDFN		
	  JNC	SENDC2		
	  MVI	A,'B'		
	  STA	BATCHFLG  	
	  MVI	A,EOT		
	  CALL	SEND
	  JMP	DONE
;
SENDC1:	  LDA	FCB+1
	  CPI	' '
	  JZ	BLKFILE
;
SENDC2:	  CALL	CNREC		
	  CALL	OPENFIL
	  MVI	E,100
	  CALL	WAITNAK
;
SENDLP:	  CALL	CKABORT		
	  CALL	RDRECD
	  JC	SENDEOF
	  CALL	INCRRNO
	  MVI	A,1
	  STA	ERRCT
;
SENDRPT:  CALL	CKABORT		
	  CALL	SENDHDR
	  CALL	SENDREC
	  LDA	CRCFLAG
	  ORA	A
	  CZ	SENDCKS
	  CNZ	SENDCRC
	  CALL	GETACK
	  JC	SENDRPT
	  JMP	SENDLP
;.....
;
;
SENDEOF:  MVI	A,EOT
	  CALL	SEND
	  CALL	GETACK
	  JC	SENDEOF
	  JMP	DONE
;.....
;
;
;***********************************************************************
;
;		       RECEIVE A CP/M FILE
;
;***********************************************************************
;
;
RCVFIL:	  LDA	CRCDFLT		
	  STA	CRCFLAG		
	  CALL	CKCHAR		
;
RCVFIL1:  CALL	JMP$PARITY	
	  LDA	BATCHFLG	
	  ORA	A
	  JNZ	RCVC1		
	  XRA	A		
	  STA	SENDFLG			
	  CALL	GETFN		
	  JNC	RCVC2		
	  MVI	A,'B'		
	  STA	BATCHFLG
	  JMP	DONE
;...
;
;
RCVC1:	  LDA	FCB+1		
	  CPI	' '
	  JNZ	RCVC3		
	  JMP	BLKFILE		
;...
;
;
RCVC2:	  CALL	CKCPM2
	  CALL	CKBAKUP
;
RCVC3:	  CALL	ERASFIL
	  CALL	MAKEFIL
	  LDA	BATCHFLG	
	  ORA	A
	  JZ	RCVC4		
	  CALL	ILPRT
	  DB	'File open - ready to receive',0
;
RCVC4:	  CALL	CRLF		
	  LDA	CRCFLAG		
	  PUSH	PSW		
	  ORA	A
	  JNZ	RCVC5		
	  CALL	ILPRT		
	  DB	'CHECKSUM in effect',CR,LF,0
	  JMP	RCVC6
;...
;
;
RCVC5:	  CALL	ILPRT
	  DB	'CRC in effect',CR,LF,0
	  LDA	QFLG		
	  ORA	A
	  CZ	CRLF		
;
RCVC6:	  POP	PSW		
	  ORA	A
	  MVI	A,CRC		
	  JNZ	RCVC7		
	  MVI	A,NAK		
;
RCVC7:	  STA	ACKFLG		
;
RCVC8:	  MVI	B,1		
	  CALL	RECV
	  JNC	RCVC8		
;
RCVLP:	  CALL	RCVRECD
	  JC	RCVEOT
	  CALL	WRRECD
	  CALL	INCRRNO
	  MVI	A,ACK
	  STA	ACKFLG		
	  JMP	RCVLP
;.....
;
;
RCVEOT:	  CALL	WRBLOCK
	  CALL	CLOSFIL
	  MVI	A,ACK		
	  CALL	SEND
	  JMP	DONE	
;.....
;
;
;=================== FILE TRANSFER IN T-MODE ===========================
;
;
; File transfer routine - called with CTL-T from terminal mode.  Trans-
; fer may be cancelled while sending, by using CTL-X.
;
TRANSFER: LXI	H,FCB4
	  CALL	INITFCB		
	  LXI	H,FCB+16	
	  CALL	INITFCB
;
;
; Get name of file to send in "T" (terminal) mode
;
GET:	  CALL	ILPRT
	  DB	CR,LF,'File name to send?   (RET to quit): ',0
	  LXI	D,CMDBUF
	  CALL	INBUF
	  LDA	CMDBUF+2	
	  CPI	' '
	  JZ	RETURN		
	  LXI	D,CMDBUF
	  LXI	H,FCB4
	  CALL	CMDLINE
	  LXI	D,FCB4
	  MVI	C,OPEN
	  CALL	BDOS
	  CPI	0FFH		
	  JZ	TRANSL
;
;
; Choice of normal speed or delays between characters / lines
;
	  CALL	ILPRT
	  DB	'Want to include time delays? (Y/N): ',0
	  CALL	KBDCHR
	  CPI	'N'		
	  JZ	DLYSAV
	  XRA	A		
;
DLYSAV:	  STA	DLYFLG		
	  CALL	CRLF	
	  LXI	D,CMDBUF	
	  MVI	C,SETDMA
	  CALL	BDOS
;
;
; Get 128-byte record
;
READMR:	  LXI	D,FCB4
	  MVI	C,READ
	  CALL	BDOS
	  ORA	A		
	  JZ	READMR1
	  DCR	A		
	  JZ	RETURNS
	  CALL	ERXIT		
	  DB	'++ DISK READ ERROR ++','$'
;
;
; Successful read, so send the record
;
READMR1:  CALL	SEND80C		
	  CPI	EOFCHAR		
	  JZ	RETURNS		
	  CPI	CANCEL		
	  JNZ	READMR
;
RETURN:	  CALL	ILPRT
	  DB	CR,LF,LF,'(in Terminal-mode now)',CR,LF,LF,0
	  CALL	SENDNOW		
	  CALL	CKCHAR		
	  JMP	TERM		
;.....
;
;
RETURNS:  CALL	ILPRT
	  DB	CR,LF,'[Transfer completed]',0
	  JMP	RETURN
;.....
;
;
TRANSL:	  CALL	ILPRT
	  DB	CR,LF,BELL,'++ FILE NAME ERROR ++ ',CR,LF,0
	  JMP	GET
;.....
;
;
; Send one 128-byes record
;
SEND80C:  MVI	B,128		
	  LXI	H,CMDBUF	
;
SENDCH1:  PUSH	D
	  CALL	SPEED		
	  POP	D
	  MOV	A,M
	  CPI	EOFCHAR
	  RZ
	  CALL	MODOUT		
	  CALL	STAT		
	  ORA	A		
	  JZ	SKIP1
	  CALL	KEYIN
	  CPI	CANCEL
	  RZ
;
SKIP1:	  INX	H
	  DCR	B
	  JNZ	SENDCH1
	  RET
;.....
;
;
; Send the character to the output
;
MODOUT:	  PUSH	PSW		
	  CPI	LF
	  JNZ	MODOUTL
	  LDA	ADDLF		
	  ORA	A
	  JNZ	MODOUTL		
	  POP	PSW		
	  CALL	TYPE		
	  RET
;
MODOUTL:  LDA	XOFFTST		
	  ORA	A
	  CNZ	TXOFF		
	  CALL	SENDRDY		
	  JNZ	MODOUTL
	  POP	PSW		
	  CALL	TYPE		
	  CALL	OUT$MODDATP	
	  CPI	CR		
	  RNZ			
;
;
; Delay to allow slow BBS systems (most use BASIC) to enter the line.
; Choice of 0-9 for about 100 ms. each, maximum of 900 ms.
;
MODOUTN:  LDA	XONWAIT		
	  ORA	A
	  JNZ	WAITXON		
	  MVI	D,10
;
MODOUTT:  PUSH	D
	  CALL	SPEED1		
	  POP	D
	  DCR	D
	  JNZ	MODOUTT		
	  RET
;.....
;
;
; Add from 0 to 90 ms. delay between characters for slow (most use
; BASIC) bulletin board systems.  Also used to add 0-900 ms. delay
; between lines.
;
SPEED:	  LDA	BYTDLY		
	  JMP	SPEED1+3	
;
SPEED1:	  LDA	CRDLY		
	  ORA	A		
	  RZ			
	  MOV	C,A		
	  LDA	DLYFLG		
	  ORA	A
	  RNZ			
;
SPEED2:	  CALL	SPEED3		
	  DCR	C
	  JNZ	SPEED2
	  RET			
;...
;
;
SPEED3:	  PUSH	H		
	  LXI	H,20
	  LDA	XOFFTST
	  ORA	A
	  JZ	SPEED4
	  LXI	H,20		
	  LDA	ECHOFLG
	  ORA	A
	  JZ	SPEED4
	  LDA	LOCFLG
	  ORA	A
	  JZ	SPEED4
	  LXI	H,25		
;
SPEED4:	  CALL	FIXCNT		
	  XCHG			
	  POP	H		
;	
SPEED5:	  DCX	D		
	  LDA	XOFFTST
	  ORA	A
	  CNZ	TXOFF
	  MOV	A,E
	  ORA	D
	  JNZ	SPEED5
	  RET
;...
;
;
TXOFF:	  CALL	RCVREADY
	  RNZ
	  CALL	IN$MODDATP
	  ANI	7FH
	  CPI	XOFF
	  CZ	WAITXON
	  RET
;.....
;
;
WAITXON:  CALL	RCVREADY	
	  JNZ	WTXON1		
	  CALL	IN$MODDATP
	  ANI	7FH		
	  CPI	XON		
	  RZ			
;
WTXON1:	  CALL	STAT		
	  JZ	WAITXON
	  CALL	KEYIN		
	  CPI	CANCEL		
	  JNZ	WAITXON		
	  RZ
;.....
;
;================ END OF FILE TRANSFER IN T-MODE =======================
;
;
;***********************************************************************
;
;			   SUBROUTINES	
;
;***********************************************************************
;
SENDFN:	  CALL	ILPRTQ
	  DB	'Awaiting name NAK',CR,LF,0
	  MVI	E,100
	  CALL	WAITNLP
	  MVI	A,ACK		
	  CALL	SEND
	  LXI	H,FILECT
	  DCR	M
	  JM	NOMRNM
	  LHLD	NBSAVE		
	  LXI	D,FCB		
	  MVI	B,12
	  CALL	MOVE
	  SHLD	NBSAVE
	  CALL	SENDNM		
	  ORA	A		
	  RET
;.....
;
;
NOMRNM:	  MVI	A,EOT
	  CALL	SEND
	  STC
	  RET
;.....
;
;
SENDNM:	  PUSH	H
;
SENDNM1:  MVI	D,11		
	  MVI	C,0		
	  MOV	A,C
	  STA	FTYCNT		
	  LXI	H,FCB+1		
;
NAMLPS:   MOV	A,M		
	  ANI	7FH		
	  CALL	SEND		
	  LDA	QFLG
	  ORA	A
	  MOV	A,M
	  CNZ	FTYTST		
;
ACKLP:	  PUSH	B		
	  MVI	B,1		
	  CALL	RECV		
	  POP	B		
	  JC	SCKSER
	  CPI	ACK
	  JNZ	ACKLP
	  INX	H		
	  DCR	D
	  JNZ	NAMLPS
	  MVI	A,EOFCHAR	
	  CALL	SEND
	  LDA	QFLG
	  ORA	A
	  CNZ	CRLF
	  MOV	D,C		
	  MVI	B,1
	  CALL	RECV		
	  CMP	D		
	  JZ	NAMEOK
;
SCKSER:	  MVI	A,BDNMCH	
	  CALL	SEND
	  CALL	ILPRT
	  DB	CR,LF,'++ ERROR sending name  ++',CR,LF,0
	  MVI	E,100		
	  CALL	WAITNLP		
	  MVI	A,ACK
	  CALL	SEND
	  JMP	SENDNM1
;.....
;
;
NAMEOK:	  MVI	A,OKNMCH	
	  CALL	SEND
	  POP	H
	  RET	
;.....
;
;
GETFN:	  LXI	H,FCB
	  CALL	INITFCB+2	
	  CALL	ILPRT
	  DB	'Awaiting FILENAME',CR,LF,0
	  CALL	HSNAK
	  CALL	GETNM		
	  CPI	EOT		
	  JZ	NOMRNMG
	  ORA	A		
	  RET
;.....
;
;
NOMRNMG:  STC
	  RET
;.....
;
;
GETNM:	  PUSH	H
;
GETNM1:	  MVI	C,0		
	  MOV	A,C
	  STA	FTYCNT		
	  LXI	H,FCB+1
;
NAMELPG:  MVI	B,5		
	  CALL	RECV		
	  JNC	GETNM2
	  CALL	ILPRT
	  DB	CR,LF,'Time out receiving FILENAME',CR,LF,0
	  JMP	GCKSER
;.....
;
;
GETNM2:	  CPI	EOT		
	  JZ	GNRET
	  CPI	EOFCHAR		
	  JZ	ENDNAME
	  MOV	M,A		
	  CALL	FTYTST
	  PUSH	B		
	  MVI	A,ACK		
	  CALL	SEND
	  POP	B
	  INX	H		
	  MOV	A,L		
	  CPI	7FH		
	  JZ	GCKSER		
	  JMP	NAMELPG
;.....
;
;
FTYTST:	  LDA	FTYCNT
	  INR	A
	  STA	FTYCNT
	  CPI	8+1		
	  JZ	SPCTST		
;
ENDSPT:	  MOV	A,M
	  CPI	' '		
	  CNZ	TYPE		
	  RET
;.....
;
;
SPCTST:	  MOV	A,M
	  CPI	' '		
	  RZ			
	  MVI	A,'.'	
	  CALL	TYPE
	  JMP	ENDSPT		
;.....
;
;
ENDNAME:  LDA	QFLG
	  ORA	A
	  CNZ	CRLF
	  MOV	A,C		
	  CALL	SEND
	  MVI	B,1
	  CALL	RECV		
	  CPI	OKNMCH		
	  JZ	GNRET		
;
GCKSER:	  LXI	H,FCB		
	  CALL	INITFCB+2	
	  CALL	ILPRT
	  DB	CR,LF,'++ CHECKSUM error ++',CR,LF,0
	  CALL	HSNAK		
	  JMP	GETNM1
;...
;
;
GNRET:	  POP	H
	  RET
;.....
;
;
HSNAK:	  MVI	E,180		
;
HSNAK1:   CALL	CKABORT		
	  MVI	A,NAK		
	  CALL	SEND
	  MVI	B,1		
	  CALL	RECV
	  CPI	ACK		
	  RZ
	  DCR	E		
	  JNZ	HSNAK1
	  JMP	ABORT		
;.....
;
;
TNMBUF:	  MVI	A,1		
	  STA	FSTFLG
	  XRA	A
	  STA	FILECT
	  CALL	SCAN
	  LXI	H,NAMEBUF
	  SHLD	NBSAVE		
;
TNLP1:	  CALL	TRTOBUF
	  LXI	H,FCB
	  LXI	D,FCBBUF
	  CALL	CMDLINE		
;
TNLP2:	  CALL	MFNAME		
	  JC	NEXTNM
	  LDA	FCB+10		
	  ANI	80H		
	  JNZ	TNLP2
	  LHLD	NBSAVE		
	  LXI	D,FCB		
	  XCHG
	  MVI	B,12
	  CALL	MOVE
	  XCHG
	  SHLD	NBSAVE		
	  LXI	H,FILECT	
	  INR	M
	  JMP	TNLP2
;.....
;
;
NEXTNM:	  LXI	H,NAMECT	
	  DCR	M
	  JNZ	TNLP1
	  LXI	H,NAMEBUF	
	  SHLD	NBSAVE
	  LDA	FILECT
	  CPI	64+1		
	  RC
	  MVI	A,64		
	  STA	FILECT
	  RET
;.....
;
;
; Tells when buffer is opened/closed for memory save to write on disk
;
BUFMSG:	  CALL	ILPRT
	  DB	CR,LF,'** Memory buffer ',0
	  LDA	SAVEFLG
	  ORA	A
	  JZ	BUFMSG1
	  CALL	ILPRT
	  DB	'open **',CR,LF,LF,';',0
	  RET
;
BUFMSG1:  CALL	ILPRT
	  DB	'closed **',CR,LF,LF,0
	  RET
;
BUFMSG2:  CALL	ILPRT
	  DB	CR,LF,'** Memory buffer available **',CR,LF,0
	  RET
;.....
;
;
; Clear the screen and return to the menu command
;
EXITMENU: CALL	CRLF
	  CALL	CLREOS		
	  JMP	MENU0
;.....
;
;
; Checks to see if the modem has a character ready
;
RCVREADY: CALL	IN$MODCTL1
	  CALL	ANI$MODRCVB
	  JMP	CPI$MODRCVR
;.....
;
;
; Checks to see if the modem is ready to receive a character
;
SENDRDY:  CALL	IN$MODCTL1
	  CALL	ANI$MODSNDB
	  JMP	CPI$MODSNDR
;.....
;
;
SENDNOW:  CALL	SENDRDY		
	  RZ			
	  CALL	EXITTEST	
	  JMP	SENDNOW		
;.....
;
;
; Send the log-on message when requested
;
SENDLOG:  LHLD	LOGONPTR	
	  CALL	LOGLP
	  JMP	TERML
;...
;
;
LOGLP:	  CALL	SENDNOW		
	  MOV	A,M		
	  ORA	A
	  RZ
	  CALL	OUT$MODDATP	
	  MOV	B,A		
	  CALL	CKOPTION	
	  INX	H		
	  JMP	LOGLP		
;.....
;
;
CKOPTION: LDA	OPTION
	  CPI	'T'		
	  JZ	CKOPT1		
	  MOV	A,B		
	  JMP	TYPE		
;
CKOPT1:	  MVI	B,1
	  CALL	RECV		
	  RC			
	  JMP	TYPE			
;.....
;
;
; Check for exit character
;
EXITTEST: CALL	STAT		
	  RZ
	  CALL	KEYIN		
	  MOV	B,A		
;
EXITTST1: MVI	A,EXITCHR	
	  CMP	B		
	  RNZ			
	  POP	H		
	  JMP	EXITMENU	
;.....
;
;
LSTMSG:	  CALL	ILPRT
	  DB	'Printer buffer is ',0
	  LDA	LISTFLG		
	  ORA	A
	  JZ	LSTMSG1
	  CALL	ILPRT
	  DB	'ON',CR,LF,0
	  RET
;
LSTMSG1:  CALL	ILPRT
	  DB	'OFF',CR,LF,0
	  RET
;.....
;
;
; Send keyboard character to modem, also to console if "E" or "L".  If
; "E" include a LF after a CR, if either, include a LF if toggle is set.
;
NOTOG:	  CALL	SENDCHR		
	  LDA	LOCFLG		
	  ORA	A
	  JNZ	LTYPE		
	  LDA	ECHOFLG		
	  ORA	A
	  JZ	TERML		
;
LTYPE:	  MOV	A,B		
	  CALL	TYPE		
	  CALL	CHKSAVE		
	  CALL	CHKPRNT		
;
CHKCR:	  MVI	A,CR
	  CMP	B
	  JNZ	TERML		
	  LDA	ECHOFLG		
	  ORA	A
	  JNZ	CHKLF		
	  LDA	LOCFLG		
	  ORA	A
	  JZ	TERM		
;
CHKLF:	  MVI	B,LF
	  JMP	NOTOG		
;.....
;
;
;
TERML:	  CALL	RCVREADY	
	  JNZ	TERM		
	  CALL	IN$MODDATP	
	  ANI	7FH		
	  JZ	TERM		
	  MOV	B,A		
	  LDA	IGNORCTL	
	  ORA	A
	  JZ	GIVLF		
	  MOV   A,B
	  CPI	' '
	  JNC	GIVLF		
	  CPI	'G'-40H		
	  JC	TERM		
	  CPI	CR+1
	  JNC	TERM		
;
GIVLF:	  MOV   A,B		
	  CALL	TYPE		
	  CALL	CHKSAVE		
	  CALL	CHKPRNT		
	  LDA	ECHOFLG		
	  ORA	A
	  JZ	NOECH		
;
GIVLF1:	  CALL	SENDCHR		
;
NOECH:	  MVI	A,CR
	  CMP	B		
	  JNZ	TERM		
	  LDA	ECHOFLG		
	  ORA	A
	  JZ	TERM
	  CALL	SENDNOW		
	  MVI	B,LF
	  JMP	GIVLF		
;.....
;
;
; See if putting character into memory for a disk file
;
CHKSAVE:  LDA	SAVEFLG		
	  ORA	A
	  RZ			
;
	  LHLD	HLSAVE		
	  MOV	M,B		
	  INX	H		
	  SHLD	HLSAVE		
	  MVI	A,LF
	  CMP	B		
	  JNZ	CHKSAVE1	
	  MVI	A,CR		
	  CALL	TYPE
	  CALL	TYPESCLN	
;
CHKSAVE1: MOV	A,H
	  LXI	H,BUFTOP	
	  CMP	H
	  CZ	D$CTL$S		
	  RET
;
;
; Memory buffer is full, send a X-OFF (CTL-S, DC3), save any extra in-
; coming characters, then dump to disk, reset buffer to include those
; characters.
;
D$CTL$S:  CALL	SENDNOW		
	  MVI	A,XOFF		
	  CALL	OUT$MODDATP
	  CALL	CHKPRNT		
	  LXI	H,BUFFDSK	
	  CALL	GETDSK		
	  PUSH	D		
	  MVI	A,1		
	  STA	WRFLG		
	  LHLD	HLSAVE		
	  CALL	WRTDSK1		
	  POP	D		
	  LXI	H,BUFFER	
	  XRA	A		
	  CMP	D		
	  JZ    D$CTL$Q		
	  LXI	B,BUFFDSK	
;
;
; Move the characters from the aux. buffer to the main buffer and display
;
D$CTL$S1: LDAX	B		
	  MOV	M,A		
	  CALL	TYPE		
	  PUSH	H
	  PUSH	D
	  PUSH	B
	  PUSH	PSW
	  MOV	B,A
	  CALL	CHKPRNT
	  POP	PSW		
	  POP	B
	  POP	D
	  POP	H
	  CPI	LF
	  CZ	TYPESCLN
	  INX	H		
	  INX	B		
	  DCR	D		
	  JNZ	D$CTL$S1	
	  MVI	B,0		
;
D$CTL$Q:  SHLD	HLSAVE			
	  CALL	SENDNOW
	  MVI	A,XON		
	  JMP	OUT$MODDATP
;.....
;
;
; Gets any incoming characters after sending an XOFF and stores at HL.
; Returns with number of characters stored in D-reg.
;
GETDSK:	  MVI	D,0		
	  MVI	E,128		
;
GETDSK1:  CALL	JMP$INMODEM	
	  RC			
	  CPI	' '
	  JNC	GETDSK2		
	  CPI	CR+1		
	  JNC	GETDSK1
;
GETDSK2:  MOV	M,A		
	  INX	H		
	  INR	D		
	  DCR	E		
	  JNZ	GETDSK1		
	  RET			
;.....	  
;
;
; See if printing the character, if yes, put into buffer
;
CHKPRNT:  LDA	LISTFLG		
	  ORA	A
	  RZ			
;
	  LHLD	HLSAVE1		
	  MOV	M,B		
	  INX	H		
	  SHLD	HLSAVE1				
	  LDA	MAXRAM		
	  CMP	H
	  CZ	P$CTL$S		
	  RET
;
;
; Memory buffer is full, send a X-OFF (CTL-S, DC3), save any extra in-
; coming characters, then dump to disk, reset buffer to include those
; characters.
;
P$CTL$S:  CALL	SENDNOW		
	  MVI	A,XOFF		
	  CALL	OUT$MODDATP
	  LXI	H,BUFFPNT	
	  CALL	GETDSK		
	  MOV	A,D		
	  STA	DSTORE		
	  RET
;.....	
;
;
; Output has now caught up to the input and both are at top of buffer
;
P$CTL$S1: LDA	DSTORE		
	  MOV	D,A		
	  XRA	A		
	  CMP	D		
	  LXI	H,PBUFF		
	  JZ    P$CTL$Q		
	  LXI	B,BUFFPNT	
;
;
; Move the characters from the aux. buffer to the main buffer and display
;
P$CTL$S2: LDAX	B		
	  MOV	M,A		
	  CALL	TYPE		
	  PUSH	H
	  PUSH	D
	  PUSH	B
	  PUSH	PSW
	  MOV	B,A
	  CALL	CHKSAVE
	  POP	PSW
	  POP	B
	  POP	D
	  POP	H
	  CPI	LF
	  CZ	TYPESCLN
	  INX	H		
	  INX	B		
	  DCR	D		
	  JNZ	P$CTL$S2	
;
P$CTL$Q:  SHLD	HLSAVE1		
	  LXI	H,PBUFF		
	  SHLD	HLSAVE2		
	  CALL	SENDNOW		
	  MVI	A,XON		
	  JMP	OUT$MODDATP	
;.....
;
;
; List the character on the printer if it is ready, then see if at the
; top of the buffer.
;
GOLIST:	  CALL	$-$		
	  ORA	A		
	  RZ			
;
;
; Compare input and output pointers.  If at same address, nothing to
; print.
;
	  CALL	CMP$I$O		
	  RZ
;
;
; If not the same, print the character
;
GOLIST1:  MOV	C,M		
	  INX	H		
	  SHLD	HLSAVE2		
	  CALL	LISTER		
;
;
; See if the output is at the end of the buffer now.  If yes, go put
; the auxiliary characters into the start of the buffer.
;
	  LDA	MAXRAM		
	  CMP	H
	  JZ	P$CTL$S1	
;
;
; See if the output has caught up with the input - if so, reset the
; pointers to the start of the buffer
;
	  CALL	CMP$I$O
	  RNZ			
	  LXI	H,PBUFF		
	  SHLD	HLSAVE1		
	  SHLD	HLSAVE2
	  RET
;.....
;
;
; Compare the input and output pointers to see if the same address
;
CMP$I$O:  LHLD	HLSAVE1		
	  XCHG			
	  LHLD	HLSAVE2		
	  MOV	A,H
	  CMP	D
	  RNZ			
	  MOV	A,L
	  CMP	E
	  RET
;.....
;
;
GETMAX:	  LDA	SAVCCP		
	  ORA	A
	  LDA	BDOS+2		
	  JZ	GETMAX1
	  SBI	8		
;
GETMAX1:  STA	MAXRAM		
	  RET	
;.....
;
;
; This subroutine will loop until the modem receives a character or 100
; milliseconds.  It returns with a character in 'A' reg. but if no char-
; acter was recieved it returns after a timeout with carry set.
;
INMODEM:  PUSH	H
	  LXI	H,63		
	  CALL	FIXCNT
	  MOV   B,H		
	  MOV	C,L		
	  POP	H		
;
INMODEM1: CALL	RCVREADY	
	  JZ	IN$MODDATP	
	  DCX	B		
	  MOV	A,B
	  ORA	C
	  JNZ	INMODEM1	
	  STC			
	  RET
;.....
;
;
; Send a space tone to the phone line for a short time.
;
BREAK:	  LDA	PMMIMODEM		
	  ORA	A
	  JZ	BREAK1		
	  LDA	MODCTLB		
	  ANI	BRKMSK		
	  CALL	OUT$MODCTL2 	
	  MVI	B,2
	  CALL	TIMER		
	  LDA	MODCTLB		
	  CALL	OUT$MODCTL2	
	  JMP	TERM		
;...
;
;
BREAK1:	  CALL	JMP$BREAK	
	  JMP	TERM			
;.....
;
;
;=======================================================================
;		       WRITE BUFFER TO DISK
;
; Make sure this record is included in the count.
;
WRTDSK:	  LHLD	HLSAVE
	  MVI	M,EOFCHAR	
	  LXI	D,127
	  DAD	D
;
WRTDSK1:  LXI	D,-(BUFFER)	
	  DAD	D		
	  MOV	A,L		
	  ORA	A
	  RAL			
	  MOV	L,H		
	  MVI	H,0
	  PUSH	PSW
	  DAD	H
	  POP	PSW
	  MVI	A,0
	  ADC	L
	  MOV	L,A		
;
;
; See if buffer is empty.  If yes, see if we need to erase an empty
; file or have already written something.
;
	  LXI	D,BUFFER
	  LDAX	D
	  CPI	EOFCHAR		
	  JNZ	WRTDSK2		
	  LDA	WRFLG		
	  ORA	A
	  JZ	NOWRITE		
	  RET			
;.....
;	
;
; Write to disk.  Start from BUFFER (in 'DE').  Number of records to
; write in 'HL'.
;
WRTDSK2:  MVI	C,SETDMA
	  CALL	BDOSRT
	  PUSH	D
	  MVI	C,WRITE
	  LXI	D,FCB3		
	  CALL	BDOSRT
	  POP	D
	  ORA	A
	  JNZ	WRERR		
	  XCHG			
	  PUSH	D		
	  LXI	D,128		
	  DAD	D		
	  POP	D		
	  XCHG				
	  DCX	H		
	  MOV	A,H
	  ORA	L		
	  JNZ	WRTDSK2		
	  RET
;.....
;
;
; Error while writing a record, show why it is aborting
;
WRERR:	  MVI	C,CANCEL	
	  CALL	SEND
	  CALL	CLOSFIL		
	  CALL	ERXIT		
	  DB	'++ DISK IS FULL, SAVING PARTIAL FILE ++','$'
;.....
;
;
; If no data to store on the disk, close the empty file and erase it
;
NOWRITE:  CALL  CLOSFIL		
	  CALL	NOASK		
	  CALL	ILPRT
	  DB	'++ Nothing to save, erasing the file ++'
	  DB    CR,LF,BELL,0
	  JMP	DONETCA		
;.....
;
; 
; Show you are in memory-save for disk write
;
TYPESCLN: MVI	A,';'
	  JMP	TYPE		
;.....
;
;
; Save the registers, call BDOS then restore the registers
;
BDOSRT:	  PUSH	B
	  PUSH	D
	  PUSH	H
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
	  RET
;.....
;
;
INITFCB:  MVI	M,0		
	  INX	H		
	  MVI	B,11		
;
LOOP11:	  MVI	M,' '		
	  INX	H		
	  DCR	B		
	  JNZ	LOOP11
	  MVI	B,21
;
LOOP21:	  MVI	M,0
	  INX	H
	  DCR	B
	  JNZ	LOOP21
	  RET
;.....
;
;
; Scans CMDBUF coutning names and putting delimiter (space) after last
; name
;
SCAN:	  PUSH	H
	  LXI	H,NAMECT
	  MVI	M,0
	  LXI	H,CMDBUF+1	
	  MOV	C,M		
	  MVI	B,0
	  LXI	H,CMDBUF+2
	  DAD	B
	  MVI	M,' '
	  LXI	H,CMDBUF+1
	  MOV	B,M
	  INR	B
	  INR	B
;
SCANLP1:  INX	H
	  DCR	B
	  JZ	DNSCAN
	  MOV	A,M
	  CPI	' '
	  JNZ	SCANLP1
;
SCANLP2:  INX	H		
	  DCR	B
	  JZ	DNSCAN
	  MOV	A,M
	  CPI	' '
	  JZ	SCANLP2
	  SHLD	BGNMS		
	  INR	B
	  DCX	H
;
SCANLP3:  INX	H
	  DCR	B
	  JZ	DNSCAN
	  MOV	A,M
	  CPI	' '
	  JNZ	SCANLP3
	  LDA	NAMECT		
	  INR	A
	  STA	NAMECT
;
SCANLP4:  INX	H		
	  DCR	B
	  JZ	DNSCAN
	  MOV	A,M
	  CPI	' '
	  JZ	SCANLP4
	  JMP	SCANLP3
;.....
;
;
DNSCAN:	  MVI	M,' '		
	  POP	H
	  RET
;.....
;
;
; Places next name in buffer so 'CMDLINE' may parse it
;
TRTOBUF:  LHLD	BGNMS
	  MVI	B,0
	  LXI	D,FCBBUF+2
;
TBLP:	  MOV	A,M
	  CPI	' '
	  JZ	TRBFEND
	  STAX	D
	  INX	H
	  INX	D
	  INR	B		
	  JMP	TBLP
;.....
;
;
TRBFEND:  INX	H
	  MOV	A,M		
	  CPI	' '
	  JZ	TRBFEND
	  SHLD	BGNMS
	  LXI	H,FCBBUF+1	
	  MOV	M,B
	  RET
;.....
;
;
; In CP/M V.2, if file is R/O or SYS, it is changed to 'BAK'.
;
CKCPM2:	  MVI	C,CPMVER	
	  CALL	BDOS
	  ORA	A	
	  RZ
	  MVI	C,SETDMA
	  LXI	D,TBUF
	  CALL	BDOS
	  MVI	C,SRCHF
	  LXI	D,FCB
	  CALL	BDOS
	  CPI	0FFH
	  RZ
;
	  CALL	GETADD
	  LXI	D,9
	  DAD	D		
	  MOV	A,M
	  ANI	80H		
	  JNZ	MKCHG		
	  INX	H		
	  MOV	A,M
	  ANI	80H
	  RZ			
	  DCX	H
;
MKCHG:	  LXI	D,-8
	  DAD	D		
	  LXI	D,FCB+1		
	  MVI	B,11		
	  CALL	MOVE
	  LXI	H,FCB+9		
	  MOV	A,M
	  ANI	7FH		
	  MOV	M,A
	  INX	H		
	  MOV	A,M
	  ANI	7FH
	  MOV	M,A
	  LXI	D,FCB
	  MVI	C,30		
	  CALL	BDOS
;
;
; Called by 'CKBAKUP' below, return done here through 'BDOS' jump
;
PLANCHG:  LXI	H,FCB		
	  LXI	D,FCB2
	  MVI	B,9		
	  CALL	MOVE
	  LXI	H,75H		
	  MVI	M,'B'
	  INX	H
	  MVI	M,'A'
	  INX	H
	  MVI	M,'K'
	  LXI	D,FCB2
	  MVI	C,ERASE		
	  CALL	BDOS
	  LXI	H,FCB2		
	  MVI	M,0		
	  LXI	D,FCB
	  MVI	C,23		
	  JMP	BDOS
;.....
;
;
CKBAKUP:  LDA	BAKUPBYTE
	  ORA	A
	  RZ
	  MVI	C,SRCHF
	  LXI	D,FCB
	  CALL	BDOS
	  INR	A
	  RZ			
	  JMP	PLANCHG		
;.....
;
;
;***********************************************************************
;
;	      RECEIVE A RECORD FROM SENDING STATION
;
;***********************************************************************
;
;
RCVRECD:  MVI	A,1
	  STA	ERRCT
	  XRA	A
	  STA	ONERR
;
RCVRPT:	  XRA	A		
	  STA	ERRCDE		
	  CALL	CKABORT		
	  LDA	QFLG
	  ORA	A
	  JZ	RCVACK
	  CALL	ILPRT
	  DB	CR,'Awaiting # ',0
	  PUSH	H		
	  LHLD	RECDNO		
	  INX	H		
	  CALL	DECOUT		
	  CALL	ILPRT
	  DB	' (', 0
	  CALL	DHXOUT		
	  CALL	ILPRT
	  DB	'H) ',0
	  MOV	A,L		
	  POP	H		
;
;
; Message is sent so now we can send the 'ACK' for previous record, (or
; CRC or NAK for the original record to start the file).
;
RCVACK:	  LDA	ACKFLG
	  CALL	SEND
;	  
; If CRC is in effect, there is a 10-second timeout to the first SOH.
; It then tries several more times to let the sender know the system is
; capable of receiving a CRC check.  At the end of that time a NAK is
; sent which tells the sender to use CHECKSUM checking instead of CRC.
; This allows automatic compatability with systems implementing CRC -
; (Cyclic Redundancy Checking).
;
; During this time incoming CRC and NAK characters are ignored as these
; may be the ones we are sending at each timeout, coming back from the
; full duplex system.
;
RCVSQ:	  MVI	B,10-1		
	  CALL	RECV		
	  JC	RCVSTOT		
	  CPI	SOH		
	  JZ	RCVSOH
	  ORA	A
	  JZ	RCVSQ
	  CPI	CRC		
	  JZ	RCVSQ		
	  CPI	NAK		
	  JZ	RCVSQ		
	  CPI	EOT
	  STC
	  RZ
;
	  MOV	B,A
	  LDA	BATCHFLG	
	  ORA	A
	  JNZ	RCVSQ1		
	  LDA	ONERR		
	  ORA	A
	  JNZ	RCVSQ1		
	  STA	ERRCT		
	  CMA			
	  STA	ONERR		
	  JMP	RCVSERR	
;
RCVSQ1:   CALL	RCVQERR		
;
RCVSQ2:	  MOV	A,B
	  CALL	HEXO
	  CALL	ILPRT
	  DB	'H received not SOH - ',0
;
RCVPRN:	  CALL	SHOWERR		
;
RCVSERR:  MVI	B,1		
	  CALL	RECV		
	  JNC	RCVSERR 	
	  CALL	CKABORT		
	  LDA	CRCFLAG		
	  ORA	A		
	  MVI	A,NAK		
	  JZ	RCVSER1		
	  LDA	FIRSTME 	
	  ORA	A		
	  MVI	A,NAK
	  JNZ	RCVSER1		
	  MVI	A,CRC		
;
RCVSER1:  STA	ACKFLG		
	  LDA	ERRCT		
	  INR	A
	  STA	ERRCT
	  CPI	10+1		
	  JC	RCVRPT		
	  JMP	ABORT		
;.....
;
;
RCVSABT:  LXI	SP,STACK	
	  CALL	CLOSFIL		
	  CALL	NOASK		
	  CALL	ILPRT
	  DB	CR,LF,LF
	  DB	'++ RECEIVED FILE CANCELLED ++',CR,LF,BELL
	  DB	'++ UNFINISHED FILE DELETED ++',CR,LF,0
	  JMP	DONETCA
;.....
;
;
RCVQERR:  LDA	QFLG		
	  ORA	A
	  RNZ			
	  POP	H		
	  JMP	RCVSERR		
;.....
;
;
; Timeout routine each 10 seconds for no 'SOH' (Start-Of-Header)
;
RCVSTOT:  MVI	A,1
	  STA	ONERR
	  LDA	QFLG
	  ORA	A
	  JZ	RCVSTOT1
	  CALL	ILPRT
	  DB	'++ Timeout ',0
	  CALL	SHOWERR		
;
;
; Routine with switch from CRC to checksum if ERCNT reaches ERRCRC and
; are currently in CRC mode
;
RCVSTOT1: LDA	ERRCT		
	  CPI	ERRCRC		
	  JC	RCVSTOT2	
	  LDA	FIRSTME		
	  ORA	A
	  JNZ	RCVSTOT2	
	  LDA	CRCFLAG		
	  ORA	A
	  JZ	RCVSTOT2	
	  XRA	A		
	  STA	CRCFLAG		
	  CALL	ILPRT		
	  DB	'++ Switching to CHECKSUM mode ++',CR,LF,BELL,0
;
RCVSTOT2: JMP	RCVSERR		
;.....
;
;
; Get the error count and display on CRT
;
SHOWERR:  PUSH	H		
	  LHLD	ERRCT		
	  MVI	H,0		
	  CALL	DECOUT		
	  POP	H		
	  CALL	ILPRT
	  DB	' ++',CR,LF,0	
	  LDA	ERRCT
	  CPI	10+1		
	  JNC	ABORT		
	  RET
;.....
;
;
; Got SOH - get block #, block # complemented for header
;
RCVSOH:	  MVI	A,1
	  STA	FIRSTME 	
	  MVI	B,1		
	  CALL	RECV		
	  JC	RCVSTOT 	
	  MOV	D,A		
	  MVI	B,1		
	  CALL	RECV		
	  JC	RCVSTOT
	  CMA			
	  CMP	D		
	  JZ	RCVDATA		
	  CALL	RCVQERR
	  CALL	ILPRT
	  DB	'++ Bad header ',0
	  JMP	RCVPRN
;.....
;
;
RCVDATA:  MOV	A,D
	  STA	RCVRNO		
	  MVI	A,1
	  STA	DATAFLG
	  MVI	C,0		
	  LXI	H,0
	  SHLD	CRCVAL		
	  LXI	H,TBUF		
;
RCVCHR:	  MVI	B,1
	  CALL	RECV
	  JC	RCVSTOT
	  MOV	M,A		
	  INR	L		
	  JNZ	RCVCHR		
	  XRA	A 
	  STA	DATAFLG
	  LDA	CRCFLAG		
	  ORA	A
	  JNZ	RCVCRC		
	  MOV	D,C
	  MVI	B,1
	  CALL	RECV		
	  JC	RCVSTOT
	  CMP	D
	  JNZ	RCVCERR
;
CHKSNUM:  LDA	RCVRNO
	  MOV	B,A
	  LDA	RECDNO
	  CMP	B
	  JZ	RECVACK
	  INR	A
	  CMP	B
	  JNZ	ABORT
	  RET
;.....
;
;
RCVCRC:   MVI	E,2		
;
RCVCRC1:  MVI	B,1
	  CALL	RECV
	  JC	RCVSTOT		
	  DCR	E
	  JNZ	RCVCRC1
	  CALL	CRCCHK		
	  ORA	A
	  JZ	CHKSNUM		
	  CALL	RCVQERR		
	  CALL	ILPRT		
	  DB	'++ CRC error ',0
	  JMP	RCVPRN		
;.....
;
;
RCVCERR:  CALL	RCVQERR		
	  CALL	ILPRT		
	  DB	'++ CHECKSUM error ',0
	  JMP	RCVPRN		
;.....  
;
;
RECVACK:  MVI	A,ACK		
	  STA	ACKFLG		
	  JMP	RCVRECD
;.....
;
;
SENDHDR:  LDA	QFLG
	  ORA   A
	  JZ	SENDHNM
  	  CALL	ILPRT
	  DB	CR,'Sending # ',0
	  PUSH	H		
	  LHLD	RECDNO		
	  CALL	DECOUT		
	  CALL	ILPRT
	  DB	' (',0
	  CALL	DHXOUT		
	  CALL	ILPRT
	  DB	'H) ',0
	  POP	H		
;
SENDHNM:  MVI	A,SOH		
	  CALL	SEND
	  LDA	RECDNO		
	  CALL	SEND
	  LDA	RECDNO
	  CMA			
	  JMP	SEND		
;.....
;
;
SENDREC:  MVI	A,1
	  STA	DATAFLG
	  MVI	C,0
	  LXI	H,0		
	  SHLD	CRCVAL		
	  LXI	H,TBUF		
;
SENDC:	  MOV	A,M
	  CALL	SEND
	  INR	L
	  JNZ	SENDC
	  XRA	A
	  STA	DATAFLG
	  RET
;.....
;
;
SENDCKS:  MOV	A,C
	  JMP	SEND
;.....
;
;
SENDCRC:  PUSH	H
	  LHLD	CRCVAL
	  MOV	A,H
	  CALL	SEND
	  MOV	A,L
	  CALL	SEND
	  POP	H
	  XRA	A		
	  RET
;.....
;
;
; After a record is sent, a character is returned telling if it was re-
; ceived properly or not.  An ACK allows the next record to be sent.  A
; NAK sends an error message and the current record is again repeated.
; This occurs until the error limit has been reached.  If the first NAK
; is missed, it waits up to 12 seconds before declaring a 2nd error.
; This insures there is no collision with the station attempting to send
; the NAK, since it waits only 10 seconds.
;
GETACK:	  MVI	B,12		
	  CALL	RECVDG		
	  JC	GETATOT		
	  CPI	87H		
	  JZ	GETACK		
	  CPI	07H		
	  JZ	GETACK		
	  CPI	ACK		
	  RZ			

;
;
; If the ACKNAK option is 'YES' it will resend the sector when any char-
; acter other than ACK (or 07H, 87H) is received (including NAK).
;
	  MOV	B,A		
	  LDA	ACKNAK		
	  ORA	A
	  JNZ	GETACK1		
	  CPI	NAK		
	  JNZ	GETACK		
;
GETACK1:  LDA	QFLG		
	  ORA	A
	  JZ	ACKERR		
	  CALL	ILPRT
	  DB	'++ ',0
	  MOV	A,B		
	  CPI	NAK		
	  JZ	GETACK2		
	  CALL	HEXO
	  CALL	ILPRT
	  DB	'H',0
	  JMP	GETACK3
;
GETACK2:  CALL	ILPRT
	  DB	'NAK',0	
;
GETACK3:  CALL	ILPRT		
	  DB	' received not ACK - ',0
	  CALL	SHOWERR		
;
;
; Timeout or error on ACK - bump error count then resend the record if
; error limit is not exceeded.
;
ACKERR:	  LDA	ERRCT		
	  INR	A
	  STA	ERRCT
	  CPI	10+1		
	  RC			
;
ACKERR1:  CALL	ERXIT
	  DB	CR,LF,'++ SEND-FILE CANCELLED ++','$'
;.....
;
;
; Reached error limit
;
GETATOT:  CALL	ILPRT
	  DB	CR,'++ TIMEOUT - no ACK - ',0
	  CALL	SHOWERR		
	  JMP	ACKERR
;.....
;
;
CKABORT:  LDA	QFLG
	  ORA	A
	  RZ
	  CALL	STAT
	  RZ
	  CALL	KEYIN
	  CPI	CANCEL
	  RNZ
;
;
; Aborts send or receive routines and returns to command line
;
ABORT:	  LXI	SP,STACK
;
ABORTL:	  MVI	B,1		
	  CALL	RECV
	  JNC	ABORTL
	  MVI	A,CANCEL	
	  CALL	SEND
;
ABORTW:	  MVI	B,1		
	  CALL	RECV
	  JNC	ABORTW
	  MVI	A,' '
	  CALL	SEND
	  MVI	A,'B'   	
	  STA	BATCHFLG  	
	  STA	ABORTFLG	
	  XRA	A
	  STA	NFILFLG		
	  LDA	OPTION		
	  CPI	'R'
	  JZ	RCVSABT		
	  CALL	ILPRT
 	  DB	CR,LF,LF,'++ FILE CANCELLED ++',CR,LF,BELL,0
	  JMP	DONETCA
;.....
;
;
; Increment the record count
;
INCRRNO:  PUSH	H
	  LHLD	RECDNO		
	  INX	H		
	  SHLD	RECDNO		
	  MOV	A,L
	  POP	H
	  RET
;.....
;
;
; First check for any wild cards and disallow, just to be safe.  Do not
; want a group of files being accidently erased.
;
ERASFIL:  LXI	H,FCB		
	  MVI	B,11		
;
ERASFIL1: INX	H		
	  MOV	A,M		
	  CPI	'?'		
	  JZ	ERRORW		
	  DCR	B		
	  JNZ	ERASFIL1	
	  LDA	BATCHFLG	
	  ORA	A		
	  JZ	NOASK		
	  LXI	D,FCB
	  MVI	C,SRCHF
	  CALL	BDOS
	  INR	A
	  RZ			
	  CALL	ILPRT		
	  DB	'File exists - erase?  (Y/N): ',BELL,0
	  CALL	KBDCHR
	  CPI	'Y'
	  JNZ	MENU		
	  CALL	CRLF		
;
NOASK:	  LXI	D,FCB
	  MVI	C,ERASE
	  JMP	BDOS
;.....
;
;
ERRORW:   POP	H		
	  CALL	ILPRT
	  DB	'++ NO WILDCARDS ALLOWED FOR TEXT FILES ++'
	  DB	CR,LF,BELL,0
	  JMP	MENU
;.....
;
;
BLKFILE:  CALL	ILPRT		
	  DB	'++ NO FILE SPECIFIED ++',CR,LF,BELL,0
	  JMP	MENU
;.....
;
;
MAKEFIL:  LXI	D,FCB
	  MVI	C,MAKE
	  CALL	BDOS
	  INR	A
	  RNZ
	  CALL	ERXIT
	  DB	'++ ERROR -- Can''t open file ++',CR,LF
	  DB	'++ Directory is perhaps full ++','$'
;
CNREC:	  MVI	C,FILSIZ	
	  LXI	D,FCB		
	  CALL	BDOS
	  LHLD	FCB+33		
	  SHLD	RCNT		
	  LXI	H,0		
	  SHLD	FCB+33		
	  RET
;
;.....
;
;
OPENFIL:  XRA	A
	  STA	FCBEXT
	  LXI	D,FCB
	  MVI	C,OPEN
	  CALL	BDOS
	  INR	A
	  JNZ	SENDTIME	
	  CALL	ERXIT		
	  DB	'++ FILE NOT FOUND ++','$'
;.....
;
;
CLOSFIL:  LXI	D,FCB		
	  MVI	C,CLOSE
	  CALL	BDOS		
	  INR	A
	  RNZ
	  JMP	ERXIT1		
;.....
;
;
; Update record read
;
RDRECD:	  LDA	RECINBF		
	  DCR	A
	  STA	RECINBF
	  JM	RDBLOCK
	  LHLD	RECPTR		
	  LXI	D,128
	  CALL	MOVE128		
	  SHLD	RECPTR		
	  RET
;.....
;
;
; Buffer empty so read in another block (up to 16k or 128 records) from
; disk
;
RDBLOCK:  LDA	EOFLG
	  CPI	1
	  STC
	  RZ
	  MVI	C,0
	  LXI	D,BUFFER
;
RDRECLP:  PUSH	B
	  PUSH	D
	  MVI	C,SETDMA
	  CALL	BDOS
	  LXI	D,FCB
	  MVI	C,READ
	  CALL	BDOS
	  POP	D
	  POP	B
	  ORA	A
	  JZ	RDRECOK
	  DCR	A
	  JZ	REOF
	  CALL	ERXIT
	  DB	'++ FILE READ ERROR ++','$'
;
RDRECOK:  LXI	H,128
	  DAD	D
	  XCHG
	  INR	C
	  MOV	A,C
	  CPI	BUFSIZ*8	
	  JZ	RDBFULL
	  JMP	RDRECLP
;...
;
;
REOF:	  MVI	A,1
	  STA	EOFLG
	  MOV	A,C
;
;
; Buffer full or rceived "End Of File (EOF)"
;
RDBFULL:  STA	RECINBF
	  LXI	H,BUFFER
	  SHLD	RECPTR
	  MVI	C,SETDMA
	  LXI	D,TBUF
	  CALL	BDOS
	  JMP	RDRECD
;.....
;
;
; Write a record
;
WRRECD:	  LHLD	RECPTR
	  XCHG
	  LXI	H,128
	  CALL	MOVE128
	  XCHG
	  SHLD	RECPTR		
	  LDA	RECINBF		
	  INR	A
	  STA	RECINBF
	  CPI	BUFSIZ*8 	
	  RNZ			
;
;
; Write a 16k block to disk (128 RECORDS)
;
WRBLOCK:  LDA	RECINBF		
	  ORA	A
	  RZ			
	  MOV	C,A		
	  LXI	D,BUFFER	
;
DSKWRT:	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MVI	C,SETDMA
	  CALL	BDOS
	  MVI	C,WRITE
	  LXI	D,FCB
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
	  ORA	A
	  JNZ	WRERR		
	  LXI	H,128		
	  DAD	D
	  XCHG
	  DCR	C		
	  JNZ	DSKWRT
	  XRA	A
	  STA	RECINBF		
	  LXI	H,BUFFER	
	  SHLD	RECPTR
	  RET
;.....
;
;
;----> RECV: Receive a character
;
; Timeout time is in B, in seconds.  Entry via 'RECVDG' deletes garbage
; characters on the line.  For example, having just sent a sector,
; calling RECVDG will delete any line noise induced characters LONG
; before the ACK/NAK would be received.  Returns with character in 'A'.
;
RECVDG:	  CALL	CKCHAR		
;
RECV:	  PUSH	D		
	  MOV	A,B		
	  RAL
	  RAL
	  MOV	B,A
;
MSEC:	  CALL	CKABORT		
	  PUSH	H		
	  LXI	H,175		
	  CALL	FIXCNT
	  XCHG			
	  POP	H		
;
MWTI:	  CALL	RCVREADY	
	  JZ	MCHAR		
	  DCR	E
	  JNZ	MWTI
	  DCR	D
	  JNZ	MWTI
	  DCR	B		
	  JNZ	MSEC		
	  POP	D		
	  STC			
	  RET
;.....
;
;
MCHAR:	  CALL	IN$MODDATP
	  POP	D		
	  PUSH	PSW
	  CALL	CRCUPD		
	  ADD	C	
	  MOV	C,A
	  LDA	RSEEFLG
	  ORA	A
	  JZ	MONIN
	  LDA	VSEEFLG
	  ORA	A
	  JNZ	NOMONIN
	  LDA	DATAFLG
	  ORA	A
	  JZ	NOMONIN
;
MONIN:	  POP	PSW
	  PUSH	PSW
	  CALL	SHOW
;
NOMONIN:  POP	PSW
	  ORA	A
	  RET
;.....
;
;
; Send a character to the modem
;
SEND:	  PUSH	PSW
	  LDA	SSEEFLG
	  ORA	A
	  JZ	MONOUT
	  LDA	VSEEFLG
	  ORA	A
	  JNZ	NOMONOT
	  LDA	DATAFLG
	  ORA	A
	  JZ	NOMONOT
;
MONOUT:	  POP	PSW
	  PUSH	PSW
	  CALL	SHOW
;
NOMONOT:  POP	PSW
	  PUSH	PSW
	  CALL	CRCUPD		
	  ADD	C
	  MOV	C,A
;
SENDW:	  CALL	SENDRDY
	  JNZ	SENDW
	  POP	PSW
	  JMP	OUT$MODDATP	
;.....
;
;
; Waits for the first character received while waiting to send a file.
; If a character is not received in one second, it loops again until a
; char. is received or it times out.  The count is set for 100 seconds
; before timeout.  This gives the receiving station ample time to name
; a file, etc.
;
WAITNAK:  CALL	ILPRT
	  DB	'Waiting ready signal',CR,LF,0
;
WAITNLP:  CALL	CKABORT
	  MVI	B,1
	  CALL	RECV
	  CPI	CANCEL		
	  JZ	ABORT
	  CPI	CRC		
	  JZ	WAITCRC		
	  CPI	NAK
	  JZ	WAITCHK
	  DCR	E
	  JNZ	WAITNLP
	  JMP	ABORT
;...
;
;
WAITCRC:  CALL	ILPRTQ
	  DB	'CRC request received',CR,LF,0
	  MVI	A,1
	  STA	CRCFLAG		
	  RET
;.....
;
;
WAITCHK:  LDA	BATCHFLG	
	  ORA	A
	  RZ
	  CALL	ILPRTQ
	  DB	'Got checksum request',CR,LF,0
	  RET
;
WAITCHK1: CALL	ILPRTQ
	  DB	'Name NAK received',CR,LF,0
	  RET
;.....
;
;
; Finished with the file transfer
;
DONE: 	  LDA	BATCHFLG	
	  ORA	A
	  JNZ	DONETC		
	  LDA	QFLG
	  ORA	A
	  JZ	NMSTRNS
	  MVI	B,12		
	  LXI	H,FTRNMSG
	  MVI	A,0
;
ZEROLP:	  MOV	M,A
	  INX	H
	  DCR	B
	  JNZ	ZEROLP
	  MVI	B,12		
	  LXI	H,FCB+1		
	  LXI	D,FTRNMSG
;
LOADMSG:  MVI	A,4		
	  CMP	B
	  JZ	PERIOD		
	  MOV	A,M	
	  CPI	' '		
	  JZ	SKPSP	
	  STAX	D		
	  INX	D
;
SKPSP:	  INX	H
	  DCR	B
	  MOV	A,B
	  ORA	A		
	  JZ	FTRNMSG0	
	  JMP	LOADMSG		
;.....
;
;
PERIOD:	  MOV	A,M
	  CPI	' '		
	  JZ	FTRNMSG0	
	  MVI	A,'.'		
	  STAX	D
	  INX	D
	  DCR	B
	  JMP	LOADMSG
;.....
;
;
FTRNMSG0: CALL	ILPRT
	  DB	CR,LF
;
FTRNMSG:  DS	12
	  DB	0
	  CALL	ILPRT
	  DB	' Transferred',CR,LF,LF,BELL,0
;
NMSTRNS:  LDA	FCB		
	  STA	DISKNO
	  LXI	H,FCB		
	  CALL	INITFCB
	  LDA	DISKNO		
	  STA	FCB
	  LXI	H,RESTSN	
	  LXI	D,RECDNOB	
	  MVI	B,RECDNOE-RECDNOB 
	  CALL	MOVE
	  CALL	SENDNOW		
	  CALL	CKCHAR		
	  LDA	SENDFLG		
	  ORA	A		
	  JNZ	SENDFIL2	
	  JMP	RCVFIL1		
;.....
;
;
DONETC:	  CALL	CKABORT		
	  CALL	ILPRT
	  DB	CR,LF,'[Transfer Completed]',CR,LF,BELL,0
;
DONETCA:  LDA	XITFLG		
	  ORA	A
	  JZ	BYEBYE		
	  LDA	DISCFLG		
	  ORA	A
	  JZ	DONETCD		
;
DONETCB:  CALL	JMP$NOPARITY	
	  XRA	A
	  STA	CRCFLAG		
	  STA	FIRSTME		
	  STA	FSTFLG		
	  STA	NFILFLG		
	  STA	SAVEFLG		
	  LDA	VSEEFLG		
	  ORA	A
	  JNZ	DONETCC		
	  CMA
	  STA	QFLG		
	  STA	VSEEFLG		
;
DONETCC:  LXI	H,QFLG		
	  MOV	A,M
	  ORA	A
	  MVI	M,'Q'		
	  JZ	MENU		
	  LDA	ABORTFLG	
	  ORA	A
	  JNZ	MENU		
	  LDA	TERMFLG		
	  ORA	A		
	  JNZ	MENU		
	  CALL	CRLF
	  JMP	TERM
;.....
;
;
DONETCD:  CALL	ILPRT
	  DB	CR,LF,'<< DISCONNECTED >>',BELL,CR,LF,0
	  CALL	JMP$GOODBYE	
	  LDA	PMMIMODEM
	  ORA	A
	  CNZ	JMP$DISCONNT
	  LDA	SMARTMODEM
	  ORA	A
	  CNZ	JMP$DISCONNT
	  JMP	MENU0		
;.....
;
;
MOVEFCB:  LXI	H,FCB+16
	  LXI	D,FCB
	  MVI	B,16
	  CALL	MOVE
	  XRA	A
	  STA	FCBSNO
	  STA	FCBEXT
	  RET
;.....
;
;
SHOW:	  CPI	LF
	  JZ	CTYPE
	  CPI	CR
	  JZ	CTYPE
	  CPI	9
	  JZ	CTYPE
	  CPI	' '
	  JC	SHOWHEX
	  CPI	7FH
	  JC	CTYPE
;
SHOWHEX:  PUSH	PSW
	  MVI	A,'('
	  CALL	CTYPE
	  POP	PSW
	  CALL	HEXO
	  MVI	A,')'
	  JMP	CTYPE
;.....
;
;
CTYPE:	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MOV	E,A
	  MVI	C,WRCON
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
	  RET
;.....
;
;
CRLF:	  PUSH	PSW
	  MVI	A,CR
	  CALL	TYPE
	  MVI	A,LF
	  CALL	TYPE
	  POP	PSW
	  RET
;.....
;
;
STAT:	  PUSH	B
	  PUSH	D
	  PUSH	H
;
VSTAT:	  CALL	$-$		
	  POP	H		
	  POP	D
	  POP	B
	  ORA	A
	  RET
;.....
;
;
KEYIN:	  PUSH	B
	  PUSH	D
	  PUSH	H
;
VKEYIN:	  CALL	$-$		
	  POP	H		
	  POP	D
	  POP	B
	  RET
;.....
;
;
LISTER:	  PUSH	B
	  PUSH	D
	  PUSH	H
;
VLIST:	  CALL	$-$		
	  POP	H		
	  POP	D
	  POP	B
	  RET
;.....
;
;
TYPE:	  PUSH	PSW
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MOV	C,A
;
VTYPE:	  CALL	$-$		
	  POP	H		
	  POP	D
	  POP	B
	  POP	PSW
	  RET
;.....
;
;
; Get a character from the keyboard, convert to upper-case if needed,
; and show on CRT
;
KBDCHR:	  CALL	KEYIN		
	  CALL	UCASE		
	  CALL	TYPE		
	  RET
;.....
;
;
UCASE:	  CPI	61H		
	  RC			
	  CPI	7AH+1		
	  RNC
	  ANI	5FH
	  RET
;.....
;
;
DECOUT:	  PUSH	PSW
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  LXI	B,-10
	  LXI	D,-1
;
DECOU1:	  DAD	B
	  INX	D
	  JC	DECOU1
	  LXI	B,10
	  DAD	B
	  XCHG
	  MOV	A,H
	  ORA	L
	  CNZ	DECOUT
	  MOV	A,E
	  ADI	'0'
	  CALL	CTYPE
	  POP	H
	  POP	D
	  POP	B
	  POP	PSW
	  RET
;.....
;
;
;---->	DHXOUT: - double precision hex output routine
;
DHXOUT:	  PUSH	H
	  PUSH	PSW
	  MOV	A,H		
	  CALL	HEXO		
	  MOV	A,L		
	  CALL	HEXO		
	  POP	PSW
	  POP	H
	  RET
;.....
;
;
; Prints a hex value in 'A' on the CRT
;
HEXO:	  PUSH	PSW
	  RAR
	  RAR
	  RAR
	  RAR
	  CALL	NIBBL
	  POP	PSW
;
NIBBL:	  ANI	0FH
	  CPI	10
	  JC	ISNUM
	  ADI	7
;
ISNUM:	  ADI	'0'		
	  JMP	CTYPE
;.....
;
;
; Displays the control-characters shown in the menu
;
SHFTYPE:  PUSH	PSW
	  CALL	ILPRT
	  DB	'CTL-',0
	  POP	PSW
	  ADI	40H		
	  CALL	TYPE		
	  JMP	ILPRT
;.....
;
;
; Write a string of characters to the CRT
;
ILPRT:	  XTHL
;
ILPRT1:	  MOV	A,M		
	  ORA	A		
	  JZ	ILPRT2		
	  CALL  CTYPE		
	  INX	H			
	  JMP	ILPRT1
;
ILPRT2:	  XTHL			
	  RET
;.....
;
;
; Write a string of characters unless in the Quiet mode
;
ILPRTQ:	  XTHL
;
ILPRTQ1:  MOV	A,M		
	  ORA	A		
	  JZ	ILPRTQ2		
	  LDA	QFLG
	  ORA	A
	  MOV	A,M
	  CNZ	CTYPE		
	  INX	H			
	  JMP	ILPRTQ1
;
ILPRTQ2:  XTHL			
	  RET
;.....
;
;
PRTMSG:	  MVI	C,PRINT		
	  JMP	BDOS
;.....
;
;
; Displays error statement then resturns to command mode
;
ERXIT:	  POP	D
	  CALL	PRTMSG
	  MVI	A,BELL
	  CALL	TYPE
	  CALL	CRLF
;
ERXIT1:	  MVI	A,1
	  STA	ABORTFLG	
	  LDA	BATCHFLG	
	  ORA	A
	  JNZ	DONETCB		
	  JMP	ABORT		
;.....
;
;
; Exits directly to CP/M, with no reboot unless you have selected pos-
; sible overwriting of 'CCP'
;
EXIT:	  LDA	OLDUSER		
	  MOV	E,A
	  CALL	SETUSER
	  MVI	C,SETDMA
	  LXI	D,TBUF		
	  CALL	BDOS
	  MVI	B,2		
	  CALL	TIMER
	  CALL	CKCON		
	  LDA	NFILFLG		
	  ORA	A
	  CNZ	WRTFIL1		
	  LDA	SAVCCP		
	  ORA	A
	  JZ	0000H		
;
EXIT1:	  XRA	A		
	  LHLD	STACK		
	  SPHL			
	  RET
;.....
;
;
; Catch any extra keyboard characters coming through BDOS
;
CKCON:	  MVI	C,CONST		
	  CALL	BDOS
	  ORA	A
	  RZ			
	  MVI	C,RDCON		
	  CALL	BDOS
	  XRA	A		
	  JMP	CKCON		
;.....
;
;	
MOVE128:  MVI	B,128
;
MOVE:	  MOV	A,M
	  STAX	D
	  INX	H
	  INX	D
	  DCR	B
	  JNZ	MOVE
	  RET
;.....
;
;
; Sends the digit to the Smartmodem
;
SENDCHR:  CALL	SENDNOW		
	  MOV	A,B		
	  JMP	OUT$MODDATP	
;.....
;
;
; Initializes CP/M file control blocks AT 5CH and 6CH
;
SETFCB:	  LXI	D,CMDBUF
	  LXI	H,FCB
	  JMP	CMDLINE
;.....
;
;
; Adjusts loop counter for the selected clock speed.  Returns with delay
; in 'HL'.
;
FIXCNT:	  LDA	CLOCK		
	  PUSH	D		
	  PUSH	H
	  POP	D		
;
CNTMUL:	  DAD	D		
	  DCR	A		
	  JNZ	CNTMUL
	  POP	D		
	  RET
;.....
;
;  
;=======================================================================
;
; Loads a command line addressed by 'DE' registers (max # characters in
; line in 'DE', number of characters in line in DE+1, line starts in
; DE+2) into FCB addressed by 'HL' registers.  The FCB should be at least

; 33 bytes in length.  The command line buffer must have a maximum length
; at least one more than the greatest number of characters that will be
; needed.

CMDLINE:  PUSH	PSW
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  CALL	INITIAL		
	  XCHG			
	  INX	H		
	  MOV	E,M		
	  MVI	D,0
	  INX	H
	  DAD	D		
	  MVI	M,CR		
	  POP	H		
	  POP	D
	  PUSH	D
	  PUSH	H
	  INX	D		
	  INX	D
	  CALL	DRIVE
;
NAME1:	  MVI	C,8		
	  CALL	TRANS
	  CPI	CR
	  JZ	DONEL
	  CPI	' '		
	  JZ	NAME2		
	  POP	H		
	  PUSH	H		
	  LXI	B,9
	  DAD	B
	  MVI	C,3		
	  CALL	TRANS
	  CPI	CR
	  JZ	DONEL
;
NAME2:	  LDAX	D		
	  CPI	' '		
	  JNZ	NAME3
	  INX	D
	  JMP	NAME2
;
NAME3:	  POP	H		
	  PUSH	H		
	  LXI	B,16
	  DAD	B
	  CALL	DRIVE
	  MVI	C,8
	  CALL	TRANS
	  CPI	CR
	  JZ	DONEL
	  POP	H		
	  PUSH	H
	  LXI	B,25
	  DAD	B
	  MVI	C,3
	  CALL	TRANS
;
DONEL:	  POP	H
	  PUSH	H
	  INX	H		
	  CALL	SCANL		
	  POP	H
	  PUSH	H
	  LXI	B,17		
	  DAD	B
	  CALL	SCANL
	  POP	H
	  POP	D
	  POP	B
	  POP	PSW
	  RET
;.....
;
;
; Subroutines for CMDLINE section
;
INITIAL:  PUSH	H	
	  PUSH	B	
	  MVI	M,0	
	  INX	H
	  MVI	B,11
	  MVI	A,' '
	  CALL	INITFILL
	  MVI	B,5
	  XRA	A
	  CALL	INITFILL
	  MVI	B,11
	  MVI	A,' '
	  CALL	INITFILL
	  MVI	B,4
	  XRA	A
	  CALL	INITFILL
	  POP	B
	  POP	H
	  RET
;.....
;
;
INITFILL: MOV	M,A
	  INX	H
	  DCR	B
	  JNZ	INITFILL
	  RET
;.....
;
;
DRIVE:	  INX	D		
	  LDAX	D		
	  DCX	D
	  CPI	':'
	  JNZ	DEFDR		
	  LDAX	D		
	  ANI	5FH
	  SUI	40H		
	  MOV	M,A		
	  INX	D		
	  INX	D		
;
DEFDR:	  INX	H		
	  RET
;.....
;
;
TRANS:	  LDAX	D		
	  INX	D		
	  CPI	CR		
	  RZ			
;
	  CPI	'.'		
	  RZ			
	  CPI	' '
	  RZ
	  DCR	C
	  JM	TRANS		
	  MOV	M,A		
	  INX	H		
	  JMP	TRANS
;...
;
;
SCANL:	  MVI	B,8		
;
TSTNAM:	  MOV	A,M
	  CPI	'*'		
	  JZ	FILL1		
	  INX	H
	  DCR	B
	  JNZ	TSTNAM
	  JMP	TSTTYP
;...
;
;
FILL1:	  CALL	FILL
;
TSTTYP:	  MVI	B,3		
;
TSTTYPL:  MOV	A,M		
	  CPI	'*'
	  JZ	FILL2
;
	  INX	H
	  DCR	B
	  JNZ	TSTTYPL
	  RET
;.....
;
;
FILL2:	  CALL	FILL
	  RET
;.....
;
;
FILL:	  MVI	M,'?'		
	  INX	H
	  DCR	B
	  JNZ	FILL
	  RET

;=======================================================================
;
; LISTS DIRECTORY AND GIVES FREE SPACE REMAINING ON THE REQUESTED DRIVE.
;
;
; Disk system reset - currently bypassed, if you wish this feature, put
;	  JMP DIRLIST2 instead of JMP DIRLIST3 in the eighth line.  The
;	  current disk (plus the A: drive) will then reset each DIR re-
;	  quest.  You can also reset the disk with the LOG command when
;	  when inserting a different one.  This saves a reset each time
;	  DIR might be requested.
;
DIRLIST:  CALL	GETDISK	
	  ADI	'A'		
	  STA	DRNAME		
	  STA	ACTDRV		
;
DIRLIST1: JMP	DIRLIST3
;
DIRLIST2: MVI	C,RESET		
	  CALL	BDOS
;
;
; Directory list routine
;
DIRLIST3: LXI	D,CMDBUF	
	  LXI	H,FCB		
	  CALL	CMDLINE		
	  LXI	H,FCB4
	  CALL	INITFCB
	  LDA	FCB2		
	  STA	FCB4
	  LDA	FCB2+1
	  CPI	' '		
	  PUSH	PSW
	  CZ	QSTMARK
	  POP	PSW
	  CNZ	MOVNAME		
	  CALL	DRIVEL
	  MVI	C,SETDMA
	  LXI	D,TBUF
	  CALL	BDOS
	  LDA	NOOFCOL		
	  STA	NAMECT		
	  LXI	D,FCB4
	  MVI	C,SRCHF		
  	  CALL	BDOS
	  INR	A		
	  JNZ	DIRLOOP
	  CALL	ILPRT
	  DB	'++ FILE NOT FOUND ++',0
	  JMP	STORAGE		
;
DIRLOOP:  CALL	GETADD
	  INX	H		
	  LXI	D,PRTNAME
	  LXI	B,8
	  CALL	MOVER
	  INX	D
	  LXI	B,3
	  CALL	MOVER
	  CALL	ILPRT
;
PRTNAME:  DB	'        ','.','   ',0   
;
NEXTSR:	  LXI	D,FCB4
	  MVI	C,SRCHN		
	  CALL	BDOS
	  INR	A		
	  JZ	STORAGE		
	  PUSH	PSW
	  PUSH	D
	  PUSH	H
	  LDA	NAMECT
	  DCR	A
	  STA	NAMECT		
	  ORA	A
	  CZ	CRLF		
	  JNZ	FENCE
	  LDA	NOOFCOL		
	  STA	NAMECT
	  JMP	NOFENCE		
;
FENCE:	  CALL	ILPRT
	  DB	' : ',0		
;				;..LAST FILENAME
NOFENCE:  POP	H
	  POP	D
	  POP	PSW
	  JMP	DIRLOOP
;.....
;
;
; Determine storage remaining on default drive
;
STORAGE:  CALL	CKCPM3
	  MVI	C,DSKPAR	
	  CALL	BDOS
	  INX	H
	  INX	H
	  MOV	A,M		
	  STA	BSHIFTF
	  INX	H		
	  MOV	A,M		
	  STA	BMASK
	  INX	H
	  INX	H
	  MOV	E,M		
	  INX	H
	  MOV	D,M
	  XCHG
	  SHLD	BMAX		
	  MVI	C,DSKALL	
	  CALL	BDOS
	  XCHG			
	  LHLD	BMAX
	  INX	H
	  LXI	B,0		
;
GSPBYT:	  PUSH	D		
	  LDAX	D
	  MVI	E,8		
;
GSPLUP:	  RAL			
	  JC	NOTFRE
	  INX	B
;
NOTFRE:	  MOV	D,A		
	  DCX	H
	  MOV	A,L
	  ORA	H
	  JZ	ENDALC		
	  MOV	A,D		
	  DCR	E		
	  JNZ	GSPLUP		
	  POP	D		
	  INX	D		
	  JMP	GSPBYT		
;
ENDALC:	  POP	D		
	  MOV	L,C		
	  MOV	H,B
	  LDA	BSHIFTF		
	  SUI	3		
	  JZ	PRTFREE		
;
FREKLP:	  DAD	H		
	  DCR	A
	  JNZ	FREKLP
;
PRTFREE:  CALL 	DECOUT		
	  LXI	D,FREEMSG
	  JMP	PRTMSG
;.....
;
;
; Subroutines for 'DIRLIST' section
;
QSTMARK:  MVI	A,'?'		
	  MVI	B,11
	  LXI	H,FCB4+1
;
QSTLP:	  MOV	M,A
	  INX	H
	  DCR	B
	  JNZ	QSTLP
	  RET
;.....
;
;
MOVNAME:  LXI	H,FCB2+1
	  LXI	D,FCB4+1
	  LXI	B,11
	  CALL	MOVER
	  RET
;.....
;
;
GETADD:	  DCR	A		
	  ADD	A		
	  ADD	A
	  ADD	A
	  ADD	A
	  ADD	A
	  ADI	TBUF		
	  MOV	L,A
	  MVI	H,0
	  RET
;.....
;
;
DRIVEL:	  LDA	FCB4		
	  ORA	A		
	  JZ	PRNTHD
	  PUSH	PSW
	  DCR	A
	  MOV	E,A
	  MVI	C,SELDSK
	  CALL	BDOS
	  POP	PSW
	  ADI	40H		
	  STA	DRNAME		
	  STA	ACTDRV
;
PRNTHD:	  CALL	ILPRT
	  DB	'Drive '
;
DRNAME:	  DB	' :',CR,LF,0
	  RET
;.....
;
;
; Initialized storage
;
FREEMSG:  DB 	'k bytes free on drive '
ACTDRV:	  DB	' :',CR,LF,'$'
;
;
; Uninitialized storage
;
BMAX:	  DS	2		
BMASK:	  DS	1		
BSHIFTF:  DS	1		
;.....
;
;
;=======================================================================
;
; Duplicates 'READ BUFFER' routine same as CP/M function 10, but does
; not use CTL-C (reason for the routine).  Does allow controls U, R, E
; and H (BACKSPACE).  Outputs bell if the input is greater than the
; buffer.
;
INBUF:	  PUSH	PSW
	  PUSH	H
	  PUSH	B 
	  PUSH	D		
;
INBUFA:	  CALL	CLEARBUF	
	  POP	D		
	  PUSH	D		
	  XRA	A
	  INX	D		
	  STAX	D		
	  INX	D
	  XCHG			
;
INBUFB:	  CALL	KEYIN		
	  CALL	UCASE		
	  CPI	CR		
	  JZ	INBUFR		
	  CPI	08H		
	  JZ	DELETE
	  CPI	7FH		
	  JZ	DELETE
	  CPI	'U'-40H		
	  JZ	INBUFO		
	  CPI	'R'-40H		
	  JZ	RETYPE
	  CPI	EXITCHR		
	  JZ	INBUFC
	  CPI	' '		
	  JC	INBUFB		
;
INBUFC:	  MOV	B,A		
	  XCHG			
	  POP	H		
	  PUSH	H		
	  INX	H		
	  INR	M		
	  DCX	H		
	  MOV	A,M		
	  INX	H		
	  CMP	M		
	  JC	ALERTL		
	  XCHG			
	  MOV	M,B		
	  MOV	A,B		
	  CPI	EXITCHR		
	  JZ	INBUFR		
	  CALL	TYPE
	  INX	H		
	  JMP	INBUFB		
;...
;
;
DELETE:	  XCHG			
	  POP	H		
	  PUSH	H		
	  INX	H		
	  MOV	B,A		
	  MOV	A,M
	  SUI	1		
	  MOV	M,A
	  JC	NODEL		
	  XCHG			
	  DCX	H		
	  MOV	A,B		
	  MOV	B,M		
	  MVI	M,' '		
	  CPI	8
	  JZ	BKSPC
	  CPI	7FH
	  JZ	BKSPC0
	  JMP	INBUFB		
;.....
;
;
NODEL:	  INR	M		
	  XCHG			
	  JMP	INBUFB
;.....
;
;
BKSPC0:	  MVI	A,08H
;
BKSPC:	  CALL	TYPE		
	  MVI	A,' '
	  CALL	TYPE
	  MVI	A,8
	  CALL	TYPE
	  JMP	INBUFB
;.....
;
;
INBUFO:	  MVI	A,'#'		
	  CALL	TYPE
	  CALL	CRLF
	  JMP	INBUFA
;.....
;
;
RETYPE:	  POP	D
	  PUSH	D
	  INX	D		
	  LDAX	D		
	  MOV	B,A
	  MVI	A,'#'
	  CALL	TYPE
	  CALL	CRLF
	  MOV	A,B		
	  ORA	A
	  JZ	INBUFB
;...
;
;
CTLRLP:	  INX	D
	  LDAX	D
	  CALL	TYPE
	  DCR	B
	  JNZ	CTLRLP
	  JMP	INBUFB
;.....
;
;	
ALERTL:	  MVI	A,BELL		
	  CALL	TYPE
	  DCR	M
	  XCHG
	  JMP	INBUFB
;.....
;
;
PCRLF:	  CALL	CRLF
	  JMP	INBUFB
;.....
;
;
INBUFR:	  CALL	CRLF		
	  POP	D
	  POP	B
	  POP	H
	  POP	PSW
	  RET
;.....
;
;
CLEARBUF: POP	D		
	  POP	H		
	  PUSH	H		
	  PUSH	D		
	  MOV	B,M		
	  INX	H		
	  INX	H		
	  MVI	A,' '
;
CLEARL:	  MOV	M,A
	  INX	H
	  DCR	B
	  JNZ	CLEARL
	  RET
;.....
;
;
;=======================================================================
;
; In-line compare.  Compares string addressed by 'DE' to string after
; call (ends with zero).  Return with carry set means strings not the
; same.  All registers except 'A'-reg are unaffected.
;
INLNCOMP: XTHL			
	  PUSH	D
;
ILCOMPL:  MOV	A,M		
	  ORA	A		
	  JZ	SAME
	  LDAX	D
	  CMP	M
	  JNZ	NOTSAME
	  INX	H
	  INX	D
	  JMP	ILCOMPL
;...
;
;
NOTSAME:  XRA	A		
;
NSLP:	  INX	H		
	  CMP	M		
	  JNZ	NSLP		
	  STC
;
SAME:	  POP	D
	  INX	H		
	  XTHL			
	  RET
;.....
;
;
;=======================================================================
;		    MULTI-FILE ACCESS ROUTINE	
;
; Multi-file access subroutine.  Allows processing of multiple files
; (i.e., *.ASM) from disk.  Builds the correct name in the FCB each time
; it is called.  The command is used in programs to process single or
; multiple files.  The FCB is set up with the next name, ready to do
; normal processing (open, read, etc.) when routine is called.  Carry is
; set if no more names are found.
                
MFNAME:	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MVI	C,SETDMA
	  LXI	D,TBUF
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
	  XRA	A
	  STA	FCBEXT
	  LDA	MFFLG1
	  ORA	A
	  JNZ	MFNAME1
	  MVI	A,1
	  STA	MFFLG1
	  LXI	H,FCB
	  LXI	D,MFNAME5
	  LXI	B,12
	  CALL	MOVER
	  LDA	FCB
	  STA	MFNAME6		
 	  LXI	H,MFNAME5
	  LXI	D,FCB
	  LXI	B,12
 	  CALL	MOVER
 	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MVI	C,SRCHF
	  LXI	D,FCB
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
	  JMP	MFNAME2
;...
;
;
MFNAME1:  LXI	H,MFNAME6
	  LXI	D,FCB
	  LXI	B,12
	  CALL	MOVER
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MVI	C,SRCHF
	  LXI	D,FCB
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
	  LXI	H,MFNAME5
	  LXI	D,FCB
	  LXI	B,12
	  CALL	MOVER
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  MVI	C,SRCHN
	  LXI	D,FCB
	  CALL	BDOS
	  POP	H
	  POP	D
	  POP	B
;
MFNAME2:  INR	A
	  STC
	  JNZ	MFNAME3
	  STA	MFFLG1
	  RET
;.....
;
; 	
MFNAME3:  DCR	A
	  ANI	3
	  ADD	A
	  ADD	A
	  ADD	A
	  ADD	A
	  ADD	A
	  ADI	81H
	  MOV	L,A
	  MVI	H,0
	  PUSH	H		
	  LXI	D,MFNAME6+1
	  LXI	B,11
	  CALL	MOVER
	  POP	H
	  LXI	D,FCB+1
	  LXI	B,11
	  CALL	MOVER
	  XRA	A
	  STA	FCBEXT
	  STA	FCBRNO
	  RET
;.....
;
;
MOVER:	  MVI	A,2
	  INR	A
	  JPE	MFNAME4
	  DB	0EDH,0B0H	
	  RET
;.....
;
;	
MFNAME4:  MOV	A,M		
	  STAX	D
	  INX	H
	  INX	D
	  DCX	B
	  MOV	A,B
	  ORA	C
	  JNZ	MFNAME4
	  RET
;.....
;
;		(END OF MULTI-FILE ACCESS ROUTINE)	
;=======================================================================
;		   CALCULATE FILE TRANSFER TIME
;
;
; Shows the time to transfer a file at various baud rates.  (110-19200)
;
SENDTIME: CALL	ILPRT	        
	  DB	'File open: ',0
	  LHLD	RCNT		
	  CALL	DECOUT		
	  CALL	ILPRT
	  DB	' (',0
	  CALL	DHXOUT		
	  CALL	ILPRT
	  DB	'H) records',CR,LF
	  DB	'Send time: ',0
	  LDA	MSPEED		
	  MVI	D,0
	  MOV	E,A		
	  LXI	H,BTABLE	
	  DAD	D		
	  DAD	D		
	  MOV	E,M
	  INX	H
	  MOV	D,M
	  LHLD	RCNT		
	  CALL	DVHLDE		
	  PUSH	H
	  MOV	L,C
	  MOV	H,B
	  CALL	DECOUT		
	  CALL	ILPRT
	  DB	' mins, ',0
	  LXI	H,RECDBL	
	  LXI	D,0		
	  LDA	MSPEED		
	  MOV	E,A
	  DAD	D		
	  MOV	A,M		
	  POP	H		
	  CALL	MULHLA		
	  CALL	SHFTHL
	  CALL	SHFTHL
	  CALL	SHFTHL
	  CALL	SHFTHL	
	  MVI	H,0
	  CALL	DECOUT		
	  CALL	ILPRT
	  DB	' secs at ',0
	  CALL	PRTBAUD
	  CALL	ILPRTQ
          DB	'To cancel: use CTL-X',CR,LF,0
	  RET
;
BTABLE:	DW	5,13,20,24,30,48,96,192,320,480,0 
RECDBL:	DB	192,74,48,40,32,20,10,5,3,2,0	  
;.....
;
;
; Shows baud rates set for 'time to send' file transfer
;
PRTBAUD:  LXI	H,BAUDSPD
	  MVI	D,0
	  LDA	MSPEED		
	  MOV	E,A		
	  ADD	A		
	  ADD	A		
	  ADD	E		
	  ADD	E
	  MOV	E,A
	  DAD	D		
	  XCHG
	  MVI	C,PRINT
	  CALL	BDOS
	  CALL	ILPRT
	  DB	' baud',CR,LF,0
	  RET
;.....
;
;
BAUDSPD:  DB	'110$',0,0,'300$',0,0,'450$',0,0,'600$',0,0,'710$',0,0
	  DB	'1200$',0,'2400$',0,'4800$',0,'9600$',0,'19200$'
;.....
;
;	
;---->  DVHLDE: Divides 'HL' by value in 'DE',
;	Upon exit: 'BC'=quotient,'L'=remainder
;
DVHLDE:	  PUSH	D		
	  MOV	A,E
	  CMA			
	  MOV	E,A
	  MOV	A,D
	  CMA
	  MOV	D,A
	  INX	D		
	  LXI	B,0		
;
DIVL1:	  DAD	D		
	  INX	B		
	  JC	DIVL1		
	  DCX	B		
	  POP	D		
	  DAD	D		
	  RET
;.....
;
;
;---->  MULHLA:  Multiply the value in 'HL' by the value in 'A'
;		 Return with answer in 'HL'
;
MULHLA:	  XCHG			
	  LXI	H,0		
	  INR	A		
;
MULLP:	  DCR	A
	  RZ
	  DAD	D
	  JMP	MULLP
;.....
;
;
; Shift 'HL' register pair one bit to the right
;
SHFTHL:	  MOV	A,L
	  RAR
	  MOV	L,A
	  ORA	A		
	  MOV	A,H
	  RAR
	  MOV	H,A
	  RNC
	  MVI	A,128
	  ORA	L
	  MOV	L,A
	  RET
;.....
;
;		
;	       (END OF FILE TRANSFER TIME ROUTINE)
;=======================================================================
;			 CRC SUBROUTINES
;
;
; Check 'CRC' bytes of record just received
;
CRCCHK:	  PUSH	H
	  LHLD	CRCVAL
	  MOV	A,H
	  ORA	L
	  POP	H
	  RZ
	  MVI	A,0FFH
	  RET
;.....
;
;
; Generate the CRC tables for fast calculations
;
CRCGEN:   LXI	H,CRCTBL	
	  MVI	C,0
;
CRCGEN1:  XCHG			
	  LXI	H,0		
	  MOV	A,C
	  PUSH	B
	  MVI	B,8
	  XRA	H
	  MOV	H,A
;
CRCGEN2:  DAD	H		
	  JNC	CRCGEN3
	  MVI	A,16		
	  XRA	H
	  MOV	H,A
	  MVI	A,32+1
	  XRA	L
	  MOV	L,A
;
CRCGEN3:  DCR	B
	  JNZ	CRCGEN2		
;
;
; Value now in 'HL', table address still stored in 'DE'.  Exchange, and
; store the 'CRC' value in the two tables after splitting.
;
	  POP	B		
	  XCHG			
	  MOV	M,D		
	  INR	H		
	  MOV	M,E		
	  DCR	H		
	  INX	H		
	  INR	C		
	  JNZ	CRCGEN1		
	  RET
;.....
;
;
; Update the CRC value from a character in the 'A' register
;
CRCUPD:	  PUSH	PSW		
	  PUSH	B
	  PUSH	D
	  PUSH	H
	  LHLD	CRCVAL		
	  XCHG			
	  MVI	B,0
	  XRA	D
	  MOV	C,A		
	  LXI   H,CRCTBL	
	  DAD	B			
	  MOV	A,M		
	  XRA	E
	  MOV	D,A
	  INR	H		
	  MOV	E,M		
	  XCHG			
	  SHLD	CRCVAL		
	  POP	H		
	  POP	D
	  POP	B
	  POP	PSW
	  RET
;.....
;
;==================== END OF CRC SUBROUTINE ============================
;
;
;=========================START OF MENU ================================
;
;
MENU0:	  LDA	NFILFLG
	  ORA	A
	  JZ	MENU		
	  CALL	ILPRT		
	  DB	CR,LF,'** File still open, use DEL, DIR, WRT, E, L '
	  DB	'or T ** ',CR,LF,BELL,0
	  JMP	MENU1
;
MENU:	  XRA	A
	  STA	ABORTFLG	
;
MENU1:	  LXI	H,RESTSN	
	  LXI	D,RECDNOB 	
	  MVI	B,RECDNOE-RECDNOB
	  CALL	MOVE
	  LXI	H,RESTROPT	
	  LXI	D,OPTBL
	  MVI	B,OPTBE-OPTBL
	  CALL	MOVE
	  XRA	A
	  STA	FSTFLG		
	  STA	MFFLG1		
	  JMP	XPRT
;.....
;
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
;		         MENU OF COMMANDS
;
; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;
MENU2:	  CALL	CLRTST
	  CALL	ILPRT
	  DB	'                  Single Letter Commands',CR,LF,LF
	  DB	' ?  - Display current settings',CR,LF
	  DB	' M  - Display the menu',CR,LF
	  DB	' E  - Terminal mode with echo',CR,LF
	  DB	' L  - Terminal mode with local echo',CR,LF
	  DB	' T  - Terminal mode',CR,LF
	  DB	'         For copying text to disk use T (E or L) '
	  DB	'FILENAME.TYP',CR,LF
	  DB	'         Start or Stop toggles described on subsequent '
	  DB	'screen.',CR,LF
	  DB	' R  - Receive CP/M file using Christensen Protocol'
	  DB	CR,LF
	  DB	' S  - Send CP/M file using Christensen Protocol',CR,LF 
	  DB	'         COMMAND: R (or S) FILENAME.TYP',CR,LF
	  DB	'         R and S can use the following subcommands:'
	  DB	CR,LF
	  DB	'            B  - Bulk transfer using wildcards '
	  DB	'(e.g., *.*)',CR,LF
	  DB	'            D  - Disconnect when done'
	  DB	CR,LF
	  DB	'            Q  - Quiet mode (no messages to console)'
	  DB	CR,LF
	  DB	'            T  - Return to terminal mode after '
	  DB	'transfer',CR,LF
	  DB	'            V  - View bytes transferred on console'
	  DB	CR,LF
	  DB	'            X  - When done, disconnect, go to CP/M'
	  DB	CR,LF,LF
	  DB	'      The single letter commands may also be used on '
	  DB	'the',CR,LF
	  DB	'      command line when the program is initially '
	  DB	'executed.',CR,LF,LF,0
;
THREELTR: CALL	JMP$NXTSCRN
	  CALL	ILPRT
	  DB	'                Three Letter Commands',CR,LF,LF
	  DB	'CPM - Exit from this program to CP/M',CR,LF
	  DB	'DIR - List directory and space free (may specify '
	  DB	'drive)',CR,LF
	  DB	'ERA - Erase file (may specify drive)',CR,LF
	  DB	'LOG - Change default drive/user no. (specify '
	  DB	'drive/user)',CR,LF
	  DB	'      and reset disks.  e.g. LOG A0: or LOG B:  '
	  DB	'(user # unchanged)',CR,LF
	  DB	'SPD - Set file output speed in terminal mode'
	  DB	CR,LF,0
;
	  CALL	SORPTST
	  JNZ	NOTIME
	  CALL	ILPRT
	  DB	'TIM - Select Baud rate for "time-to-send" msg.',CR,LF,0
;
NOTIME:	  LDA	TOGGLECRC
	  ORA	A
	  JZ	NOTOGCRC
	  CALL	ILPRT
	  DB	'TCC - Toggle CRC/Checksum mode on receive',CR,LF,0
;
NOTOGCRC: LDA	TOGGLEBK
	  ORA	A
	  JZ	NOTOGBK
	  CALL	ILPRT
	  DB	'TBR - Toggle backspace to rubout conversion',CR,LF,0
;
NOTOGBK:  LDA	TOGGLELOC
	  ORA	A
	  JZ	NOTOGLOC
	  CALL	ILPRT
	  DB	'TLC - Toggle  1) local command immediate',CR,LF
	  DB	'              2) local command after ',0
	  LDA	EXTCHR
	  CALL	SHFTYPE
	  DB	CR,LF,0
;
NOTOGLOC: LDA	TOGGLELF
	  ORA	A
	  JZ	NOTOGLF
	  CALL	ILPRT
	  DB	'TLF - Toggle LF after CR when sending disk file '
 	  DB	'in "T" mode',CR,LF,0
;
NOTOGLF:  LDA	TOGXOFF
	  ORA	A
	  JZ	NOTOGXOF
	  CALL	ILPRT
	  DB	'TXO - Toggle XOFF testing in terminal mode '
	  DB	'file output',CR,LF,0
;
NOTOGXOF: LDA	PMMIMODEM
	  ORA	A
	  JNZ	NONUM
	  LDA	SMARTMODEM
	  ORA	A
	  JNZ	NOTOGX2
;
NOTOGX1:  CALL	ILPRT
	  DB	'NUM - List remote systems',CR,LF,0
;
NOTOGX2:  LDA	SETUPTST
	  ORA	A
	  JZ	NONUM
	  CALL	ILPRT
	  DB	'SET - Set modem baud rate',CR,LF,0
;
NONUM:	  CALL	ILPRT
	  DB	'BYE - Disconnect, then return to CP/M'
	  DB	CR,LF,0
	  LDA	PMMIMODEM	
	  ORA	A
	  JNZ	NONUM0		
	  LDA	SMARTMODEM
	  ORA	A
	  JZ	NOPMMI		
;
NONUM0:	  CALL	ILPRT
	  DB	'CAL - Dial number',CR,LF,0
;
NOPMMI:	  CALL	ILPRT
	  DB	'DSC - Disconnect from the phone line',CR,LF,LF
	  DB	'          The following are terminal text '
	  DB	'buffer commands:',CR,LF,LF,0
;
SKIPLF:	  CALL	ILPRT
	
	  DB	'DEL - Delete memory buffer and file',CR,LF
	  DB	'WRT - Write memory buffer to disk file',CR,LF,LF,0
;
	  CALL	NXTSCRN
	  CALL	ILPRT
	  DB	'        Local Commands while in Terminal Mode'
	  DB	CR,LF,LF,0
	  LDA	BRKCHR
	  CALL	SHFTYPE
	  DB	'  - Send a break tone for 300 ms.',CR,LF,0
	  LDA	PMMIMODEM
	  ORA	A
	  JZ	SKIPLF1
	  LDA	CHGBAUD
	  CALL	SHFTYPE
	  DB	'  - Change baud rate',CR,LF,0
;
SKIPLF1:  MVI	A,EXITCHR
	  CALL	SHFTYPE
	  DB	'  - Exit to command mode',CR,LF,0
	  LDA	TRANLOGON
	  ORA	A
	  JZ	NOTRNLOG
	  LDA	LOGCHR
	  CALL	SHFTYPE
	  DB	'  - Send log-on message',CR,LF,0
;
NOTRNLOG: LDA	NOCONNCT
	  CALL	SHFTYPE
	  DB	'  - Disconnect from the phone line',CR,LF,0
	  LDA	LSTTST
	  ORA	A
	  JZ	NOLIST
	  LDA	LSTCHR
	  CALL	SHFTYPE
	  DB	'  - Toggle printer',CR,LF,0
;
NOLIST:   MVI	A,LF
	  CALL	TYPE
	  LDA	SAVECHR
	  CALL	SHFTYPE
	  DB	'  - Start copy into buffer',CR,LF,0
	  LDA	UNSAVECHR
  	  CALL	SHFTYPE
	  DB	'  - Stop copy into buffer',CR,LF,LF
	  DB	'             Start & Stop may be toggled as often as '
 	  DB	'desired.',CR,LF
	  DB	'             A ";" at start of line indicates buffer '
	  DB	'is copying.',CR,LF
	  DB	'             XOFF automatically used to stop input '
	  DB	'when writing',CR,LF
	  DB	'                full buffer to disk, XON sent to '
	  DB	'resume.',CR,LF,LF,0
	  LDA	TRANCHR
	  CALL	SHFTYPE
	  DB	'  - Transfer ASCII file to remote',CR,LF,LF,0
	  LDA	LOCONEXTCHR
	  ORA	A
	  LDA	EXTCHR
	  JNZ	REMDFLT
	  CALL	SHFTYPE
	  DB	'  - Send local control character to remote'
	  DB	CR,LF,LF,0
	  JMP	CKSPCL
;
REMDFLT:  CALL	SHFTYPE
	  DB	'  - Next character will be used for local control'
	  DB	CR,LF,0
;
CKSPCL:	  CALL	JMP$SPCLMENU	
;				;FALLS ON THROUGH TO 'XPRT'	
;
;
;			(END OF COMMAND MENU)
;=======================================================================
;		  START OF COMMAND LINE HANDLING
;
;
; Check first to see if a file was opened for copying incoming to disk
;
XPRT:	  CALL	CRLF		
	  LDA	NFILFLG		
	  ORA	A
	  JZ	XPRT1		
;
	  CALL	GETSPC		
	  CALL	ILPRT
	  DB	' Bytes of buffer free',CR,LF,LF,0
;
;
; Show disk drive and user number, then command line
; 
XPRT1:	  MVI	C,CURDSK	
	  CALL	BDOS
	  ADI	'A'		
	  CALL	TYPE
	  CALL	GETUSER		
	  ORA	A
	  JZ	XPRT2		
	  MVI	H,0
	  MOV	L,A
	  CALL	DECOUT		
;
XPRT2:	  MVI	A,'>'
	  CALL	TYPE
	  MVI	A,'>'
	  CALL	TYPE
	  CALL	ILPRT
	  DB	'COMMAND: ',0
;
;
; Get the command line parameters
;
GETCMD:	  LXI	D,CMDBUF	
	  CALL	INBUF
	  LDA	CMDBUF+2
	  CPI	EXITCHR		
	  JZ	XPRT1
	  CPI	' '
	  JZ	XPRT+3		
	  LDA	CMDBUF+3
	  CPI	':'		
	  JZ	SETDRV
	  LXI	D,CMDBUF+2	
	  CALL	INLNCOMP
	  DB	'CPM',0
	  JNC	EXIT
	  CALL	CRLF		
	  CALL	INLNCOMP
	  DB	'LOG',0
	  JNC	LOGNEW
	  CALL	INLNCOMP
	  DB	'DIR',0
	  JNC	DIR
	  CALL	INLNCOMP
	  DB	'ERA',0
	  JNC	ERASEF
	  CALL	INLNCOMP
	  DB	'?',0
	  JNC	CURPAR
	  CALL	INLNCOMP
	  DB	'SPD',0
	  JNC	SETSPD
	  CALL	INLNCOMP
	  DB	'TIM',0
	  JNC	SETTIM
	  CALL	INLNCOMP
	  DB	'TCC',0
	  JNC	TOGCRC
	  CALL	INLNCOMP
	  DB	'TBR',0
	  JNC	TOGBKSP
	  CALL	INLNCOMP
	  DB	'TLC',0
	  JNC	TOGLOC
	  CALL	INLNCOMP
	  DB	'TLF',0
	  JNC	TOGLF
	  CALL	INLNCOMP
	  DB	'TXO',0
	  JNC	TOGTXOFF
	  LDA	PMMIMODEM
	  ORA	A
	  JNZ	NONUM1 
	  LDA	SMARTMODEM
	  ORA	A
	  JNZ	NONUM1
	  CALL	INLNCOMP
	  DB	'NUM',0
	  JNC	NUMPRN
;
NONUM1:	  LDA	SETUPTST
	  ORA	A
	  JZ	NXTOPT1
	  CALL	INLNCOMP
	  DB	'SET',0
	  JNC	SETUPENT
;
NXTOPT1:  CALL	INLNCOMP
	  DB	'WRT',0
	  JNC	WRTFIL
	  CALL	INLNCOMP
	  DB	'DEL',0
	  JNC	NEWFILE
	  CALL	INLNCOMP
	  DB	'BYE',0
	  JNC	BYEBYE
	  CALL	INLNCOMP
	  DB	'DSC',0
	  JNC	DONETCD
	  LDA	PMMIMODEM
	  ORA	A
	  JNZ	NXTOPT0
	  LDA	SMARTMODEM
	  ORA	A
	  JZ	NXOPT2
;
NXTOPT0:  CALL	INLNCOMP	
	  DB	'CAL',0
	  JC	NXOPT2
	  MVI	A,' '		
	  STA	CMDBUF+4	
	  JMP	DOOPT		
;
NXOPT2:   LDA	CMDBUF+2
	  LXI	H,COMPLIST
	  CALL	COMPARE		
	  JC	NOTVLD		
;
DOOPT:	  CALL	SETFCB		
	  CALL	PROCOPT		
	  JMP	RESTART		
;.....
;
;
NOTVLD:	  CALL	NTVLDMSG
	  JMP	XPRT
;.....
;
;
NTVLDMSG: CALL	ILPRT
	  DB	'++ Invalid command ++',CR,LF,BELL,0
	  RET
;.....
;
;
BYEBYE:	  LDA	PMMIMODEM
	  ORA	A
	  CNZ	GOODBYE
	  LDA	SMARTMODEM
	  ORA	A
	  CNZ	GOODBYE
	  CALL	JMP$GOODBYE	
	  CALL	ILPRT
	  DB	CR,LF,'<<Exit to CP/M>>',CR,LF,0
	  JMP	EXIT		
;.....
;
;
DIR:	  MVI	C,CURDSK
	  CALL	BDOS
	  STA	DISKSAV
	  CALL	DIRLIST
	  LDA	DISKSAV
 	  MOV	E,A
	  MVI	C,SELDSK
	  CALL	BDOS
	  JMP	XPRT
;.....
;
;
ERASEF:	  LXI	D,CMDBUF	
	  LXI	H,FCB
	  CALL	CMDLINE
	  CALL	MOVEFCB		
	  LDA	FCB+1
	  CPI	' '
	  JZ	NOTVLD		
	  LXI	D,FCB
	  MVI	C,SRCHF
	  CALL	BDOS
	  INR	A		
	  JNZ	ERAFILE 	
	  CALL	ILPRT
	  DB	'++ File not found ++',CR,LF,BELL,0
	  JMP	XPRT
;.....
;
;
ERAFILE:  LXI	D,FCB
	  MVI	C,ERASE
	  CALL	BDOS
	  CALL	ILPRT
	  DB	'File erased',CR,LF,0
	  JMP	XPRT
;.....
;
;
LOGNEW:	  LDA	NFILFLG		
	  ORA	A
	  JNZ	NORESET		
	  LDA	CMDBUF+6	
	  CPI	' '
	  JNZ	LOGNEW1		
	  CALL	GETDISK		
	  ADI	'A'		
;
LOGNEW1:  SUI	'A'
	  CPI	15+1		
	  JNC	NOTVLD		
	  STA	DISKSAV		
	  CALL	GETUSER		
	  MOV	B,A		
	  LDA	CMDBUF+7	
	  CALL	CHRCHK		
	  CALL	FINDUSER
	  LDA	CMDBUF+8		
	  CALL	CHRCHK		
	  CALL	FINDUSER+2
;
LOGNEW2:  CALL	SAVEUSER	
	  MVI	C,RESET
	  CALL	BDOS
	  LDA	DISKSAV
	  MOV	E,A
	  MVI	C,SELDSK
	  CALL	BDOS
	  LDA	SAVUSR
	  MOV	E,A
	  CALL	SETUSER	
	  JMP	XPRT
;.....
;
;
CHRCHK:	  CPI	' '
	  JZ	CHRCHK1
	  CPI	':'		
	  RNZ
;
CHRCHK1:  POP	PSW		
	  JMP	LOGNEW2
;.....
;
;
FINDUSER: MVI	B,0		
	  CALL	NUMCHK		
	  MOV	C,A		
	  MOV	A,B		
	  ADD	A		
	  ADD	A		
	  ADD	A		
	  ADD	B		
	  ADD	B		
	  ADD	C
	  MOV	B,A		
	  RET
;.....
;
;
SAVEUSER: MOV	A,B
	  CPI	15+1		
	  JNC	NOTVLD
	  STA	SAVUSR
	  RET
;.....
;	
;
NUMGET:	  LXI	D,CMDBUF
	  CALL	INBUF
	  LDA	CMDBUF+2		
	  CPI	' '
	  RZ
;
NUMCHK:	  SUI	'0'		
	  CPI	9+1
	  RC			
	  POP	H		
	  POP	H			
	  JMP	NOTVLD
;
GETUSER:  MVI	E,0FFH		
;
SETUSER:  MVI	C,USER		
	  JMP	BDOS
;.....
;
;
GETDISK:  MVI	C,CURDSK	
	  JMP	BDOS
;.....
;
;
NORESET:  CALL	ILPRT
	  DB	'++      Terminal mode file open      ++',CR,LF
	  DB	'++ Use WRT or DEL before LOG command ++',CR,LF
	  DB	CR,LF,BELL,0
	  XRA	A
	  JMP	XPRT
;.....
;
;
SETSPD:	  CALL	ILPRT
	  DB	'Delay between chars. (0-9): ',0
;
NOKEYS:	  CALL	STAT
	  JZ	NOKEYS
	  CALL	KEYIN
	  CALL	TYPE
	  CALL	SAVEA
	  SUI	'0'
	  CPI	10
	  JNC	NOTVLD
	  STA	BYTDLY
;
	  CALL	ILPRT
	  DB	'Delay at end of line (0-9): ',0
;
NOKEYS1:  CALL	STAT
	  JZ	NOKEYS1
	  CALL	KEYIN
	  CALL	TYPE
	  CALL	SAVEA
	  SUI	'0'
	  CPI	10
	  JNC	NOTVLD
	  STA	CRDLY
;
SPDMSG:	  CALL	ILPRT
	  DB	CR,LF,'Char. delay (terminal file mode) is:  ',0
	  LDA	BYTDLY
	  MOV	B,A
	  MOV	A,B
	  PUSH	H
	  MOV	L,A
	  MVI	H,0
	  CALL	DECOUT
	  POP	H
	  CALL	ILPRT
	  DB	'0 ms. per character',CR,LF
	  DB	'Line  delay (terminal file mode) is: ',0
	  LDA	CRDLY
	  MOV	B,A
	  PUSH	H
	  MOV	L,A
	  MVI	H,0
	  CALL	DECOUT
	  POP	H
	  CALL	ILPRT
	  DB	'00 ms. per character',CR,LF,0
	  JMP	XPRT
;......
;
;
SAVEA:	  PUSH	PSW
	  CALL	ILPRT
	  DB	CR,LF,0
	  POP	PSW
	  RET
;.....
;
;
SETDRV:	  LDA	CMDBUF+2	
	  SUI	'A'		
	  CPI	15+1		
	  JNC	NOTVLD
	  MOV	E,A
	  MVI	C,SELDSK	
	  CALL	BDOS
	  LDA	CMDBUF+5	
	  CPI	' '		
	  JZ	XPRT
	  SUI	'0'		
	  CPI	1		
	  JNZ	SETDRV1		
	  LDA	CMDBUF+6	
	  CPI	'0'
	  JC	SETDRV2		
	  SUI	'0'-10		
;
SETDRV1:  CPI	15+1		
	  JNC	NOTVLD
	  MOV	E,A
	  CALL	SETUSER
	  JMP	XPRT		
;
SETDRV2:  MVI	A,1
	  JMP	SETDRV1
;.....
;
;
SETTIM:   CALL	SORPTST
	  JNZ	NOTVLD
	  CALL	ILPRT
	  DB	'Use 0-8 to give baud rate for ''S'' mode '
	  DB	'time-to-send message,',CR,LF
	  DB	'where 0=110, 1=300, 2=450, 3=600, 4=710, 5=1200, '
	  DB	'6=2400, ',CR,LF,'7=4800 8=9600 and 9=19200 Baud.'
	  DB	CR,LF,LF,'Enter value: ',0
	  CALL	NUMGET
	  CPI	9+1		
	  JNC	NOTVLD
	  STA	MSPEED
	  CALL	SETTIM1
	  JMP	XPRT
;.....
;
;
SETTIM1:  CALL	SORPTST
	  JNZ	SETTIM2
	  CALL	ILPRT
	  DB	'Rate for the S mode time-to-send message is set to ',0
	  JMP	SETTIM3
;...
;
;
SETTIM2:  CALL	ILPRT
	  DB	'Modem speed is ',0
;
SETTIM3:  JMP	PRTBAUD
;.....
;
;
SORPTST:  LDA	SETUPTST	
	  MOV	B,A		
	  LDA	PMMIMODEM	
	  ORA	B
	  RNZ
	  LDA	SMARTMODEM
	  ORA	B
	  RET
;.....
;
;
TOGCRC:	  LDA	TOGGLECRC	
	  ORA	A
	  JZ	NOTVLD		
	  LDA	CRCDFLT		
	  CMA
	  STA	CRCDFLT
	  CALL	TOGCRC1		
	  JMP	XPRT
;.....
;
;
TOGCRC1:  CALL	ILPRT
	  DB	'Mode: ',0
	  LDA	CRCDFLT		
	  ORA	A
	  JZ	CHEKMSG
	  CALL	ILPRT
	  DB	'CRC',CR,LF,0
	  RET
;.....
;
;
CHEKMSG:  CALL	ILPRT
	  DB	'CHECKSUM',CR,LF,0
	  RET
;.....
;
;
TOGBKSP:  LDA	TOGGLEBK
	  ORA	A
	  JZ	NOTVLD
	  LDA	CONVBKSP
	  CMA
	  STA	CONVBKSP
	  CALL	TOGBKSP1
	  JMP	XPRT
;.....
;
;
TOGBKSP1: LDA	CONVBKSP
	  ORA	A
	  JZ	NORUBMSG
	  CALL	ILPRT
	  DB	'Backspace is rub',CR,LF,0
	  RET
;.....
;
;
NORUBMSG: CALL	ILPRT
	  DB	'Backspace is backspace',CR,LF,0
	  RET
;.....
;
;
TOGLOC:	  LDA	TOGGLELOC
	  ORA	A
	  JZ	NOTVLD
	  LDA	LOCONEXTCHR
	  CMA
	  STA	LOCONEXTCHR
	  CALL	TOGLOC1
	  JMP	XPRT
;.....
;
;
TOGLOC1:  CALL	ILPRT
	  DB	'Use ',0
	  LDA	LOCONEXTCHR
	  ORA	A
	  LDA	EXTCHR
	  JZ	LOCMSG
	  CALL	SHFTYPE
	  DB	' before local command',CR,LF,0
	  RET
;...
;
;
LOCMSG:	  CALL	SHFTYPE
	  DB	' to send local command to remote',CR,LF,0
	  RET
;.....
;
;
TOGLF:	  LDA	TOGGLELF
	  ORA	A
	  JZ	NOTVLD
	  LDA	ADDLF
	  CMA
	  STA	ADDLF
	  CALL	TOGLF1
	  JMP	XPRT
;.....
;
;
TOGLF1:	  CALL	ILPRT
	  DB	'Linefeed ',0
	  LDA	ADDLF					
	  ORA	A
	  JNZ	LFMSG		
	  CALL	ILPRT
	  DB	'NOT ',0
;
LFMSG:	  CALL	ILPRT
	  DB	'sent after CR for disk file in T-mode',CR,LF,0
	  RET
;.....
;
;
TOGTXOFF: LDA	TOGXOFF
	  ORA	A
	  JZ	NOTVLD
	  CALL	ILPRT
	  DB	'Use XOFF testing? (Y/N): ',0
	  CALL	GETANS
	  JC	NOCHG3
	  STA	XOFFTST
;
NOCHG3:	  CALL	XOFFMSG
	  CALL	ILPRT
	  DB	CR,LF,'Use XON waiting after <CR> (Y/N): ',0
	  CALL	GETANS
	  JC	NOCHG4
	  STA	XONWAIT
;
NOCHG4:	  CALL	XONMSG
	  LDA	XONWAIT
	  ORA	A
	  JZ	XPRT
	  CMA
	  STA	XOFFTST		
	  CALL	ILPRT
	  DB	'Therefore ',0
	  CALL	XOFFMSG
	  JMP	XPRT
;.....
;
;
GETANS:   LXI	D,CMDBUF
	  CALL	INBUF
	  LDA	CMDBUF+2	 	
	  CPI	' '
	  CMC			
	  RZ
	  MOV	B,A
	  CPI	'N'
	  MVI	A,0
	  RZ			
	  MOV	A,B
	  CPI	'Y'
	  MVI	A,1
	  RZ
	  POP	PSW		
	  JMP	NOTVLD
;.....
;
;
XOFFMSG:  CALL	ILPRT
	  DB	'XOFF testing ',0
	  LDA	XOFFTST
	  ORA	A
	  JNZ	XOTSTON
	  CALL	ILPRT
	  DB	'NOT ',0
;
XOTSTON:  CALL	ILPRT
	  DB	'used',0
;
XONMSG1   CALL	ILPRT
	  DB	' in terminal mode file output',CR,LF,0
	  RET
;.....
;
;
XONMSG:	  CALL	ILPRT
	  DB	'XON ',0
	  LDA	XONWAIT
	  ORA	A
	  JNZ	XONMSG2
	  CALL	ILPRT
	  DB	'NOT ',0
;
XONMSG2:  CALL	ILPRT
	  DB	'automatically tested after CR',0
	  JMP	XONMSG1
;...
;
;
SETUPENT: LDA	SETUPTST
	  ORA	A
	  JZ	NOTVLD
	  LXI	D,CMDBUF+1
	  CALL	JMP$SETUPR
	  LDA	SMARTMODEM
	  ORA	A
	  JZ	XPRT
	  MVI	B,'A'		
	  CALL	SENDCHR		
	  MVI	B,'T'		
	  CALL	SENDCHR
	  MVI	B,CR
	  CALL	SENDCHR
	  JMP	XPRT
;.....
;
;
NEWFILE:  LDA	NFILFLG		
	  ORA	A
	  JZ	NOFILOPN	
	  LDA	FCB3+1		
	  CPI	' '
	  JZ	NOFILOPN	
	  LXI	D,FCB3		
	  MVI	C,ERASE
	  CALL	BDOS
	  XRA	A
	  STA	NFILFLG		
	  STA	SAVEFLG
	  LXI	H,FCB3
	  CALL	INITFCB
	  LXI	H,BUFFER	
	  SHLD	HLSAVE		
	  JMP	XPRT
;.....
;
;
WRTFIL:	  LDA	NFILFLG		
   	  ORA	A
	  JZ	NOFILOPN	
	  CALL	WRTFIL1		
	  STA	SAVEFLG
	  STA	WRFLG
	  LXI	H,FCB3
	  CALL	INITFCB		
	  LXI	H,BUFFER	
	  SHLD	HLSAVE		
	  JMP	XPRT
;...
;
;
WRTFIL1:  LDA	FCB3+1		
	  CPI	' '
	  RZ
	  CALL	WRTDSK		
	  LXI	D,FCB3		
	  MVI	C,CLOSE
	  CALL	BDOS
	  XRA	A
	  STA	NFILFLG		
	  RET
;.....
;
;
NOFILOPN: CALL	ILPRT
	  DB	'++ No File Open ++',CR,LF,BELL,0
	  JMP	XPRT
;.....
;
;
; THIS ROUTINE DISPLAYS THE PHONE NUMBERS IN THE LIBRARY
;
NUMPRN:	  PUSH	H
	  CALL	CLRTST
	  CALL	ILPRT
	  DB	'           Library of Phone Numbers of Remote Systems'
	  DB	0
	  MVI	C,13		
	  LXI	H,NUMBLIB	
	  LXI	D,BUFFER	
	  CALL	NEWLINE		
	  STAX	D		
	  INX	D		
;
NUMPRN1:  INX	H		
	  INX	H		
	  MVI	B,LIBLEN-2	
	  CALL	MOVE		
	  CALL	SPACES		
	  INX	H
	  INX	H
	  MVI	B,LIBLEN-2
	  CALL	MOVE
	  CALL	NEWLINE
	  DCR	C		
	  JZ	NUMPRN2
	  JMP	NUMPRN1
;.....
;
;
NEWLINE:  MVI	A,CR		
	  STAX	D		
	  MVI	A,LF		
	  INX	D		
	  STAX	D		
	  INX	D		
	  RET
;.....
;
;
SPACES:	  MVI	A,' '		
	  STAX	D
	  INX	D		
	  STAX	D
	  INX	D		
	  STAX	D
	  INX	D		
	  RET
;.....
;
;
NUMPRN2:  MVI	A,'$'
	  STAX	D
	  MVI	C,PRINT
	  LXI	D,BUFFER	
	  CALL	BDOS
	  CALL	CRLF
	  CALL	CRLF
	  POP	H
	  JMP	XPRT
;......
;
;
COMPARE:  MOV	B,M		
;
COMPLP:	  INX	H		
	  CMP	M		
	  JZ	VALID		
	  DCR	B		
	  JNZ	COMPLP		
	  STC
;
VALID:	  RET
;.....
;
;
NXTSCRN:  CALL  ILPRT
	  DB	'HIT any KEY to CONTINUE',0
;
NOKEY1:	  CALL	STAT		
	  JZ	NOKEY1		
	  CALL	KEYIN		
	  CPI	'C'-40H		
	  JNZ	CLRTST
	  POP	H		
	  CALL	CRLF		
	  JMP	XPRT
;.....
;
;
CLRTST:	  LDA	SCRNTEST
	  ORA	A
	  JNZ	CLRSCRN
;.....
;
;
LOTSALF:  MVI	A,CR
	  CALL	TYPE
	  MVI	B,12
	  MVI	A,LF
;
LFLOOP:	  CALL	TYPE
	  DCR	B
	  JNZ	LFLOOP
	  RET
;.....
;
;
CURPAR:	  CALL	CLRTST
	  CALL	ILPRT
	  DB	'                Current Settings',CR,LF,LF,0
	  CALL	TOGCRC1
	  LDA	LSTTST
	  ORA	A
	  JZ	NOLIST1
	  CALL	LSTMSG
;
NOLIST1:  CALL	TOGBKSP1
	  CALL	SETTIM1
	  CALL	ILPRT
	  DB	'Terminal mode file buffer is ',0
	  LDA	NFILFLG		
	  ORA	A
	  JNZ	ACTIVE		
	  CALL	ILPRT
	  DB	'in',0		
;
ACTIVE:	  CALL	ILPRT
	  DB	'active',CR,LF,'Unused portion of buffer is ',0
	  CALL	GETSPC
	  CALL	ILPRT
	  DB	' bytes',CR,LF,0
	  CALL	TOGLOC1
	  CALL	TOGLF1
	  CALL	XOFFMSG
	  CALL	XONMSG
	  CALL	SPDMSG
	  CALL	CRLF
	  CALL	CRLF
	  CALL	CRLF
	  JMP	XPRT
;.....
;
;
GETSPC:	  LXI	D,BUFTOP	
	  LHLD	HLSAVE		
	  XCHG
	  XRA	A		
	  SUB	E
	  MOV	L,A
	  MOV	A,H
	  SBB	D
	  MOV	H,A
	  CALL	DECOUT		
	  RET
;.....
;
;
;***********************************************************************
;
;       D - A - T - A    A - R - E - A
;
;***********************************************************************
;
;
COMPLIST: DB	 6, 'S', 'R', 'T', 'E', 'L', 'M'
;.....
;
;
; OPTION TABLE
;
OPTBL:	  EQU	$
ANSWFLG:  DB	'A'
BATCHFLG: DB	'B'
DISCFLG:  DB	'D'
LOCCHFLG: DB	'L'
ORIGFLG:  DB	'O'
QFLG:	  DB	'Q'
RSEEFLG:  DB	'R'
SSEEFLG:  DB	'S'
TERMFLG:  DB	'T'
VSEEFLG:  DB	'V'
XITFLG:	  DB	'X'		
EPARITY:  DB	'0'	
OPARITY:  DB	'1'	
OPTBE:	  EQU	$	
;
;
; The following must be in the same order as the table above:
;
RESTROPT: DB	'A','B','D','L','O','Q','R','S','T','V','X','0','1'
;
;
; The next 13 bytes equal the number of bytes between RECDNOB and
; RECDNOE.
;
RESTSN:   DB	0,0,0,0,0,0
	  DW	BUFFER
	  DB	0,0,0,0,0
;
RECDNOB   EQU	$	
RCVRNO:   DB	0	
RECDNO:   DB	0,0	
ERRCT:    DB	0	
ERRCDE:   DB	0	
EOFLG:    DB	0		
RECPTR:   DW	BUFFER	
RECINBF:  DB	0	
MAXEXT:   DB	0	
RCNT:     DB	0,0 	
DATAFLG:  DB	0	
RECDNOE   EQU	$	
;
;
; Additional 16-bit initialized storage
;
CRCVAL:	  DW	0
DIALCT:	  DW	0
HLSAVE:	  DW	BUFFER
HLSAVE1:  DW	PBUFF
HLSAVE2:  DW	PBUFF
;
;
; Additional general purpose initialized storage
;
ABORTFLG: DB	0
ACKFLG:	  DB	0
CRCFLAG:  DB	0	
CRFLAG:	  DB	0
CURRENT:  DB	52	
DLYFLG:	  DB	0
ECHOFLG:  DB	0
EXACFLG:  DB	0
FIRSTME:  DB	0
FSTFLG:	  DB	0
LISTFLG:  DB	0
LOCFLG:	  DB	0
MFFLG1:	  DB	0
MODCTLB:  DB	07FH
NFILFLG:  DB	0
ONERR:    DB	0
OPTION:	  DB	0
ORIGSAV:  DB	0
RINGBKFL: DB	0
SAVEFLG:  DB	0
UARTCTLB: DB	ORIGMOD	
WRFLG:	  DB	0
CMDBUF:	  DB	80H,0	
;
;
; General purpose unitialized storage area
;
	  DS	128	
BGNMS:	  DS	2
DISKNO:	  DS	1
DISKSAV:  DS	1
DSTORE:	  DS	1
FILECT:	  DS	1
FTYCNT:	  DS	1
MAXRAM:	  DS	1
NAMECT:	  DS	1
NBSAVE:	  DS	2
OLDUSER:  DS	1
SENDFLG:  DS	1
SAVUSR:	  DS	1
;
FCB3:	  DS	33
FCB4:	  DS	33
FCBBUF:	  DS	15
MFNAME5:  DS	12		
MFNAME6:  DS	12		
          DS	80		
EVENPAGE: EQU	($+255)/256*256 
;
	  ORG	EVENPAGE
;
STACK:	  EQU	EVENPAGE-2	
CRCTBL:	  DS	512		
BUFFER:	  DS	1024*BUFSIZ	
BUFTOP:	  DS	0		
BUFFDSK:  DS	128		
BUFFPNT:  DS	128		
NAMEBUF:  DS	256		
PBUFF:	  DS	0		
;.....
;
;
; BDOS EQUATES
;
RDCON:	  EQU	1
WRCON:	  EQU	2
LSTOUT:	  EQU	5
PRINT:	  EQU	9
RDBUF:	  EQU	10
CONST:	  EQU	11
CPMVER:	  EQU	12
RESET:	  EQU	13
SELDSK:	  EQU	14
OPEN:	  EQU	15
CLOSE:	  EQU	16
SRCHF:	  EQU	17
SRCHN:	  EQU	18
ERASE:	  EQU	19
READ:	  EQU	20
WRITE:	  EQU	21
MAKE:	  EQU	22
REN:	  EQU	23
CURDSK:	  EQU	25
SETDMA:	  EQU	26
DSKALL:	  EQU	27
DSKPAR:	  EQU	31
USER:	  EQU	32
FILSIZ:	  EQU	35
BDOS:	  EQU	0005H
REIPL:	  EQU	0
FCB:	  EQU	5CH
FCBEXT:	  EQU	FCB+12
FCBSNO:	  EQU	FCB+32
FCBRNO:	  EQU	FCB+32
FCB2:	  EQU	6CH
TBUF:	  EQU	80H
;.....
;
;
	  END

