/*
 *
 *			      CBC.C
 *
 *		  Brace and Parenthesis Checker
 *
 *		      and Comment Checker
 *
 *	     for CP/M-86 and Computer Innovations C
 *
 *		By Bob Green for Solution Systems
 *
 *		   Copyrite (c) November, 1983
 *
 */

#include "local.h"

char *Fname, Line_buf[132];

int Help,	/*	  Global flags		*/
No_brace,
Count_comments,
No_paren,
No_ln_num,
Ff_on;

main(argc,argv)
int argc;
char *argv[];
{
	int  *fd,	/*  file descriptor		*/
	num_braces,	/*  depth of curly braces	*/
	prev_num_braces, /*  prev num_braces to hilite fncs */
	ln_num, 	/*  line #			*/
	err_flg,	/*  negative nesting error	*/
	in_quote,	/*  quoted character		*/
	sgl_quote_flg,	/*  quoted by single quotes	*/
	dbl_quote_flg,	/*  quoted by double quotes	*/
	i;		/*  counter for 'for'		*/


	num_braces=0;  /*  init brace depth	       */
	prev_num_braces=0; /*  no prev nesting	       */
	err_flg=0;     /*  not close before open brace */
	ln_num=1;      /*  init line #		       */
/*
 * init flags
 */
	Help=FALSE;
	No_brace=FALSE;
	Count_comments=FALSE;
	No_paren=FALSE;
	No_ln_num=FALSE;
	Ff_on=FALSE;
	dbl_quote_flg=FALSE;
/*
 * usage message and exit if no args
 */
	if (argc < 2) {
		usage_msg();
		exit();
	}
/*
 *  open input file
 *
 *  if can't be opened, is it help. print help or file error msg then exit.
 *
 */
	Fname=argv[--argc];
	if ((fd=fopen(Fname,"r"))==NULL) {
		if ((argv[argc][0]=='?') || (argv[argc][1]=='?'))
			help_msg();
		else {
			usage_msg();
			fprintf(stderr, "\ncannot open: %s\n",Fname);
		}
		exit();
	}
/*
 *  while flag(s)
 *
 * test for flag validity or help and identify flag if valid
 *
 */

	while (--argc) {
		if (argv[argc][0]=='-') {
			switch(toupper(argv[argc][1])) {
			case '?':
				Help=TRUE;
				help_msg();
				fprintf(stderr,"\n\n");
				break;
			case 'H':
				Help=TRUE;
				help_msg();
				fprintf(stderr,"\n\n");
				break;
			case 'B':
				No_brace=TRUE;
				if (Help)
					fprintf(stderr,
					"\nDon't count braces flag\n");
				break;
			case '{':
				No_brace=TRUE;
				if (Help)
					fprintf(stderr,
					"\nDon't count braces flag\n");
				break;
			case 'C':
				Count_comments=TRUE;
				if (Help)
					fprintf(stderr,
					"\nCount comments flag\n");
				break;
			case 'P':
				No_paren=TRUE;
				if (Help)
					fprintf(stderr,
					"\nDon't count parenthesis flag\n");
				break;
			case '(':
				No_paren=TRUE;
				if (Help)
					fprintf(stderr,
					"\nDon't count parenthesis flag\n");
				break;
			case 'L':
				No_ln_num=TRUE;
				if (Help)
					fprintf(stderr,
					"\nDon't display depth of braces (etc) and line numbers flag\n");
				break;
			case 'F':
				Ff_on=TRUE;
				if (Help)
					fprintf(stderr,
					"\nFF on at 0 count and LINESPG flag\n");
				break;
			default:
				fprintf(stderr,
				"\nError, -%c not a valid flag\n",
				argv[argc][1]);
				break;
			}
		}
		else if ((argv[argc][0]=='?') ||
			  (toupper(argv[argc][0]=='h'))) {
			help_msg();
			Help=TRUE;
		}

		else fprintf(stderr, "\nNo_t a valid flag, '-' missing\n");
	}

	fprintf(stderr,
	"\n\tCBC, Brace Checker Copyrite (c) Dec. 1983 by Solution Systems");
	fprintf(stderr, "\n\tChecking File: %s\n\n",
			Fname);

/*
 *   while data (main program loop)
 */

	while (fgets(Line_buf,132,fd)) {

		for(i=0;Line_buf[i];++i) {

			/*
			 * is character being tested in quotes ?
			 */

			in_quote=sgl_quote_flg=single_quote(i);

			if (Line_buf[i]=='"') {
				unless (sgl_quote_flg) {
					if (dbl_quote_flg) dbl_quote_flg=FALSE;
					else dbl_quote_flg=TRUE;
				}
			}

			if ((sgl_quote_flg) || (dbl_quote_flg)) in_quote=TRUE;

			/*
			 * count close brace and comments and parenthesis
			 */

			if (Line_buf[i]=='}')
				unless (((No_brace) || (in_quote)))
					--num_braces;
			if (Line_buf[i]==')')
				unless (((No_paren) || (in_quote)))
					--num_braces;
			if ((Count_comments) &&
			    (Line_buf[i]=='*' && Line_buf[i+1]=='/'))
					--num_braces;

			if(num_braces<0) ++err_flg;    /*  an error if < 0  */

			/*
			 * count open brace and comments and parenthesis
			 */

			if (Line_buf[i]=='{')
				unless (((No_brace) || (in_quote)))
					++num_braces;
			if (Line_buf[i]=='(')
				unless (((No_paren) || (in_quote)))
					++num_braces;
			if ((Count_comments) &&
			    (Line_buf[i]=='/' && Line_buf[i+1]=='*'))
					++num_braces;
		}
/*
 * bad nesting error test and message
 */
		if(err_flg>0) {
			fprintf(stderr, "\n++ bad nesting: ++\n");
			err_flg=0;
		}
/*
 *    output
 */
		if(err_flg<0)
			err_flg=0;
		ln_num++;
		if (No_ln_num) fprintf(stdout, "%s",Line_buf);
		else fprintf(stdout, "%3d %2d: %s",ln_num,num_braces,Line_buf);
		if(prev_num_braces && (num_braces==0)) {	  /* just decrement to 0? */
			fprintf(stdout,"----------------------\n");
			if (Ff_on) fprintf(stdout,"%c", FF);
		}
		prev_num_braces=num_braces;
	}
}

help_msg()
{
	usage_msg();
	fprintf(stderr, "\n\tH        Help");
	fprintf(stderr, "\n\t?        Help");
	fprintf(stderr, "\n\tB        No Braces Counted.");
	fprintf(stderr, "\n\t{        No Braces Counted.");
	fprintf(stderr, "\n\tC        Count Comments.");
	fprintf(stderr, "\n\tP        No Parenthesis Counted.");
	fprintf(stderr, "\n\t(        No Parenthesis Counted.");
	fprintf(stderr, "\n\tL        No Depth and Line Numbers.");
	fprintf(stderr, "\n\tF        FF on, A New Page At 0 Depth.\n\n");
}

usage_msg()
{
	fprintf(stderr, "\n\tCBC: Brace Checker for C programs");
	fprintf(stderr, "\n\tCopyrite (c) Dec. 1983 by Solution Systems");
	fprintf(stderr,
	  "\n\tUsage: cbc [-flag(s)] input_filename [>output_filename]\n");
}

single_quote(i)
{
	if ((Line_buf[i-1]=='\'') && (Line_buf[i+1]=='\'')) return(TRUE);
	else return(FALSE);
}

