	ASEG
; * * * * *
;
;  TASK RECORD DEFINITION
;
; * * * * *
	ORG	0
TSKSTS:	DS	1		;TASK STATUS (STOP,NEW,ACTIVE)
TSKADR:	DS	2		;TASK ADDRESS (STARTING ADDRESS)
TSKSTK:	DS	1		;TASK STACK (ASSOCIATED STACK)
TSKLNK:	DS	2		;TASK LINK (LINK TO NEXT TASK)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		;TASK STATUS IS STOP
TSKNEW	EQU	1		;TASK STATUS IS NEW
TSKACT	EQU	2		;TASK STATUS IS ACTIVE
; * * * * *
;
;  TASK VARIABLES AND TASK BLOCKS
;
; * * * * *
	ORG	0080H		;ABSOLUTE PAGE
TSKPTR:	DS	2		;TASK POINTER
TSKJMP:	DS	2		;INDIRECT JUMP POINT FOR TASK START-UP
	ORG	0200H		;RAM, NOT REQ'D ON ABSOLUTE PAGE
TASK1:	DS	TSKSZE		;TASK ONE
TASK2:	DS	TSKSZE		;TASK TWO
TASK3:	DS	TSKSZE		;TASK THREE
; * * * * *
;
;  USER DEFINED STACKS FOR ASSOCIATED TASKS
;
; * * * * *
	ORG	0100H		;STACK PAGE
	DS	59
STACK1:	DS	1		;STACK ONE
	DS	59
STACK2:	DS	1		;STACK TWO
	DS	59
STACK3:	DS	1		;STACK THREE
; * * * * *
;
;  TASK INITIALIZATION
;
; * * * * *
	ORG	8000H		;ROM SPACE
	LDA	#LO(CODE1)	;EXECUTION ADDR FOR TASK 1
	STA	TASK1+TSKADR+0
	LDA	#HI(CODE1)
	STA	TASK1+TSKADR+1
	LDA	#LO(STACK1)	;STACK FOR TASK ONE
	STA	TASK1+TSKSTK
	LDA	#TSKNEW		;NEW TASK
	STA	TASK1+TSKSTS
	LDA	#LO(TASK2)	;LINK TO TASK 2
	STA	TASK1+TSKLNK+0
	LDA	#HI(TASK2)
	STA	TASK1+TSKLNK+1
;
	LDA	#LO(CODE2)	;EXECUTION ADDR FOR TASK 2
	STA	TASK2+TSKADR+0
	LDA	#HI(CODE2)
	STA	TASK2+TSKADR+1
	LDA	#LO(STACK2)	;STACK FOR TASK TWO
	STA	TASK2+TSKSTK
	LDA	#TSKNEW		;NEW TASK
	STA	TASK2+TSKSTS
	LDA	#LO(TASK3)	;LINK TO TASK 3
	STA	TASK2+TSKLNK+0
	LDA	#HI(TASK3)
	STA	TASK2+TSKLNK+1
;
	LDA	#LO(CODE3)	;EXECUTION ADDR FOR TASK 3
	STA	TASK3+TSKADR+0
	LDA	#HI(CODE3)
	STA	TASK3+TSKADR+1
	LDA	#LO(STACK3)	;STACK FOR TASK THREE
	STA	TASK3+TSKSTK
	LDA	#TSKNEW		;NEW TASK
	STA	TASK3+TSKSTS
	LDA	#LO(TASK1)	;LINK TO TASK 1
	STA	TASK3+TSKLNK+0
	LDA	#HI(TASK1)
	STA	TASK3+TSKLNK+1
;
	LDA	#LO(TASK3)	;TSKPTR = ADDR OF TASK3
	STA	TSKPTR+0
	LDA	#HI(TASK3)
	STA	TSKPTR+1
	JMP	NXTTSK		;START TASK 1
; * * * * *
;
;  SYSTEM TASK SCHEDULER
;  ENTERED VIA CALL FROM ACTIVE TASK
;
; * * * * *
SYSTEM:	SEI			;DISABLE INTERRUPTS
;
	PHP			;SAVE WORKING REGISTERS
	PHA
	TXA
	PHA
	TYA
	PHA
; * * * * *
;
;  ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
TSKINT:	TSX
	TXA
	LDY	#TSKSTK
	STA	(TSKPTR),Y	;SAVE TASK STACK POINTER
;
;  NEXT TASK
;
NXTTSK:	LDY	#TSKLNK		;SET TSKPTR = ADDR OF NEXT TASK
	LDA	(TSKPTR),Y
	TAX
	INY
	LDA	(TSKPTR),Y
	STX	TSKPTR+0
	STA	TSKPTR+1
;
	LDY	#TSKSTS
	LDA	(TSKPTR),Y
	CMP	#TSKSTP
	BEQ	NXTTSK		;IF TASK STATUS = STOP THEN  NXTTSK
;
	LDY	#TSKSTK
	LDA	(TSKPTR),Y
	TAX
	TXS			;SP = TASK STACK
;
	LDY	#TSKSTS
	LDA	(TSKPTR),Y
	CMP	#TSKNEW
	BEQ	NEWTSK		;IF TASK STATUS = NEW THEN  NEWTSK
;
;  RETURN TO ACTIVE TASK
;
	PLA			;RESTORE TASK STATE
	TAY
	PLA
	TAX
	PLA
	PLP
;
	CLI			;ENABLE INTERRUPTS
	RTS			;RETURN TO TASK
;
;  ACTIVATE NEW TASK
;
STRTUP:	CLI			;COMPLETE ACTIVATION STEPS
	JMP	(TSKJMP)
;
NEWTSK:	LDY	#TSKSTS
	LDA	#TSKACT
	STA	(TSKPTR),Y	;TASK STATUS = ACTIVE
;
	LDY	#TSKADR
	LDA	(TSKPTR),Y
	STA	TSKJMP+0
	INY
	LDA	(TSKPTR),Y
	STA	TSKJMP+1
	JSR	STRTUP		;ACTIVATE TASK
;
;  DEACTIVATE ACTIVE TASK
;
ENDTSK:	SEI			;DISABLE INTERRUPTS
;
	LDY	#TSKSTS
	LDA	#TSKSTP
	STA	(TSKPTR),Y	;TASK STATUS = STOP
;
	TSX
	TXA
	LDY	#TSKSTK
	STA	(TSKPTR),Y	;TASK STACK = SP
;
	JMP	NXTTSK		;SCHEDULE NEXT TASK
;
; * * * * *
;
;  USER DEFINED CODE FOR TASK ONE
;
; * * * * *
CODE1:
	JSR	SYSTEM		;SCHEDULE OTHER TASKS
	JMP	CODE1		;DO TASK AGAIN
; * * * * *
;
;  USER DEFINED CODE FOR TASK TWO
;
; * * * * *
CODE2:
	RTS			;ASSUME TASK COMPLETE
; * * * * *
;
;  USER DEFINED CODE FOR TASK THREE
;  THIS EXAMPLE TASK INITIATES TASK 2 IF IT IS INACTIVE
;
; * * * * *
CODE3:
	LDA	TASK2+TSKSTS
	CMP	#TSKSTP
	BNE	C3SKP		;IF TASK2 STATUS <> TSKSTP THEN SKIP
	LDA	#TSKNEW
	STA	TASK2+TSKSTS	;TASK2 STATUS = TSKNEW
C3SKP:	JSR	SYSTEM		;SCHEDULE OTHER TASKS
	JMP	CODE3
	END
                                                                                     