	ASEG
; * * * * *
;
;  TASK RECORD DEFINITION
;
; * * * * *
	ORG	0
TSKSTS:	DS	1		;TASK STATUS (STOP,NEW,ACTIVE)
TSKADR:	DS	2		;TASK ADDRESS (STARTING ADDRESS)
TSKSTK:	DS	2		;TASK STACK (ASSOCIATED STACK)
TSKLNK:	DS	2		;TASK LINK (LINK TO NEXT TASK)
TSKSZE	EQU	*-TSKSTS
;
TSKSTP	EQU	0		;TASK STATUS IS STOP
TSKNEW	EQU	1		;TASK STATUS IS NEW
TSKACT	EQU	2		;TASK STATUS IS ACTIVE
; * * * * *
;
;  TASK VARIABLES AND TASK BLOCKS
;
; * * * * *
	ORG	0100H
TSKRA:	DS	1		;A REGISTER TEMP
TSKCC:	DS	1		;CONDITION CODE TEMP
TSKRX:	DS	2		;X REGISTER TEMP
TSKPTR:	DS	2		;TASK POINTER
TASK1:	DS	TSKSZE		;TASK ONE
TASK2:	DS	TSKSZE		;TASK TWO
TASK3:	DS	TSKSZE		;TASK THREE
; * * * * *
;
;  USER DEFINED STACKS FOR ASSOCIATED TASKS
;
; * * * * *
	DS	59
STACK1:	DS	1		;STACK ONE
	DS	59
STACK2:	DS	1		;STACK TWO
	DS	59
STACK3:	DS	1		;STACK THREE
; * * * * *
;
;  TASK INITIALIZATION
;
; * * * * *
	ORG	8000H
	LDX	#CODE1		;CODE FOR TASK ONE
	STX	TASK1+TSKADR
	LDX	#STACK1		;STACK FOR TASK ONE
	STX	TASK1+TSKSTK
	LDAA	#TSKNEW		;NEW TASK
	STAA	TASK1+TSKSTS
	LDX	#TASK2
	STX	TASK1+TSKLNK	;LINK TO TASK2
;
	LDX	#CODE2		;CODE FOR TASK TWO
	STX	TASK2+TSKADR
	LDX	#STACK2		;STACK FOR TASK TWO
	STX	TASK2+TSKSTK
	LDAA	#TSKNEW		;NEW TASK
	STAA	TASK2+TSKSTS
	LDX	#TASK3
	STX	TASK2+TSKLNK	;LINK TO TASK3
;
	LDX	#CODE3		;CODE FOR TASK THREE
	STX	TASK3+TSKADR
	LDX	#STACK3		;STACK FOR TASK THREE
	STX	TASK3+TSKSTK
	LDAA	#TSKNEW		;NEW TASK
	STAA	TASK3+TSKSTS
	LDX	#TASK1
	STX	TASK3+TSKLNK	;LINK TO TASK1
;
	LDX	#TASK3
	STX	TSKPTR		;TSKPTR = ADDRESS OF TASK3
	BRA	NXTTSK		;START TASK 1
; * * * * *
;
;  SYSTEM TASK SCHEDULER
;  ENTERED VIA CALL FROM ACTIVE TASK
;
; * * * * *
SYSTEM:	NOP
	SEI			;DISABLE INTERRUPTS
;
;  SAVE REGISTERS ON THE STACK IN INTERRUPT ORDER, SEE RTI BELOW
;
	PSHA			; SAVE A WITHOUT CHANGING CC REG
	TPA
	STAA	TSKCC
	PULA
	STAA	TSKRA		;SAVE TASK STATE (IRQ ORDER)
	STX	TSKRX
	LDAA	TSKRX+1
	PSHA			;X REG LOW BYTE
	LDAA	TSKRX+0
	PSHA			;X REG HIGH BYTE
	LDAA	TSKRA
	PSHA			;A REG
	PSHB			;B REG
	LDAA	TSKCC
	PSHA			;CONDITION CODE
; * * * * *
;
;  ENTRY POINT FOR INTERRUPT INITIATED TASK SWITCH
;
; * * * * *
TSKINT:	LDX	TSKPTR
	STS	TSKSTK,X	;TASK STACK = SP
;
;  NEXT TASK
;
NXTTSK:	LDX	TSKLNK,X
	STX	TSKPTR		;TSKPTR = ADDRESS OF NEXT TASK
;
	LDAA	TSKSTS,X
	CMPA	#TSKSTP
	BEQ	NXTTSK		;IF TASK STATUS = STOP THEN  NXTTSK
;
	LDS	TSKSTK,X	;SP = TASK STACK
;
	CMPA	#TSKNEW
	BEQ	NEWTSK		;IF TASK STATUS = NEW THEN  NEWTSK
;
;  RETURN TO ACTIVE TASK
;
	PULA
	ANDA	#0EFH		; CLEAR INTERRUPT MASK BIT IN CC REG
	PSHA
	RTI			;RETURN TO TASK (WITH IRQ ENABLED)
;
;  ACTIVATE NEW TASK
;
NEWTSK:	LDX	TSKPTR
	LDAA	#TSKACT
	STAA	TSKSTS,X	;TASK STATUS = ACTIVE
;
	LDX	TSKADR,X	;X = ADDRESS OF TASK
	NOP
	CLI			;ENABLE INTERRUPTS
	JSR	0,X		;ACTIVATE TASK
;
;  DEACTIVATE ACTIVE TASK
;
ENDTSK:	NOP
	SEI			;DISABLE INTERRUPTS
;
	LDX	TSKPTR
	LDAA	#TSKSTP
	STAA	TSKSTS,X	;TASK STATUS = STOP
;
	STS	TSKSTK,X	;TASK STACK = SP
;
	BRA	NXTTSK		;SCHEDULE NEXT TASK
; * * * * *
;
;  USER DEFINED CODE FOR TASK ONE
;
; * * * * *
CODE1:
	JSR	SYSTEM		;SCHEDULE OTHER TASKS
	JMP	CODE1		;DO TASK AGAIN
; * * * * *
;
;  USER DEFINED CODE FOR TASK TWO
;
; * * * * *
CODE2:
	RTS			;ASSUME TASK COMPLETE
; * * * * *
;
;  USER DEFINED CODE FOR TASK THREE
;  THIS EXAMPLE TASK INITIATES TASK 2 IF IT IS INACTIVE
;
; * * * * *
CODE3:
	LDAA	TASK2+TSKSTS
	CMPA	#TSKSTP
	BNE	C3SKP		;IF TASK2 STATUS <> TSKSTP THEN SKIP
	LDAA	#TSKNEW
	STAA	TASK2+TSKSTS	;TASK2 STATUS = TSKNEW
C3SKP:	JSR	SYSTEM		;SCHEDULE OTHER TASKS
	JMP	CODE3
	END
                                             