
{ isdelim -- finds out if the character is in the set of valid delimiters }
function isdelim(examine : char):boolean;
begin
  isdelim := (examine in [' ', ',', ';']);
end(* isdelim *);

(* The following declarations have to appear in the main program before the
  include for this program:

const
  cpmlinesz = 127;
  argsize = (some number like 10 or 30);
type
  argstring = tstring;		( This is due to conversion probs, as well as
				other things. )

  str = string[cpmlinesz];
var
  argument:argtstring;
  source : str;

  Invocation of the processes should look like this:

  grabtail(source);
  if getarg(n, source, argsize) then writeln(source);

  For more data, look in the file GARG.PAS. *)

{ grabtail -- returns the command line tail, after the program invocation. }
procedure grabtail(var cmdstrg:str);
(* your basic routine to snag the CP/M command tail and stuff it in a
   string.  Another Pizzini/Pournelle endeavor.*)

(* The procedure grabtail, or something like it, should be called before any
  getarg calls happen.  It should be called once and only once before calls to
  getarg and in fact the very first thing in the program.  Due to the rather
  insipid way the command line is returned in Pascal/M (in the first readln),
  if the user doesn't type anything after the program invocation the program
  will wait for something to be typed.  I know of no other way to do it under
  this system; any and all suggestions are welcomed. *)

(* It's not that bad.  The program does show the arguments, if any:

A>prun garg hi hi hi hi hi	<--- you type this
HI,HI,HI,HI,HI,			<--- the program writes this
( then the prog continues.  If you don't type any args in, the prog waits for
  the first readln.  Play around with it; it's not completely consistent.)
*)

const
  space=' ';
var
  lastpos:0..cpmlinesz;
  I:Integer;
begin
  CMDSTRG:='';
  readln(CMDSTRG);
  lastpos:=0;
(* Following removes invalid chars.  I don't currently trust pos, which is why
   I am using this less efficient method. *)
  if length(cmdstrg)>0 then
  begin
    while (length(cmdstrg)>0) and (cmdstrg[1]<=space) do
      delete(cmdstrg,1,1); 
(* Now, remove invalids from the other end.*)
    while (length(cmdstrg)>0) and (cmdstrg[length(cmdstrg)]<=space) do
      delete(cmdstrg,length(cmdstrg),1);
    if (isdelim(cmdstrg[length(cmdstrg)])) then (* remove the last trailing
					   delimiter from the command string *)
      delete(cmdstrg, length(cmdstrg), 1);

  end;
  (* the string that's passed back should be stripped of all garbage, and
     will be of length= 0..cpmlinesz. *)
end(* grabtail *);

{ getarg -- returns the specified argument out of the command line tail }
function getarg(n : integer; var charstr : argstring;
	maxsize : integer) : boolean;

(* This version of getarg will return 'true' and an empty string if two
  delimiters (other than a space) are encountered.  You can check for empty
  return values if you like; not difficult.  If you'd rather not, the area
  that takes care of this little feature is marked; it shouldn't be any big
  deal to change. *)
var
  i, argcnt : integer;
  foundarg : boolean;	(* foundarg is the 'shadow variable' of getarg. *)

{ depad -- removes padding characters from passed input }
procedure depad(var charstr : str; padchar : char);
(* Could it be that having a parm larger than the string it's called with will
  cause crashing? we'll find out. Nope, doesn't seem to. *)
(* note this proc should work under M or MT+ *)
var
  i : integer;
  lastpad : boolean;
begin
  lastpad := false;
  i := 1;
  while (i<=length(charstr)) do
  begin
    if (charstr[i]=padchar) then
      if lastpad then
        begin
          delete(charstr, i, 1);
	  i := i - 1; (* so the results will be correct when deletions happen*)
	end
      else
        lastpad := true
    else
      lastpad := false;
    i := i + 1;
  end(* while *);
end (* depad *);

{ fillarg -- a part of the main while loop of getarg, moved for clarity }
function fillarg(var i:integer; var charstr:argstring; maxsize : integer;
		 argno:integer) : boolean;
var
  index,
  j : integer;
  done : boolean;
  filler : string[1];
begin
(* the following little trick is so we properly obtain the first argument;
  remember that for every arg but #1, we start out at a delimeter.  In arg #1,
  since all leading blanks are stripped by GRABTAIL, we start out right on top
  of the first (possibly of none) character.*)
  If (argno = 1) then
    j := 0
  else
    j := 1;
  index := 1;	 (*index tracks where in the output string we currently are *)
  fillarg := true;	(* meaning we've found our argument, even if it's
			empty.  Change this if you want to return 'false' for
			empties.  Meaning to the outside world that we've
			filled an argument, even if it's with nothing. *)

  done := false;
  filler := ' ';	(* readying filler for filling later *)
  while ((index <= maxsize) and ((i + j) <= length(source)) and (not done)) do
  begin
    filler[1] := source[i + j];	(* necessary 'cuz M can't concatenate
				a string and a character *)
    done := isdelim(filler[1]); (* this allows us to finish when the next
					delimiter is found*)
    if not done then	(* add this character to the string *)
    begin
      charstr := concat(charstr,filler);
      j := j + 1;		(* this is enclosed here so that two
				  delimiters in a row can be handled.*)
      index := index + 1;	(* Tracks the location we're inserting to *)
    end (* if not done *);
  end (* while (j < maxsize) ... *);

{ If the user wishes to use tstrings, the following should be uncommented:

  if done then	(* we found a delimiter; the next character in the output
		string needs to be an ENDSTR*)
    charstr[index] := ENDSTR
  else	   	(* we either overran the end of the input string or the end
 		of the output string *)
    charstr[index + 1] := ENDSTR;
    
 But I don't like tstrings, and see no need for them with real strings
 available.}

(* we return an empty arg if two delimiters in a row are encountered.  This
 could be used intentionally.  If you don't want this feature, a little thought
 and work will change it. *)

end (* fillarg *);


begin (* function getarg *)

(* the method used here is basically brute-force, but it should work.  Every
  time an argument is asked for, the procedure grabtail reloads the command
  line, the function counts parms, finds the next one(if any), and returns it.
  This can be improved on, but it works. *)

  charstr := '';	(* empty string *)
  if ((n <= 0) or (length(source)<=0)) then	(*Takes care of cases where no
						args or negative args given *)
    getarg := false
  else
  begin
    depad(source,' ');	(* removes all duplicate spaces from input string *)
    i :=1;
    argcnt := 1;
    foundarg := false;

(* the line below will not compile if it looks like this:

    while i<=length(source) and (not foundarg) do

   however, the errors it gives are "error 129; last identifier scanned was
   DONE."  The parentheses correct it, but it's certainly not clear where the
   error is, unless you know a lot about compiler construction.  Bleah. *)

    while ((i<=length(source)) and (not foundarg)) do
    begin
      if (argcnt = n) then foundarg := fillarg(i, charstr, maxsize, n);
(* fill with the string to return *)
      if not foundarg then
      begin
        i := i + 1;
        if (i<=length(source)) then
	(* test this way so as not to overflow source*)
          if (isdelim(source[i])) then argcnt := argcnt + 1;
      end;
    end (* while *);
  getarg := foundarg;
  end (* if (n <= 0) *);
end (* function getarg *);

{ nargs (M/MT+) -- return number of arguments }
function nargs : integer;
var
    i : integer;
    trash_string : argstring;

(* This version does NOT return a zero for the zeroth argument, which, on UCB
  systems, is the program invocation argument.  I don't know how to get the
  name of the invoking program from CP/M, though doubtless there is a way. *)

begin
  i := 1;
  if (not getarg(i, trash_string, ARGSIZE)) then
    nargs := 0
  else
  begin
    while (getarg(i, trash_string, ARGSIZE)) do
    begin
      i := i + 1;
    end;
    i := i - 1;
    nargs := i;
{DIAGNOSTIC}
WRITELN('NARGS = ',i);
  end;
end (* nargs *);

