
(*  INTEGERS ARE NOT STRINGS.  THUS WHEN WE go to put the length of a file
into the file header, we cannot simply put the integer there; Pascal cannot
do that.  Instead, we convert it to a string, and then we can concatenate that
into the header.*)

(* make notes and changes: TEXT standard, check for zero or beyond length
  strings *)

	{ITOC}
{ itoc -- convert integer n to char string in s[i]... }
function itoc (n : integer; var s : string; i : integer)
	: integer;  { returns end of s }

(* converted to use M or MT+ strings; use tstrings and the book's version if
  you really want them. *)

VAR
	teeny : string[1];

begin
    if (n < 0) then begin
	s := concat(s,'-');   {this magically transforms length; as opposed
				to how we do it in SCOPY below.}

	itoc := itoc(-n, s, i+1)
    end
    else begin
	if (n >= 10) then
	    i := itoc(n div 10, s, i);
	teeny := ' ';		{sets length of teeny to 1}
	teeny[1] := chr(n mod 10 + ord('0'));   {all this, believe it or not,
					  is to get around the fact that concat
					  doesn't know how to handle type char}

	s := concat(s,teeny);
(*      s[i+1] := ENDSTR;*)      (* old K&P*)
	itoc := i + 1		(* still returns one beyond the end of the
				  string, as in the book *)
    end {if -- there could be a ";" here but it isn't needed. K&P don't.}
end {ITOC};
