(* This is the file Lwercase.Pas, a file of lowercase routines for M and MT+ *)

{ lower_case (M/MT+) converts a char to lowercase }
function lower_case ( f : char ) : char;

(* This is NOT the most general form of an upper- to lower-case converter, but
  it works.  32 happens to be the offset between 'A' and 'a' in ASCII; I assume
  you are working on an ASCII machine. *)

begin
    if ((f >= 'A') and (f <= 'Z')) then
	lower_case := chr( ord(f) + 32)
    else 
	lower_case := f;
end(* lower_case *);

{ l_case_string (M/MT+) -- converts a string to all lowercase letters }
procedure l_case_string (var stringy : string );
var
    i : integer;
begin
    for i := 1 to length(stringy) do
	stringy[i] := lower_case(stringy[i]);
end (* l_case_string *);


