(* This is the file TOOLSINC.PAS, a file of include stuff for Software Tools
   programs. *)

(* these declarations should appear at the beginning of 'most all K & P
   programs.  I will try to keep them as universal as I can.*)

(* this is the M version; the MT+ version is very similar. *)

const
(* the following are for getting arguments from the command line *)
    argsize = 25;
    cpmlinesz = 127;

(* the following are for all tools programs. *)

(* universal constants *)
    MAXSTR = 80;
    ENDSTR = 0; 
    ENDFILE = 26;	(* a control-Z *)

{ standard file descriptors, subscripts in open, etc. }
    STDIN = 1;      (* Changing these constants would be difficult, *)
    STDOUT = 2;     (* resulting in strange consequences *)
    STDERR = 3;
    FIRSTAVAIL = 4;	(* The first available file for scratch files.  Should 
  be equal to 1 + last_program_file (1 + STDERR at the moment). *)
    MAXOPEN = 8;   (* maximum number of open files.  System-dependent. *)
    LASTAVAIL = 8;	(* Last available file for scratch files.  Should be
  equal to FIRSTAVAIL + MAXOPEN - 1. *)
    LASTFILE  = 8;		(* last file, period.  The declarations for
				  "filedesc", etc., uses this value. *)
    LASTPLUSONE = 9;		(* the last file plus one *)

{ other I/O-related stuff }
    IOERROR = 0;    { status values for open files }
    IOAVAIL = 1;
    IOREAD  = 2;
    IOWRITE = 3;

{ the necessary ASCII character set in decimal form for tstrings.  The rest are
 in the book if you need them. }

    NEWLINE= 10;(* return; note that linefeed counts as a separate character *)
    BLANK  = 32;(* a space *)
    PLUS   = 43; (* + *)
    MINUS  = 45; (* - *)
    BACKSPACE = 8; (* control - H *)
    TAB    = 9; (* control - I *)
    SKIP   = BLANK;(* character to skip a line on printer *)
    NOSKIP = PLUS; (* sends a command not to skip *)
    TILDE  = 126;  (* ~ *)
    WARNING = TILDE;


type
    character = 0..127; (* no -1 because ENDFILE is a 26. *)
    filedesc = IOERROR .. LASTFILE;
    filesearch = IOERROR .. LASTPLUSONE; (* used to search one past last file*)

(* the following are for obtaining stuff from the command line. *)
    argstring = string[argsize];
    str	      = string[cpmlinesz];

    ioblock = packed record	{ to keep track of open files }
(*	filevar : text;	   this won't work on M; we use CASES instead. *)
  	mode : IOERROR .. IOWRITE;
	name : argstring;
    end;  

(* we declare the type tstring instead of string so that we can get at M and
  MT+ strings.  This means somewhat changed programs, but that's life.*)

    tstring = array [1..MAXSTR] of character;
var
    openlist : packed array [1 .. LASTFILE] of ioblock;	{ open-file list }
    STDOUTFILE,
    STDERRFILE,
    file1,
    file2,
    file3,
    file4,
    file5: text;	(* files used within archive *)
    

(* both M and MT+ require this string for command line arguments *)
    source : str;
    argument : argstring;

{ min -- compute minimum of two integers }
function min (x, y :integer) : integer;
begin
    if (x < y) then
	min := x
    else
	min := y
end;

(* Rather obviously, this is not the bestest function that I could think of to
  do this.  An improved version would be best for the DLE version.*)

{ isupper -- true if c is upper case letter }
function isupper (c : character) : boolean;
begin
    isupper := c in [ord('A')..ord('Z')]
end;

