procedure putstr (var s : string; f : filedesc); forward;

procedure message (billboard : string ); forward;

procedure error ( panic_message : string ); forward;

{ tool_close -- M interface to close files }
procedure tool_close (fd : filedesc);
const
    close_err_msg = 'Error in closing file (tool_close)';
var
    close_status : integer;

(* Currently does nothing about file problems, except report them and not use
  the file variable again.  What to do depends on what YOU want to do; I would
  strongly suggest some recovery method. *)

procedure file_close (var fyle : text);
begin
  close(fyle, lock);
  close_status := IORESULT;
  if (close_status <> 0) then begin
    putstr(openlist[fd].name, fd);
    message(close_err_msg);
    openlist[fd].mode := IOERROR;
  end
  else openlist[fd].mode := IOAVAIL;
  openlist[fd].name := '';	(* set name to empty *)
end (* file_close *);

begin
  case fd of
    STDERR: close(STDERRFILE, lock);
    4: file_close(file1);
    5: file_close(file2);
    6: file_close(file3);
    7: file_close(file4);
    8: file_close(file5)
  otherwise
    message(close_err_msg);	(* DO NOT call error here; you would get a
				  recursive call during abnormal termination --
				  error calls tool_close; if tool_close also
				  called error, you'd never get out. *)
  end (* case *);
  WRITELN('in tool_close close returns ',close_status,' ',ioresult);
{DIAG}
    writeln('Closed file #', fd);
end (* tool_close *);


