/* line by line file comparison routine */
#include "b:pt.h"
#include "b:ptdefs.h"

/*
	compare:
*/
compare()
{
	if(cmd_cnt < 2)
	  if(!findin(cmd[1],nom[_COMP])) return;
	if(cmd_cnt < 3)
	  if(!findin(cmd[2],nom[_COMP])) return;
	_compare(); 
} 

/* 
	_compare: 
*/ 
_compare() 
{ 
#define MAXERROR 25 
FILE *i1, *i2; 
char *s, *t; 
unsigned linecount, errors, a, b;
static char *shorted = "\n%s ended before %s on line %u\n"; 
static char *okay = "\n%s and %s compared. %u lines.\n";
static char *report = "\n%s compared to %s with %u errors\n";

	i1 = xfopen(cmd[1],"r");
	if(!i1) { fnf(cmd[1]); return; }
	i2 = xfopen(cmd[2],"r");	
	if(!i2) { fnf(cmd[2]); fclose(i1); return; } 

	getvec(&s); getvec(&t); 
	linecount = 0; 
	errors = 0; 
	while((a=xfgets(s,BLOCK,i1)) && (b=xfgets(t,BLOCK,i2))) 
	   { 
	   if(interrupt()) break; 
	   linecount++; 
	   if(strcmp(a,b)!=0) 
	     { 
	     fprintf(progout,"\nDifference at line %u\n",linecount);	      
	     fprintf(progout,"%s: %s",cmd[1],s); 
	     fprintf(progout,"%s: %s",cmd[2],t); 
	     if(errors++ > MAXERROR) 
		{ 
		fprintf(progout,"\nError count exceeded\n"); 
		break; 
		} 
	     } 
	   } 

	if(a>b) 
	   fprintf(progout,shorted,cmd[1],cmd[2],linecount); 
	else if(b<a) 
	   fprintf(progout,shorted,cmd[2],cmd[1],linecount); 
	else

	   fprintf(progout,okay,cmd[1],cmd[2],linecount);
	fprintf(progout,report,cmd[1],cmd[2],errors);
	free(s); free(t); 
	fclose(i1); fclose(i2); 
	return; 
} 
f(progout,"%s: