/* hex, octal, decimal, file dump */
#include "b:pt.h"
#include "b:ptdefs.h"

/*
	hdump:
*/
hdump()
{
	if(cmd_cnt<2)
    	  {
	  if(!findin(cmd[1],nom[_HDUMP])) return;
	  cmd_cnt++;
	  }
	do_dump(16);
}

/*
	odump:
*/
odump()
{
	if(cmd_cnt<2)
	  {
          if(!findin(cmd[1],nom[_ODUMP])) return;
	  cmd_cnt++;
	  }
	do_dump(8);
}

/*
	ddump:
*/
ddump()
{
	if(cmd_cnt<2)
	  {
          if(!findin(cmd[1],nom[_DDUMP])) return;
	  cmd_cnt++;
	  }
	do_dump(10);
}

/*
	do_dump:
*/
do_dump(base)
int base;
{
int i;
	for(i=1; i<cmd_cnt; i++) _dump(cmd[i],base);
}

/*
	_dump:
*/
_dump(fn,base)
char *fn;
int base;
{
char *buffer, *place, *format;
FILE *input;
int i, j, k;
unsigned recno; 

	if((input=fopen(fn,"rb"))==0)
	     { fnf(fn); newline(); return; }
	buffer = (char *) calloc(RECLEN,1);
	format = (char *) calloc(BLOCK,1);

	switch(base)
	  {
	  default:
	  case 16: strcpy(format,"%02x  "); break;
	  case  8: strcpy(format,"%03o "); break;
	  case 10: strcpy(format,"%03u "); break;
	  }

	recno=0;
	while(read(input-0x8000,buffer,RECLEN)>0)
	   {
	   fprintf(progout,"\n\nFile: %s Record: %u\n",fn,++recno);
	   place = buffer;
	   for(j=0; j<(RECLEN/8); j++) 
	      { 
	      newline(); 
	      for(k=0; k<8; k++) 
		fprintf(progout,format,*(place+k)&0xff); 
	      fprintf(progout,"  "); 
	      for(k=0; k<8; k++) 
		fprintf(progout,"%c",isprint(*(place+k)&0xff) ?  
					*(place+k)&0xff : '.'); 
	      place += 8;       /* next line */
	      } 
	   if(interrupt()) goto done;
	   }

done: 
	fclose(input); 
	free(buffer); 
	free(format);
	return;
}

n\nFile: %s Record: %u\n",fn,++recno);
	   place = buffer;
	   for(j=0; j<(RECLEN/8); j++) 
	      { 
	      newline/* write out blocks */
	   buffer += RECLEN;
	   code = bdos(WRSEQ,outfcb)&0xff;
	   if(code==0) continue;
	   message("WRITE ERROR"); 
	   break; 
	   }

	if(code==0) goto repeat;

	bdos(CLOSE,infcb);      /* close files */
	bdos(CLOSE,outfcb);