/* fast disk file copy */
#include "b:pt.h"
#include "b:ptdefs.h"

/*
	fast:
*/
fast()
{
	if(cmd_cnt<2) 
		if(!findin(cmd[1],nom[_FAST])) return;
	if(cmd_cnt<3)
		if(!findout(cmd[2],nom[_FAST])) return;
	_fast(cmd[1],cmd[2]);
	return;
}

/*
	_fast:
*/
_fast(infile,outfile)
char *infile, *outfile;
{
char *infcb, *outfcb, *dma, *buffer, *start;
unsigned space, blocks, code;
unsigned i, j;

#define CREC 32		/* current record */
	infcb = (char *) makefcb(infile);
	outfcb = (char *) makefcb(outfile);
	if((bdos(OPEN,infcb)&0xff)==0xff)         /* open file for read */
	   {
	   fnf(infile);
	   goto done;
	   }
	*(infcb+CREC) = 0;                    /* set current record to zero */
	if(SHIELD && exists(outfile))
	  {
	  fprintf(progout,
	  "\n%s exists. Would you like to write over it ? \007",outfile);
	  if(!wants()) goto done;
	  }

	bdos(DELETE,outfcb);		      /* delete output file */
	if((bdos(CREATE,outfcb)&0xff)==0xff)  /* create file */
	  {
	  fnf(outfile);
	  goto done;
	  }
	dma = (char *) calloc(RECLEN,1);	 	/* get dma buffer */
	bdos(SETDMA,dma);			/* set it for read/write */

	space = (unsigned) coreleft() - SAFETY; /* get space available   */
	blocks = space / RECLEN;                /* how many blocks ?     */
	buffer = (char *) calloc(space,1);      /* get memory            */
	start = buffer;                         /* save starting address */

repeat:
	for(i=0; i<blocks; i++)                 /* read into buffer      */
	   {
	   code = bdos(RDSEQ,infcb)&0xff;
	   if(code==1 || code==2) break;	/* EOF */
	   movmem(dma,buffer,RECLEN);
	   buffer += RECLEN;
	   }

	buffer = start;                         /* reset buffer ptr */
	for(j=0; j<i; j++)
	   {
	   movmem(buffer,dma,RECLEN);   	/* write out blocks */
	   buffer += RECLEN;
	   code = bdos(WRSEQ,outfcb)&0xff;
	   if(code==0) continue;
	   message("WRITE ERROR"); 
	   break; 
	   }

	if(code==0) goto repeat;

	bdos(CLOSE,infcb);      /* close files */
	bdos(CLOSE,outfcb);
	free(start);		/* restore memory space */
	free(dma);
done:
	free(infcb);
	free(outfcb);
	return;
}

ECLEN;
	   }

t test.dat
	
	copies test.dat, test2.dat, test3.dat and test.dat to output.dat
	
	EXAMPLE:

	cat output.dat $files.bat

	copies the files in file.bat to output.dat
	filenames are expected as one per line (terminated by CRLF)

	The above example could be done as:

	In files.bat put the following:

	test.dat
	test2.dat
	test3.dat
	test.dat
	
	Each file will be rea