/* directory bound programs */
#include "b:pt.h"
#include "b:ptdefs.h"
/* list_dir: */
list_dir(linear) boolean linear; {
	if(common_dir()) display_dir(linear); free_dir(); pchr(NL); return; }

/* common_dir: */
common_dir() {
char get_drive();
int i, found;
        found = dir_cnt = 0; drive = get_drive();
        default_drive = drive;
        if(cmd_cnt<2) { found += do_dir(SEARCHALL); goto enddir; }
        for(i=1;i<cmd_cnt;i++) {
                if((strlen(cmd[i])==2) && (*(cmd[i]+1)==':'))
			strcat(cmd[i],SEARCHALL);
                if(*(cmd[i]+1)==':')
                        default_drive = toupper(*cmd[i]);
                found += do_dir(cmd[i]); default_drive = drive; }
enddir:
        if(found==0)
		{ message("No file found"); return(FALSE); }
	sort_dir(); return(TRUE); }

/* multget: */
multget(operation) char *operation; {
int i, j;
char *tmpvec;
	getvec(&tmpvec);
	for(i=0;i<dir_cnt;i++) { if(i%4==0) fputc(NL,progout);
                fprintf(progout,"%2d %-16s",i+1,dir_entry[i].name); }
	prompt2("Please enter the numbers of the files that you want to ",
		operation);
	prompt("Put a period '.' at the end of the list of numbers. ");
	j=0; while(fscanf(progin,"%d",&store[j])) j++;
	xfgets(tmpvec,BLOCK,progin);
	for(i=0; i<j; i++) store[i]--;	/* get one less for array ref */
	free(tmpvec);
	return(j);

}

/* mcopy: */
mcopy() {
char outdrive;
int i, j;
char *tmpvec;
	if(!common_dir()) goto end;
	j=multget(nom[_COPY]);
	if(!j) goto end;
	getvec(&tmpvec);
gdrve:
	prompt("What drive do you want the files copied to ? ");
	xfgets(tmpvec,BLOCK,progin); outdrive = toupper(*tmpvec);
	if(outdrive<'A' || outdrive>'P') goto gdrve;

	for(i=0; i<j; i++) {
	   strcpy(tmpvec,dir_entry[store[i]].name); nospace(tmpvec);
	   fprintf(progout,"File: %-16s %scopied to %c:\n",
		tmpvec,
		mfcpy(tmpvec,outdrive) ? " " : "not ",outdrive); }
	free(tmpvec);
end:	free_dir(); pchr(NL);
	return; 
} 

/* mfcpy: */
mfcpy(fn,outdrive) char *fn, outdrive; {
char *tmps;
int retcode;
FILE *input, *output;
	if(*fn==outdrive) return(FALSE);
	getvec(&tmps);  strcpy(tmps,fn); *tmps=outdrive;
	input=xfopen(fn,"rb"); if(!input) { retcode=FALSE; goto done; }
	output=xfopen(tmps,"wb"); if(!output)
		{ fclose(input); retcode=FALSE; goto done; }
	retcode = _copy(input,output);
done:
	fclose(input); fclose(output);
	free(tmps);
	return(retcode);
}

/* merase: */
merase() {
int i, number;
char *tmpvec;
	if(!common_dir()) goto finis; number=multget(nom[_ERASE]);
	getvec(&tmpvec);
	for(i=0;i<number;i++) {
		strcpy(tmpvec,dir_entry[store[i]].name); nospace(tmpvec);
		fprintf(progout,"File: %-16s %serased\n",tmpvec,
			unlink(tmpvec) ? "not " : " "); }
	free(tmpvec);
	free_dir(); pchr(NL); return; }

/* nospace: */
nospace(s) char *s; {
char *t;
int i,j;
	getvec(&t);
	i=j=0;
	while(*(s+i)) { if(*(s+i)!=' ') { *(t+j)=*(s+i); j++; } i++; }
	*(t+j)=EOS; strcpy(s,t); free(t);
	return;
}

/* mprint: */
mprint() {
int i, number;
FILE *input, *output;
char *tmpvec;
	if(!common_dir()) goto end;
	number=multget(nom[_PRINT]); if(!number) goto end;
	get_print_options();
	getvec(&tmpvec);
	for(i=0;i<number;i++) {
		strcpy(tmpvec,dir_entry[store[i]].name);
		nospace(tmpvec);
		message3("File:",tmpvec,"is being printed");
		if(!openrw(tmpvec,PRINTER,&input,&output)) goto end;
		if(popt.FORMFEED) fputc(FF,output);
 		if(popt.NAME) fprintf(output,"\nFILE: %s\n",tmpvec);
		_print(input,output); fclose(input); fclose(output); }
	free(tmpvec);
end:
	free_dir(); pchr(NL); return; }

/* msearch: */
msearch() {
char *sr;
int i, number;
FILE *report;
boolean REPORT;
char wild='?';
char *tmpvec;
	if(!common_dir()) goto end;
	number = multget(nom[_SEARCH]); if(!number) goto end;
	prompt("What string would you like to search for ? ");
	getvec(&sr);
	if(!xfgets(sr,BLOCK,progin)) goto endsr;
	if(*sr=='\n') goto endsr;
	chop(sr);
	REPORT=FALSE;
	prompt2("Enter a report file name or",
		"Press [RETURN] if you do not want one ");
	getvec(&tmpvec);
	if(!xfgets(tmpvec,BLOCK,progin)) goto endsr; 
	if(*tmpvec=='\n') goto noreport; 
	chop(tmpvec);
	report=xfopen(tmpvec,"w");
	if(!report) goto endsr; 
	REPORT=TRUE;
noreport:
	for(i=0;i<number;i++) {
		strcpy(tmpvec,dir_entry[store[i]].name); nospace(tmpvec);
		_search(tmpvec,sr,wild,REPORT,report); }
	
endsr:	free(tmpvec); free(sr); if(REPORT) fclose(report);
end:	free_dir(); pchr(NL); return; }

/* do_dir: */
do_dir(str)          /* returns number entries found */
char *str;
{
char *file, *fcb;
int res;
	getvec(&file);
        quest(file,str);             /* copy with ??? */
        fcb = (char *) makefcb(file); res = get_dir(fcb);
        free(file); return(res); }

/* get_dir: */
get_dir(fcb)            /* returns number entries matched */
char *fcb; {
int r0, r1;
char *dr, *dma, *file, *ext;

	getvec(&dma); 
        bdos(SETDMA,dma);               /* set dma address */
        r1 = 0;

        r0 = bdos(FIRST,fcb)&0xff;           /* search 1st entry */
        if(r0==ERROR) goto cleanup;

#ifdef CPM86 
	r0 <<= 5; 
#endif 
        r1 = 1;

        file = (char *) calloc(10,1);
        ext = (char *) calloc(4,1);
        extract(dma,r0,dr,file,ext);
        add_to_dir(dr,file,ext);

        forever {
                r0 = bdos(NEXT,fcb)&0xff; if(r0==ERROR) break;
#ifdef CPM86 
		r0 <<= 5; 
#endif 
                r1++;
                extract(dma,r0,dr,file,ext);
                add_to_dir(dr,file,ext); }
        free(file); free(ext);
cleanup:
	free(dma); return r1; }

/* extract: */
extract(dma,res,dr,file,ext)
char *dma; int res;
char *dr, *file, *ext;
{
int i,j;

#ifdef MSDOS
	*dr = *dma;
	for(i=1, j=0; i<9; i++, j++) *(file+j) = *(dma+i);  *(file+j)=EOS;
	for(i=9, j=0; i<12; i++, j++) *(ext+j) = *(dma+i);   *(ext+j)=EOS;
#endif

#ifdef CPM86
        *dr = *(dma+res) ;
        for(i=1,j=0;i<9;i++,j++) *(file+j)=*(dma+res+i);  *(file+j)=EOS; 
        for(i=9,j=0;i<12;i++,j++) *(ext+j)=*(dma+res+i);  *(ext+j)=EOS; 
#endif
	s_toascii(file); s_toascii(ext); return; }

/* add_to_dir: */
add_to_dir(dr,fn,fe) char *dr, *fn, *fe; {
char *buf;
        if(in_dir(*dr,fn,fe)) return;
	buf = (char *) calloc(17,1);
        *buf = (*dr==0) ? default_drive : *dr + 'A' - 1;
        *(buf+1) = ':'; *(buf+2) = EOS;
        strcat(buf,fn); strcat(buf,"."); strcat(buf,fe);
	if(in_dir(buf)) free(buf);
        else { dir_entry[dir_cnt].name=buf; dir_cnt++; }
	return; }

/* display_dir: */
display_dir(fl) boolean fl; {
int i;
        for(i=0;i<dir_cnt;i++) {
		if((fl==LINEAR) || (i%4==0)) fputc(NL,progout);
                fprintf(progout,"%-19s",dir_entry[i].name); }
        if(dir_cnt>1) fprintf(progout,"\n%d entries\n",dir_cnt);
        else pchr(NL); return; }

/* free_dir: */
free_dir() {
int i;
        for (i=0;i<dir_cnt;i++) free(dir_entry[i].name); return; }

/* quest: */
quest(to,from) char *to, *from; {
int base, end , END, src, dst, x;
        if(index(from,'*')==0) { strcpy(to,from); return; }
        base = 0; end = 8; END = 0;
        if(*(from+1)==':') { base = 2; end = 10;
                *(to) = *(from); *(to+1) = ':'; }
        for(src=base,dst=base;src<end;src++) {
		if(*(from+src)==EOS) { END = 1; break; }
                else if(*(from+src)=='.') break;
		else if(*(from+src)=='*')
			while(dst<end) { *(to+dst)='?'; dst++; }
		else { *(to+dst)=*(from+src); dst++; } }
                *(to+dst)='.';
                if(END) { *(to+dst+1)=EOS; return;} dst++;
                while(src < (base+11)) {
			src++; if(*(from+src)==EOS) break;
                        else if(*(from+src)=='*') {
                                x = dst + 3;
                                while(dst<=x) { *(to+dst)='?'; dst++; }
                                break; }
                        else { *(to+dst)=*(from+src); dst++; } }
                *(to+dst)=EOS; return; }

/* sort_dir: */
sort_dir() {
int i; boolean OK; char *n;
	forever {
        	OK=TRUE;
        	for(i=0;i<dir_cnt-1;i++)
		  if(strcmp(dir_entry[i].name,dir_entry[i+1].name)==1)
                       	{
			OK=FALSE;
        		n = dir_entry[i].name;
			dir_entry[i].name = dir_entry[i+1].name;
        		dir_entry[i+1].name = n;
			}
        	if(OK) break; }
	return; }

/* in_dir: */
in_dir(buf) char *buf; {
int i;  for(i=0;i<dir_cnt;i++) if(!strcmp(buf,dir_entry[i].name)) return TRUE;
        return FALSE; }


() {
int i; boolean OK; char *n;
	forever {
        	OK=TRUE;
        	for(i=0;i<dir_cnt-1;i++)
		  if(strcmp(dir_e