/* sort lines ascending/descending */
#include "b:pt.h"
#include "b:ptdefs.h"

#define NULL 0
struct tnode { char *line; struct tnode *left, *right; } ;
typedef struct tnode NODE;

/*
	sort:  forward sort
*/
sort()
{
	fsort(TRUE);
}
/*
	rsort: reverse sort
*/
rsort()
{
	fsort(FALSE);
}
/* fsort: */
fsort(flag)
int flag;
{
FILE *input, *output;
	if(cmd_cnt<2) { if(!findin(cmd[1],nom[_SORT])) return; }
	if(cmd_cnt<3) { if(!findout(cmd[2],nom[_SORT])) return; }
	if(!(openrw(cmd[1],cmd[2],&input,&output))) return;
	_sort(input,output,flag); 
	fclose(input); fclose(output);
	return;
}

/* _sort: */
_sort(input, output,flag) FILE *input, *output; int flag; {
NODE *root, *tree();
char *line;
	getvec(&line);
	root = NULL;
	while(getline(line,input)) 
		root = tree(root,line,flag);
	treeprint(root,output);
	treefree(root);
 	return;
}

/* getline: */
getline(w,input) char *w; FILE *input; { return(xfgets(w,BLOCK,input)); }

/**
	tree: 
*/ 
NODE *tree(p,w,fl) 
NODE *p; char *w; int fl;
{ 
NODE *newnode(); char *strsave();
	if(p==NULL)		/* new node */
		{ p = newnode(); p->line = strsave(w);
		  p->left = NULL; p->right = NULL; }
	else switch(strcmp(w,p->line)) {
		default: p=NULL; break;

		case -1: if(fl) p->left = tree(p->left,w,fl);
			 else p->right = tree(p->right,w,fl);
			 break;
		case  1: if(fl) p->right = tree(p->right,w,fl);
			 else p->left = tree(p->left,w,fl);
		         break;
		}
	return(p);
}

/* newnode: */
NODE *newnode()
{ 
	return((struct tnode *) calloc(sizeof(struct tnode),1));
} 

/**
	treeprint:
*/
treeprint(p,output)
NODE *p;
FILE *output;
{
	if(p != NULL)
		{
		treeprint(p->left,output);
		xfputs(p->line,output);
		treeprint(p->right,output);
		}
	return;
}

/**
	treefree:
*/
treefree(p)
NODE *p;
{
	if(p != NULL)
	    {
	    treefree(p->left);
	    free(p->line);
	    treefree(p->right);
	    free(p);
	    }
	return;
}

/* strsave: */
char *strsave(s) char *s; {
char *p;
	if((p = (char *) calloc(strlen(s)+1,1)) != NULL)
		strcpy(p,s); 
	return (p);
}


t:
*/
treeprint(p,output)
NODE *p;
FILE *outpuart,place,p_len,match,m_len,wild)
int start; char *place; int p_len; char *match; int m_len; char wild; {
int i, j;
	if(p_len<m_len) return FALSE;	/* not possible to match */
	for(i=start,j=0;j<m_len;i++,j++) {
		if(*(match+j)==wild) ;
		else if(*(match+j)!=*(place+i))
			return FALSE; }
	return TRUE; }

/* sr_batch: */
sr_batch(bat,fn) FILE *bat; char *fn; {
	if(!xfget