Package Assembly Bit
;	Bit manipulation library
;	Last modified 3/27/83


;	Copyright 1982,1983  RR Software, P.O. Box 1512, Madison WI 53701
;	Permission is hereby given to distribute Object Code produced from
;	these libraries.

	Jmp	Pend

;Set bit number Bit
Proc Setbit
	Pop	SI	;Return Address
	Pop	AX	;Bit number
	Pop	BX	;Val address
	Push	BX	;Restore the stack, as it has an IN OUT param
	Push	AX
	Push	SI
	Mov	SI,AX	;Get the bit mask
	Add	SI,SI	;Double the bit number
	Seg	CS
	Mov	AX,[SI + Bit_Table]	;Get the bit mask
	Or	[BX],AX	;Set the bit
	Ret
End Proc Setbit

;Clear bit number Bit
Proc Clrbit
	Pop	SI	;Return Address
	Pop	AX	;Bit number
	Pop	BX	;Val address
	Push	BX	;Restore the stack, as it has an IN OUT param
	Push	AX
	Push	SI
	Mov	SI,AX	;Get the bit mask
	Add	SI,SI	;Double the bit number
	Seg	CS
	Mov	AX,[SI + Bit_Table]	;Get the bit mask
	Not	AX	;Complement the mask
	And	[BX],AX	;Clear the bit
	Ret
End Proc Clrbit

;Test bit number bit
Proc Tstbit
	Pop	SI	;Return Address
	Pop	AX	;Bit number
	Pop	BX	;Value
	Push	SI	;Replace the return address, tossing params
	Mov	SI,AX	;Get the bit mask
	Add	SI,SI	;Double the bit number
	Seg	CS
	Mov	AX,[SI + Bit_Table]	;Get the bit mask
	Test	BX,AX	;Test the bit
	Jz	Isfalse
	Mov	AL,1	;Result is true
	Ret
Isfalse:Mov	AL,0	;Result is false
	Ret
End Proc Tstbit

Bit_table:	;Table of bit masks
	dw	0001h	;Bit 0
	dw	0002h	;Bit 1
	dw	0004h	;Bit 2
	dw	0008h	;Bit 3
	dw	0010h	;Bit 4
	dw	0020h	;Bit 5
	dw	0040h	;Bit 6
	dw	0080h	;Bit 7
	dw	0100h	;Bit 8
	dw	0200h	;Bit 9
	dw	0400h	;Bit 10
	dw	0800h	;Bit 11
	dw	1000h	;Bit 12
	dw	2000h	;Bit 13
	dw	4000h	;Bit 14
	dw	8000h	;Bit 15

;Logical And of the args.
Proc Land
	Pop	SI	;Return Address
	Pop	AX	;Val2
	Pop	BX	;Val1
	Push	SI	;Replace the return address, tossing params
	And	AX,BX	;And the values
	Ret
End Proc Land

;Logical Or of the args
Proc Lor
	Pop	SI	;Return Address
	Pop	AX	;Val2
	Pop	BX	;Val1
	Push	SI	;Replace the return address, tossing params
	Or	AX,BX	;Or the values
	Ret
End Proc Lor

;Logical Xor of the args
Proc Lxor
	Pop	SI	;Return Address
	Pop	AX	;Val2
	Pop	BX	;Val1
	Push	SI	;Replace the return address, tossing params
	Xor	AX,BX	;Xor the values
	Ret
End Proc Lxor

;Logical Not of the parameter
Proc Lnot
	Pop	SI	;Return Address
	Pop	AX	;Val
	Push	SI	;Replace the return address, tossing params
	Not	AX	;Not the value
	Ret
End Proc Lnot

;Returns the byte at addr in the data segment
;Function Peek (Addr : In Integer) Return Byte;
Proc Peek
	Pop	SI	;Return Address
	Pop	BX	;Addr
	Push	SI	;Replace the return address, tossing params
	Mov	AL,[BX]	;Get the byte
	Ret
End Proc Peek
	
;Changes the byte at addr in the data segment to Val
;Procedure Poke (Addr : In Integer; Val : In Byte);
Proc Poke
	Pop	SI	;Return Address
	Pop	AX	;Val
	Pop	BX	;Addr
	Push	SI	;Replace the return address, tossing params
	Mov	[BX],AL	;Set the Byte
	Ret
End Proc Poke

;Returns the byte at address Segment:Offset
;Function LPeek (Segment,Offset : In Integer) Return Byte;
Proc LPeek
	Pop	SI	;Return Address
	Pop	BX	;Offset
	Pop	CX	;Segment
	Push	SI	;Replace the return address, tossing params
	Push	DS
	Mov	DS,CX	;Set the segment register
	Mov	AL,[BX]	;Get the byte
	Pop	DS	;Restore the segment register
	Ret
End Proc LPeek

;Changes the byte at address Segment:Offset to Val
;Procedure LPoke (Segment,Offset : In Integer; Val : In Byte);
Proc LPoke
	Pop	SI	;Return Address
	Pop	AX	;Value to Poke
	Pop	BX	;Offset
	Pop	CX	;Segment
	Push	SI	;Replace the return address, tossing params
	Push	DS
	Mov	DS,CX	;Set the segment register
	Mov	[BX],AL	;Set the byte
	Pop	DS
	Ret
End Proc Lpoke

;Return CS - Not useful in multiple segment versions of Janus/Ada
;Function Code_Seg Return Integer;
Proc Code_Seg
	Mov	AX,CS
	Ret
End Proc Code_Seg

;Return DS - Not useful in multiple segment versions of Janus/Ada
;Function Data_Seg Return Integer;
Proc Data_Seg
	Mov	AX,DS
	Ret
End Proc Data_Seg

;Reads a byte from the port portnum, returning it in Value
;Procedure InPort (Portnum : In Integer; Value : Out Byte);
Proc InPort
	Pop	SI	;Return Address
	Pop	BX	;Value's Address
	Pop	DX	;Portnum
	Push	DX	;Restore the stack, as it has an OUT param
	Push	BX
	Push	SI
	In	AL,DX	;Input byte
	Mov	[BX],AL	;Put the byte into the parameter
	Ret
End Proc InPort

;Writes Value to the port portnum
;Procedure Outport (Portnum : In Integer; Value : In Byte);
Proc OutPort
	Pop	SI	;Return Address
	Pop	AX	;Value
	Pop	DX	;Portnum
	Push	SI	;Replace the return address, tossing params
	Out	DX,AL	;Output byte
	Ret
End Proc OutPort

Pend:

End Package Bit;
DX	;Input byte
	Mov	[BX],AL	;Put the byte into the parameter
	Ret
End Proc InPort

;Writes Value to the port portnum
;Procedure Outport (Portnum : In Integer; Value : In Byte);
Proc OutPort
	Pop	SI	;Return Address
	Pop	AX	;Value
	Pop	DX	;Portnumt portnum, returning it in Value
;Procedure InPort (Portnum : In Integer; Value : Out Byte);
Proc InPort
	Pop	SI	;Return Addr