With Jlib86;
Package Assembly Longops

    ; Copyright 1983  RR Software, Inc., P.O. Box 1512, Madison WI 53701
    ; Permission is hereby given to distribute Object Code produced from
    ; these libraries.  All Other rights reserved.

    ; Long Integer Operations
    ; Last Modified 4/29/83
    ; The names of these routines will be changed when operator overloading
    ; is implemented.

	Jmp	Pend	;Skip Package Body

Return:
	;Returns the result (which is in BX & CX; BX being low)
	;This entry ought to be JMPed to.
	Push	BX
	Push	CX
	Call	Func_Ret
	DW	4	;Return 4 byte record, pointer in AX
	Mov	SI,AX	;Copy the pointer to use it
	Pop	CX
	Pop	BX
	Mov	[SI],BX
	Mov	[SI+2],CX ;Copy the result into the return block
	Ret		;The pointer is still in AX

;Function Labs (Item : In Long_Integer) Return Long_Integer;
;    Operator "ABS" - Take the absolute value of operand
Proc Labs
	Pop	SI	;Return Address
	Pop	DI	;Address of Item
	Push	SI	;Replace return address - Params tossed
	Mov	BX,[DI]	;Get the value
	Mov	CX,[DI+2]
	Cmp	CX,0	;Test sign of upper byte
	Jge	LabsEnd
	Not	BX	;Negative, so negate CX:BX
	Not	CX
	Add	BX,1	;Make into 2's complement
	Adc	CX,0	;Add carry, if any
	Into		;Check for Overflow Error
LabsEnd:Jmp	Return	;Return the value in CX:BX
End Proc Labs

;Function Lneg (Item : In Long_Integer) Return Long_Integer;
;    Operator "-" - Negate the operand
Proc Lneg
	Pop	SI	;Return Address
	Pop	DI	;Address of Item
	Push	SI	;Replace return address - Params tossed
	Mov	BX,[DI]	;Get the value
	Mov	CX,[DI+2]
	Not	BX	;Negate CX:BX
	Not	CX
	Add	BX,1	;Make into 2's complement
	Adc	CX,0	;Add carry, if any
	Into		;Check for Overflow error
	Jmp	Return	;Return the value in CX:BX
End Proc Lneg

;Function Lint (Item : In Integer) Return Long_Integer;
;   Type Conversion Integer => Long_Integer
Proc Lint
	Pop	SI	;Return Address
	Pop	AX	;Item Value
	Push	SI	;Replace return address - Params tossed
	Cwd		;Sign Extend Number
	Mov	BX,AX
	Mov	CX,DX	;Get value from DX:AX => CX:BX
	Jmp	Return
End Proc Lint

;Function L_to_int (Item : In Long_Integer) Return Integer;
;    Type Conversion Long_Integer => Integer
Proc L_to_int
	Pop	SI	;Return Address
	Pop	DI	;Address of Item
	Push	SI	;Replace return address - Params tossed
	Mov	AX,[DI]	;Get the value
	Mov	CX,[DI+2]
	Cwd		;Sign Extend to see if the result is the same
	Cmp	CX,DX
	Jne	Conv_Err
	Ret		;Return the value in AX
Conv_Err: Int	4	;Force Arith. Overflow!
	Ret
End Proc L_to_int

;Function Ladd (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "+" - Long Integer addition
Proc Ladd
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Add	BX,[DI]	;Add Item2 (low)
	Adc	CX,[DI+2];Add Item2 (high)
	Into		;Check for Overflow error
	Jmp	Return
End Proc Ladd

;Function Lsub (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "-" - Long Integer subtraction
Proc Lsub
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Sub	BX,[DI]	;Subtract Item2 (low)
	Sbb	CX,[DI+2];Subtract Item2 (high)
	Into		;Check for Overflow error
	Jmp	Return
End Proc Lsub

;Function Lmul (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "*" - Long Integer multiply
Proc Lmul
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Mov	AX,[DI]	;Get Item2
	Mov	DX,[DI+2]
	Mov	SI,0
	Mov	DI,0	;Zero out accumulator
	Mov	BP,CX	;Use BP as upper bytes
	Mov	CX,32	;Loop counter
Mult_Loop:
	;Shift DI:SI Left
	Sal	SI,1
	Rcl	DI,1	;Include Carry
	;Shift BP:BX Left
	Sal	BX,1
	Rcl	BP,1	;Include Carry; Most sig. bit not in carry
	;Add  DX:AX to DI:SI if Carry
	Jnc	MAdd_Skip
	Add	SI,AX
	Adc	DI,DX
Madd_Skip:
	Loop	Mult_Loop	;Do it until the loop counter runs out
	Mov	CX,DI
	Mov	BX,SI
	Jmp	Return	;Return value in accumulator (no overflow check,
			; sorry)
End Proc Lmul

;Division Routine
;Divide CX:BX by DX:AX; Leaving Result in CX:BX; Remainder in DI:SI
	DSEG
Sign:	RB	1
	CSEG
Divide:	Mov	BP,AX
	Xor	BP,DX
	Jz	Dzero
	Mov	Byte([Sign]),0	;Clear Sign flag
	Cmp	DX,0	;Check divisor for negative
	Jge	Posop
	Not	Byte([Sign])
	Not	DX	;Negate Divisor
	Not	AX
	Add	AX,1
	Adc	DX,0
Posop:	Cmp	CX,0	;Check dividend for negative
	Jge	Posop2
	Not	Byte([Sign]) ;Flip sign flag
	Not	CX	;Negate Divisor
	Not	BX
	Add	BX,1
	Adc	CX,0
Posop2:
	Mov	DI,0
	Mov	SI,0	;Clear result
	Mov	BP,CX	;Need CX (so use BP:BX)
	Mov	CX,32	;Bit count
	;Now have Dividend/Result BP:BX; Divisor DX:AX; Remainder DI:SI;
	; Counter CX
	Shl	BX,1
	Rcl	BP,1	;Shift Dividend Left, Setting Carry
			;Result will be shifted in as dividend is shifted out
DivLoop:Rcl	SI,1	;Shift Remainder Left, Adding Carry
	Rcl	DI,1
	Push	SI	;Save remainder during trial subtraction
	Push	DI
	Sub	SI,AX	;Subtract Divisor
	Sbb	DI,DX
	Jge	DivIt	;If the Remainder is positive, the subtraction stays
	Pop	DI
	Pop	SI	;Restore the remainder
	Shl	BX,1	;Shift Dividend Left, Shifting in New Quotient of 0,
	Rcl	BP,1	;And setting carry if necessary.
	Jmp	Dskip
DivIt:	Add	SP,4	;Remove old remainder from stack
	Shl	BX,1	;Shift Dividend Left, Shifting in New Quotient of 1,
	Rcl	BP,1	;Add setting carry if necessary.
	Inc	BX	;(No carry since last bit MUST be zero)
Dskip:  Loop	DivLoop
	Mov	CX,BP	;Get upper byte of result into correct place
	Ret
DZero:	Int	0	;Divide by zero error
	Ret

;Function Ldiv (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "/" - Long Integer division
Proc LDiv
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Mov	AX,[DI]	;Get Item2
	Mov	DX,[DI+2]
	Call	Divide	;Result in CX:BX; Remainder in DI:SI
	Cmp	Byte([Sign]),0
	Jz	LDDone
	Not	CX
	Not	BX
	Add	BX,1
	Adc	CX,0	;Negate result (CX:BX)
LDDone: Jmp	Return	;Return the result
End Proc LDiv

;Function Lrem (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "REM" - Long Integer remainder
Proc LRem
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Mov	AX,[DI]	;Get Item2
	Mov	DX,[DI+2]
	Cmp	CX,0	;Determine if Dividend is negative
	Pushf
	Call	Divide	;Remainder in DI:SI
	Popf
	Jge	LRDone
	Not	DI	;Negate remainder
	Not	SI
	Add	SI,1
	Adc	DI,0
LRDone:	Mov	CX,DI
	Mov	BX,SI	;Get result into standard return registers.
	Jmp	Return	;Return result
End Proc LRem

;Function Lmod (Item,Item2 : In Long_Integer) Return Long_Integer;
;   Operator "-" - Long Integer modulus
Proc LMod
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Mov	AX,[DI]	;Get Item2
	Mov	DX,[DI+2]
	Push	AX	;Save Divisor
	Push	DX
	Cmp	CX,0	;Determine if Dividend is negative
	Pushf
	Call	Divide	;Remainder in DI:SI
	Mov	CX,DI
	Mov	BX,SI	;Put in normal operating registers
	Popf
	Jge	LMRem
	Not	CX	;Negate remainder
	Not	BX
	Add	BX,1
	Adc	CX,0
LMRem:	;Now, add divisor if Sign of result is negative and result /= 0
	Pop	DI	;Get Divisor back
	Pop	SI
	Mov	AX,CX
	Xor	AX,BX
	Jz	LMDone	;Result = 0
	Cmp	Byte([Sign]),0
	Jz	LMDone	;Sign is positive
	Add	BX,SI
	Adc	CX,DI	;Add divisor
LMDone:	Jmp	Return	;Return result
End Proc LMod

;Function Lgt (Item,Item2 : In Long_Integer) Return Boolean;
;   Operator ">" - Long Integer greater than
Proc Lgt
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Sub	BX,[DI]	;Subtract Item2 (low)
	Sbb	CX,[DI+2];Subtract Item2 (high)
	;Note: Only OF and SF are set properly by subtract; ZF is not
	;Cannot use Jle or Jg
	Jge	LLTrue
LFalse:	Mov	AL,0
	Ret
LLTrue:	Or	BX,CX
	Jz	LFalse	;False if values are equal
LTrue:	Mov	AL,1
	Ret
End Proc Lgt

;Function Lge (Item,Item2 : In Long_Integer) Return Boolean;
;   Operator ">=" - Long Integer greater than or equals
Proc Lge
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Sub	BX,[DI]	;Subtract Item2 (low)
	Sbb	CX,[DI+2];Subtract Item2 (high)
	Jge	LTrue	;In Lgt
	Mov	AL,0
	Ret
End Proc Lge

;Function Llt (Item,Item2 : In Long_Integer) Return Boolean;
;   Operator "<" - Long Integer less than or equals
Proc Llt
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Sub	BX,[DI]	;Subtract Item2 (low)
	Sbb	CX,[DI+2];Subtract Item2 (high)
	Jl	LTrue
	Mov	AL,0
	Ret
End Proc Llt

;Function Lle (Item,Item2 : In Long_Integer) Return Boolean;
;   Operator "<=" - Long Integer less than
Proc Lle
	Pop	DX	;Return Address
	Pop	DI	;Address of Item2
	Pop	SI	;Address of Item
	Push	DX	;Replace return address - Params tossed
	Mov	BX,[SI]	;Get Item
	Mov	CX,[SI+2]
	Sub	BX,[DI]	;Subtract Item2 (low)
	Sbb	CX,[DI+2];Subtract Item2 (high)
	;Only OF and SF set properly; ZF is not; thus Jg & Jle cannot be used
	Jl	LTrue	;LTrue in Lgt
	Or	BX,CX
	Jz	LTrue
	Mov	AL,0
	Ret
End Proc Lle

Pend:

End Package Longops;
t Item2 (high)
	Jge	LTrue	;In Lgt
	Mov	AL,0
	Ret
End Proc Lge

;Function Llt (Item,Item2 : In Long_Integer) Return Boolean