Package Assembly Mathlib2;

    ;-- Mathematic functions library
    ;-- These routines do no checking, kave weird use restrictions, and
    ;-- should not be used from user programs.  Use Mathlib instead.
    ;-- Last modified 4/29/83

    ; Copyright 1983  RR Software, Inc., P.O. Box 1512, Madison WI 53701
    ; Permission is hereby given to distribute Object Code produced from
    ; these libraries.  All Other rights reserved.

    FldL	Equ	40
    FstpL	Equ	43
    FldR	Equ	 8
    FxchR	Equ	 9
    FstpR	Equ	43
    Fld1	Equ	13 ;(Use 0 as Operand)
    Faddp	Equ	48 ;(Use 1 as Operand)
    Fmulp	Equ	49 ;(Use 1 as Operand)
    Fsubp	Equ	52 ;(Use 1 as Operand)
    Fsubrp	Equ	53 ;(Use 1 as Operand)
    Fdivp	Equ	54 ;(Use 1 as Operand)
    Fdivrp	Equ	55 ;(Use 1 as Operand)
    Fstsw	Equ	47
    Fchs	Equ	12 ;(Use 0 as Operand)

    DSEG
Result:	RB	8	;Long Float result
Status: RW	1	;Status word
Junk:	RB	8	;Place to toss extra junk
    CSEG

	Jmp	Pend

    ;Function Exp (Val : In Long_Float) Return Long_Float;
    ;	-- Returns E ** Val
Proc Exp
	Pop	DI
	Pop	SI	;Get the address on the floating point value
	Push	DI	;Restore Return address - Toss Params
	Wait
	Esc	FldL,[SI] ;Fld Long_Float([SI])
	Wait
	Esc	13,2	;Fld2lE
	Wait
	Esc	Fmulp,1
	Jmp	T_Exp	;Enter T_Exp with value on top of stack
End Proc Exp;


    ;Function Power (X,Y : In Long_Float) Return Long_Float;
    ;-- Returns X ** Y
    ;-- Y must be positive!!
Proc Power
	Pop	CX
	Pop	DI	;Y
	Pop	SI	;X
	Push	CX	;Restore Return address - Toss Params
	Wait
	Esc	FldL,[DI] ;Fld Long_Float([DI]) - Load Y value
	Wait
	Esc	FldL,[SI] ;Fld Long_Float([SI]) - Load X value
	Wait
	Esc	14,1	;Fyl2x	- Calculates Y * Log X
	Jmp	T_Exp	;Enter T_Exp with value on top of stack
End Proc Power

    ;Function Two_Exp (Val : In Long_Float) Return Long_Float;
    ;-- Returns 2 ** Val
Proc Two_Exp
	Pop	DI
	Pop	SI	;Get the address on the floating point value
	Push	DI	;Restore Return address - Toss Params
	Wait
	Esc	FldL,[SI] ;Fld Long_Float([SI])
T_Exp:	;Entry from E to the X
	Wait
	Esc	FldR,0	;Fld	St(0)
	Wait
	Esc	15,4	;Frndint
	Wait		;Get the fractional part of the exponent,
	Esc	FxchR,1 ;Fxchg	St(1)
	Wait		;as that is all the instruction will do.
	Esc	4,1	;Fsub	ST,ST(1)
	Wait
	Esc	12,4	;Ftst
	Wait
	Esc	Fstsw,[Status]
	Wait
	Mov	AX,[Status]	;Get status into flags
	Sahf
	Jb	Negtv
	;Just take 2 ** X
	Wait
	Esc	14,0	;F2xm1 - (2 ** X) - 1
	Wait
	Esc	Fld1,0	;Add one to get 2 ** X
	Wait
	Esc	Faddp,1
	Jmp	Join
Negtv:	;Negative value
	;Negate remainder and invert
	Wait
	Esc	Fchs,0 ;(Fneg)
	Wait
	Esc	14,0	;F2xm1 - (2 ** X) - 1
	Wait
	Esc	Fld1,0	;Add one to get 2 ** X
	Wait
	Esc	Faddp,1
	Wait
	Esc	Fld1,0	;Take 1/ 2 ** X
	Wait
	Esc	Fdivp,1
Join:	Wait
	Esc	15,5	;FScale - Calulates (2 ** X(Fract) *
			; 2 ** X(Integer Part) [Fract part from above]
			;Use the integer part of the exponent
	Wait
	Esc	FstpL,[Result]
	Mov	AX,Result ;Return the address of 'result'
	Wait
	Esc	FstpL,[Junk]	;Toss scale value
	;Don't wait, since this info will not be used
	Ret
End Proc Two_Exp;

Proc PTan
    ;Partial Tangent - Entry - Address of Angle in SI
    ;Exit TOS 8087 - X, ST(1) - Y - To be used to get result.
	Wait
	Seg	CS
	Esc	56,[NegTwo]	;Fld Integer([NegTwo]), Load constant -2
	Wait
	Esc	13,3	;FldPI
	Wait
	Esc	15,5	;FScale result - gives PI/4
	Wait
	Esc	FstpR,1	;Copy PI/4 into ST(1), and Pop. (Toss ST(1))
	Wait
	Esc	FldL,[SI] ;Get angle
Reduce:	;Reduce angle to proper quadrant - Only works for positive angles
	Wait
	Esc	15,0	;Fprem
	Wait
	Esc	Fstsw,[Status]
	Wait
	Mov	AX,[Status]
	Sahf
	Jpe	Reduce	;Loop until fully reduced
	Wait
	Esc	FstpR,1	;Copy Angle into ST(1), and pop. (Toss ST(1))
	Wait
	;Here it is - FPTan
	Esc	14,2	;FPTan
	Wait
	;Status bit C0,C1, and C3, hold the bottom three bits of the
	;Division result - use them to adjust the results
	Jnc	Skip1	;Test C0
	Esc	Fchs,0	;For octants 4,5,6,7
	Wait
	Esc	FxchR,1 ;Need both signs changed
	Wait
	Esc	Fchs,0
	Wait
	Esc	FxchR,1
	Wait
Skip1:	Jnz	Skip2	; Test C3
	Esc	FxchR,1 ;For Octants 2,3,6,7
	Wait
	Esc	Fchs,0	;Need an operand switch and a sign change
	Wait
Skip2:	Test	AH,2	;Test C1, which does not correspond to a flag
	Jz	Skip3	;For Octants 1,3,5,7 - Need X + Y and X - Y
	Esc	FldR,0	;Copy top of stack
	Wait
	Esc	FldR,2
	Wait
	Esc	Faddp,1
	Wait
	Esc	FxchR,2
	Wait
	Esc	Fsubrp,1
	Wait
Skip3:	;X and Y now on 8087 stack.
	Ret
NegTwo: DW	-2
End Proc PTan;

    ;Function Sin (Angle : In Long_Float) Return Long_Float;
    ;	-- Returns the Sine of the angle
Proc Sin
	Pop	DI
	Pop	SI
	Push	DI	;Restore Return address - Toss Params
	Call	PTan
	;Compute R - Hypotenuse
	Wait
	Esc	FldR,0	;Duplicate X
	Wait
	Esc	1,0	;FMul ST,ST	;Square it
	Wait
	Esc	FldR,2	;Duplicate Y
	Wait
	Esc	1,0	;FMul ST,ST	;Square it
	Wait
	Esc	Faddp,1
	Wait
	Esc	15,2	;Fsqrt	;Now have R
	Wait
	Esc	FldR,2	;Fld ST(2) ;Get Y on top
	Wait
	Esc	FDivp,1
	Wait
	Esc	FstpL,[Result]
	Mov	AX,Result	;Address of result
	Wait
	Esc	FstpR,1		;Toss X
	Wait
	Esc	FstpL,[Junk]	;Toss Y
	;Don't wait since no one wants the result
	Ret
End Proc Sin;

    ;Function Cos (Angle : In Long_Float) Return Long_Float;
    ;	-- Returns the Cosine of the angle
Proc Cos
	Pop	DI
	Pop	SI
	Push	DI	;Restore Return address - Toss Params
	Call	PTan
	;Compute R - Hypotenuse
	Wait
	Esc	FldR,0	;Duplicate X
	Wait
	Esc	1,0	;FMul ST,ST	;Square it
	Wait
	Esc	FldR,2	;Duplicate Y
	Wait
	Esc	1,0	;FMul ST,ST	;Square it
	Wait
	Esc	Faddp,1
	Wait
	Esc	15,2	;Fsqrt	;Now have R
	Wait
	Esc	FDivrp,1	;X / R
	Wait
	Esc	FstpL,[Result]
	Mov	AX,Result	;Address of result
	Wait
	Esc	FstpL,[Junk]	;Toss Y
	;Don't WAIT, since no one cares!
	Ret
End Proc Cos;

    ;Function Tan (Angle : In Long_Float) Return Long_Float;
    ;	-- Returns the Tangent of the Angle
Proc Tan
	Pop	DI
	Pop	SI
	Push	DI	;Restore Return address - Toss Params
	Call	PTan
	Wait
	Esc	FDivrp,1 ; Y / X
	Wait
	Esc	FstpL,[Result]
	Mov	AX,Result	;Address of result
	Wait
	Ret
End Proc Tan;

Pend: ;No initialization

End Package Mathlib2;

	Esc	FstpL,[Junk]	;Toss Y
	;Don't WAIT, since no one cares!
	Ret
End Proc Cos;

    ;Function Tan (Angle : In Long_Float) Return Long_Float;
    ;	-- Returns the Tangent of the Angle
Proc Tan
	Pop	DI
	Pop	SI
	Push	DI	;Restore Return address - Toss Params
	Call	PTan
	Wait
	Esc	FDivrp,1 ; Y / X
	Wait
	Esc	FstpL,[Result]
	Mov	AX,Result	;Address of result
	Wait
	Re
	Esc	15,2	;Fsqrt	;Now have R
	Wait
	Esc	FDivrp,1	;X / R
	Wait
	Esc	FstpL,[Result]
	Mov	AX,Result	;Address of result
	Wai