	TITLE	'DocOp69 - MC6809 Opcode Listing.'
;	DOCOP69  6809 Opcode Listing
;	Since there are so many addressing mode combinations,
;	the first part of this list only has enough instructions
;	to generate every possible first byte.
;	The file DOCAD69.Asm has one of each address mode.

nn:	equ	5
mmmm:	equ	$FFEE

	Link	DOCAD69		;all addressing modes
	
	ORG	$100

	ABX			;3A

	ADCA	#nn		;89 05
	ADCA	nn		;99 05
	ADCA	nn,X		;A9 05
	ADCA	mmmm		;B9 mmmm

	ADCB	#nn		;C9 05
	ADCB	nn		;D9 05
	ADCB	B,X		;E9 85
	ADCB	mmmm		;F9 mmmm
	
	ADDA	#nn		;8B 05
	ADDA	nn		;9B 05
	ADDA	[B,X]		;AB 95
	ADDA	mmmm		;BB FFEE
	
	ADDB	#nn		;CB 05
	ADDB	nn		;DB 05
	ADDB	D,S		;EB EB
	ADDB	mmmm		;FB FFEE
	
	ADDD	#mmmm		;C3
	ADDD	nn		;D3 05
	ADDD	0,-Y		;E3 A2
	ADDD	[nn,X]		;E3 98 05
	ADDD	mmmm		;F3 FFEE
	
	ANDA	#nn		;84 05
	ANDA	nn
	ANDA	mmmm,X
	ANDA	mmmm
	
	ANDB	#nn		;C4
	ANDB	nn
	ANDB	[mmmm,X]
	ANDB	mmmm
	
	ANDCC	#nn		;1C 05
	
	ASL	nn		;08
	ASL	0,-Y		;68
	ASL	,Y+
	ASL	mmmm		;78
	ASLA			;48
	ASLB			;58
	
	ASR	nn		;07
	ASR	0,X+		;67
	ASR	mmmm		;77
	ASRA			;47
	ASRB			;57
	
	BCC	rel
	BCS	rel
	BEQ	rel
	BGE	rel
	BGT	rel
	BHI	rel
	BHS	rel
	
	BITA	#nn
	BITA	nn
	BITA	,Y+
	BITA	mmmm
	
	BITB	#nn
	BITB	nn
	BITB	0,-Y
	BITB	mmmm
	
rel:	BLE	rel
	BLO	rel
	BLS	rel
	BLT	rel
	BMI	rel
	BNE	rel
	BPL	rel
	BRA	rel
	BRN	*
	BSR	rel
	BVC	rel
	BVS	rel
	
	CLR	nn
	CLR	0,-Y
	CLR	mmmm
	CLRA
	CLRB
	
	CMPA	#nn
	CMPA	nn
	CMPA	0,-Y
	CMPA	mmmm
	
	CMPB	#nn
	CMPB	nn
	CMPB	0,-Y
	CMPB	,Y+
	CMPB	0,-X
	CMPB	0,X+
	CMPB	0,-U
	CMPB	0,U++
	CMPB	mmmm
	
	CMPD	#mmmm
	CMPD	nn
	CMPD	0,-Y
	CMPD	mmmm
	
	CMPS	#mmmm
	CMPS	nn
	CMPS	0,-Y
	CMPS	,Y+
	CMPS	0,-X
	CMPS	0,X+
	CMPS	0,-U
	CMPS	0,U++
	CMPS	mmmm
	
	CMPU	#mmmm
	CMPU	nn
	CMPU	0,-Y
	CMPU	mmmm
	
	CMPX	#mmmm
	CMPX	nn
	CMPX	0,-Y
	CMPX	,Y+
	CMPX	0,-X
	CMPX	mmmm
	
	CMPY	#mmmm
	CMPY	nn
	CMPY	0,-Y
	CMPY	mmmm
	
	COM	nn
	COM	0,-Y
	COM	,Y+
	COM	0,-X
	COM	mmmm
	COMA
	COMB
	
	CWAI	#nn
	
	DAA
	
	DEC	nn
	DEC	0,-Y
	DEC	mmmm
	DECA
	DECB
	
	EORA	#nn
	EORA	nn
	EORA	0,-Y
	EORA	mmmm
	
	EORB	#nn
	EORB	nn
	EORB	0,-S
	EORB	mmmm
	
	EXG	A,B
	EXG	B,A
	EXG	D,X
	EXG	D,Y
	EXG	D,U
	EXG	D,S
	EXG	D,PC		;1E 05
	EXG	D,A		;1E 08		ERROR (self)
	EXG	D,B		;1E 09		ERROR (self)
	EXG	D,CC		;1E 0A		ERROR (16 <-> 8)
	EXG	D,DP		;1E 0B		ERROR (16 <-> 8)
	EXG	X,U
	EXG	Y,S
	EXG	X,DP		;1E 1B		ERROR (16 <-> 8)
	EXG	Y,CC		;1E 2A		ERROR (16 <-> 8)
	EXG	X,PC		;1E 15
	
	INC	nn		;0C
	INC	0,-Y
	INC	mmmm
	INCA
	INCB
	
	JMP	nn		;0E 05
	JMP	[mmmm]		;6E 9F FFEE
	JMP	0,PC		;6E 8D xxxx
	JMP	*		;7E xxxx
	JMP	mmmm		;7E FFEE
	
	JSR	nn		;9D 05
	JSR	0,PC		;AD 8D xxxx
	JSR	,Y+
	JSR	mmmm
	
	LBCC	*		;10 24 FFFC
	LBCS	rel2		;10 25 0000
rel2:	LBEQ	rel2		;10 27 FFFC
	LBGE	rel2		;10 2C xxxx
	LBGT	rel2
	LBHI	rel2
	LBHS	rel2
	LBLE	rel2
	LBLO	rel2
	LBLS	rel2
	LBLT	rel2
	LBMI	rel2
	LBNE	rel2
	LBPL	rel2
	LBRA	rel2
	LBRN	rel2
	LBSR	rel2
	LBVC	rel2
	LBVS	rel2
	
	LDA	#nn		;86
	LDA	nn
	LDA	B,Y
	LDA	mmmm
	
	LDB	#nn		;C6
	LDB	nn
	LDB	B,Y
	LDB	mmmm
	
	LDD	#mmmm		;CC
	LDD	nn
	LDD	[B,Y]
	LDD	mmmm
	
	LDS	#mmmm		;10 CE
	LDS	nn
	LDS	[nn]
	LDS	[A,Y]
	LDS	[B,Y]
	LDS	[D,Y]
	LDS	[0,Y]
	LDS	[0,PC]
	LDS	[0,Y++]
	LDS	[mmmm]
	LDS	mmmm
	
	LDU	#mmmm		;CE FFEE
	LDU	nn
	LDU	D,U
	LDU	mmmm
	
	LDX	#mmmm		;8E
	LDX	nn
	LDX	[D,U]
	LDX	mmmm
	
	LDY	#mmmm		;10 8E
	LDY	nn
	LDY	,--U
	LDY	mmmm
	
	LEAS	,Y+		;32
	LEAS	0,Y++
	LEAS	1,-Y
	LEAS	--Y
	
	LEAU	0,-Y		;33
	LEAU	0,-X
	LEAU	0,-S
	LEAU	0,-U
	
	LEAX	0,PC		;30
	LEAX	[0,PC]
	LEAX	*,PC
	LEAX	[*,PC]

	LEAY	[U+]		;31
	LEAY	[U++]
	LEAY	[-U]
	LEAY	[--U]
	
	LSL	nn		;08
	LSL	0,-Y
	LSL	,Y+
	LSL	0,-X
	LSL	0,X+
	LSL	0,-U
	LSL	0,U++
	LSL	mmmm
	LSLA
	LSLB
	
	LSR	nn		;04
	LSR	,-U
	LSR	mmmm
	LSRA
	LSRB
	
	MUL			;3D
	
	NEG	nn		;00
	NEG	-S
	NEG	mmmm
	NEGA
	NEGB
	
	NOP			;12
	
	ORA	#nn		;8A
	ORA	nn
	ORA	0,-X
	ORA	mmmm
	
	ORB	#nn		;CA
	ORB	nn
	ORB	0,-Y
	ORB	mmmm
	
	ORCC	nn		;1A
	
	PSHS	PC,U,Y,X,DP,B,A,CC
	PSHU	PC,S,Y,X,DP,B,A,CC
	PULS	PC,U,Y,X,DP,B,A,CC
	PULU	PC,S,Y,X,DP,B,A,CC
	
	ROL	nn		;09 05
	ROL	,X+		;69 80
	ROL	mmmm		;79 FFEE
	ROLA			;49
	ROLB			;59
	
	ROR	nn		;06 05
	ROR	,Y+		;66 A0
	ROR	mmmm		;76 FFEE
	RORA			;46
	RORB			;56
	
	RTI			;3B
	RTS			;39
	
	SBCA	#nn		;82 05
	SBCA	nn		;92 05
	SBCA	,S+		;A2 E0
	SBCA	mmmm		;B2 FFEE
	
	SBCB	#nn		;C2 05
	SBCB	nn		;D2 05
	SBCB	,U+		;E2 C0
	SBCB	mmmm		;F2 FFEE
	
	SEX			;1D
	
	STA	nn		;97 05
	STA	[X]		;A7 94
	STA	mmmm		;B7 FFEE
	
	STB	nn		;D7 05
	STB	[X++]		;E7 91
	STB	mmmm		;F7 FFEE
	
	STD	nn		;DD 05
	STD	[--X]		;ED 93
	STD	mmmm		;FD FFEE
	
	STS	nn		;10 DF 05
	STS	[D,X]		;10 EF 9B
	STS	mmmm		;10 FF FFEE
	
	STU	nn		;DF 05
	STU	[mmmm]		;EF 9F FFEE
	STU	mmmm		;FF FFEE
	
	STX	nn		;9F 05
	STX	[nn]		;AF 9F 0005
	STX	mmmm		;BF FFEE
	
	STY	nn		;10 9F 05
	STY	0,-Y		;10 AF A2
	STY	mmmm		;10 BF FFEE
	
	SUBA	#nn		;80
	SUBA	nn
	SUBA	0,-Y
	SUBA	,Y+
	SUBA	0,-X
	SUBA	mmmm
	
	SUBB	#nn		;C0
	SUBB	nn
	SUBB	0,X+
	SUBB	mmmm
	
	SUBD	#mmmm		;83
	SUBD	nn
	SUBD	0,-Y
	SUBD	,Y+
	SUBD	mmmm
	
	SWI			;3F
	SWI2			;10 3F
	SWI3			;11 3F
	
	SYNC			;13
	
	TFR	A,B		;1F 89
	TFR	B,A		;1F 98
	TFR	D,D		;1F 00
	TFR	X,D		;1F 10
	TFR	Y,D		;1F 20
	TFR	U,D		;1F 30
	TFR	S,D		;1F 40
	TFR	PC,D		;1F 50
	TFR	A,D		;1F 80
	TFR	B,D		;1F 90
	TFR	CC,D		;1F A0
	TFR	DP,D		;1F B0
	TFR	U,S		;1F 34
	TFR	CC,DP		;1F AB
	TFR	U,B
	
	TST	nn		;0D
	TST	0,-Y
	TST	mmmm
	TSTA
	TSTB


;	Endx	DocOp69.asm
	