ORG 100H
LXI SP,STACK
BEG LXI D,LBL1
MVI A,84H
OUT 78H;  RESET DATA-IN SIGNAL
CALL PRINT; PRINT TITLE
CALL RDKEY;  READ KEYBOARD
CALL XOUT;  XFER MULTIPLICAND TO 9555
LXI D,LBL2
CALL PRINT
    CALL RDKEY
    CALL XOUT;  XFER MULTIPLIER TO 9555
LXI D,LBL3
CALL PRINT
CALL XIN;  XFER 32 BIT PRODUCT TO CRT
MVI A,81H
OUT 73H
MVI A,30H
OUT 72H;RESET
JMP 0
LBL1 DB 0AH,0DH,'INPUT MULTIPLICAND',0AH,0DH,'$'
LBL2 DB 0AH,0DH,'INPUT MULTIPLIER',0AH,0DH,'$'
LBL3 DB 0AH,0DH,'THE PRODUCT IS',0AH,0DH,'$'

PRINT MVI C, 9H;  ENABLE PRINT BUFFER
      CALL 5H ;PRINT LINE
      RET
XOUT MVI B,2H; LOAD COUNT FOR 4 CHAR
     LXI H,BUF1;  LOAD ADDRESS OF FIRST CHAR
LOOP MOV A,M; LOAD CHAR
     CALL VHEX+1; CONVERT CHAR TO BINARY
     RLC
     RLC
     RLC
     RLC
    MOV C,A
   INX H
     MOV A,M
   CALL VHEX+1
     ORA C ;JOIN 2 CHAR BYTE
     DCR B; DECREMENT CHAR COUNT
     MOV C,A
     MVI A,0
     CMP B
     JZ SBYTE
     MOV A,C     
     OUT 70H; A
     INX H; INCR CHAR ADDRESS
     JMP LOOP
SBYTE    MOV A,C
     OUT 71H; B
    MVI A,85H
    OUT 78H; SET 8080 OBF FLAG
AGAIN  IN 72H
    ANI 01H; CHECK2903 ACK
    JNZ AGAIN 
    MVI A,84H
    OUT 78H; RESET 8080 OBF FLAG
    RET


XIN 	MVI B,2H;LOAD WORD COUNT
LOOK	IN 72H;READ HANDSHAKE
	ANI 02H; MASK 2903 OBF
	JNZ LOOK
	MVI A,93H; MODE 0 INPUT
	OUT 73H; PROGRAM 9555
	MVI	A,80H
	OUT	78H	;ENABLE DATA IN
	IN 70H; READ IN BYTE  PORT A
	CALL ACBTTY

	IN 71H;READ IN BYTE PORT B
	CALL ACBTTY
	MVI A,86H
	OUT 78H;ACK
CK	IN 72H
	ANI 02H;CHECK IF 2903 HAS DROPPED OBF
	JZ CK
	MVI A,84H
	OUT 78H; RESET ACK
     DCR B
     RZ
     JMP LOOK
RDKEY MVI A, 80H

      STA BUF2; SET MAX READ BUFFER TO 128
      LXI D, BUF2; ADDRESS READ BUFFER
      MVI C,0AH ;  ENABLE READ BUFFER
      CALL 5H;  READ CRT
      RET
;
; A STANDARD SET OF USEFULL SUBROUTINES
;
; WRITE A CHARACTER IN E TO THE CONSOLE DEVICE
;
TTYOUT	CALL	SAVE	;SAVE EVERYTHING (CP/M DESTROYS ALL)
	MVI	C,2	;CHARACTER TO CONSOLE FUNCTION CODE
	CALL	5	;PUT OUT CHARACTER IN C
	CALL	UNSAVE	;RESTORE ALL
	RET		;
;
; CARRIAGE RETURN/LINE FEED ON THE CONSOLE DEVICE
;
DOCRLF	PUSH	D	;SAVE D&E
	MVI	E,0DH	;CARRIAGE RETURN
	CALL	TTYOUT	;PUT IT OUT
	MVI	E,0AH	;LINE FEED
	CALL	TTYOUT	;PUT IT OUT
	POP	D	;RESTORE D&E
	RET		;
;
; OUTPUT A CARRIAGE SPACE TO THE CONSOLE DEVICE
;
SPTTY	PUSH	D	;SAVE D&E
	MVI	E,' '	;'SPACE' INTO E
CONOUT	CALL	TTYOUT	;OUTPUT TO CONSOLE
	POP	D	;RESTORE D&E
	RET		;
;
; OUTPUT CHARACTER IN ACCUMULATOR TO CONSOLE DEVICE
;
ACCTTY	PUSH	D	;SAVE D&E
	MOV	E,A	;CHARACTER FROM A TO E
	JMP CONOUT	;PUT IT OUT
;
; OUTPUT THE CHARACTER PAIR IN H&L TO CONSOLE DEVICE
;
HLCTTY	PUSH	D	;SAVE D&E
	MOV	E,H	;CHARACTER FROM H INTO E
	CALL	TTYOUT	;OUTPUT H
	MOV	E,L	;CHARACTER FROM L TO E
	JMP	CONOUT	;OUTPUT L
;
; OUTPUT THE BINARY VALUE IN A AS TWO ASCII CHARACTERS
;
ACBTTY	PUSH	PSW	;SAVE A
	RRC ! RRC ! RRC ! RRC ;HI NIBBLE TO LOW NIBBLE
	ANI	0FH	;KEEP ONLY LOW NIBBLE
	CALL	HEXEX	;CONVERT BINARY TO ASCII & O/P
	POP	PSW	;GET A AGAIN
	ANI	0FH	;GET NIBBLE
	CALL	HEXEX	;CONVERT TO ASCII & O/P
	RET		;
HEXEX	CPI	10	;LESS THAN 10?
	JM	CON	;JUMP IF YES
	ADI	07	;ADD BIAS
CON	ADI	30H	;CONVERT TO ASCII
	JMP	ACCTTY	;OUT TO TTY
;
; BINARY VALUE IN H&L TO TTY AS FOUR ASCII CHARACTERS
;
HLBTTY	PUSH	PSW	;SAVE A
	MOV	A,H	;H TO A
	CALL	ACBTTY	;H TO TTY AS 2 ASCII CHARACTERS
	MOV	A,L	;L TO A
	CALL	ACBTTY	;L TO TTY AS 2 ASCII CHARACTERS
	POP	PSW	;RESTORE A
	RET		;
;
; OUTPUT A STRING TO CURRENT CONSOLE DEVICE. THE
; FIRST BYTE OF THE STRING MUST BE THE O/P DATA LENGTH
;
STCTTY	CALL	SAVE	;SAVE EVERYTHING
	MOV	B,M	;GET COUNT
STCLOOP	INX	H	;BUMP MEM PTR TO NXT CHR
	MOV	E,M	;GET NEXT CHARACTER
	CALL	TTYOUT	;PUT IT OUT
	DCR	B	;COUNT -1
	JNZ	STCLOOP ;LOOP UNTIL COUNT GOES TO ZERO
	CALL	UNSAVE	;RESTORE ALL
	RET		;
;
; SAVE THE WHOLE MACHINE
;
SAVE	SHLD	TEMPHL	;SAVE H&L
	XTHL		;GET RETURN, PUSH H&L
	PUSH	PSW	;SAVE PSW
	PUSH	B	;SAVE B&C
	PUSH	D	;SAVE D&E
	PUSH	H	;PUT RETURN ONTO STACK
	LHLD	TEMPHL	;RESTORE INCOMING H&L
	RET		;
TEMPHL	DS	2	;TEMP SAVE OF H&L
;
; UNSAVE THE WHOLE MACHINE
;
UNSAVE	POP	H	;GET RETURN
	POP	D	;RESTORE D&E
	POP	B	;RESTORE B&C
	POP	PSW	;RESTORE AC & FLAGS
	XTHL		;POP H&L, RETURN ONTO STACK
	RET		;
;

; SAVE THE STACK POINTER IN 'SAVESP'
;
SAVSP	SHLD	TEMPHL	;SAVE H&L
	POP	H	;GET RETURN FROM STACK
	SHLD	SAVRET	;SAVE RETURN
	LXI	H,0000	;ZERO H&L
	DAD	SP	;CAPTURE SP
	SHLD	SAVESP	;SAVE IT
	LXI	SP,SAVRET ;POINT TO RETURN
	LHLD	TEMPHL	;RESTORE H&L
	RET		;
SAVESP	DS	2	;
SAVRET	DS	2	;
;
; UNSAVE PREVIOUSLY SAVED SP FROM 'SAVESP'
;
UNSAVSP	SHLD	TEMPHL	;SAVE H&L
	POP	H	;GET RETURN
	SHLD	SAVRET	;SAVE RETURN
	LHLD	SAVESP	;GET OLD SP
	SPHL		;..INTO SP
	LHLD	SAVRET	;GET RETURN
	PUSH	H	;RETURN ONTO STACK
	LHLD	TEMPHL	;RESTORE H&L
	RET		;
;
; H&L POINTS TO STARTING LOCATION WITHIN BUFFER.
; BUFFER MUST BE TERMINATED WITH A CR (HEX 0D)
;	FINDC - FIND NEXT ALPHANUMERIC CHARACTER
;	FINDD - FIND NEXT DELIMITER
;	CHKDEL - CHECK CHARACTER IN A FOR A DELIMITER
;
FINDC	CALL	CKDEL	;CHECK FOR DELIMITER
	JZ	FC1	;JUMP IF DELIMITER
	SHLD	NCP	;SAVE CURRENT BUFFER POINTER
	RET		;
FC1	CPI	0DH	;CR?
	RZ		;RETURN IF YES
	INX	H	;TO NEXT LOCATION
	JMP	FINDC	;CONTINUE
FINDD	INX	H	;TO NEXT LOCATION
	CALL	CKDEL	;CHECK FOR DELIMITER
	JNZ	FINDD	;CONTINUE LOOKING IF NO
	RET		;
CKDEL	MOV	A,M	;GET CHARACTER IN A
CHKDEL	CPI	' '	;SPACE?
	RZ		;RETURN IF YES
	CPI	','	;COMMA?
	RZ		;RETURN IF YES
	CPI	'.'	;DOT?
	RZ		;RETURN IF YES
	CPI	'='	;EQUAL SIGN?
	RZ		;RETURN IF YES
	CPI	'('	;LEFT PAREN?
	RZ		;RETURN IF YES
	CPI	')'	;RIGHT PAREN?
	RZ		;RETURN IF YES
	CPI	0DH	;CARRIAGE RETURN?
	RET		;RETURN 
;
NCP:	DW	0000	;NEXT BUFFER POINTER SAVE LOCATION
ONCP:	DW	0000	;PREVIOUS BUFFER POINTER SAVE LOCATION
;
; VHEX VALIDATES A HEX DIGIT & PUTS IT IN A
;
VHEX	LDAX	D	;GET DIGIT IN A
	CPI	30H	;VALID?
	RC		;RETURN IF NO
	CPI	3AH	;NUMERIC?
	JC	VNUM	;JUMP IF YES
	CPI	41H	;ALPHA?
	RC		;RETURN IF NO
	CPI	47H	;VALID?
	JC	VALPHA	;JUMP IF YES
	ORA	A	;SET CC IF NO
	RET		;RETURN
VALPHA	SUI	7	;ADJUST ALPHA
VNUM	ANI	0FH	;STRIP HI NIBBLE
	CMP	A	;SET ZERO CONDITION CODE
	RET		;RETURN
;
; CVHL CONVERTS UP TO TWO BYTES OF ASCII-HEX TO BINARY IN H&L
;
CVHL	LXI	H,0000	;INIT ACCUMULATOR
CVHL1	CALL	VHEX	;GET HEX DIGIT
	RNZ		;RETURN IF NOT VALID HEX
	DAD	H	;SHIFT H&L OVER FOUR BITS
	DAD	H	; *
	DAD	H	; *
	DAD	H	; *
	ORA	L	;ADD NEW DIGIT TO H&L
	MOV	L,A	; *
	INX	D	;BUMP TO NEXT DIGIT
	JMP	CVHL1	;CONTINUE
;
;
GTPARM:	LHLD	NCP	;GET CURRENT BUFF POINTER
	SHLD	ONCP	;SAVE OLD POINTER
	CALL	FINDD	;FIND NEXT DELIMITER
GTPRM1:	CALL	FINDC	;FIND NEXT CHARACTER
	RET		;
;
;
; SUBTRACT D&E FROM H&L, RESULT IN H&L
;
HLMDE	PUSH	PSW	;SAVE AC
	MOV	A,L	;L TO A
	SUB	E	;MINUS E
	MOV	L,A	;RESTORE NEW L
	MOV	A,H	;GET H IN A
	SBB	D	;MINUS D
	MOV	H,A	;RESTORE NEW H
	POP	PSW	;RESTORE AC
	RET		;
;
STACK	EQU 5000H
BUF1	EQU 4800H
BUF2	EQU BUF1-2
    END

