	title	'FOXYCALC message file'
;
	page	58
;
;
index	MACRO	label
	db	((label - 100h) / 128) and 00ffh
	db	((label - 100h) mod 128) and 00ffh
	ENDM
;
tbl$secs	equ	8		;number of table sectors
;
entries		equ	tbl$secs*128/2	;number of table entries
;
cr		equ	0dh		;eol flag
;
	org	100h		;makes for easy loading
;
;
;**************************************************************
;
;two byte index entry structure:
;
;		first byte:	absolute sector number
;				of start of message.
;		second byte:	offset from start of sector
;				to start of message.
;
;	     INSERT INDEX MACROS AFTER THIS POINT
;**************************************************************
;
	index	<msg0>
	index	<msg1>
	index	<msg2>
	index	<msg3>
	index	<msg4>
	index	<msg5>
	index	<msg6>
	index	<msg7>
	index	<msg8>
	index	<msg9>
	index	<msg10>
	index	<msg11>
	index	<msg12>
	index	<msg13>
	index	<msg14>
	index	<msg15>
	index	<msg16>
	index	<msg17>
	index	<msg18>
	index	<msg19>
;
;**************************************************************
;	     INSERT INDEX MACROS BEFORE THIS POINT
;**************************************************************
;
;	filler macro, fills the end of the index table with zeros
$-Print
;
	rept	(((tbl$secs * 128) - ($ - 100h))) / 2
	dw	0000h
	endm
;
;
$+Print
Page
;*************************************************************
;
;message structure:
;		first byte:   row address byte
;		second byte:  column address byte
;		bytes 2...N:  ascii message
;		byte N+1:     00h terminator
;
;		INSERT MESSAGES AFTER THIS POINT
;*************************************************************
;
msg0	db	0,0,0		;clears the screen message
;
msg1	db	22,00,'1-  CMD  |2-DTA IN |3- CALC  |4- EXIT  |'
	db	'5-MV CUR |6-RECALL |7- HELP1 |8-REPEAT |',0
;
msg2	db	22,00,'1- OTHER |2-SC FMT |3- FILES |4-DA FMT |'
	db	'5-OUTPUT |6-GL FMT |7- HELP2 |8-CANCEL |',0
;
msg3	db	22,00,'1-TXT IN |2-FRM IN |3-DELETE |4-INSERT |'
	db	'5- MOVE  |6- COPY  |7- HELP3 |8-CANCEL |',0
;
msg4	db	22,00,'1- TITLE LOCK |2- WINDOW |',0
;
msg5	db	22,00,'1-  HOR  |2- VERT  |3- BOTH  |4-  CLR  |',0
;
msg6	db	22,00,'1-  HOR  |2- VERT  |3-  CLR  |4- SYNC  |5-UNSYNC |',0
;
msg7	db	22,00,'1-  FMT  |2- A ADV |3-BORDER |4-  TAB  |5-RECALL |',0
;
msg8	db	22,00,'1-  ROW  |2-  COL  |3- AUTO  |4-  MAN  |',0
;
msg9	db	22,00,'1- SAVE  |2- LOAD  |3-  DIR  |4-DELETE |',0
;
msg10	db	22,00,'1- DATA  |2- EXPR  |',0
;
msg11	db	22,00
	db	'1-GLOBAL |2-  C/R  |3-   $   |4-PROTEC |5- BLANK |6-  ZAP  |'
	db	0
;
msg12	db	22,00,'1-DISPLAY SCREEN |2-LIST EXP FILE |',0
;
msg13	db	22,00,'1- PRINT |2- SETUP |3- CONSOLE |',0
;
msg14	db	22,00
	db	'1-CANCEL |2- P WID |3- P LEN |4-  MC   |5- PRINT |6- EXIT  |'
	db	0
;
msg15	db	22,00,'FROM RANGE',0
;
msg16	db	22,00,'TO RANGE',0
;
msg17	db	22,00,'1-  ADJ  |2-NO ADJ |3- VALUE |',0
;
msg18	db	22,00,'1-  ROW  |2-  COL  |',0
;
msg19	db	0,0,cr
	db	7,7,'    FOXYCALC version x.x',cr
	db	9,7,'       COPYRIGHT 1982',cr
	db	11,7,'DIGITAL MICROSYSTEMS, INC.',cr
	db	13,7,'       OAKLAND, CA.',cr
	db	22,3,'Type any key to continue',0
;
