	TITLE	'FOX DISPLAY MODULE VERSION 0.0'
*****************************************************************
*								*
*		FOXICALC DISPLAY MODULE				*
*								*
*		By Bruce Sherry					*
*		Created:	JULY 28, 1982			*
*		Version	0.0					*
*		Last update:	AUGUST 13, 1982			*
*		By Bruce Sherry					*
*								*
*****************************************************************

*****************************************************************
*								*
*	This module contains the following Public routines:	*
*								*
*	DISP$SCN	Displays the whole screen.  Used	*
*			to initially set up the scree for	*
*			FOXICALC.				*
*								*
*	MOVE$ACP	Moves the Active Cell Pointer to a	*
*			new location.				*
*								*
*	TITL$LCK	Locks the titles on the screen.		*
*								*
*	UPD$CELL	Called by calculation routine to	*
*			update a cell if it is on the screen.	*
*								*
*	PRNT$SCN	Prints the spread sheet and expres-	*
*			sion tables.				*
*								*
*****************************************************************
	PAGE
*****************************************************************
*								*
*	EXTERNAL ROUTINES AND VARIABLES				*
*								*
*****************************************************************

	EXTRN	GOTO$XY		;Move CRT cursor
	EXTRN	CLR$SCN		;Clear CRT screen
	EXTRN	CLR$LIN		;Clear CRT line
	EXTRN	CLR$EOL		;Clear to end of CRT line

	EXTRN	INV$ON		;Turns on inverse video
	EXTRN	INV$OFF		;Turns off inverse video
	EXTRN	INV$SPC		;Zero if turning on or off in-
				;verse video does not take space.
	EXTRN	READ$LN		;Input a command line.
	EXTRN	CHAR$ST		;Test keyboard status.
	EXTRN	CHAR$IN		;Input character from keyboard.
	EXTRN	CHR$OUT		;Send a character to CRT.

	EXTRN	GET$VAL		;Get value cell.
	EXTRN	VAL$COL		;Value cell column.
	EXTRN	VAL$ROW		;Value cell row.
	EXTRN	VAL$ADR		;Value cell addressl
	EXTRN	FST$EXP		;Get first expression cell.
	EXTRN	EXP$COL		;Expression cell column.
	EXTRN	EXP$ROW		;Expression cell column.
	EXTRN	NXT$EXP		;Get next expression cell.
;	EXTRN	CWT		;Collumn width table.

*****************************************************************
*								*
*	LOCAL VARIABLES						*
*								*
*****************************************************************

	DSEG

	PUBLIC	ACP$COL, ACP$ROW, TLK$COL, TLK$ROW
	PUBLIC	TSC$COL, TSC$ROW, SCR$COL, SCR$ROW
ACP$COL	DB	1		;Active cell pointer.
ACP$ROW	DB	1

TLK$COL	DB	4		;Title locked cell pointer.
TLK$ROW	DB	0
TSC$COL	DB	1		;Locked cell screen position.
TSC$ROW	DB	0
SCR$COL	DB	8		;Upper left cell contents.
SCR$ROW	DB	1
COUNT	DB	0		;Collumn count.
ROWCNT	DB	0		;Row counter.
SCREENC	DB	0		;Collumn being displayed now.
SCREENR	DB	0		;Row being displayed now.
NUMDAT	DB	0		;Numbers or values for DISPROW
ICNT	DB	0
JCNT	DB	0
CNVSPC	DS	10		;Space for converting numbers
ASCSPC	DS	15
;^^^^
;
; TEMPORARY DATA FOR TESTING
;
;
CWT	DB	8
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
	DB	8
	DB	16
	DB	5
	DB	10
	DB	24
;^^^^^
SCN$DAT	DS	1600		;20 lines of screen contents
SCN$END	EQU	$		;End of screen
	CSEG
	PAGE
*****************************************************************
*								*
*	DISP$SCN	Display Screen				*
*								*
*	INPUTS:		none					*
*	OUTPUTS:	Clears the CRT screen then displays	*
*			initial screen.				*
*	RETURNS:	Nothing.				*
*								*
*****************************************************************

	PUBLIC	DISP$SCN
DISP$SCN:
;	CALL	CLR$SCN
	LXI	H,SCN$DAT
	MVI	A,0		;Display top row
	CALL	DISPROW
;
	MVI	A,0
	STA	ROWCNT
;
	LDA	TLK$ROW
	ORA	A
	JZ	NOROWLK		;if tlk$row <> 0 then
;
	MOV	B,A		;Save the locked row number
	LDA	TSC$ROW
	STA	ICNT
	CMA
	INR	A		;Form 2's complement
	ADD	B		;Subtract tsc$row from tlk$row
	STA	SCREENR
;
RLKLOOP:			;for i := 0 to tsc$row
	MVI	A,1		;1 for values
	CALL	DISPROW
	LDA	ICNT
	SUI	1
	STA	ICNT
	JNC	RLKLOOP
;
NOROWLK:
	LDA	SCR$ROW
	STA	SCREENR		;screenrow := scr$row
	LDA	ROWCNT		;while rowcount < 19 do
	CPI	19
;
ROWLOOP:
	RZ			;return from DISP$SCN
;
	MVI	A,1		;1 for values
	CALL	DISPROW
	LDA	ROWCNT
	INR	A
	STA	ROWCNT
	JMP	RLKLOOP
;
*****************************************************************
*								*
*  DISPlay ROW		Displays row of data or column numbers	*
*								*
*  INPUTS:		A = 0 for column numbers,		*
*			A = nonzero for data.			*
*			HL = Address in scn$dat for data	*
*  RETURNS:		HL = Next row.				*
*								*
*****************************************************************
;
DISPROW:
	STA	NUMDAT
	ORA	A
	JZ	BLNKLBL		;No label on top row
	LDA	SCREENR
	MOV	B,A
	CALL	CNV8		;Display row number
	CALL	SCNSPACE
	JMP	COLUMNS
BLNKLBL:
	LXI	B,2004H		;B gets 20h C gets 4
SPCLOP:
	MOV	M,B		;Clear first 4 locations
	INX	H
	DCR	C
	JNZ	SPCLOP
;
COLUMNS:
	MVI	A,76		;Get remaining screen width
	STA	COUNT
	LDA	TLK$COL
	ORA	A
	JZ	NOCOLLK
;
	MOV	B,A		;Save the locked column number
	LDA	TSC$COL
	STA	ICNT
	CMA
	INR	A		;Form 2's complement
	ADD	B		;Subtract tsc$col from tlk$col
	STA	SCREENC
CLKLOOP:			;Collumn locked loop
	LDA	NUMDAT
	ORA	A		;Is this a label or value row
	JZ	CLKLOOP1
	CALL	DISPVAL		;Value row
	JMP	$+3
	CALL	DISPNUM
CLKLOOP1:
	LDA	ICNT
	SUI	1
	STA	ICNT
	JNC	CLKLOOP
;
NOCOLLK:
	LDA	SCR$COL
	STA	SCREENC
COLMNLOP:
	CALL	GETWIDTH
	INR	B
	LDA	COUNT
	SUB	B		;COUNT - (CWT[SCREENCOL] + 1)
	JC	NOMOCOL
;
	LDA	NUMDAT
	ORA	A		;Is this a label or value row
	JZ	COLMNLOP1
	CALL	DISPVAL		;Value row
	JMP	COLMNLOP
COLMNLOP1:
	CALL	DISPNUM		;Label row
	JMP	COLMNLOP	;Check for more columns
;
NOMOCOL:
	LDA	COUNT
	MVI	B,' '
NOMOCOL1:
	MOV	M,B
	INX	H
	DCR	A
	JNZ	NOMOCOL1
	CALL	SENDLINE	;Display all them numbers
	RET
;
*****************************************************************
*								*
*  DISPlay NUMber						*
*								*
*  INPUTS:		HL = Left edge of column		*
*  OUTPUTS:		Column number with vertical bars	*
*			at both edges of column.		*
*  RETURNS:		HL = Left edge of next column		*
*								*
*****************************************************************
;
DISPNUM:
	LDA	SCREENC
	CALL	GETWIDTH	;jcnt := cwt[screencol]
	MOV	A,B
	STA	JCNT
	CALL	VBAR
	LDA	JCNT		;for B := 1 to (cwt[screenc] / 2 - 2)
	INR	A
	RAR	
	SUI	2
	MOV	B,A
	JZ	NOLSPC
LSPCLOP:
	CALL	SCNSPACE
	LDA	JCNT
	DCR	A
	STA	JCNT
	DCR	B
	JNZ	LSPCLOP
;
NOLSPC:
	LDA	SCREENC
	MOV	B,A
	CALL	CNV8
	LDA	COUNT
	SUI	3
	STA	COUNT
	LDA	JCNT
	SBI	4		;Extra for last vbar
	MOV	B,A
RSPCLOP:
	JZ	RHTBAR		;while temp > 1
	CALL	SCNSPACE
	DCR	B
	JMP	RSPCLOP
;
RHTBAR:
	CALL	VBAR
	LDA	SCREENC
	INR	A
	STA	SCREENC
	LDA	INV$SPC
	ORA	A
	CZ	SCNSPACE	;Print space if required
	RET
;
SCNSPACE:
	MVI	M,' '		;scn$dat[location] := ' '
	INX	H
	LDA	COUNT		;count := count - 1
	DCR	A
	STA	COUNT
	RET
;
VBAR:
	MVI	M,'|'
	LDA	JCNT
	DCR	A
	STA	JCNT
	JMP	SCNSPACE + 2
;
BLANKCELL:
	CALL	GETWIDTH
	MOV	B,A
BLANKCELL1:
	CALL	SCNSPACE	;for i := cwt[screenc] downto 1
	DCR	B
	JNZ	BLANKCELL1
	RET
;
GETWIDTH:
	PUSH	H
	PUSH	D
	LXI	H,CWT
	MVI	D,0
	LDA	SCREENC
	MOV	E,A
	DAD	D
	MOV	B,M		;Get column width
	POP	D
	POP	H
	RET
;
*****************************************************************
*								*
*	DISPlay VALue	Display value cell.			*
*								*
*	INPUTS:		HL = Left edge of column		*
*	OUTPUTS:	Value cell if it fits in the column.	*
*	RETURNS:	HL = Left edge of next column		*
*								*
*****************************************************************
;
DISPVAL:
	PUSH	H
	LHLD	SCREENC
	SHLD	VAL$COL
	CALL	GET$VAL		;Try and get the value
	LHLD	VAL$ADR
	MOV	A,H
	ORA	L
	JNZ	NOTBLANK
	POP	H
	CALL	BLANKCELL	;No cell for this location
	RET
;
NOTBLANK:
	INX	H
	INX	H		;pointer := pointer + 2
	MOV	A,M
	INX	H
	ANI	78H
	CPI	20H		;Is it right justified string?
	JZ	RHTSTRING
	CPI	60H		;Is it left justified string?
	JZ	LFTSTRING
	CPI	28H		;Right justified number?
	JZ	RHTNUM
	CPI	68H		;Left justified number?
	JZ	LFTNUM
	CPI	30H		;Right justified dollars?
	JZ	RHTDOLLAR
	CPI	70H		;Left justified dollars?
	JZ	LFTDOLLAR
	CALL	BLANKCELL	;BLANK IF UNKNOWN
	RET
;
RHTSTRING:
	CALL	GETWIDTH
	SUB	M		;Length
	JNC	RHTLESS
	CALL	GETWIDTH	;Length >= Width
	LDA	COUNT
	SUB	C
	STA	COUNT
	MOV	C,A
	MVI	B,0
	XCHG
	POP	H
	JMP	MOVEDN		;Move them and return
;	
RHTLESS:
	MOV	B,A
	MOV	C,M		;Save string length in C
	INX	H
	XCHG			;Save string location in DE
	POP	H
RHTLESS1:
	CALL	SCNSPACE
	DCR	B
	JNZ	RHTLESS1
	LDA	COUNT
	SUB	C
	STA	COUNT
	JMP	MOVEDN		;And return
;
LFTSTRING:
	CALL	GETWIDTH
	SUB	M		;Length
	JNC	LFTLESS
	CALL	GETWIDTH	;Length >= Width
	LDA	COUNT
	SUB	C
	STA	COUNT
	MOV	C,A
	MVI	B,0
	XCHG
	POP	H
	JMP	MOVEDN		;Move them and return
;	
LFTLESS:
	PUSH	PSW
	MOV	C,M		;Length to BC
	MVI	B,0
	INX	H
	XCHG			;Source to DE
	POP	H		;Destination to HL
	PUSH	PSW
	LDA	COUNT
	SUB	C
	STA	COUNT
	CALL	MOVEDN		;Move them
	POP	PSW
	MOV	B,A
LFTLESS1:
	CALL	SCNSPACE
	DCR	B
	JNZ	LFTLESS1
	RET
;
RHTNUM:
	CALL	STRETCH
	MVI	A,19
	CALL	FLOAT
	

STRETCH:
	LXI	D,CNVSPC
	MVI	B,8
	MOV	C,B
STRETCH1:
	INX	H
	MOV	A,M
	STAX	D
	INX	D
	DCR	B
	DCR	C
	JNZ	STRETCH1
	XCHG
STRETCH2:
	MVI	M,0
	INX	H
	DCR	B
	JNZ	STRETCH2
	LXI	D,CNVSPC
	LXI	H,ASCSPC
	CALL	GETWIDTH
	MOV	C,B
	RET
;
SENDLINE:

*****************************************************************
*								*
*	MOVE$ACP	Move active cell pointer		*
*								*
*	INPUTS:		New acprow in H, new acpcol in L.	*
*	OUTPUTS:	Unhilights old ACP, Highlilghts new	*
*			ACP.					*
*	RETURNS:	Nothing.				*
*								*
*****************************************************************

	PUBLIC	MOVE$ACP
MOVE$ACP:

*****************************************************************
*								*
*	TITL$LCK	Lock Titles				*
*								*
*	INPUTS:		None.					*
*	OUTPUTS:	None.					*
*	RETURNS:	Zero if OK, Nonzero if titles were	*
*			already locked.				*
*								*
*****************************************************************

	PUBLIC	TITL$LCK
TITL$LCK:

*****************************************************************
*								*
*	UPD$CELL	Update value cell on screen		*
*								*
*	INPUTS:		Address of a value cell in memory	*
*	OUTPUTS:	The updated cell onto the screen if	*
*			on the screen, nothing otherwise.	*
*	RETURNS:	Nothing.				*
*								*
*****************************************************************

	PUBLIC	UPD$CELL
UPD$CELL:

*****************************************************************
*								*
*	PRNT$SCN	Print spread sheet.			*
*								*
*****************************************************************

	PUBLIC	PRNT$SCN
PRNT$SCN:


	PAGE
*****************************************************************
*								*
*  CNV8								*
*								*
*  Convert an unsigned 8-bit number to ASCII			*
*								*
*  Input:	Number in B					*
*		Address of 3-byte field in HL			*
*  Uses:	A, C, D, E, HL					*
*  Changes:	HL to point to last character			*
*								*
*****************************************************************

CNV8:
	MVI	E, '0'		;Set space flag to space
	MVI	C,100		;First digit is 100's
	CALL	SUBL
	INX	H
	MVI	C,10		;Next 10's digit
	CALL	SUBL
	INX	H		;Point to next character
	MVI	A,'0'
	ADD	B		;Ones digit
	MOV	M,A
	INX	H
	RET			;All done.

SUBL:
	MVI	D, '0'-1	;Set up for pre-increment
	MOV	A,B
SUBL1:
	INR	D		;Increment count
	SUB	C
	JNC	SUBL1		;Continue if not negative
	ADD	C		;Fix remaninder
	MOV	B,A
	MOV	M,D		;Save it if not zero
	MVI	A, '0'
	CMP	D		;Was it zero?
	JNZ	SUBL2
	CMP	E
	RNZ
	MVI	M, ' '		;Previous was zero
SUBL2:
	MOV	E,D
	RET

*****************************************************************
*								*
*	DISPADD		Find the address in the SCN$DAT array	*
*			for a screen location.			*
*								*
*	INPUTS:		Screen row in H, screen column in L.	*
*	USES:		D, E.					*
*	RETURNS:	Location in SCN$DAT in HL.		*
*								*
*****************************************************************

DISPADD:
	PUSH	H		;Save L
	MOV	E,H
	MVI	D,0
	LXI	H,0
	DAD	D		;1
	DAD	H		;2
	DAD	H		;4
	DAD	D		;5
	DAD	H		;10
	DAD	H		;20
	DAD	H		;40
	DAD	H		;80
	POP	D
	MVI	D,0
	DAD	D
	LXI	D,SCN$DAT
	DAD	D
	RET

*****************************************************************
*								*
*	MOVEDN		Moves charaters from higher locations	*
*			to lower locations			*
*								*
*	INPUTS:		DE = source address, HL = destination	*
*			address, BC = number of bytes to move.	*
*	RETURNS:	Nothing.				*
*								*
*****************************************************************

MOVEDN:
	LDAX	D
	MOV	M,A
	INX	H
	INX	D
	DCX	B
	MOV	A,C
	ORA	B
	JNZ	MOVEDN
	RET

*****************************************************************
*								*
*	MOVEUP		Moves charaters from lower locations	*
*			to higher locations			*
*								*
*	INPUTS:		BC = source address, DE = destination	*
*			address, HL = number of bytes to move.	*
*	RETURNS:	Nothing.				*
*								*
*****************************************************************

MOVEUP:
	PUSH	H		;Correct for going down
	DAD	D
	XCHG
	POP	H
	PUSH	H
	DAD	B
	PUSH	H
	POP	B
	POP	H
MOVEUP1:
	LDAX	B		;Now move them
	STAX	D
	DCX	B
	DCX	D
	DCX	H
	MOV	A,L
	ORA	H
	JNZ	MOVEUP1
	RET
