/*
	Header for RED buffer routines -- AZTEC CII version

 	Source:  red10.h
	Version: April 24, 1983

	Copyright (C) 1983 by

		Edward K. Ream
		1850 Summit Ave.
		Madison, WI 53705
		(608) 231 - 2952

*/


/*
	You may tune these constants for better disk performance.
	These constants are defined on file red.h

	DATA_SIZE:  The size of struct BLOCK.
		    Make sure that DATA_SIZE is a multiple
		    of the size of your disk sectors.
		    (for CP/M, a multiple of 128)

	DATA_RES:   The number of BLOCKS resident in memory.
		    The code assumes this number is AT LEAST 3.
*/


/*
	The name of the work file. Note the double quotes.
	Pick a name you never use.
*/

#define DATA_FILE  "@@data@@.tmp"


/*
	The current disk error recovery point is defined in red2.az
*/

extern
char DISK_ERR [6];


/*
	All following extern variables are defined in redbuf.az
*/

extern
BOOL	b_fatal;	/* clear buffer on error	*/
extern
BOOL	b_cflag;	/* buffer changed flag		*/

extern
int	b_line;		/* current line number		*/
extern
int	b_max_line;	/* highest line number		*/
extern
char *	b_linep;	/* pointer to line (local var)	*/

extern
int	b_slot;		/* current block's slot number	*/
extern
struct BLOCK * b_bp;	/* mem pointer to current block	*/
extern
int	b_start;	/* first line of current block	*/

extern
int	b_head;		/* first block's disk pointer	*/
extern
int	b_tail;		/* last block's disk pointer	*/
extern
int	b_max_diskp;	/* last sector allocated	*/

extern
int	b_data_fd;	/* file descriptor of data file	*/
extern
int	b_user_fd;	/* file descriptor of user file	*/
extern
int	b_free;		/* head of list of free blocks	*/

extern
char	b_buff [DATA_SIZE];	/* temporary buffer. 	*/



/*
	Partially define the format of a block.  The data
	field is organized as a singly linked list of lines;
	that is, each line is preceded by a two-byte length
	field.

	The d_back and d_next fields in the header are used
	to doubly-link the disk blocks so that stepping
	through the blocks either forward or backwards is
	efficient.  -1 denotes the end of each list.

	When blocks become totally empty they are entered
	on a list of free blocks.  The links of this list
	are kept in the blocks themselves in the d_next field.
	The b_free variable is the head of this list.

	Also define the in-core block table.  This table
	contains the blocks that have been swapped into
	memory.  Each entry in this table is called a slot.
*/

#define HEADER_SIZE	8	/* size of first 4 fields */
#define BUFF_SIZE (DATA_SIZE - HEADER_SIZE)

extern
struct BLOCK {
	int	d_back;		/* # of previous block	*/
	int	d_next;		/* # of next block	*/
	int	d_avail;	/* # of data bytes free	*/
	int	d_lines;	/* # of lines on block	*/
	char	d_data [BUFF_SIZE];	/* data		*/
}d_blocks [DATA_RES];


/*
	Define the resident status table.
	There is one entry for each slot.
*/

#define FREE	1	/* status:  block is available	*/
#define FULL	2	/* status:  block is allocated	*/
#define DIRTY	3	/* status:  must swap out	*/

extern
struct STATUS {
	int	d_lru;		/* lru count		*/
	FLAG	d_status;	/* FULL, FREE or DIRTY	*/
	int	d_diskp;	/* disk pointer		*/
} d_stat_tab [DATA_RES];
ru;		/* lru count		*/
	FLAG	d_status;	/* FULL, FREE or DIRTY	*/
	i