                             ; CP/M FILE LISTING FACILITY, INCUDING
                             ; AUTOMATIC PRINTING OF TIME AND DATE
                             ; USING COMPU/TIME T-102 CLOCK BOARD
                             ;
                             ; ver. 1.1.A  12/02/79 - HARRY KAEMMERER
                             ; TEL. NY TIME 201-221-2297
                             ;
                             ; BASED ON VER. 1.1 4/17/79 BY DENNIS THOVSON
                             ;
                             ; Based on ver. 2.0 of IMSAI's IMDOS 
                             ; File List Facility
                             ;
                             ; FCB FOR FILE MUST BE SET UP BEFORE ENTRY
                             ; i.e. "TLIST FILENAME.TYP" Command
                             ; DO NOT ENTER AMBIGUOUS (? or *) FILENAME
                             ; OR TYPE
                             ;
                             ; Default Title is FILENAME.TYP +
                             ; any additional information (up to 48
                             ; characters) appended to the entry command.
                             ;
                             ; Optional Title and Subtitle may be
                             ; entered after Entry Command is executed.
                             ;
PGSIZ	EQU   65             ;NO. OF LINES PER PAGE
PPPAGE	EQU   60             ;NO. OF LINES TO PRINT PER PAGE
PNOCOL	EQU   64             ;COLUMN "PAGE" AND NUMBER
RESET	EQU   0CH            ;FF CLEARS SCREEN ON MY CONSOLE
                             ;SYSTEM CALL FUNCTION NUMBERS
CLK     EQU   0C0H           ;MY CLOCK BOARD ADDRESS PORT
CONIN	EQU   1              ;CONSOLE INPUT CHAR
CONOUT	EQU   2              ;CONSOLE OUTPUT CHAR (E)
CONRDY	EQU   11             ;CONSOLE CHARACTER READY TEST
BUFFRD	EQU   10             ;BUFFERED READ COMMAND
PRINT	EQU   9              ;PRINT STRING (DE) TO $
LIST	EQU   5              ;OUT CHAR (E) TO LST: DEVICE
OPEN	EQU   15             ;OPEN FILE CONTROL BLOCK
READ	EQU   20             ;READ NEXT SEQUENTIAL RECORD
BDOS	EQU   05H            ;SYSTEM CALL ENTRY POINT
FCB	EQU   5CH            ;DEFAULT FILE CONTROL BLOCK
NR	EQU   FCB+32         ;NEXT RECORD TO READ
TBUFF	EQU   80H            ;WHERE CCP PUTS COMMAND LINE
DEFBUF	EQU   80H            ;WHERE SECTORS ARE READ
TBASE	EQU   100H           ;TRANSIENT PROGRAM BASE
                             ;EQUATES FOR ASCII CONTROL CHARACTERS
TAB	EQU   9              ;CONTROL I (HT) TAB.
LF	EQU   0AH            ;LINE FEED
FF	EQU   0CH            ;FORM FEED
ALTFF	EQU   0BH            ;CONTROL K (VT) ALSO CAUSES FF
CR	EQU   0DH            ;CARRIAGE RETURN
CTRLZ	EQU   1AH            ;CONTROL Z. EOF.
                             ;
                             ;
	ORG   TBASE          ;ENTRY POINT 
                             ;
TLIST:	JMP   LISTGO         ;NORMAL ENTRY
	LXI   SP,DSTACK      ;DDT DEBUGGING ENTRY
	CALL  LISTGO         ;USE "I" COM'D TO SET FILE NAME
	RST   7              ;RETURN TO DDT
                             ;
                             ;MAIN PROGRAM BEGINS HERE
LISTGO:	LXI   H,0            ;
	DAD   SP             ;
	SHLD  CALRSP         ;
	LXI   SP,STACK       ;
                             ;
                             ;SIGN-ON MESSAGES
                             ;
	LXI   D,CMSG1        ;MESSAGE 1 TO CONSLOLE
	CALL  PCOMSG         ;
                             ;PRINT DEFAULT TITLE ON CONSOLE
	LXI   H,TBUFF        ;GET DEFAULT TITLE
	MOV   B,M            ;HOW MANY CHARACTERS
TLTOUT:	DCR   B              ;	
	JM    TLTEND         ;
	INX   H              ;
	MOV   A,M            ;
	CALL  CONO           ;PRINT TITLE ON CONSOLE
	JNZ   TLTOUT         ;DO IT ALL
TLTEND: LXI   D,CMSG2        ;CONSOLE MESSAGE 2
	CALL  PCOMSG         ;
	MVI   C,CONIN        ;GET CHAR. FROM CONSOLE
	CALL  BDOS           ;
	CPI   CR             ;IS IT A CR ?
	JNZ   LTE1           ;
	CALL  TITL1          ;DEFAULT TITLE
	JMP   NSTEND         ;
LTE1:	CPI   'Y'            ;IS IT A YES ?
	JNZ   TLTEND         ;ASK AGAIN IF NOT
	LXI   D,CMSG4        ;CONSOLE MESSAGE 4
	CALL  PCOMSG         ;
                             ;GET NEW TITLE
	LXI   D,RDBUFF       ;
	MVI   A,60           ;LENGTH OF TITLE
	STAX  D              ;
	MVI   C,BUFFRD       ;
	CALL  BDOS           ;GET NEW TITLE
	LXI   H,RDBUFF+1     ;SEE IF ANY CHARS.
	MOV   A,M            ;
	CPI   0              ;
	JNZ   NBE1           ;
	CALL  TITL1          ;DEFAULT TITLE
	JMP   NTEND          ;
NBE1:	LXI   D,TTLBUF       ;MOVE NEW TITLE TO
	MOV   C,A            ;BUFFER
	MVI   B,60           ;
	CALL  TITLUP         ;DO IT
NTEND:                       ;
NSTBEG:	LXI   D,CMSG6        ;CONSOLE MESSAGE 6
	CALL  PCOMSG         ;
	LXI   H,STLBUF       ;SUBTITLE OUTPUT BUFFER POINTER
	SHLD  SBTPNT         ;
	XRA   A              ;
	STA   SUBTF          ;SET SUBTITLE FLAG TO 0
GSBTL:	LXI   D,RDBUFF       ;BUFFERED READ THRU CP/M
	MVI   A,80           ;
	STAX  D              ;
	MVI   C,BUFFRD       ;
	CALL  BDOS           ;
	LXI   H,RDBUFF       ;
	LDA   RDBUFF+1       ;NO. OF CHARS. THIS LINE
	CPI   0	             ;SEE IF ANY CHARS.
	JZ    NSTEND         ;NO, IGNORE SUBTITLE
	INR   A              ;
	MVI   D,0            ;
	MOV   E,A            ;
	DAD   D	             ;ADDRESS OF LAST CHAR.
	MOV   A,M            ;
	CPI   1AH            ;IS IT A CONTROL Z ?
	JZ    GSB1           ;YES, MORE TO DO
	INX   H	             ;ADD 0 TO END
	MVI   M,0            ;END OF SUBTITLE
	CALL  SASBTL         ;PUT LINE IN BUFFER
	MVI   A,0FFH         ;
	STA   SUBTF          ;SET FLAG
	JMP   NSTEND         ;ALL DONE
GSB1:	MVI   M,0DH          ;CR, OVERWRITE CONTROL Z
	INX   H              ;
	MVI   M,0AH          ;LF
	CALL  SASBTL         ;PUT LINE IN BUFFER
	MVI   A,LF           ;
	CALL  CONO           ;SEND A LF TO CONSOLE
	JMP   GSBTL          ;GET NEXT LINE
SASBTL:	LHLD  SBTPNT         ;WHERE SUBTITLE GOES
	XCHG                 ;
	LXI   H,RDBUFF+1     ;NO. OF CHARS IN LINE
	MOV   B,M            ;
	INR   B	             ;ADD 1 FOR LF OR 0
SAS1:	INX   H	             ;MOVE LINE TO BUFFER
	MOV   A,M            ;
	STAX  D              ;
	INX   D              ;
	DCR   B              ;
	JNZ   SAS1           ;
	XCHG                 ;
	SHLD  SBTPNT         ;SAVE SUBTITLE BUFF. PTR.
	RET                  ;
                             ;
NSTEND:	LXI   D,CMSG7        ;CONSOLE MESSAGE 7
	CALL  PCOMSG         ;
	MVI   C,CONIN        ;
	CALL  BDOS           ;
	CPI   CR             ;
	JNZ   NSTEND         ;
	JMP   TITL9          ;
                             ;SET UP DEFAULT TITLE.  TITLE CONSISTS OF FILE
                             ;NAME AND ANYTHING USER TYPES AFTER IT.
TITL1:	LXI   H,TTLBUF       ;WHERE TO PUT TEXT
	XCHG                 ;
	LXI   H,TBUFF        ;WHERE CCP LEFT TEXT
	MOV   C,M            ;NUMBER OF CHARS IN TBUFF
	INX   H	             ;DISCARD LEADING ' '
	DCR   C              ;
	MVI   B,60           ;MAX # CHARS TO USE
	CALL  TITLUP         ;
	RET                  ;
                             ;COPY TEXT
TITLUP:	DCR   C              ;
	JM    TITL2          ;STOP IF INPUT USED UP
	INX   H              ;
	MOV   A,M            ;
	STAX  D              ;
	INX   D	             ;MOVE 1 CHARACTER
	DCR   B              ;
	JNZ   TITLUP         ;STOP AT MAX # CHARS
                             ;TERMINATE WITH 0
TITL2:	XRA   A              ;
	STAX  D              ;
	RET                  ;
                             ;MAKE SURE NO ?'S IN FILE NAME: IF AFN IS GIVEN
                             ;DIRECTORY ENTRIES GET CHANGED TO ?'S ON AUTOMATIC
                             ;CLOSES ON GOING TO NEXT EXTENT, AND SUCCESSIVE
                             ;EXTENTS ARE NOT NECESSARILY OF THE SAME FILE.
                             ;CCP TRANSLATES *'S TO MULTIPLE ?'S.
TITL9:	LXI   H,FCB          ;WHERE NAME IS
	MVI   C,11           ;NUMBER OF CHARS
	LXI   D,EMQUES       ;MESSAGE TO USE IF ? FOUND
QLUP:	INX   H	             ;POINT NEXT CHARACTER
	MOV   A,M            ;GET CHARACTER
	CPI   '?'            ;
	JZ    TERM           ;JMP IF ?
	DCR   C	             ;COUNT CHARACTERS TO TEST
	JNZ   QLUP           ;LOOP BACK UNLESS DONE
                             ;OPEN FILE
	MVI   C,OPEN         ;
	LXI   D,FCB          ;
	CALL  BDOS           ;CALL SYSTEM
	CPI   255            ;
	LXI   D,EMFNF        ;MESSAGE IF ERROR
	JZ    TERM           ;IF NOT FOUND, ERROR EXIT
	XRA   A              ;
	STA   NR             ;SAY START AT RECORD 0
	STA   ICOUNT         ;SAY EMPTY INPUT BUFFER
                             ;INITIALIZE OUTPUT
	XRA   A              ;
	STA   COL            ;
	STA   LINE           ;INIT CURSOR POSITION
	STA   PAGE+1         ;
	INR   A              ;
	STA   PAGE           ;.. PAGE STARTS AT DW 1
                             ;POSTION PAPER TO FIRST LINE BEFORE CALLING
                             ;LIST. THE NEXT PROGRAM SEGMENT WILL SPACE
                             ;DOWN TO THE 4th LINE AND PRINT TITLE
                             ;(SUBTITLE) INFORMATION.
	MVI   B,3            ;SEND 3 LINE FEEDS
TOPPAG:	PUSH  B              ;
	MVI   A,LF           ;
	CALL  LOCH           ;
	POP   B              ;
	DCR   B              ;
	XRA   A              ;
	CMP   B              ;
	JNZ   TOPPAG         ;
                             ;PRINT TITLE AND SUBTITLE FOR FIRST PAGE
	CALL  PTITL          ;
                             ;IGNORE ANY CR'S, LF'S, FORM FEEDS, ECT.
                             ;AT BEGINNING OF FILE.
	CALL  IGNORE         ;IGNORE FF'S ETC.
	JMP   CLOOP1         ;ENTER CHARACTER LOOP
                             ;MAIN PROGRAM CONTROL LOOP STARTS HERE
CLOOP:	CALL  INCH           ;GET CHARACTER
CLOOP1:	PUSH  B              ;
	PUSH  H              ;
	CALL  LSTCH          ;PROCESS  & LIST 1 CHAR
                             ;CHECK CONSOLE STATUS
	MVI   C,CONRDY       ;
	CALL  BDOS           ;
	RAR                  ;TEST LSB
	CC    CHKCON         ;SEE WHAT CONSOLE WANTS
	POP   H              ;
	POP   B              ;
	JMP   CLOOP          ;
                             ;CONSOLE CONTROL ROUTINE
CHKCON:	MVI   C,CONIN        ;
	CALL  BDOS           ;GET CHARACTER
	CPI   15H            ;IS IT A CONTROL U ?
	JZ    EOF            ;
	CPI   13H            ;IS IT A CONTROL S ?
	RNZ                  ;RETURN IF NOT
CON1:	MVI   C,CONRDY       ;
	CALL  BDOS           ;
	RAR                  ;
	JNC   CON1           ;WAIT FOR CONSOLE
	MVI   C,CONIN        ;
	CALL  BDOS           ;WHAT IS IT ?
	CPI   13H            ;
	RZ                   ;START LIST AGAIN
	CPI   15H            ;WANT TO ABORT ?
	JZ    EOF            ;ABORT
	JMP   CON1           ;WAIT FOR ANOTHER CHAR
                             ;END OF FILE.  FORM FEED AND EXIT.
                             ;OUTPUT FF WITHOUT TITLE
EOF:	CALL  LFFSUB         ;
                             ;EXIT ROUTINE
EXIT:	LHLD  CALRSP         ;ENTRY STACK POINTER
	SPHL                 ;RESET SP FOR CCP
	MVI   A,0            ;SAY NO ERROR
	RET                  ;
                             ;ERROR STUFF
NSERR:	LXI   D,MERR         ;MISCELLANEOUS ERRORS
                             ;COME HERE WITH DE POINTING TO TEXT
TERM:	MVI   C,PRINT        ;
	CALL  BDOS           ;
	JMP   EXIT           ;
                             ;READ NEW RECORD FROM OPEN FILE
NEWREC:	MVI   C,READ         ;
	LXI   D,FCB          ;
	CALL  BDOS           ;READ RECORD
	CPI   1              ;
	JZ    EOF            ;IF END OF FILE
	ORA   A              ;
	JNZ   NSERR          ;GOOD RETURN FROM BDOS ?
	LXI   H,ICOUNT       ;
	MVI   M,128          ;INIT BUFFER COUNTER
	LXI   H,DEFBUF       ;
	SHLD  IPOINT         ;INIT BUFFFER POINTER
	POP   H              ;
                             ;ENTRY POINT
INCH:	PUSH  H              ;
	LXI   H,ICOUNT       ;
	DCR   M	             ;COUNT CHARS USED FROM RECORD
	JM    NEWREC         ;NEED ANOTHER RECORD
	LHLD  IPOINT         ;GET BUFFER POINTER
	MOV   A,M            ;FETCH CHARACTER
	CPI   CTRLZ          ;
	JZ    EOF            ;GO DIRECT TO EOF ROUTINE
	INX   H              ;
	SHLD  IPOINT         ;POINT NEXT
	POP   H              ;
	RET                  ;
                             ;LIST CHAR IN A WITH PROCESSING OF SPECIAL CHARS
                             ;KEEPS TRACK OF COLUMN, LINE, PAGE.
                             ;EXPANDS TABS WITH STOPS EVERY 8 COLUMNS
                             ;SIMULATES FORM FEEDS WITH LINE FEEDS.
LSTCH:	LXI   H,COL          ;INCREMENT COLUMN COUNTER
	INR   M              ;
                             ;KILL PARITY BIT IN CHARS. FROM  FILE.
                             ;(NOTE: ELSE CERTAIN CHARS CAN PRODUCE
                             ;INFINITE LOOP OF ^'S.)
	ANI   7FH            ;
                             ;SPACE OR GREATER ASCII CODE JUST GETS PRINTED
	CPI   ' '            ;
	JP    LOCH           ;GO PRINT IT
	DCR   M	             ;ELSE RESTORE COLUMN COUNTER
                             ;PROCESS SPECIALS
	PUSH  PSW            ;
	CPI   CR             ;
	JNZ   LSC2           ;
	XRA   A              ;
	STA   COL            ;
POPLOC:	POP   PSW            ;GET CHAR BACK
	JMP   LOCH           ;GO LIST IT
LSC2:	CPI   LF             ;
	JNZ   LSC3           ;
	LDA   LINE           ;
	CPI   PPPAGE-1       ;
	JP    LISFF          ;PAGE FULL, MAKE LIKE FF
	POP   PSW            ;CLEAR STACK AND PROCEED
                             ;PROCESS AND PRINT LINE FEED
LISLF:	PUSH  PSW            ;
	MVI   A,LF           ;
	CALL  LOCH           ;OUTPUT LINE FEED
	LDA   LINE           ;
	INR   A	             ;LINE+1
	CPI   PGSIZ          ;
	JM    LSC2A          ;IF BOTTOM OF PAGE, MAKE IT..
	XRA   A	             ;..TOP OF NEXT PAGE.
	LHLD  PAGE           ;
	INX   H              ;
	SHLD  PAGE           ;
LSC2A:	STA   LINE           ;
	POP   PSW            ;
	RET                  ;
                             ;
LSC3:	CPI   ALTFF          ;
	JZ    LISFF          ;ALTERNATE FORM FEED
	CPI   FF             ;
	JNZ   LSC4           ;
                             ;PRINT CR, LF'S TILL LINE=0
LISFF:	CALL  LFFSUB         ;SIMULATE FORM FEED
                             ;NEED A TITLE AT TOP OF NEXT PAGE, BUT FIRST SEE
                             ;IF ANY MORE NON-CR, LF, FF CHARACTERS IN FILE.
                             ;THUS IT AVOIDS BLANK SPACE AT TOP OF PAGE.
	CALL  IGNORE         ;PASS CR, FF, ETC
                             ;IF HERE, NOT AT EOF AND NEXT CHAR IS IN A REG.
	CALL  PTITL          ;PRINT TITLE
	POP   H              ;
	JMP   LSTCH          ;CLEAR STACK, GO LIST CHAR
LSC4:	CPI   TAB            ;
	JNZ   LSC5           ;
                             ;PRINT SPACES TILL LO 3 BITS OF COL = 0
LSC4A:	MVI   A,' '          ;
	CALL  LSTCH          ;
	LDA   COL            ;
	ANI   7              ;
	JNZ   LSC4A          ;
LPOPX:	POP   PSW            ;
	RET                  ;
                             ;ADD MISCELLANEOUS CHARACTERS HERE.
                             ;PRINT ^ AND LETTER
LSC5:	MVI   A,'^'          ;
	CALL  LSTCH          ;
	POP   PSW            ;
	ORI   40H            ;
	JMP   LSTCH          ;
                             ;PROCESS AND OUTPUT (SIMULATED) FORM FEED
LFFSUB:	MVI   A,CR           ;
	CALL  LSTCH          ;
LSFF2:	LDA   LINE           ;
	ORA   A              ;
	CNZ   LISLF          ;
	JNZ   LSFF2          ;
	RET                  ;
                             ;SUBROUTINE TO IGNORE CR'S, LF'S, FORM FEEDS.
                             ;CALLED AT TOP OF EACH PAGE. RETURNS NEXT NON-
                             ;IGNORED CHAR. IN A. QUIT 'LIST' IF EOF FOUND.
IGNORE: CALL  INCH           ;GET SOURCE FILE CHAR. IN A
	CPI   CR             ;
	JZ    IGNORE         ;
	CPI   LF             ;
	JZ    IGNORE         ;
	CPI   FF             ;
	JZ    IGNORE         ;
	CPI   ALTFF          ;
	JZ    IGNORE         ;
	RET                  ;CHARACTER IS IN A
                             ;LIST OUTPUT CHAR IN A, WITHOUT PROCESSING
LOCH:	MOV   E,A            ;
	MVI   C,LIST         ;
        JMP   BDOS           ;
                             ;SUBROUTINE TO PRINT PAGE TITLE
PTITL:  CALL  CLOCK          ;*** READ CLOCK AND PRINT IT ON TOP OF PAGE  ***
      	PUSH  PSW            ;
	PUSH  H              ;
                             ;TITLE TEXT
	LDA   TFLAG          ;
	ORA   A              ;
	JZ    NOTITL         ;
	LXI   H,TTLBUF       ;
	CALL  LSTRNG         ;
                             ;PAGE NUMBER
NOTITL:	LDA   PNFLAG         ;
	ORA   A              ;
	JZ    NOPGNO         ;
                             ;SPACE TO COLUMN
PAGN1:	MVI   A,' '          ;
	CALL  LSTCH          ;MINIMUM ONE SPACE
	LDA   COL            ;
	SBI   PNOCOL         ;
	JM    PAGN1          ;
                             ;"PAGE" TEXT
	LXI   H,PGETXT       ;
	CALL  LSTRNG         ;
                             ;NUMBER
	LHLD  PAGE           ;
	CALL  DECPR          ;
                             ;PRINT SUBTITLE IF ANY
	LDA   STFLAG         ;
	ORA   A              ;
	JZ    NOPGNO         ;
	LDA   SUBTF          ;
	ORA   A              ;
	JZ    NOPGNO         ;
	MVI   A,CR           ;
	CALL  LSTCH          ;
	MVI   A,LF           ;
	CALL  LSTCH          ;
	LXI   H,STLBUF       ;
	CALL  LSTRNG         ;
                             ;TEST IF EITHER OF ABOVE WAS PRINTED
NOPGNO:	LHLD  TFLAG          ;
	LDA   PNFLAG         ;
	ORA   L              ;
	JZ    PTTLEX         ;NO, NEED NO CRLF'S
                             ;CR AND 2 LF'S
	MVI   A,CR           ;
	CALL  LSTCH          ;
	MVI   A,LF           ;
	CALL  LSTCH          ;
	MVI   A,LF           ;
	CALL  LSTCH          ;
PTTLEX:	POP   H              ;
	POP   PSW            ;
	RET                  ;
                             ;SUBR TO LIST STRING (HL) TO NULL
LSTRNG:	MOV   A,M            ;
	ORA   A              ;
	RZ                   ;
	INX   H              ;
	PUSH  H              ;
	CALL  LSTCH          ;
	POP   H              ;
	JMP   LSTRNG         ;
                             ;DECIMAL PRINT HL, UNSIGNED
DECPR:	PUSH  B              ;
	PUSH  D              ;
	PUSH  H              ;
	LXI   B,-10          ;MINUS RADIX
	LXI   D,-1           ;BECOMES NUMBER/RADIX
DECPR1:	DAD   B              ;
	INX   D              ;
	JC    DECPR1         ;SUBTRACT TILL NEGATIVE
	LXI   B,10           ;
	DAD   B              ;AD RADIX BACK ONCE
	XCHG                 ;HAVE N/10 IN HL, REM. IN DE
	MOV   A,H            ;
	ORA   L              ;
	CNZ   DECPR          ;GET REMAINING DIGITS, IF ANY
	MOV   A,E            ;
	ADI   '0'            ;
	CALL  LOCH           ;PRINT THIS DIGIT
	POP   H              ;
	POP   D              ;
	POP   B              ;
	RET                  ;
                             ;OUTPUT MESSAGE TO CONSOLE
PCOMSG:	MVI   C,PRINT        ;MSG POINTER IN DE
	CALL  BDOS           ;
	RET                  ;
                             ;OUTPUT CHAR IN A REG.
CONO:	PUSH  PSW            ;
	PUSH  B              ;
	PUSH  D              ;
	PUSH  H              ;
	MOV   E,A            ;
	MVI   C,CONOUT       ;
CALLEN: CALL  BDOS           ;
	POP   H              ;
	POP   D              ;
	POP   B              ;
	POP   PSW            ;
	RET                  ;
                             ;
CLOCK:  PUSH  PSW            ;*** SAVE ALL REGISTERS ***
        PUSH  B              ;
        PUSH  D              ;
        PUSH  H              ;
                             ;
        LXI   H,TIME+4       ;SET MEM. POINTER TO START OF TIME SLOT
        MVI   A,0            ;HR. TENS ADDRESS
        CALL  GETDIG         ;GET IT
        MVI   A,1            ;HR. UNITS
        CALL  GETDIG         ;GET IT
        INX   H              ;SKIP ":"
        MVI   A,2            ;MIN. TENS
        CALL  GETDIG         ;GET IT
        MVI   A,3            ;MIN. UNITS
        CALL  GETDIG         ;GET IT
        INX   H              ;SKIP ":"
        MVI   A,4            ;SEC. TENS
        CALL  GETDIG         ;GET IT
        MVI   A,5            ;SEC. UNITS
        CALL  GETDIG         ;GET IT
        LXI   H,TIME+19      ;SET DATE ADDRESS
        MVI   A,8            ;MONTH TENS
        OUT   CLK            ;SEND TO CLOCK PORT
        CALL  DELAY          ;WAIST SOME TIME
        IN    CLK            ;READ PORT
        ANI   0FH            ;CLEAR SOME BITS
        ADI   48             ;MAKE IT ASCII
        CPI   63             ;TEST FOR "15"
        CZ    SET1           ;IF SO THEN SET TO BLANK
        MOV   M,A            ;PUT IN MEM.
        MVI   A,9            ;MONTH UNITS
        CALL  GETDIG         ;GET IT
        INX   H              ;SKIP "/"
        MVI   A,10           ;DAY TENS
        CALL  GETDIG         ;GET IT
        MVI   A,11           ;DAY UNITS
        CALL  GETDIG         ;GET IT
        LXI   H,TIME         ;RESET INDEX REGISTER TO START OF TIME MESS.
YY1     MOV   A,M            ;SEND IT TO THE PRINTER
        CPI   '$'            ;CHECK FOR END OF MESS.
        JZ    ZZ1            ;IF SO JUMP TO RETURN SECTION     
        PUSH  H              ;
        CALL  LOCH           ;
        POP   H              ;
        INX   H              ;
        JMP   YY1            ;DO IT AGAIN
                             ;
ZZ1     POP   H              ;RESTORE ALL REGISTERS AND RETURN
        POP   D              ;
        POP   B              ;
        POP   PSW            ;
        RET                  ;
                             ;
SET1:   MVI   A,20H          ;
        RET                  ;
                             ;
GETDIG: OUT   CLK            ;SEND CHAR. IN REG. A TO PORT
        CALL  DELAY          ;
        IN    CLK            ;READ PORT
        ANI   0FH            ;
        ADI   48             ;MAKE IT ASCII
        INX   H              ;POINT TO NEXT SLOT IN MEM.
        MOV   M,A            ;PUT IT THERE
        RET                  ;RETURN
                             ;
DELAY:  LXI   D,02FFH        ;WAIST SOME TIME
WAIT1:  DCR   E              ;CPU TOO FAST FOR CLOCK
        JNZ   WAIT1          ;
        DCR   D              ;
        JNZ   WAIT1          ;
        RET                  ;
                             ;
CMSG1:	DB    RESET
	DB    '* * * XT VER. 1.1.A * * *'
	DB    CR,LF,LF
	DB    'LISTING CONTROL CONSOLE COMMANDS:'
	DB    CR,LF,LF
	DB    'Control U aborts listing'
	DB    CR,LF
	DB    'Control S stops-restarts listing'
	DB    CR,LF,LF
	DB    'The default Title Line is:'
	DB    CR,LF,LF,24H
CMSG2:	DB    CR,LF,LF
	DB    'Do you want to enter a new TITLE or '
	DB    'SUBTITLE',CR,LF
	DB    'YES - enter Y',CR,LF
	DB    'NO  - enter CR  ??$'
CMSG4:	DB    CR,LF,LF
	DB    'Enter New Title (enter a CR to '
	DB    'retain Default Title)',CR,LF
	DB    'Title can be one line only - '
	DB    '60 characters maximum - '
	DB    'End with a CR',CR,LF,'$'
CMSG6:	DB    CR,LF,LF
	DB    'Enter Subtitle (a CR skips subtitle)'
	DB    CR,LF
	DB    'SUBTITLE can be multiple lines. '
	DB    'If you want to enter additional lines '
	DB    CR,LF
	DB    'end preceeding lines with a control Z.  '
	DB    'End Subtitle input with a CR.'
	DB    CR,LF,24H
CMSG7:	DB    CR,LF,LF
	DB    '* * * POSITION PAPER TO TOP LINE * * *'
	DB    CR,LF,LF
	DB    'Enter CR when ready',CR,LF,'$'
MERR:	DB    CR,LF,'SOME KIND OF ERROR'
	DB    CR,LF,24H
EMFNF:	DB    LF,'FILE NOT FOUND',CR,LF,'$'
TIME:   DB    'TIME HH:MM:SS DATE MM/DD/1979',CR,LF,'$'
EMQUES:	DB    LF,'NO *.S OR ?.S PLEASE!'
	DB    CR,LF,24H
PGETXT: DB    'PAGE '
        DB    0
TFLAG:	DB    0FFH           ;MAKE 0 TO SUPPRESS TITLE
PNFLAG:	DB    0FFH           ;MAKE 0 TO SUPPRESS PAGE NOS.
STFLAG:	DB    0FFH           ;MAKE 0 TO SUPPRESS SUBTITLE
        DS    1
SUBTF:	DS    1	             ;SUBTITLE PRESENT FLAG
SBTPNT:	DS    2	             ;SUBTITLE BUFFER POINTER
IPOINT:	DS    2	             ;INPUT BUFFER POINTER
ICOUNT:	DS    1	             ;INPUT BUFFER DOWN-COUNTER
COL:	DS    1
LINE:	DS    1
PAGE:	DS    2
CALRSP:	DS    2	             ;CALLER'S STACK POINTER
RDBUFF:	DS    84             ;SPACE FOR CP/M BUFFERED READ
TTLBUF:	DS    80             ;SPACE FOR TITLE
STLBUF:	DS    100H           ;SPACE FOR SUBTITLE
        DS    80
TIMESP: DS    29
STACK:	DS    4
DSTACK:	DS    2
