#include "stdio.h"
#include "printf.h"

/* mkrel from1.com from2.com to.pre */

/* Create a relocatable ".pre" file from two ".com" files */
/*  "from1.com" must be assembled with ORG 0100H */
/*  "from2.com" must be assembled with ORG 0200H */

#define MAXRELOC	2048	/* 32k bytes */

main(argc, argv)
char **argv;
{
	int n, j, w, diff, c, d;
	FILE *f1, *f2, *t1;
	char reloc[MAXRELOC];
	int nw;

	if (argc != 4) {
		fprintf(stderr,
		    "Usage: mkrel from1.com from2.com to.pre\n");
		exit(-1);
	}
	f1 = fopen(argv[1], "rb");
	if (!f1) {
		fprintf(stderr,
		    "%s: Cannot open\n", argv[1]);
		exit(-1);
	}
	f2 = fopen(argv[2], "rb");
	if (!f2) {
		fprintf(stderr,
		    "%s: Cannot open\n", argv[2]);
		exit(-1);
	}
	t1 = fopen(argv[3], "wb");
	if (!t1) {
		fprintf(stderr,
		    "%s: Cannot create\n", argv[3]);
		exit(-1);
	}
	/* Ignore first page of f2 */
	for (n = 256; --n >= 0; getc(f2));
	/* Put out page of zeros to t1 */
	for (n = 256; --n >= 0; putc(0, t1));
	w = 0;
	j = 7;
	nw = 0; /* Count of relocation bytes */
	for (n = 0; (c = getc(f1)) != EOF; ++n) {
		d = getc(f2);
		if (d == EOF) {
			fprintf(stderr,
			    "Premature EOF on %s\n", argv[2]);
			break;
		}
		diff = (d-c)&0377;
		if (diff > 1) {
			fprintf(stderr,
			    "Corresponding bytes off by more than 1.\n");
			fprintf(stderr,
			    "BYTE %6x, FIRST %6x, SECOND %6x\n", n, c, d);
			diff = 0;
		}
		/* Put out zero-relative */
		putc(c-diff, t1);
		w |= diff<<j;
		if (--j < 0) {
			/* Save byte of bits */
			reloc[nw++] = w;
			w = 0;
			j = 7;
		}
	}
	if (j < 7) reloc[nw++] = w;
	/* Write out reloc table */
	for (j = 0; j < nw; j++) {
		putc(reloc[j], t1);
	}
	/* Make even multiple of 128 bytes */
	j += n;
	while (j++ & 127) putc(0, t1);
	/* Flush out last sector */
	fflush(t1);
	/* Re-position to beginning of file */
	fseek(t1, 0, 0);
	/* Output length of code in bytes */
	putc(0, t1);
	putc(n, t1);
	putc(n>>8, t1);
	fclose(t1);
	exit(0);
}

 t1));
	w = 