#include "stdio.h"
#include "printf.h"
#include "malloc.h"

/* Dynamic memory allocation routines */
/* Each memory chunk has a length, and some data */
/* The data part is always an even number of bytes */
/* The low order bit of the length is used to indicate */
/*  that the chunk is in use */
/* m.m_first, m.m_cur, and m.m_last must all be set up before */
/*  call on malloc(), all equal to first memory available for heap. */

/* They are initially set to "$END", a symbol assumed to be defined */
/*  to represent the end of the code */

/* Free memory starts at m.m_last */
/* compress() may be called to set m.m_last to minimum possible address */

struct m_headers m;	/* Initialize to zero */

static char *
stk_ptr(x)
{
	/* Return value of stack pointer */
	return((char *)&x);
}

static int
init_mhead()
{
	/* Initialize m_head (aka m) if necessary */
	if (m.m_last) return;	/* Nothing to do */
	if (!m.m_first) {
		/* No user-specified initial value */
#asm
	EXTRN	$END	; this sym must be defined to be end of prog

	LXI	H,$END	; init m_head.m_first
	SHLD	m_head
#endasm
	}
	/* Copy m.m_first to other two pointers */
	m.m_cur = m.m_last = m.m_first;
}

char *
malloc(n)
register int n;
{
	/* Allocate area of size n off of "heap." */
	/* Assume m.m_first, m.m_cur, m.m_last set up. */
	/* m.m_first is pointer to first block of heap storage, */
	/* m.m_last is pointer to unused memory */
	/* m.m_cur is pointer to some block of heap storage, set */
	/*  by most recent malloc or free. */
	register l;
	register struct melem *p;
	struct melem *basep;
	int totl, loop;

	init_mhead();
	/* Never start with m.m_cur pointing to m.m_last */
	if (m.m_cur >= m.m_last) {
		m.m_cur = m.m_first;
		/* Check if empty */
		if (m.m_first == m.m_last) {
			/* Create first chunk */
			m.m_first->m_len = MIN_ALLOC&~1;
			m.m_last = &m.m_first->m_data[MIN_ALLOC&~1];
		}
	}
	/* Start with m.m_cur, scan to m.m_last */
	p = m.m_cur;
	/* Scan just once if starting at m.m_first, otherwise twice */
	loop = (p == m.m_first)? 1: 2;
	totl = 0;	/* Will be length of contiguous free area */
	for (;;) {
		l = p->m_len;
		if (l & 01) {
			/* Low bit of length used to mark block "busy" */
			totl = 0;
			--l;	/* clear low bit */
		} else {
			/* Block is free, add to total length */
			if (totl == 0) {
				/* first free block in possible group */
				totl = l;
				basep = p;
			} else {
				/* consolidate consecutive free blocks */
				totl += l + sizeof(int);
				basep->m_len = totl;
			}
			if (totl >= n) break;	/* Found large enough area */
		}
		/* Advance to next block */
		p = (struct melem *)(&p->m_data[l]);
		if (p != m.m_last) continue;
		/* End of heap */
		if (--loop != 0) {
			/* loop again */
			totl = 0;
			p = m.m_first;
			continue;
		}
		/* Calculate extra space needed */
		l = (n - totl + 1) & ~01;
		if (!totl) l += sizeof(int);	/* Needed if prev. blk busy */
		if (p > stk_ptr() - l - SAFETY) {
			/* Out of room */
			fprintf(stderr, "Out of memory in malloc(%d)\n", n);
			return((char *)0);
		}
		if (l < MIN_ALLOC && p < stk_ptr() - (MIN_ALLOC+SAFETY)) {
			l = MIN_ALLOC&~01;	/* Adjust up allocation */
		}
		/* Set up new block */
		p->m_len = (l -= sizeof(int));
		m.m_last = (struct melem *)(&p->m_data[l]);
		/* And loop around */
	}
	/* Found enough space, basep/totl now set up */
	p = basep;
	l = (n+1) & ~01;
	if (totl - l >= MIN_FRAG + sizeof(int)) {
		/* Ok to break up block */
		p->m_len = l;
		basep = (struct melem *)(&p->m_data[l]);
		basep->m_len = totl - l - sizeof(int);
	}
	m.m_cur = basep;  /* Save pointer to (next) heap block */
	++p->m_len;	/* Indicate this heap block busy */
	return(p->m_data);	/* And return block */
}

free(cp)
char *cp;
{
	/* Free block allocated by malloc */
	/* Adjust m.m_cur if new block lower */
	register struct melem *p;

	/* Point to beginning of block's melem struct */
	p = (struct melem *)(cp - sizeof(int));
	if (!(p->m_len & 01) || p < m.m_first || p >= m.m_last) {
		/* Block not busy, or out of range */
		fprintf(stderr, "Bad pointer in free(0%o)\n", cp);
		return;
	}
	--p->m_len;	/* Clear busy bit */
	/* Adjust m.m_cur if appropriate */
	if (p < m.m_cur) m.m_cur = p;
}

struct m_headers *
compress()
{
	/* Release any free space at end of heap, */
	/*  and return pointer to headers structure */
	struct melem *p, *freep;
	int l;

	init_mhead();
	/* Never start with m.m_cur pointing to m.m_last */
	if (m.m_cur >= m.m_last) m.m_cur = m.m_first;

	/* Start with m.m_cur, scan to m.m_last */
	p = m.m_cur;
	freep = 0;
	while (p != m.m_last) {
		l = p->m_len;
		if (l&01) {
			/* block is busy, null out freep */
			freep = 0;
			--l;	/* Clear low bit */
		} else if (!freep) {
			/* set freep to first of sequence of free blocks */
			freep = p;
		}
		/* Advance p to next block */
		p = (struct melem *)(&p->m_data[l]);
	}
	/* Back up m.m_last to first of free sequence */
	if (freep) m.m_last = freep;
	/* Return pointer to headers struct */
	return(&m);
}
y, or out of range */
		fprintf(stderr, "Bad pointer in free(0%o)\n", cp);
		return;
	}
	--p->m_len;	/