.TITLE "{ITS100/TIP LINKER}- REV-{4.7}" 
.SBTTL "ASSEMBLY CONTROL"
.I8080	; ALLOW ONLY 8080 OPERATORS
.PABS	; ABSOLUTE ASSEMBLY FORMAT
.XLINK	; SUPRESS LINKER DATA
.PHEX	; HEXIDECIMAL OBJECT GENERATION
.XSYM	; DELETE SYMBOL TABLE
.SALL	; INHIBIT MACRO EXPANSIONS
;
;
;
; COPYRIGHT 1979 BY:
;
; ALLOY ENGINEERING COMPANY, INC.
; COMPUTER PRODUCTS DIVISION
; 12 MERCER RD.
; NATICK, MA. 01760
; (617) 655-3900
;
;
;        This DOCUMENT contains INFORMATION 
; which is PROPRIETARY to ALLOY ENGINEERING
; COMPANY, INC. REPRODUCTION or USE WITHOUT
; an EXPRESS WRITTEN CONSENT from the ALLOY
; ENGINEERING COMPANY IS PROHIBITED........
;
; DOCUMENT # {FW-100075:MM}
;
;
EOIS	= \ "ASSEMBLE OVERLAPPED I/O (1=YES, 0=NO)? "
OIO	= EOIS-1
;
;
;
;  {REVISIONS:}
;
; REV----DATE----DETAILS
;
; 4.1  09/02/81	 4.0 DERIVATIVE OF MBTL
; 4.2  09/19/81  ADD OVERLAPPED I/O ON WRITE
; 4.4  04/12/82  SLOW PRDY CODE FOR 5/6 MHZ
;		 COMMON CODE FOR IDXS/ITS
; 4.5  05/03/82  FIX ECODE ON VLR FAILURE
; 4.6  10/18/82  WRDCNT & R.AREA HANDLING AS PER MANUAL
; 4.7  01/24/83  SUPPORT SET REC LENGTH COMMAND
;
.PAGE
.SBTTL "MISC EQUATES AND MAPPING"
;---- UNIQUE INSTRUCTIONS ----
;
.DEFINE CLA=[.BYTE 0AFH]
	; CLEAR ACCUMULATOR (XRA A)
;
;
;---- ALLOY SPECIFIC EQUATES ----
;
ATU	=1800H	; CIPHER TAPE UTILITY
		; PROGRAM START ADDR.
;
P	=\"I/O PORT GROUP?"
		; (4 LONG)
;
R.MBA	=2900H	; MASK BUFFER AREA
R.MBL	=16	; MASK BUFFER LENGTH
;
R.DBA	=3000H	; DEFAULT DATA BUFFER AREA
R.DBL	=8208	; DEFAULT DATA BUFFER LENGTH
		; (SET ON CALL TO INIT.)
;
;
.REMARK	"
	THIS PROGRAM CONFORMS TO THE SPECIFICATIONS
OF THE DEI/MULTIBUS CONTROLLER INTERFACE GUIDE
(DOCUMENT NUMBER IG-100031), COPYRIGHT ALLOY ENGIEERING
COMPAY - COMPUTER PRODUCTS DIVISION.  PLEASE REFER TO
THIS DOCUMENT FOR FURTHER INFORMATION" 
;
;---- HERE ARE MULTIBUS TRANSFER I/O PORTS ----
;
ISTAT	=P+1	; INPUT PORT STATUS  
;	
;	B0-	OPA*	; OUTPUT PORT AVAILABLE =0
;     	B1-	IDR*   	; INPUT DATA READY =0
	;
IDATA	=P+2	; INPUT PORT DATA
;
	;
OMA 	=P+0	; OUTPUT MA VALUES
	;
OPA	=P+1	; OUTPUT PA VALUES
	;
OCA	=P+2	; OUTPUT CA VALUES
	;
ODATA	=P+3	; OUTPUT DATA OR MASK
.PAGE
.SBTTL "{LINKER PROGRAM ENTRY}"
;**************************************************
	.LOC	ATU
;
ATUS:	PUSH	PSW	; SAVE CALLING REG'S
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	H,0	; SAVE CURRENT STACK LOC
	DAD	SP	;  IN CASE OF TROUBLE
	SHLD	SSAVE
;
;---- CHECK IF RESET COMMAND ----
;
CKR:	LDA	CA	; GET CALLING CMD
	ANI	10H	; RESET BIT SET ?
	JZ	..A2	; IF NOT, CONTINUE
;
;---- CHECK IF IDXS OR ITS CONTROLLER ----
;
	MVI	A,08	; REQUEST STATUS
	OUT	OCA
	CALL	RCV	; GET DS
	ANI	80H	; IF 80 SET =IDXS-100
	STA	ODS	; SAVE
	LXI	H,R.DBL	; RESET DEFAULT RECORD
	SHLD	WRDCNT	;   LENGTH
	LXI	H,R.DBA	;[4.6] RESET DEFAULT BUFFER
	SHLD	R.AREA	;[4.6]   AREA
	XRA	A	; CLEAR STATUS PENDING
	STA	SPF
	LDA	CA	; GET CMD AGAIN
	OUT	OCA	; SEND RESET COMMAND
	LDA	ODS	; GET TYPE IDENT
	ORA	A
	JNZ	ATUE	; DON'T DISTURB DS IF IDXS
	MVI	A,11H	; INIT DS
	STA	DS
	JMP	ATUE	;  AND EXIT
..A2:	NOP
;
;---- CHECK IF STATUS PENDING ----
;
	.IFE	OIO,[
	LDA	SPF	; GET PENDING FLAG
	ORA	A	; TEST IT
	JZ	..A	; CONTINUE IF LOW
	XRA	A	; DROP THE FLAG
	STA	SPF
	LDA	ODS	; GET TYPE IDENT
	ORA	A
	JNZ	..A	; IF IDXS THEN NO OIO
	CALL	RCV	; GET THE DRIVE STATUS
	STA	DS
	CALL	RCV	; AND THE INTERFACE STATUS
	STA	IS
	ANI	30H	; STAUS OK?
	JNZ	ATUE	; IF NOT, GO RETURN IT
	]
;
;---- CHECK IF MASK COMMAND ----
;
..A:	LDA	CA	; GET COMMAND
	ANI	0FH	; ISOLATE CMD BITS
	MOV	B,A	; SAVE FOR LATER
	CPI	11	; MASK SEARCH ?
	JNZ	..B	; IF NOT, CONTINUE
	CALL	PRDY	; AWAIT PORT READY
	LDA	MA	; GET MA VALUE
	ANI	0FH	; ISOLATE DRIVE/TRK
	ORI	0E0H	; SET MASK & 8208 BYTES
	OUT	OMA	; SEND MA
	LXI	H,R.MBA ; SET MASK AREA
	MVI	C,R.MBL ; SET MASK LENGTH
..A1:	CALL	PRDY	; AWAIT PORT READY
	MOV	A,M	; GET MASK BYTE
	OUT	ODATA	; SEND TO DMB-1
	INX	H	; INC POINTER
	DCR	C	; DEC THE COUNTER
	JNZ	..A1	; LOOP FOR THE COUNT
	JMP	..C	; SKIP MA OUTPUT
;
;---- HERE WE OUTPUT MA VALUE ----
;
..B:	CALL	PRDY	; AWAIT PORT READY
	LDA	MA	; GET MA VALUE
	ANI	8FH	; SET 8208 SIZE IN CASE
	ORI	60H	;  IT ISN'T ALREADY
	OUT	OMA	; SEND TO DMB-1
;
;---- HERE WE OUTPUT PA VALUE ----
;
..C:	CALL	PRDY	; AWAIT PORT READY
	LDA	PA	; GET PA VALUE
	OUT	OPA	; SEND TO DMB-1
	MOV	A,B	; GET MASKED COMMAND
	CPI	2	; CHECK IF WRITE COMMAND
	JZ	..C0	;[4.7] IF SO, GO SET & SEND
	CPI	9	;[4.7] CHECK IF SET LENGTH
	JNZ	..D	; IF NOT, DO CA
;
;---- SET BLOCK SIZE FOR WRITE ----
;
..C0:	LHLD	WRDCNT	; GET SIZE TO SEND
	CALL	PRDY	; AWAIT PORT
	MOV	A,H	; SEND MSB
	OUT	ODATA
	CALL	PRDY	; AWAIT PORT AGAIN
	MOV	A,L	; SEND LSB
	OUT	ODATA
	MOV	A,B	;[4.7] CHECK THE COMMAND
	CPI	9	;[4.7] IS IT SET LENGTH?
	JZ	..D	;[4.7] IF SO, GO CONT NORMAL
	CALL	PRDY	; WAIT SOME MORE
	MVI	A,9	; SEND SIZE CMD
	OUT	OCA
	CALL	RCV	; GET DS
	STA	DS
	CALL	RCV	; GET IS
	STA	IS
	ANI	30H	; EVERYTHING OK?
	JNZ	ATUE	; IF NOT, EXIT
	.IFE	OIO,[
	LDA	ODS	; GET INTERFACE TYPE
	ORA	A
	JNZ	..C1A	; NO OIO IF IDXS-100
	MVI	A,0FFH	; SET STATUS PENDING
	STA	SPF
	]
..C1A:	CALL	PRDY	; WAIT 
	LDA	MA	; SEND MA
	ANI	8FH	; SET 8208 SIZE IN CASE
	ORI	60H	;  IT ISN'T ALREADY
	OUT	OMA
;
;---- HERE WE OUTPUT DATA ----
;
	LHLD	WRDCNT	; SET DATA BUFFER LENGTH
	XCHG
;[4.6]	LXI	H,R.DBA	; SET DATA BUFFER START
	LHLD	R.AREA	;[4.6] SET DATA BUFFER START
..C1:	IN	ISTAT	; GET PORT STATUS
	RRC		; MOVE EMPTY TO CY
	JNC	..C1	; LOOP TILL READY
	MOV	A,M	; GET DATA BYTE
	OUT	ODATA	; SEND TO DMB-1
	INX	H	; INC INDEX
	DCX	D	; DEC THE COUNTER
	MOV	A,D	; CHECK FOR COUNTER = 0
	ORA	E	
	JNZ	..C1	; LOOP TILL 0
;
;---- HERE WE OUTPUT CA VALUE ----
;
..D:	CALL	PRDY	; AWAIT PORT READY
	MOV	A,B	; GET STRIPPED CMD
	CPI	10	; SEE IF VLR REQUESTED
	LDA 	CA	; GET CA VALUE
	JNZ	..D0	; IF NOT, GO SEND CMD
	ANI	0F0H	; MAKE IT A READ
	ORI	1
..D0:	OUT	OCA	; SEND TO DMB-1
;
;---- AWAIT OPERATION COMPLETE ----
;
	.IFE	OIO,[
	LDA	ODS	; GET TYPE IDENT
	ORA	A
	JNZ	..D01	; IF IDXS THE NO OIO
	MVI	A,11H	; SET DEFAULT STATUS
	STA	DS
	MVI	A,80H
	STA	IS
	MOV	A,B	; TEST THE COMMAND
	CPI	2	; WAS IT WRITE?
	JZ	ATUE	; IF SO, PENDING STATUS
	]
..D01:	CALL	RCV	; WAIT AND GET CHARACTER
	STA	DS	; SAVE DS VALUE
	CALL	RCV	; WAIT AND GET CHARACTER
	STA	IS	; SAVE IS VALUE
	ANI	40H	; DOES DATA BLOCK FOLLOW ?
	JZ	ATUE	; EXIT IF NOT
;
;---- ACCUMULATE DATA ---- 
;
	CALL	RCV	; GET BLOCK SIZE
	MOV	L,A
	CALL	RCV
	MOV	H,A
	SHLD	LWCNT	; SAVE FOR COMPARE
	XCHG		; COUNT TO DE
;[4.6]	LXI	H,R.DBA	; SET DATA BUFFER START
	LHLD	R.AREA	;[4.6] SET DATA BUFFER START
..D1:	IN	ISTAT	; GET PORT STATUS
	ANI	2	; TEST DATA READY*
	JZ	..D1	; LOOP TILL READY
	IN	IDATA	; GET A BYTE
	MOV	M,A	; STORE IN MEMORY
	INX	H	; INC INDEX
	DCX	D	; DEC COUNTER
	MOV	A,D	; CHECK COUNTER = 0
	ORA	E
	JNZ	..D1	; LOOP TILL 0
	LHLD	LWCNT	; GET RCVD COUNT
	LDA	CA	; CHECK COMMAND
	ANI	0FH	; CONSIDER ONLY ACTUAL CMD
	CPI	0AH	; VAR LEN READ?
	JNZ	..D2	; IF NOT, GO CHECK CNT
	SHLD	WRDCNT	; SAVE THE LENGTH
	JMP	ATUE	; AND GO EXIT
;
..D2:
;[4.6]	LXI	D,R.DBL	; GET EXPECTED COUNT
	XCHG		;[4.6] SAVE COUNT
	LHLD	WRDCNT	;[4.6] AND GET EXPECTED
	MOV	A,D	; COMPARE THEM
	CMP	H
	JNZ	..E	; ERROR IF NOT THE SAME
	MOV	A,L	; IN BOTH BYTES
	CMP	E
	JZ	ATUE	; GO RETURN IF GOOD
..E:	LDA	IS	; GET INTERFACE STATUS
	ANI	8FH	; DROP BLOCK FOLLOWS
	ORI	20H!10	; SET AWA CODE=10 SHORT REC.
	STA	IS	; AND RESAVE IT
;
;---- WE ENTER HERE TO EXIT TO MAIN CALLER ----
;
ATUE:	LDA	IS	; GET THE INTERFACE STATUS
	ANI	0FH	; MASK TO ERROR CODE
	STA	ECODE	; AND SAVE THIS
	LDA	IS	;[4.6] GET IS AGAIN
	ANI	0F0H	;[4.6] PRESERVE MSN
	MOV	B,A	;[4.6] SAVE FOR LATER
	LDA	MA	;[4.6] GET MODE ARGUMENT
	ANI	0FH	;[4.6] GET DRV & TRK
	ORA	B	;[4.6] USE IN IS
	STA	IS	;[4.6] AND SAVE FOR CALLER
	LHLD	SSAVE	; RESTORE STACK -IN CASE
	SPHL
	POP	H	; AND ALL REG'S
	POP	D
	POP	B
	POP	PSW
	RET		; RETURN TO MAIN PROGRAM
;
;
;---- HERE WE AWAIT DMB-1 OUTPUT PORT READY ----
;
PRDY:	NOP		; SLOW DOWN FOR 8085
	NOP
	NOP
	NOP
	NOP
	IN	ISTAT	; GET PORT STATUS
	RRC		; MOVE READY* TO CY
	RC		; RETURN IF READY*
	JMP	PRDY	; LOOP TILL READY
;
;
;---- HERE WE AWAIT INPUT & READ DATA BYTE ----
;
RCV:	IN	ISTAT	; GET PORT STATUS
	ANI	2	; CHECK DATA AVAIL*
	JZ	RCV	; LOOP TILL READY
	IN	IDATA	; READ THE DATA
	RET		; RETURN 'A'=DATA BYTE
.PAGE
.SBTTL	"{RAM VARIABLES}"
;*****************************************************
;
;---- LOCAL RESERVED RAM ----
;
LWCNT:	.WORD	0	; RECIEVED WORD COUNT
SPF:	.BYTE	0	; STATUS PENDING FLAG
;
	.LOC	ATU+76CH
;
;---- GLOBAL RESERVED RAM ----
;
R.AREA:	.WORD	0	; READ/WRITE BUFFER AREA
WRDCNT:	.WORD	0	; READ/WRITE RECORD SIZE
MA:	.BYTE	0	; MODE ARGUMENT
PA:	.BYTE	0	; POSITIONAL ARGUMENT
CA:	.BYTE	0	; COMMAND ARG.
CSR:	.BYTE	0	; CA INTERMEDIATE STORAGE
DS:	.BYTE	0	; DRIVE STATUS
IS:	.BYTE	0	; INTERFACE STATUS
RETRY:	.BYTE	0	; INTERNAL RETRY LITERAL
DRETRY:	.BYTE	0	; DYNAMIC RETRY COUNTER
LRC:	.BYTE	0	; LRC STORAGE
ODS:	.BYTE	0	; OLD DRIVE STATUS
DTLS:	.BYTE	0	; DRIVE/TRK/LED STORAGE
FMFLG:	.BYTE	0	; INTERNAL FMK COORD.
ECODE:	.BYTE	0	; TAPE ERROR CODE STORAGE
VER:	.BYTE	"7"!80H	; VERSION NUMBER
SSAVE:	.WORD	0	; STACK SAVE LOCATION
;
.END
