.TITLE "{MAG-TAPE UTILITY}- REV-{4.x5}" 
.SBTTL "ASSEMBLY CONTROL"
.I8080	; ALLOW ONLY 8080 OPERATORS
.PABS	; ABSOLUTE ASSEMBLY FORMAT
.XLINK	; SUPRESS LINKER DATA
.PHEX	; HEXIDECIMAL OBJECT GENERATION
.XSYM	; DELETE SYMBOL TABLE
.SALL	; INHIBIT MACRO EXPANSIONS
;
;
;
; COPYRIGHT 1979 BY:
;
; ALLOY ENGINEERING COMPANY, INC.
; COMPUTER PRODUCTS DIVISION
; 12 Mercer Road
; Natick, Ma. 01760
; (617) 655-3900
;
;
;        This DOCUMENT contains INFORMATION 
; which is PROPRIETARY to ALLOY ENGINEERING
; COMPANY, INC. REPRODUCTION or USE WITHOUT
; an EXPRESS WRITTEN CONSENT from the ALLOY
; ENGINEERING COMPANY IS PROHIBITED........
;
; DOCUMENT # {FW-100075:MM}
;
.PAGE
.SBTTL "REVISION HISTORY"
;  {REVISIONS:}
;
; REV----DATE----DETAILS
;
; P0   06/05/80  PRELIM ASMBL MODULE BASED ON
;		 FW-100065:MM REV.2.0
; P1   07/31/80  MORE CHANGES BEFORE TEST
; P2   08/04/80  MISC. CHANGES FOR TEST
; P3   08/05/80  CHANGE IGO* CONFIG.
; P4/5 08/11/80  REVERSE SPACE FIXED
; P6   08/12/80  MULTIPLE FILE SEARCH FIX
; A0   08/28/80  CORRECT SPACE ALG'S
; A1   08/28/80  DITTO ABOVE
; A2   09/10/80  VARIOUS FUNCTIONAL UPDATES
;		 AS PER OSTU REV. B1
; 3.0  09/10/80  'TIP' VERSION 
;		 INCLUDES ALLOY SPECIFIC EQUATE MODS
;		 AND SETTING S TO 0FFH ON INITIALIZATION
; 3.1  09/11/80  SUPPORT VARIABLE RECORD LENGTHS
; 3.2  09/18/80  INVERT DATA IN WRITE ROUTINE
; 3.21 10/19/80  PROVIDE FOR VARIED REC SIZE & LOC
; 3.22 12/24/80  FIX REC LOC DEFAULT SET ON INIT
; 3.23 03/12/81  FIX SDAT IGO* EQUATE 3.35+ CHANGE
; 4.x0 03/27/81	 MAKE TIP 4.0 COMPATIBLE, FIX ERROR
;		 REPORTING FROM CWEN, RELOCATE CODE
; 4.x1 06/10/81  FIX MDS NOT TO ABORT WITH 00 ERROR
;		 DON'T WAIT FOR REWIND TO COMPLETE
;		 BEFORE EXIT. NO REWIND IF BOT.
; 4.x2 06/23/81  ADD VARIABLE LENGTH READ COMMAND,
;		 TERMINATE SHORT RECORD WITH ^Z,
;		 MISC. FUNCIONAL UPDATES.
; 4.x3 06/26/81	 ALTER VAR LEN READ COMMAND
; 4.x4 07/06/81	 INCREASE MAX REC LENGTH TO 32K
;		 FOR VARIABLE LENGTH READ
.PAGE
.SBTTL "MISC EQUATES AND MAPPING"
;---- UNIQUE INSTRUCTIONS ----
;
.DEFINE CLA=[.BYTE 0AFH]
	; CLEAR ACCUMULATOR (XRA A)
;
;
;---- ALLOY SPECIFIC EQUATES ----
;
ATU	=1800H	; CIPHER TAPE UTILITY
		; PROGRAM START ADDR.
;
P	=\"I/O PORT GROUP?"
		; (16 LONG)
;
R.MBA	=2900H	; MASK BUFFER AREA
R.MBL	=16	; MASK BUFFER LENGTH
;
R.DBA	=3000H	; DATA BUFFER AREA
R.DBL	=8208	; DEFAULT DATA BUFFER LENGTH
		; (SET ON CALL TO INIT.)
;
;
;---- COMMAND EQUATES ----
;
C.RFR	=0H	; READ FORWARD RECORD
C.RRR	=1H	; READ REVERSE RECORD
C.RRE	=09H	; READ REVERSE EDIT
C.WFR	=2H	; WRITE FORWARD RECORD
C.WFE	=0AH	; WRITE FORWARD EDIT
C.WFM	=6H	; WRITE FILE MARK
C.EVL	=12H	; ERASE VARIABLE LENGTH
C.EFL	=16H	; ERASE FIXED LENGTH
C.EAL	=1EH	; ERASE ALL LENGTH TO EOT
C.SFR	=10H	; SPACE FORWARD RECORD
C.SRR	=11H	; SPACE REVERSE RECORD
C.SFF	=14H	; SPACE FORWARD FILE
C.SRF	=15H	; SPACE REVERSE FILE
;
RCNT	=8	; WRITE RETRY COUNT+1
RRCNT	=16	; READ RETRY COUNT
;
;
.REMARK	"
	THIS PROGRAM CONFORMS TO THE SPECIFICATIONS
OF THE 'ALLOY TAPE UTILITIES'.  PLEASE REFER TO
THIS DOCUMENT FOR FURTHER INFORMATION" 
.PAGE
.SBTTL "{ERROR CODES}"
.REMARK " WHEN THE SUBROUTINES RETURN TO THE CALLER,
  THE (B) REGISTER CONTAINS INFORMATION RELATED TO
  THE SOURCE OF THE ERROR.  THIS ERROR CODE IS VALID
  ANY TIME THE SUBROUTINE RETURNS WITH THE (CY) SET."


;---- ERROR CODES FOLLOW: (B) ----
;
;**** CODES 0-3 WILL "ABORT WITHOUT MOTION" ****
;
E0	=0	; WARNING-- SELECTED DRIVE HAS
		; EXECUTED AUTO-REWIND SEQUENCE
		; SINCE PREVIOUS INIT OR REWIND
		; CMD. ISSUE REWIND TO CLEAR.
;
E1	=1	; WRITE OPERATION REQUEST TO A
		; WRITE-PROTECTED DRIVE.
;
E2	=2	; CMD. TO NON-PRESENT DRIVE OR
		; DRIVE WITH CARTRIDGE REMOVED.
;
E3	=3	; DRIVE FAILED TO RESPOND TO THE
		; REQUESTED COMMAND. I.E. BACK-
		; SPACE AT BOT ETC.
;
;**** CODES 6-13 WILL "ABORT WITH MOTION" ****
;
E6	=6	; FILE-MARK VERIFICATION FAILURE
		; AFTER WRITING IT.
;
E7	=7	; TRANSPORT ABORT PRIOR TO COMMAND
		; COMPLETION. I.E. SKIP RECORD ON
		; BLANK TAPE
;
E8	=8	; READ FAIL- MISSING DATA OR FMK.I.D.
;
E9	=9	; READ FAIL- BAD LRCC
;
E10	=10	; READ FAIL- SHORT RECORD ERROR
;
E11	=11	; READ FAIL- BAD VERTICAL PARITY
;
E12	=12	; WRITE FAIL- R-A-W VERIFY ERROR
;
E13	=13	; WRITE FAIL- IDBY LOST BEFORE
		; WRITE OPERATION COMPLETE.
;
;**** CODE 14 WILL REPORT A FILE MARK ****
;
E14	=14	; READ FAIL- FILE MARK DETECTED
.PAGE
.SBTTL "{I/O ASSIGNMENTS}"
ISTAT	=P+0	; INPUT TAPE STATUS  
;	
; NOTE: L=LATCHED STATUS CLEARED BY OTCLR
;
;	B0-	IONL	; DRIVE IS ON-LINE
;   L 	B1-	IFMK   	; FILE MARK DETECTED
;	B2-	IREW	; DRIVE IS REWINDING
;	B3-	IFPT	; FILE IS PROTECTED (SAFE)
;	
;   L	B4-	IHER	; HARD ERROR WAS DETECTED
;   L	B5-	IEOT	; END OF TAPE
;	B6-	ILPT	; TAPE AT LOAD-POINT AREA
;	B7-	IRDY	; TAPE UNIT IS READY
	;
IMSR	=P+1	; INPUT MISC. STATUS REG. 
;
;	B0-B3	NOT ASSIGNED
;
;	B4-	TAPE DATA BUSY    (IDBY)
;	B5-	FORMATTER IS BUSY (IFBY)
;	B6-	DATA TO   TAPE BUFFER FULL
;	B7-	DATA FROM TAPE BUFFER FULL
;
	;
OCEOF 	=P+2	; CLEAR EOF STATUS
;
;	NOTE: SEE EQUATES PAGE FOR COMMANDS
	;
ORWD	=P+3	; REWIND SELECTED DRIVE
	;
OCONT	=P+4	; OUTPUT CONTROL
;
;	NOTE: THE SENSE OF THESE BITS IS LOW=TRUE
;
;	B0-	LED1*	; 
;	B1-	LED2*	; 
;	B2-	LED3*	; 
;	B3-	ITAD1*	; LOW  = DRIVE 1
			; HIGH = DRIVE 0
;	B4-	ILWD*	; LAST WRITE WORD
;	B5-	IFAD*	; FORMATTER ADDR.
;	B6-	IGO*	; GO COMMAND TO FORMATTER
;			;  BASED ON DATA IN OTDAT
;	B7-	IDEN*	; SELECT HIGH SPEED/DEN
.PAGE
OTDAT	=P+5	; OUTPUT DATA TO TAPE
;
;	NOTE: THE SENSE OF THESE BITS IS LOW=TRUE
;	NOTE: THE INVERSE OF THE TAPE COMMAND IS
;		ALSO SET BY THIS CMD INTO THE LOW
;		ORDER 5 BIT OF THE LATCH.
	;
ITDAT	=P+6	; INPUT TAPE DATA
;
; 	NOTE: THE SENSE OF THESE BITS IS LOW=TRUE
	;
OTCLR	=P+7	; OUTPUT TAPE CLEAR
;
;	CLEARS:	ITDAT FULL
;		OTDAT FULL
;		IHER & IEOT F/F'S
;		PULSES IFEN*
.PAGE
.SBTTL "{MTU PROGRAM ENTRY}"
;**************************************************
	.LOC	ATU
;
; NOTE: SET-UP MA/PA/CA PRIOR TO CALL
;	ALL PRIMARY REGISTERS SAVED U USED
;       BUT RESTORED ON RETURN
;
ATUS:	PUSH	PSW	; SAVE CALLING REG'S
	PUSH	B
	PUSH	D
	PUSH	H
	LXI	H,0	; SAVE CURRENT STACK LOC
	DAD	SP	;  IN CASE OF TROUBLE
	SHLD	SSAVE
;
	LDA	CA	; GET THE REQUESTED CMD.
	STA	CSR	; SAVE FOR COORDINATION
	ANI	17H	; STRIP TO ACTUAL CMD
	ANI	10H	; CHECK IF "RESET COMMAND"
	CNZ	INIT	; GO DO TAPE INIT THINGS
;
;---- HERE WE CHECK IF RE-TRANSMIT COMMAND ----
;
SAP:	LDA	CA	; GET THE COMMAND
	ANI	7FH	; CHECK IF RE-TRANSMIT
	JZ	RTRAN	; IF SO, JUST DO IT
;
;---- HERE WE PRE-PROCESS MA ----
;
	LDA	MA	; GET CALLING MODE ARGUMENT
	ANI	8FH	; REMOVE TRANSIENT BITS
	ORI	80H	; SET DRS-232 COMPATIBLE BIT
	STA	IS	; SAVE INITIALIZED ISW
	MVI	A,80H	; GET NAKED DRIVE STATUS
	STA	DS	; SAVE INITIALIZED DSW
;
;---- HERE WE SELECT THE DRIVE & TRACK ----
;
	LDA	MA	; SET DRIVE & TRACK
	MOV	B,A
	CALL	SDAT	
;
;---- HERE WE PRE-PROCESS CA ----
;
	LDA	CA	; GET THE COMMAND
	MOV	B,A	; SAVE FOR LATER
;
;---- HERE WE INIT THE RETRY COUNT ----
;
	ANI	20H	; CHECK AUTO-REWRITE BIT
	MVI	A,RCNT	; IF FALSE, DONT'T DISABLE 
	JZ	..B
	SUI	RCNT-1	; SET RETRY TO 1
..B:	STA	RETRY
.PAGE
;---- HERE WE DECODE THE SPECIFIED COMMAND ----
;
	MOV	A,B	; GET COMMAND
	ANI	40H	; RELATIVE TO BOT?
	JZ	..C	; IF NOT, NO REWIND
	CALL	REWIND	; IF SO, REWIND
	JC	ABORT	; CHECK ABORT CAUSE & REPORT
..C:	LDA	CA	; GET COMMAND BACK
	MOV	B,A	; STORE FOR LATER
	ANI	80H	; CHECK RESERVED COMMAND
	JNZ	RDIAG	; GO DO RAM DIAGNOSTIC READ
	MOV	A,B	; GET CA BACK
	ANI	0FH	; MASK DOWN TO COMMAND
	JZ	NOC	; IF ZERO, GO SET THAT FLAG
	CPI	8	; CHECK EXTENDED COMMAND BIT
	JNC	EXT	; IF SET, GO EXTEND
	DCR	A	; READ?
	JZ	RR  	; IF SO, GO READ
	DCR	A	; WRITE?
	JZ	WR	; IF SO, GO DO THAT
	DCR	A	; WRITE FILE MARK?
	JZ	WFMR	; IF SO, GO DO THAT
;
;-- HERE IS LOW SPEED COMMAND 4-7 DISPATCH ----
;
JTRLS:	MVI	D,0FFH	; SET FOR LOW SPEED
;
;---- HERE WE DISPATCH ON CMD 4-7 ----
;
JTR:	LXI	H,SRET	; GET RETURN ADDR FOR SUBS
	PUSH	H	; SAVE AS RETURN PC
	LDA	PA	; GET POSITIONAL ARGUMENT
	MOV	C,A	; PUT IN C IN CASE IT'S USED
	MOV	A,B	; GET THE COMMAND BYTE
	ANI	7	; MASK TO COMMAND PROPER
	CPI	6	; CHECK IF FORWARD OR REVERSE
	MOV	A,D	; GET SPEED CALLING ARGUMENT
	JC	SRF	; DO FORWARD ON 4 OR 5
	JMP	SRR	; DO REVERSE ON 6 OR 7
;
;---- HERE WE RETURN FROM CMD 3-7 ----
;
SRET:	JC	ABORT	; GO SORT OUT REASON ABORTED
;
;---- FALL INTO TRANSMIT ROUTINE ----
.PAGE
.SBTTL "{TRANSMIT} DATA CIRCUIT"
;---- HERE WE DEVELOP THE DS WORD ----
;
CPRA:	LDA	DS	; GET THE DS WORD
	MOV	B,A	; SAVE FOR LATER USE
	IN	ISTAT	; GET TAPE STATUS
	RRC
	RRC
	RRC
	ANI	1FH	; ISOLATE DEI USABLE BITS
	XRI	1	; INVERT FPT TO COMPATIBLE
	ORA	B
	STA	DS	; SAVE DRIVE STATUS
	STA	ODS	; SAVE AS OLD DRIVE STATUS
;
;---- WE ENTER HERE TO EXIT TO MAIN CALLER ----
;
RTRAN:	LDA	CSR	; GET SAVE CA VALUE
	STA	CA	; RESTORE CALLERS'
	LHLD	SSAVE	; RESTORE STACK -IN CASE
	SPHL
	POP	H	; AND ALL REG'S
	POP	D
	POP	B
	POP	PSW
	RET		; RETURN TO MAIN PROGRAM
.PAGE
.SBTTL "{EXTENDED} COMMAND ROUTINES"
;---- EXTENDED COMMAND HANDLER ----
;
EXT:	ANI	7	; MASK TO COMMAND PROPER
	JZ	WRRS	; WAIT READY & SEND DS/IS
			;   ON ZERO COMMAND
	CPI	4	; SEE IF HSPD SEARCH
	JC	..A	; IF NOT, GO SEE WHAT
	LDA	PA	; GET THE POSITIONAL ARG.
	ORA	A	; SET THE PSW BITS
	JZ	JTRLS	; GO SET LOW SPEED ON
			;  SINGLE SEARCH
..B:	MVI	D,0FBH	; SET HSP* TRUE
	JMP	JTR	; AND GO CALL THE ROUTINES
;
;---- CHECK IF COPY/MASK OR VARIABLE LENGTH READ ----
;
..A:	DCR	A	; CHECK IF COPY COMMAND
	JZ	SRE	; IF SO, SEND SYNTAX REJECT
	DCR	A	; CHECK IF VAR LEN READ
	JZ	VLR	; IF SO, GO DO IT
	JMP	MDS	; IT MUST BE MASK-SEARCH
;
;
VLR:	LXI	H,8000H	; SET DEFAULT RECORD LENGTH
			;  AS 32K, IS LARGEST ALLOWED
	SHLD	WRDCNT
	MVI	A,1	; DO THE READ
	CALL	RRS
	JNC	..A	; CONT IF NO ERRORS
	MOV	A,B	; GET THE ERROR CODE
	CPI	E10	; SHORT RECORD ERROR?
	JNZ	ABORT	; ERROR IF ANYTHING ELSE
..A:	MOV	A,E	; DE CONTAINS NUMBER OF WORDS
	CMA		; LEFT TO READ - COMPLAMENT THIS VALUE
	MOV	E,A
	MOV	A,D
	CMA
	MOV	D,A
	INX	D
	LHLD	WRDCNT	; THEN ADD TO TOTAL NUMBER
	DAD	D	;  OF WORDS TO HAVE READ
			;  TO OBTAIN NUMBER READ
	SHLD	WRDCNT	; SAVE AS BUFFER LENGTH
	JMP	CPRA	; THEN EXIT NORMAL
.PAGE
.SBTTL "{MASK} ROUTINES"
;---- MASK DATA SEARCH ROUTINE ----
;
MDS:	MVI	A,RCNT	; GET RETRY CONSTANT
	CALL	RRS	; GO READ A RECORD
	JC	ABORT	; IF ERROR, ABORT/ATTMT
	LXI	H,R.DBA	; SET PTR TO RECORD
	LXI	D,R.MBA	; AND ONE TO MASK
..A:	LDAX	D	; GET MASK CHAR
	MOV	B,A	; SAVE THIS
	CPI	"?"	; IS IT A "?"?
	JZ	..B	; IF SO, IT MATCHES
	MOV	A,M	; GET CHARACTER FROM REC
	ANI	07FH	; CONSIDER ON LS 7 BITS
	CMP	B	; COMPARE WITH MASK CHAR
	JNZ	MDS	; GET NEXT REC. ON NO MATCH
..B:	INX	D	; INC TO NEXT BYTE
	INX	H
	LXI	B,R.MBA+R.MBL ; FETCH END MARKER
	MOV	A,C	; GET LS BYTE
	CMP	E	; COMPARE TO DYNAMIC
	JNZ	..A	; LOOP IF NOT EQUAL
	MOV	A,B	; GET MS BYTE
	CMP	D	; COMPARE TO DYNAMIC
	JNZ	..A	; LOOP TILL EQUAL
	JMP	CPRA	; GO SEND ON MATCHING REC.
.PAGE
.SBTTL "MISC. {STANDARD} COMMAND ROUTINES"
;---- NOP ROUTINE ----
;
NOC:	LDA	DS	; GET DRIVE STATUS
	ORI	20H	; SET REWIND FLAG
	STA	DS
	JMP	CPRA	; AND EXIT
;
;---- HERE IS RECORD/WRITE CALLER ----
;
WR:	IN	ISTAT	; GET DRIVE STATUS
	ANI	20H	; CHECK IF EOT/EARLY WARNING
	JNZ	..A	; CHECK IF PREVIOUS REPORT
..B:	LDA	RETRY	; GET SPECIFIED RETRY COUNT
	CALL	WRS	; CALL WRITE/RETRY
	JC	ABORT	; ABORT IF ERROR
	JMP	CPRA	; SEND & PROCESS
..A:	LDA	ODS	; GET OLD DRIVE STATUS
	ANI	20H	; WAS EWS REPORTED?
	JNZ	AWOA	; IF SO, SIGNAL ABORT
	JMP	..B	; IF NOT, LET IT RIDE
;
;---- HERE IS RECORD/READ CALLER ----
;
RR:	MVI	A,RRCNT	; GET RETRY CONSTANT
	CALL	RRS	; CALL READ/RETRY
	JC	ABORT	; ABORT IF ERROR
	JMP	CPRA	; SEND IF DATA
;
;---- HERE IS THE WRITE FILE MARK CALLER ----
;
WFMR:	LDA	RETRY	; GET SPECIFIED RETRY COUNT
	CALL	WFMRS	; CALL WFMK/RETRY SUB.
	JC	ABORT	; LET ABORT HANDLE ERRORS
	JMP	CPRA	; GO SEND & PROCESS
.PAGE
.SBTTL "{WRITE & WFM/RETRY} SUBROUTINES"
;---- HERE IS THE WRITE/RETRY SUBROUTINE ----
;
;---- 	CALL	A= RETRY COUNT
;	RET	CY=1 IF ABORT B= ABORT CODE
;
;
WRS:	STA	DRETRY	; MOVE TO DYNAMIC COUNTER
..A:	CALL	WRITE	; TRY TO WRITE PROPER
	RNC		; RETURN IF NO ERROR
	LDA	DRETRY	; GET DYNAMIC RETRY COUNTER
	DCR	A	; DEC RETRY
	RZ		; ABORT. CY=1
	STA	DRETRY	; RESTORE UPDATED RETRY COUNT
	CALL	CLRTP	; ELSE CLEAR TAPE
	IN	ISTAT	; GET TAPE STATUS
	ANI	20H	; CHECK EWS STATUS
	STC		; SET ABORT JUST IN CASE
	MVI	B,1	;   WITHOUT ATTEMPT SIGNAL
	RNZ		; ABORT IF EWS PRESENT
	JMP	..A	; IF NOT, TRY AGAIN
;
;
;---- HERE IS THE WFM/RETRY SUBROUTINE ----
;
;---- 	CALL	A= RETRY COUNT
;	RET	CY=1 IF ABORT B= ABORT CODE
;		FMK STATUS SET IN DSW IF OK.
;
;
WFMRS:	STA	DRETRY	; MOVE TO DYNAMIC COUNTER
..A:	CALL	WFM	; TRY TO WRITE FMK PROPER
	RNC		; RETURN ON NO ERRROR
	LDA	DRETRY	; GET DYNAMIC RETRY COUNTER
	DCR	A	; DEC RETRY
	RZ		; ABORT. CY=1
	STA	DRETRY	; RESTORE UPDATED RETRY COUNT
	CALL	CLRTP	; ELSE CLEAR TAPE
	JMP	..A	; AND TRY AGAIN
.PAGE
.SBTTL "{READ/RETRY} SUBROUTINE"
;----	CALL	A= RETRY COUNT
;	RET	CY=1 IF ABORT EXCEPT FMK. B=CODE
;		NON-ZERO IF FMK
;		DSW/ISW SET FOR DATA BLOCK/FMK ETC.
;	
RRS:	STA	DRETRY	; SET IN DYNAMIC COUNTER
RR.A:	CALL	READ	; DO ACTUAL READ
	JC	..B	; IF ERROR, HANDLE IT
	LDA	IS	; GET INTERFACE STATUS
	ORI	40H	; SET DATA BLOCK FOLLOWS
	STA	IS
	CLA		; NO FMK, SO CLEAR ZERO
	RET		; RETURN
;
..B:	MOV	A,B	; GET THE ERROR CODE
	CPI	14	; WAS IT FMK DETECTED?
	STC		; SET CARRY FOR RETURN
	RZ		; IF SO, RETURN WITH IT
;
;---- HERE ERROR, SO CLEAR TAPE AND TRY AGAIN ----
;
RR.C:	STC		; SET CY FOR ABORT
	LDA	DRETRY	; GET DYNAMIC RETRY COUNTER
	DCR	A	; DEC RETRY COUNTER
	RZ		; ABORT. CY=1
	STA	DRETRY	; RE-STORE COUNTER
	MVI	A,6	; AND BACKSPACE
	STA	CA
	MVI	C,0	; ONCE
	MVI	A,0FFH	; AT LOW SPEED
	CALL 	SRR
	JMP	RR.A	; AND TRY AGAIN
;
;---- HERE FOR RAM DIAGNOSTIC READ ----
;
RDIAG:	LDA	IS	; SET DATA FOLLOWS IS ISW
	ORI	40H	
	STA	IS
	JMP	CPRA	; GO SEND THE DATA W/O READ
.PAGE
.SBTTL "{ABORT} ROUTINES"
;---- HERE ON SYNTAX/PARITY ERRORS ----
;
SRE:	LDA	IS	; GET THE ISW
	ORI	30H	; SET SYNTAX/PE BITS
	STA	IS	; SAVE FOR SEND ROUTINE
	CALL	S.L	; SET ERROR LED
TSTAT:	CLA		; CLEAR THE CA TO FAKE
	STA	CA	;   A RE-TRANSMIT
	JMP	SAP	; GO SEND & PROCESS
;
;---- HERE ABORT WITHOUT ANY ATTEMPT ----
;
AWOA:	MVI	B,10H	; SET ABORT WITHOUT ATTEMPT
	JMP	SFL	; GO SET FAULT LED
;
;---- HERE TO DETERMINE IF ATEMPT WAS MADE ----
;---- B REG. = TAPE MODULE ABORT CODE
;
ABORT:	MOV	A,B	; GET THE ABORT CODE
	STA	ECODE	; SAVE FOR CALLER
	CPI	4	; CHECK IF MOTION
	JC	AWOA	; IF <4 THEN NO MOTION
			; IF >4 FALL TO AWA
;
;---- HERE ABORT WITH CONCEIVABLE ATTEMPT ----
;
AWA:	OUT	OTCLR	; CLEAR TAPE UNIT
	MVI	B,20H	; SET ABORT WITH ATTEMPT
;
SFL:	LDA	IS	; GET INTERFACE STATUS
	ANI	0BFH	; CLEAR POSSIBLE BLOCK/FOL.
	ORA	B	; SET ERROR CODE
	STA	IS
	LDA	DS	; GET THE DRIVE STATUS
	ANI	40H	; CHECK IF FMK DET.
	JNZ	CPRA	; IF SO, NO FAULT LED
	CALL	S.L
	JMP	CPRA	; GO EXIT
;
;---- SET FAULT LED ----
;
S.L:	RET		; BACK TO CALLER
.PAGE
.SBTTL "{INIT & REWIND}-PROGRAMS"
;---- HERE WE INIT THE TAPE ----
;
INIT:	OUT	OTCLR	; CLEAR ALL
	MVI	A,0FFH	; IFAD*/ITAD1*
	OUT	OCONT	; SET IN CONTROL LATCH
	OUT	OCEOF	; CLEAR EOF STATUS
	STA	DS	; SET DS TO INDICATE TO TIP
			; THAT WE ARE MTU (AS OPPOSED
			; TO ATU)
	LXI	H,R.DBL	; SET DEFAULT BUFFER LENGTH
	SHLD	WRDCNT
	LXI	H,R.DBA	; SET UP DEFAULT BUFFER AREA
	SHLD	R.AREA
;
;---- NORMAL -OK RETURN FOLLOWS ----
;
EOK:	CLA		; CLEAR (A) & CY
	RET		; RETURN TO CALLER -OK
;
;
;---- HERE TASK IS REWIND CMD. ----
;
REWIND:	CALL	WRDY	; CHECK READY STATUS
	OUT	ORWD	; RWD*
	OUT	OTCLR	; CLEAR BAD STATUS
	OUT	OCEOF	; CLEAR EOF STATUS
	CLA		; EXIT OK
	RET
.PAGE
.SBTTL "{SDAT & CLEAR TAPE}"
;---- SELECT DRIVE AND TRACK ----
;
SDAT:	IN	ISTAT	; GET DRIVE STATUS
	ANI	4	; CHECK REWINDING
	JNZ	SDAT	; LOOP TILL IT COMPLETES
	LDA	MA	; GET MA
	RAL		; ADJUST FOR USE
	ANI	18H	; CHECK DRIVE SELECTION
	CPI	10H	; IF 3 OR 4, SYTAX REJECTION
	JNC	SRE
	XRI	8	; INVERT FOR LATCH
	STA	DTLS	; SAVE THE SELECTION
	ORI	0F7H	; SET FOR SELECT
	OUT 	OCONT	; AND TELL IT TO THE TAPE
	XRA	A	; EXIT OK
	RET
;
;---- CLEAR TAPE GAP PROGRAM ----
;
CLRTP:	CALL	WRDY	; WAIT FOR DRIVE READY
	MVI	A,C.RRE	; DO EDIT SPACE REVERSE
	CALL	DCAC
	CALL	WDONE
	JMP	ERASE	; GO DO ERASE AT CMD. LEVEL
.PAGE
.SBTTL "{WRITE}-RECORD ROUTINE"
WRITE:	CALL	WRDY	; CHECK READY STATUS
	CALL	CWEN	; CHECK WRITE ENABLED
	MVI	A,C.WFR	; GET WRITE RECORD CMD
	CALL	DCAC	; ISSUE CMD. AND CHECK
	LHLD	WRDCNT	; SET THE BUFFER LENGTH
	DCX	H
	XCHG
	LHLD	R.AREA	; DITTO STARTING ADDR.
	JMP	WCKF	; GO LOAD FIRST BYTE
;
;---- WRITE RECORD BODY CIRCUIT ----
;
W.A:	JP	E13E	; IF NO IFBY, ERROR
WCK1:	IN	IMSR	; GET TX FULL
	ADD	A	; MOVE IT TO SIGN BIT
	ADD	A	; MOVE IT TO CY BIT
	JC	W.A	; IF FULL, CHECK IFBY
;
WCKF:	MOV	A,M	; GET BYTE FROM MEMORY
	OUT	OTDAT	; SEND IT
	INX	H	; INDEX NEXT BYTE OF DATA
	DCX	D	; DEC. THE BYTE COUNTER
	MOV	A,D	; CHECK FOR ZERO COUNTER
	ORA	E
	JNZ	WCK1	; LOOP TILL COUNTER IS ZERO
;
;---- SET ILWD WITH LAST BYTE ----
;
WCKL:	IN	IMSR	; GET TX FULL
	ADD	A
	JM	WCKL	; LOOP TILL READY
	MOV	A,M	; GET THE CHARACTER
	OUT	OTDAT	; WRITE IT
	LDA	DTLS	; GET DRIVE SELECT
	ORI	0E7H	; SELECT WITH ILWD*
	OUT	OCONT	; SET IN CONTROL LATCH
	CALL	WDONE	; GO WAIT TILL DONE
	MVI	B,E12	; GET R-A-W CODE IN CASE
	RET		; RETURN TO CALL
;
;---- HERE WE ERROR IF IFBY IS LOST ----
;
E13E:	MVI	B,E13	; GET WRITE FAIL CODE
	STC
	RET		; RETURN A FAILURE
.PAGE
.SBTTL "{READ}-RECORD ROUTINES"
READ:	LHLD	WRDCNT	; GET THE DBUFFER LENGTH
	XCHG
	LHLD	R.AREA	; DITTO STARTING ADDR.
	CALL	WRDY	; WAIT FOR DRIVE READY
	MVI	A,C.RFR	; GET READ COMMAND
	CALL	DCAC	; ISSUE CMD. & CHECK TAKEN
	IN	ITDAT	; FAKE READ TO CLEAR F/F
;
R.A:	IN	IMSR	; CHECK RXRDY
	ADD	A
	JNC	R.B	; NOT FUL, CHECK IFBY
	IN	ITDAT	; READ THE TAPE DATA
	CMA		; INVERT FROM LATCH
	MOV	M,A	; PUT IN RAM
	INX	H	; INC. MEMORY POINTER
	DCX	D	; DECR. THE WORD COUNT
	MOV	A,D	; CHECK FOR ZERO CONDITION
	ORA	E
	JNZ	R.A	; LOOP TILL IT HAPPENS
;
FME:	CALL	WDONE	; WAIT TILL DONE
	RNC		; EXIT IF OK
	IN	ISTAT	; READ THE DRIVE STATUS
	MVI	B,E8	; SET ABORT CODE IN CASE
	ANI	2	; CHECK FMK
	STC		; SET CY FOR ABORT
	RZ		; ABORT IF NOT FMK
FMS:	MVI	B,E14	; GET FMK ABORT CODE
	LDA	DS	; GET DRIVE STATUS
	ORI	40H	; SET FMK BIT
	STA	DS	; RESTORE IT
	STC	
	RET		; EXIT FMK COMPATIBLE
;
R.B:	ADD	A	; MOVE IFBY TO POS BIT
	JM	R.A	; LOOP STILL TRUE
;
;---- HERE FMK OR SHORT RECORD ----
;
	IN	ISTAT	; GET TAPE STATUS
	ANI	2	; CHECK FMK
	JNZ	FMS	; IF SO, GO PROCESS
	MVI	M,1AH	; TERMINATE SHORT REC. 
			; WITH ^Z
	MVI	B,E10	; SIGNAL SHORT RECORD 
	STC
	RET
.PAGE
.SBTTL "{WFM}-&-{ERASE} CIRCUITS"
WFM:	CALL	WRDY	; WAIT FOR DRIVE READY
	CALL	CWEN	; CHECK WRITE ENABLED
	MVI	A,C.WFM	; GET FILE MARK COMMAND
	CALL	DCAC	; ISSUE CMD. AND CHECK
	JMP	FME	; USE COMMON CIRCUIT EXIT
;
;---- ERASE ----
;
ERASE:	CALL	WRDY	; WAIT FOR DRIVE READY
	CALL	CWEN	; CHECK WRITE ENABLED
	MVI	A,C.EFL	; GET FIXED LENGTH ERASE
	CALL	DCAC	; ISSUE CMD. & CHECK TAKEN
	JMP	WDONE	; ALLOW WDONE TO ABORT
.PAGE
.SBTTL "FWD./REV. SPACE CIRCUIT"
;---- SPACE FORWARD ----
;
SRF:	MVI	A,C.RFR	; READ FORWARD RECORD
;
SCMD:	PUSH	PSW	; SAVE A REG
RCMD:	POP	PSW	; GET A REG
	PUSH	PSW	; BUT KEEP IT SAFE
	CALL	DCAC	; ISSUE & CHECK TAKEN
..A:	IN	IMSR	; GET THE STATUS
	ANI	10H	; WAIT IDBY
	JNZ	..B	; IF TRUE, BRANCH
	IN	IMSR	; GET STATUS AGAIN
	ANI	20H	; CHECK IFBY
	JNZ	..A	; IF STILL TRUE, LOOP
	MVI	B,E7	; GET ERROR CODE
	JMP	SEE	; USE POP LEVEL EXIT
..B:	IN	IMSR	; WAIT FOR IDBY FALSE
	ANI	10H
	JNZ	..B	
	LDA	CA	; GET THE CMD
	RRC
	JC	..D	; BRANCH ON FMK TEST
	IN	ISTAT	; GET DRIVE STATUS
	MVI	B,14	; GET ABORT-FMK IN CASE
	ANI	62H	; CHECK FMK/EOT/BOT
	CNZ	FMS	; SET FMK DETECT
	JC	SEE	; ABORT ON ANY OF ABOVE
..E:	MOV	A,C	; GET COUNT
	ORA	A	; CHECK IF 0
	JZ	..C	; IF ZERO, BRANCH
	DCR	C	; DEC THE COUNTER
	JMP	RCMD	; RE-QUEUE THE COMMAND
..C:	POP	PSW	; NORMALIZE THE LEVEL
	CALL	WDONE	; WAIT TILL DONE
	IN	ISTAT	; GET DRIVE STATUS
	ANI	2	; FMK?
	CNZ	FMS	; IF SO, SET FMK FLAG
	JMP	EOK	; EXIT OK
;
..D:	IN	ISTAT	; GET DRIVE STATUS
	ANI	62H	; CHECK FMK/EOT/BOT
	JZ	RCMD	; IF NONE, REQUEUE COMMAND
	ANI	60H	; CHECK EOT/BOT
	MVI	B,E7	; GET EC IN CASE
	JNZ	SEE	; ABORT
	JMP	..E	; IF NOT, CHECK COUNT ETC.
;
;---- SPACE REVERSE ----
;
SRR:	MVI	A,C.RRR	; REVERSE RECORD READ
	JMP	SCMD
.PAGE
.SBTTL "MISC. SUBROUTINES"
;---- HERE WE WAIT FOR OPERATION DONE ----
;
WDONE:	IN	IMSR	; GET MISC DRIVE STATUS
	ANI	20H	; CHECK IFBY
	JNZ	WDONE	; LOOP IF BUSY
	IN	ISTAT	; GET DRIVE STATUS
	ANI	10H	; ISOLATE IHER
	RZ		; IF NONE, EXIT OK
	STC
	RET		; IF SO, SIGNAL ERROR
;
;---- WAIT FOR DRIVE READY ----
;
WRDY:	IN	ISTAT	; GET DRIVE STATUS
	ANI	4	; CHECK REWINDING
	JNZ	WRDY	; LOOP TILL IT COMPLETES
	IN	ISTAT	; GET THE DRIVE STATUS
	ANI	81H	; CHECK RDY + SLD
	CPI	81H
	JNZ	..B	; SIGNAL ERROR
..A:	IN	IMSR	; GET MISC STATUS
	ANI	20H	; CHECK IFBY
	JNZ	..A	; LOOP TILL NOT BUSY
	RET		; RETURN READY AND RAREING
;
..B:	MVI	B,E2	; CMD. TO BAD DRIVE
	JMP	SEE
;
;---- CHECK WRITE ENABLED ----
;
CWEN:	IN	ISTAT	; READ DRIVE STATUS
	ANI	8	; CHECK FILE PROTECTED
	RZ		; RETURN IF OK
	MVI	B,E1	; WRITE NOT ENABLED
	POP	PSW	; SET FOR ERROR RETURN 
;
;---- SUBROUTINE ERROR EXIT ----
;
SEE:	OUT	OTCLR	; CLEAR THE DRIVE
	CALL	DLY2	; DELAY AT LEAST 2 MS.
	POP	PSW	; POP TO CMD. LEVEL
	STC		; SET CY TO SIGNAL ERROR
	RET		; RETURN TO CALLER
;
;---- DRIVE COMMAND AND CHECK ----
;
DCAC:	PUSH	PSW	; SAVE 'A' REG.
	IN	IMSR	; GET THE STATUS
	ANI	10H	; CHECK IDBY
	JNZ	..A	; ERROR IF TRUE
	OUT	OTCLR	; CLEAR MISC. F/F'S
	CALL	D.A	; ALL .25MS SETTLEING
	POP	PSW	; GET A REG BACK
	CMA		; INVERT CMD FOR OUTPUT
	OUT	OTDAT	; LATCH THE ACTUAL CMD
	LDA	CSR	; GET COMMAND
	ANI	0FH	; MASK TO COMMAND ONLY
	CPI	0CH	; HS SEARCH?
	JNC	..B	; IF SO, DO HIGH SPEED
	LDA	DTLS	; GET DRIVE SELECT
	ORI	0B7H	; SET IGO TRUE
	OUT	OCONT
	ORI	040H	; SET IGO FALSE
..C:	OUT	OCONT
	NOP		; DELAY FOR SLEW
	IN	IMSR	; GET DRIVE STATUS
	ANI	20H	; CHECK IFBY
	RNZ		; RETURN TO CALLER -OK
..A:	POP	PSW	; POP TO SUB. LEVEL
	MVI	B,E3	; DRIVE -CMD. REJECTED
	JMP	SEE	; ERROR SIGNAL ETC.
;
;---- HIGH SPEED COMMAND ISSUE ----
;
..B:	LDA	DTLS	; GET DRIVE SELECTION
	ORI	37H	; IGO+IHISP TRUE
	OUT	OCONT
	ORI	40H	; IHISP TRUE ONLY
	JMP	..C	; GO ISSUE COMMAND
;
;---- DELAY 2 MILLI-SECONDS ----
;
;-- ASSUMES 4MHZ Z-80 -NO WAIT STATES
;
DLY2:	MVI	A,205	; GET 39 STATE CONSTANT
D.A:	NOP		; KILL 9.75 MICRO-SECS.
	NOP
	NOP
	NOP
	NOP
	DCR	A
	RZ
	JMP	D.A
;
;---- DELAY 0.5 MILLISECONDS ----
;
DLY.5:	MVI	A,52	; GET CONSTANT FOR .5 MS.
	JMP	D.A	; USE ABOVE CIRCUIT TO TIME
;
;
;---- WAIT READY AND RETURN CURRENT STATUS ----
;
WRRS:	CALL	..A	; LOWER PGM LEVEL FOR ABORT
	JC	AWOA	; IF ABORT, SIGNAL SAME
	JMP	CPRA	; SENT CURRENT DRIVE STATUS
;
..A:	CALL	WRDY	; WAIT FOR DRIVE READY
	CLA		; CLEAR CY FOR RETURN
	RET		; RETURN TO PSEUDO CALLER
.PAGE
.SBTTL	"{RAM VARIABLES}"
;*****************************************************
	.LOC	ATU+76CH
;
;---- RESERVED RAM ----
;
R.AREA:	.WORD	R.DBA	; READ/WRITE RECORD AREA-START
WRDCNT:	.WORD	R.DBL	; READ/WRITE RECORD SIZE-BYTES
MA:	.BYTE	0	; MODE ARGUMENT
PA:	.BYTE	0	; POSITIONAL ARGUMENT
CA:	.BYTE	0	; COMMAND ARG.
CSR:	.BYTE	0	; CA INTERMEDIATE STORAGE
DS:	.BYTE	0	; DRIVE STATUS
IS:	.BYTE	0	; INTERFACE STATUS
RETRY:	.BYTE	0	; INTERNAL RETRY LITERAL
DRETRY:	.BYTE	0	; DYNAMIC RETRY COUNTER
LRC:	.BYTE	0	; LRC STORAGE
ODS:	.BYTE	0	; OLD DRIVE STATUS
DTLS:	.BYTE	0	; DRIVE/TRK/LED STORAGE
FMFLG:	.BYTE	0	; INTERNAL FMK COORD.
ECODE:	.BYTE	0	; TAPE ERROR CODE STORAGE
VER:	.BYTE	"5"	; VERSION CODE FOR TIP MENU
SSAVE:	.WORD	0	; STACK SAVE LOCATION
;
.END








