TITLE	SETCLK.ASM	3-27-86

;This software may be freely ditributed and no charge shall
;be made by anyone for its use or distribution except for
;a copying charge.

;This program sets the Leading Edge Model-M battery backed-up clock
;when using DOS 3.xx

;The main purpose is to avoid having to boot-up under DOS 2.11 in
;order to set the battery backed-up clock with its DATE and TIME
;commands.  Use this utility instead.  Assemble, link and then
;convert to a .COM file with EXE2BIN.
;                              		-done by Bob Plouffe
;					CompuServe: 70220,113
;					Fido: Net 109, node 404
;					PLOUFF at MIT-MC.ARPA
;					GENIE: RPLOUFFE
;
;*****************************************************************
;
;The program uses an undocumented feature of the Leading Edge Model M
;ROM Bios.  The Time-of Day interrupt (INT 1AH) has four additional
;functions beyond that of the IBMPC ROM Bios.  (See the IBM code for
;INT 1AH in the IBM Technical Reference Manual.  Note that this function
;allows the current clock [DOS clock] to be set/read for AH=1/0 upon
;entry)  For the Leading Edge, Model M, this interrupt can also 
;set/read the date/time of the on-board battery backed-up clock. Entry
;and return of CX/DX registers is the same as for the DOS function
;calls with INT 21H for AH=2AH through 2DH except that CX sets/returns
;an offset from the year 1980 (07cbh).  The following AH reg entry
;values accomplish the described functions:

;		AH=2	Read the time from the battery backed-up clock.
;		AH=3	Set the time into the     "	 "         "
;		AH=4	Read the date from the	  "      "         "		
;		AH=5	Set the date into the     "      "         "

;*****************************************************************
;Equates
	cr		equ	0dh
	lf		equ	0ah

;INT 10H video	functions
	set_cursor	equ	2
	scroll_up	equ	6

;INT 1AH function calls - peculiar to Leading Edge, Model M
	set_btime	equ	3	;       "
	set_bdate	equ	5	;for battery clock

;INT 21H Dos function calls
	print_str	equ	09h	;print string function
	kbdbuf_in	equ	0ah	;buffered kbd input
	set_cdate	equ	2bh	;for current clock
	set_ctime	equ	2dh	;       "

;**********************************************************

setclk		segment		;the program itself

;-----------------------------------------------------------

main	proc	far

	assume cs:setclk, ds:setclk, es:setclk, ss:setclk

	org	100h

;clear the screen

begin:	mov	ah,scroll_up
	mov	al,0			;to blank entire window
	mov	ch,0			;upper left row,
	mov	cl,0			;....column
	mov	dh,24			;lower right row,
	mov	dl,79			;....column
	mov	bh,7			;attribute used on blank line
	int	10h			;clear the screen
	;
	;set cursor postion for sign-on
	mov	ah,set_cursor		
	mov	dh,3			;row
	mov	dl,11			;column
	mov	bh,0			;page
	int	10h			;set the cursor
	;
	mov	ah,print_str
	lea	dx,sign_on
	int	21h			;give the sign-on message
get_date:
	call	flush_buf
	;
	;clear any entry
	mov	ah,scroll_up
	mov	al,0			;clear to end of line
	mov	ch,7
	mov	cl,43
	mov	dh,7
	mov	dl,79
	mov	bh,7
	int	10h
	;
	;set cursor to prompt beginning
	mov	ah,set_cursor		
	mov	dh,7			;row
	mov	dl,15			;column
	mov	bh,0			;page
	int	10h			;set the cursor
	;
	mov	ah,print_str
	lea	dx,date_msg
	int	21h			;ask him for date
	;
	mov	ah,kbdbuf_in
	lea	dx,inbuff
	int	21h			;get answer in buffer
	;
	call	prochar			;process the characters
	jz	get_time		;
	lea	bx,ys1
	mov	al,[bx]
	sub	al,8
	jnc	skip3
	mov	al,[bx]
	add	al,2
skip3:	mov	[bx],al		;yr x10 now adj as offset from 1980

;first, set up the year parameters in CX
	mov	bl,0ah			;x10 multiplier
	mov	al,byte ptr ys1		;get 10's digit for Yr.
	mul	bl			;multiply by 10
	add	al,byte ptr ys2		;add Yr units to AL
	mov	ah,0			;zero the high byte
	mov	cx,ax			;
	;CX now contains the year parameters

;now set up the Month/Day parameters in DX
	mov	al,byte ptr mh1		;get the 10's digit for month
	mul	bl			;multiply x10
	add	al,byte ptr mh2		;add the units digit to AL
	mov	dh,al			;put Month data in DH
	mov	al,byte ptr dm1		;get the 10's digit for Day
	mul	bl			;multiply by 10
	add	al,byte ptr dm2		;add the units digit for Day
	mov	dl,al			;put day data in DL
	;DX now contains the Month/Day parameters

	;enter with CX = year offset from 1980
	;...and DX = Month/Day
	push	cx
	add	cx,07bch		;add initial year - 1980
	mov	ah,set_cdate		;prepare to set the date
	int	21h			;do it to current clock
	pop	cx
	or	al,al
	jnz	get_date
	mov	ah,set_bdate		;to set date
	int	1ah			;..of battery clock


get_time:
	call	flush_buf		;flush the input buffer
	;
	;clear any entry
	mov	ah,scroll_up
	mov	al,0			;clear to end of line
	mov	ch,9
	mov	cl,43
	mov	dh,9
	mov	dl,79
	mov	bh,7
	int	10h
	;
	;set cursor to prompt beginning
	mov	ah,set_cursor		
	mov	dh,9			;row
	mov	dl,15			;column
	mov	bh,0			;page
	int	10h			;set the cursor
	;
	mov	ah,print_str
	lea	dx,time_msg		;ask for the time
	int	21h
	mov	ah,kbdbuf_in
	lea	dx,inbuff		;get the input
	int	21h
	call	prochar			;process the characters
	jz	done			;

;set up the time parameters in CX/DX
;first, set up the Hour/Minutes in CX
	mov	al,byte ptr mh1		;get the 10's digit for hours
	mov	bl,0ah			;to multiply by 10
	mul	bl			;multiply AL by 10
	add	al,byte ptr mh2		;add the Hr units digit
	mov	ch,al			;put it in CH
	mov	al,byte ptr dm1		;get mins. 10's digit
	mul	bl			;multiply by 10
	add	al,byte ptr dm2		;add the mins. unit digit to AL
	mov	cl,al			;put it in CL
	;CX now contains the Hours/Minutes data

;now set up the Seconds in DX
	mov	al,byte ptr ys1		;get the 10's digit
	mul	bl			;x 10
	add	al,byte ptr ys2		;add the units
	mov	dh,al			;put in DH
	mov	dl,0			;zero DL (seconds/100)
	;DX now contains Seconds data

	;enter with CX = Hours/Minutes
	;......DX = Seconds/Hundredths 
	mov	ah,set_ctime		;prepare to set time
	int	21h			;do it to current clock
	or	al,al			;see if a valid time
	jnz	get_time		;if not, try again
	mov	ah,set_btime		;set the time
	int	1ah			;...for battery clock

	;close up shop and return

done:	int	20h			;return to DOS

	;we are done.

main	endp


;**********************************
;Sub-routines
;
;Process the entered characters to make them hex binary.
;leave 0 entry positions alone. Returns with the z flag
;set if first position in the buffer is a carriage return

prochar	proc	near
	lea	bx,inbuff
	mov	cl,[bx]
	dec	cl
	mov	ch,0
	inc	bx
asci2hex:
	inc	bx
	mov	al,[bx]
	cmp	al,0
	jz	skip1
	sub	byte ptr [bx],30h
skip1:	loop	asci2hex
	lea	bx,inbuff+1
	mov	al,[bx]
	or	al,al
	ret
prochar	endp
;-----------

;Subroutine to flush the input buffer
flush_buf proc	near	
	lea	bx,inbuff+1
	mov	cx,000ah
	mov	al,0
flush:	mov	byte ptr [bx],al
	inc	bx
	loop 	flush
	ret
flush_buf endp

;***************************************************************
;Data
;
;Messages
sign_on    db	'Program to set the battery backed-up clock',cr,lf
	   db   '             for the Leading Edge, Model M computer.$'
date_msg   db	'Enter new date, (mm-dd-yy): $'
time_msg   db	'Enter new time, (hh:mm:ss): $'

;Input buffer
inbuff	 	db	09h	;max length of buffer
		db	0	;number of characters entered	
mh1		db	0	;for mo x10 or hrs x10
mh2		db	0	;for mo x1 or hrs x1 
		db	"-"	;separator
dm1		db	0	;for day X10 or mins x10
dm2		db	0	;for day x1 or mins x1
		db	"-"	;separator
ys1		db	0	;for yr x10 or secs x10
ys2		db	0	;for yr x1 or secs x1
		db	0	;terminator

;
;-------------------------------------------------------

	setclk	ends

;********************************************************

end	begin
