;************************************************************************;
;*									*;
;*		Intel Corporation Proprietary Information		*;
;*									*;
;*	 This  source  is  supplied  under  the  terms  of  a  license  *;
;*  agreement or  non-dislosure statement  with the  Intel Corporation  *;
;*  and may not be copied nor disclosed except in accordance with  the  *;
;*  terms of that agreement.                                            *;
;*									*;
;************************************************************************;
        name cstart

;************************************************************************;
;*									*;
;*	This source file is a sample start-up code. This code can be	*;
;*  tailored differently according to the needs of the user, and the	*;
;*  environment under which the application will run.			*;
;*									*;
;************************************************************************;

;************************************************************************;
;*  Following are the Macros supplied to aid in initializing data	*;
;*  in ROMable systems. See Appendix D in the C386 User's Manual	*;
;************************************************************************;
%*define(_string(s)) local label(
%label:
	db	'%s',0
	org	offset $ + (LONGEST - (offset $ - offset %label))
)

%*define(move_rom(source,target,count)) (
	mov	ecx,%count		; Load count into ecx
	mov	edi,offset %target	; Load target offset into edi
	mov	esi,offset %source	; Load source offset into esi
	call	move_			; Call move_ to do the moving.
)

%*define(leave_space(amount)) (
	org	offset $ + %amount
)

%*define(cstring_pointer(base,number,length)) local label
(
	mov	ecx, %number		; Load number of entries
%label: lea	eax, [ecx-1]
	imul	edx, eax, %length	; edx = offset of string
	add	edx, offset %base + (%number*4)  ;offset of text from base
	mov	dword ptr %base [eax*4], edx	; place address in table
	loop	%label			; Loop through all entries
)

%*define(move_) (
move_:	push	ds
	mov	ax,ds
	mov	es,ax           ; target selector
	mov	ax,cs
	mov	ds,ax           ; source selector
	cld
	rep	movsb           ; doit
	pop	ds
	ret
)

;************************************************************************;
;*  Declarations of the DATA segment variables				*;
;************************************************************************;
	assume	ds:data
data	segment rw public
	public	__argc, __argv
__argc  dd	(?)			; receives number of parameters
__argv  dd	32 dup (?)		; maximum 32 parameters
data	ends

;************************************************************************;
;*  Declarations of the CODE32 segment routines				*;
;************************************************************************;
code32	segment er public

	extrn	main:near		; user's code
	extrn	_cli:near		; setup argv and argc
	extrn	init_nm:near		; initialize numeric coprocessor
	extrn	init_runtime:near, exit:near	; run-time library routines

;************************************************************************;
;*									*;
;*	This source file is a sample start-up code. This code can be	*;
;*  tailored differently according to the needs of the user, and the	*;
;*  environment under which the application will run.			*;
;*									*;
;************************************************************************;

startup:

;************************************************************************;
;*	init_runtime							*;
;*  init_runtime is used to initialize the constants of the run-time	*;
;*  library. This is necessary because the library was designed to be	*;
;*  ROMable - i.e. all data variables can only be initialized at	*;
;*  run-time. If you will not work with the run-time library, you may	*;
;*  want to remove this call, to make your object module smaller.	*;
;*  If your application is ROMable, you may want to call a routine that	*;
;*  makes some application-specific initializations.			*;
;************************************************************************;
	call	init_runtime        ;runtime library constants


;************************************************************************;
;*	init_nm								*;
;*  init_nm is used to initialize the numeric coprocessor. If your	*;
;*  application will run without a numeric coprocessor, you will have	*;
;*  to remove this call. You may want to call a different routine, if	*;
;*  your application requires some exceptions handlers.			*;
;************************************************************************;
	call	init_nm			;numeric processor


;************************************************************************;
;*  The following routine is used under the SIM386 environment to read	*;
;*  a command line from the console, and set up __argc and __argv. You	*;
;*  will have to tailor this according to your host operating system.	*;
;************************************************************************;
	call	_cli			;set up __argc, __argv


;************************************************************************;
;*  Push __argc and __argv on the stack. Again, you will have to tailor	*;
;*  this according to your host operating system.			*;
;************************************************************************;
	push	offset __argv
	mov	eax, __argc
	push	eax


;************************************************************************;
;*  call the main entry point of the application, passing argc and argv	*;
;*  parameters.								*;
;************************************************************************;
	call	main			; call main(argc,argv)
	add	esp, 8			; pop out parameters (C calling conv.)

;************************************************************************;
;*  call the exit() routine, which closes all files and transfer control*;
;*  back to the O.S. If you do not use the run-time I/O facilities, and	*;
;*  would like to minimize the size of your object file, you may want	*;
;*  to remove this call, or replace it with a call to _terminate.	*;
;************************************************************************;
	push	eax			;call exit(main(argc,argv))
	call	exit			;will not get here if user already did exit

code32	ends
	end	startup, ds:data, ss:data
