echo off 
rem =========================================================================
rem STACDOS5.BAT - Version 1.02, MS-DOS 5 Upgrade Batch File
rem =========================================================================
rem History:
rem    9-12-91 Added checking for read-only COMMAND.COM in root directory
rem            and DOS directory on boot drive and Stacker drive.
rem    9-11-91 Changed verbage from 'Stacker volume' and 'compressed
rem            drive' to 'Stacker drive'.
rem    7-15-91 Added checking for 'DRIVER.SYS'.
rem
rem Purpose:  To ease the upgrade to MS DOS 5 for users meeting the following
rem    criteria: there is less than 2.8 MB of space available on the
rem    uncompressed drive.
rem 
rem Assumptions: 
rem    The batch file MUST be run from the 'STACKER' directory on the 
rem    Stacker drive.
rem 
rem Parameters (all required):
rem 
rem    %1 = on PASS 1: drive letter to install from (A, B, A:, or B:)
rem       = on PASS 2: drive & directory name of DOS dir on boot drive
rem    %2 = drive letter for Stacker drive with DOS directory (eg., C:)
rem    %3 = DOS directory on Stacker drive (eg., \DOS)
rem 
rem Environment variables used:
rem 
rem   _b = drive letter of real boot drive (uncompressed), with ':' 
rem          character appended
rem   _d = user's DOS directory name; if there's no leading '\' on it,
rem          one is prepended before the variable is used
rem  _hd = hard drive letter for DOS directory (must be a Stacker drive)
rem  _fd = floppy drive letter for drive DOS 5 is installed from 
rem  _fs = floppy diskette size; _f=3 means 3.5", _f=5 means 5.25"
rem
rem Troubleshooting:
rem
rem The batch file creates a file called STACDOS5.LOG in the root directory 
rem of the uncompressed drive.  Echo statements are used to append to the 
rem file so that tech support can know how far the process got if it fails.
rem 
rem =========================================================================
rem Flow of processing...
rem 
rem   Execute pass 2 if STACDOS5.LOG is present in the root dir of the
rem   current drive.
rem
rem PASS 1:
rem   Verify that there are three parameters.
rem   Check for sufficient environment space.
rem   Check for SATTRIB, SWAPMAP and DRVTYPE in 'STACKER' directory.
rem   Determine real boot drive using use SWAPMAP.
rem   Verify the drive letter (%1).
rem   Verify the DOS directory name specified (%2).
rem   Verify that the drive for DOS directory is on a Stacker drive (%3).
rem 
rem   Display the welcome screen with user instructions.
rem   Save CONFIG.SYS and AUTOEXEC.BAT for later restoration.
rem   Prompt for diskette containing EXPAND.EXE and copy it.
rem   Prompt for distribution diskettes and expand files into DOS directory.
rem   Delete .COM versions of old DOS files that are .EXE in DOS 5.
rem   Update driver files in root, DOS, and Windows directories as needed.
rem   Update COMMAND.COM and system files on Stacker drive.
rem   Create correct DOSSHELL based on video type.
rem   Prepare for pass 2 by copying ourselves to the boot disk.
rem   Transfer control to Setup /M.
rem 
rem PASS 2:
rem   Restore config.sys and autoexec.bat from 'STACKER' directory. 
rem   Cleanup after SETUP /M (copy files to dos directory).
rem   Instruct the user to reboot and exit.
rem =========================================================================

rem If STACDOS5.LOG is in the current directory, then it's time for PASS 2.
rem 
if exist stacdos5.log goto pass2

rem PASS 1 Process.
rem 
:pass1
rem Verify that there are three parameters.
if %1qq==qq goto noparms
if %2qq==qq goto noparm2
if %3qq==qq goto noparm3

rem Check for sufficient environment space.  This check will fail for one
rem of 2 reasons: 1) not enough environment, and 2) DOS version prior to
rem 3.1.  Those DOS versions don't handle environment vars in batch files.
:chkenv
set _b=1234567890123456789012345
if %_b%==1234567890123456789012345 goto chkenv_e
goto nospace
:chkenv_e
set _b=

rem Check to see that we're in the 'STACKER' directory.  We need to be here
rem so we can use the SATTRIB, SWAPMAP, and DRVTYPE commands later on.
:ckstkr
if not exist sattrib.com goto notstkr1
if not exist swapmap.com goto notstkr1
if not exist drvtype.exe goto notstkr1

:chkswap
rem Find out what the real boot drive is.
swapmap c:
IF errorlevel 26  goto noboot
IF errorlevel 25  goto bootZ
IF errorlevel 24  goto bootY
IF errorlevel 23  goto bootX
IF errorlevel 22  goto bootW
IF errorlevel 21  goto bootV
IF errorlevel 20  goto bootU
IF errorlevel 19  goto bootT
IF errorlevel 18  goto bootS
IF errorlevel 17  goto bootR
IF errorlevel 16  goto bootQ
IF errorlevel 15  goto bootP
IF errorlevel 14  goto bootO
IF errorlevel 13  goto bootN
IF errorlevel 12  goto bootM
IF errorlevel 11  goto bootL
IF errorlevel 10  goto bootK
IF errorlevel  9  goto bootJ
IF errorlevel  8  goto bootI
IF errorlevel  7  goto bootH
IF errorlevel  6  goto bootG
IF errorlevel  5  goto bootF
IF errorlevel  4  goto bootE
IF errorlevel  3  goto bootD
IF errorlevel  2  goto bootC
goto noboot

:bootC
set _b=C:
Goto bootdon

:bootD
set _b=D:
goto bootdon

:bootE
set _b=E:
goto bootdon

:bootF
set _b=F:
goto bootdon

:bootG
set _b=G:
goto bootdon

:bootH
set _b=H:
goto bootdon

:bootI
set _b=I:
goto bootdon

:bootJ
set _b=J:
goto bootdon

:bootK
set _b=K:
goto bootdon

:bootL
set _b=L:
goto bootdon

:bootM
set _b=M:
goto bootdon

:bootN
set _b=N:
goto bootdon

:bootO
set _b=O:
goto bootdon

:bootP
set _b=P:
goto bootdon

:bootQ
set _b=Q:
goto bootdon

:bootR
set _b=rR:
goto bootdon

:bootS
set _b=S:
goto bootdon

:bootT
set _b=T:
goto bootdon

:bootU
set _b=U:
goto bootdon

:bootV
set _b=V:
goto bootdon

:bootW
set _b=W:
goto bootdon

:bootX
set _b=X:
goto bootdon

:bootY
set _b=Y:
goto bootdon

:bootZ
set _b=Z:
:bootdon
echo Boot drive is %_b% >> %_b%\stacdos5.log

rem Check for presence and validity of the drive letter parameter.
:chkdrv
if %1==a: goto setdrv
if %1==A: goto setdrv
if %1==b: goto setdrv
if %1==B: goto setdrv
if %1==a  goto setdrv
if %1==A  goto setdrv
if %1==b  goto setdrv
if %1==B  goto setdrv
goto nodrive

rem Set drive letter variable.
:setdrv
if %1==a: set _fd=A:
if %1==A: set _fd=A:
if %1==b: set _fd=B:
if %1==B: set _fd=B:
if %1==a  set _fd=A:
if %1==A  set _fd=A:
if %1==b  set _fd=B:
if %1==B  set _fd=B:

rem Make sure the drive for the DOS directory is a Stacker drive.
rem Append a ':' to it, if it helps.
cls
set _hd=%2
set _d=%3
drvtype %_hd%
if errorlevel 3 goto notstkr2
if errorlevel 2 goto chkdir
goto notstkr2

:chkdir
if exist %_hd%%_d%\chkdsk.com goto welcome
if not exist %_hd%:%_d%\chkdsk.com goto direrr1
set _hd=%_hd%:

rem We're done error checking, let's tell them why we're here.  This is
rem the normal opening screen for the target audience.
:welcome
cls
echo .
echo          Welcome to the MS-DOS 5 Upgrade for Stacker users.
echo          ==================================================
echo .
echo This process will allow you to upgrade your system to MS-DOS 5.  During
echo this process you will be prompted to insert each of your MS-DOS 5
echo Upgrade diskettes.  All of the DOS command files and drivers on your
echo system will be updated.
echo .
echo This process will take approximately 20 minutes.
echo .
echo You will need at least 3 MB of disk space on your Stacker drive.
echo .
echo You will also need at least 650 KB of disk space on your uncompressed
echo boot drive.
echo .
echo ********
echo WARNING: IF YOU PERFORM YOUR MS-DOS 5 UPGRADE USING THIS PROCEDURE, 
echo ******** YOU WILL NOT BE ABLE TO USE THE MS-DOS 5 UNINSTALL FEATURE
echo          TO RETURN TO YOUR OLD DOS VERSION.
echo .
echo          IF YOU WISH TO EXIT, PRESS CTRL-C.
echo . 
pause
dir %_b% /w
echo                    --------------------
echo                             ^
echo                             :
echo                             :
echo                             :
echo If the number displayed above as "bytes free" is less than 650,000, 
echo be sure to do the following:
echo .
echo   1. Press Ctrl-C to exit this process.
echo .
echo   2. Make at least 650 KB available on drive %_b%.  You can do this by
echo      deleting unnecessary files or backing up files to diskettes.
echo .
echo   3. Re-run this batch file.
echo .
echo If there is sufficient space available, you may continue this process.
echo .
pause
cls
echo .
echo We will now display the amount of space available on your Stacker 
echo drive.
echo .
echo If you wish to exit, press Ctrl-C.
echo .
pause
dir %_hd%%_d% /w
echo                    --------------------
echo                             ^
echo                             :
echo                             :
echo                             :
echo .
echo If the number displayed above as "bytes free" is less than 3,000,000,
echo be sure to do the following:
echo .
echo   1. Press Ctrl-C to exit this process.
echo .
echo   2. Make at least 3 MB available on the Stacker drive containing the
echo      %_hd%%_d% directory.  You can do this by deleting unnecessary files 
echo      or by backing up files to diskettes.
echo .
echo   3. Re-run this batch file.
echo .
echo If there is sufficient space available, you may continue this process.
echo .
pause

rem At this point we're ready to get started with the process.
echo STACDOS5.BAT start. > %_b%\stacdos5.log
rem Save config.sys and autoexec.bat for subsequent restoration.
if exist %_b%\config.sys copy %_b%\config.sys %_b%\config.$s$ > nul
if exist %_b%\autoexec.bat copy %_b%\autoexec.bat %_b%\autoexec.$s$ > nul

rem Get the disk with EXPAND.EXE on it.
cls
:gtexpdsk
echo .
echo If you are using 5.25" diskettes, insert DISK 6.
echo .
echo If you are using 3.5"  diskettes, insert DISK 3.
pause
if exist %_fd%expand.exe goto cpyexpnd
cls
echo Error: This is the wrong disk, try again...(press Ctrl-C to exit)
echo.
echo This batch file is designed to assist you during installation of
echo the Microsoft MS-DOS 5 Upgrade.  It does not support the IBM DOS 5.0
echo Upgrade.  If you need assistance with the IBM DOS 5.0 Upgrade, please
echo contact Stac Technical Support.
goto gtexpdsk

:cpyexpnd
echo Copying expand.exe to %_hd%%_d%...
copy %_fd%expand.exe expand.exe > nul
echo .
rem Figure out which diskette format.
rem _fs=3 means 3.5" diskettes; _fs=5 means 5.25" diskettes
rem 
set _fs=3
if exist %_fd%4201.cp_ goto endwhfmt
set _fs=5
:endwhfmt

rem Based on disk format, start prompting for the distribution diskettes.
if %_fs%==3 goto getdsk31
if %_fs%==5 goto getdsk51
rem Copy files from 3.5" diskettes.

:getdsk31
echo Insert DISK 1 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 1 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%command.co_ goto copyd31
cls
echo Error: This doesn't look like DISK 1, try again...(press Ctrl-C to exit)
echo .
goto getdsk31

:copyd31
echo Expanding contents of DISK 1 to %_hd%%_d%...
echo .
copy %_fd%autoexec.bat %_hd%%_d%\autoexec.bat > nul
copy %_fd%io.sy_ %_hd%%_d%\io.sy_ > nul
copy %_fd%msdos.sy_ %_hd%%_d%\msdos.sy_ > nul
sattrib -r -s -h %_hd%%_d%\command.com
expand %_fd%command.co_ %_hd%%_d%\command.com
expand %_fd%ega.sy_ %_hd%%_d%\ega.sys
expand %_fd%format.co_ %_hd%%_d%\format.com
copy %_fd%hdbkup.exe %_hd%%_d%\hdbkup.exe > nul
copy %_fd%setup.ini %_hd%%_d%\setup.ini > nul
copy %_fd%setup.exe %_hd%%_d%\setup.exe > nul
expand %_fd%uninstal.ex_ %_hd%%_d%\uninstal.exe
copy %_fd%readme.1st %_hd%%_d%\readme.1st > nul
expand %_fd%country.sy_ %_hd%%_d%\country.sys
expand %_fd%display.sy_ %_hd%%_d%\display.sys
expand %_fd%ega.cp_ %_hd%%_d%\ega.cpi
expand %_fd%himem.sy_ %_hd%%_d%\himem.sys
expand %_fd%keyb.co_ %_hd%%_d%\keyb.com
expand %_fd%keyboard.sy_ %_hd%%_d%\keyboard.sys
expand %_fd%mode.co_ %_hd%%_d%\mode.com
expand %_fd%nlsfunc.ex_ %_hd%%_d%\nlsfunc.exe
expand %_fd%setver.ex_ %_hd%%_d%\setver.exe
expand %_fd%ansi.sy_ %_hd%%_d%\ansi.sys
expand %_fd%debug.ex_ %_hd%%_d%\debug.exe
expand %_fd%doskey.co_ %_hd%%_d%\doskey.com
expand %_fd%edlin.ex_ %_hd%%_d%\edlin.exe
expand %_fd%emm386.ex_ %_hd%%_d%\emm386.exe
expand %_fd%fastopen.ex_ %_hd%%_d%\fastopen.exe
expand %_fd%fdisk.ex_ %_hd%%_d%\fdisk.exe
expand %_fd%mem.ex_ %_hd%%_d%\mem.exe
expand %_fd%mirror.co_ %_hd%%_d%\mirror.com
expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
expand %_fd%share.ex_ %_hd%%_d%\share.exe
expand %_fd%smartdrv.sy_ %_hd%%_d%\smartdrv.sys
expand %_fd%sys.co_ %_hd%%_d%\sys.com
expand %_fd%undelete.ex_ %_hd%%_d%\undelete.exe
copy %_fd%unformat.com %_hd%%_d%\unformat.com > nul
expand %_fd%xcopy.ex_ %_hd%%_d%\xcopy.exe
expand %_fd%cga.vi_ %_hd%%_d%\cga.vid

:getdsk32
echo Insert DISK 2 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 2 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%cga.gr_ goto copyd32
cls
echo Error: This doesn't look like DISK 2, try again...(press Ctrl-C to exit)
echo .
goto getdsk32

:copyd32
echo Expanding contents of DISK 2 to %_hd%%_d%...
echo .
expand %_fd%cga.gr_ %_hd%%_d%\cga.grb
expand %_fd%cga.in_ %_hd%%_d%\cga.ini
expand %_fd%dosshell.co_ %_hd%%_d%\dosshell.com
expand %_fd%dosshell.ex_ %_hd%%_d%\dosshell.exe
expand %_fd%dosswap.ex_ %_hd%%_d%\dosswap.exe
expand %_fd%ega.gr_ %_hd%%_d%\ega.grb
expand %_fd%ega.in_ %_hd%%_d%\ega.ini
expand %_fd%ega.vi_ %_hd%%_d%\ega.vid
expand %_fd%egamono.gr_ %_hd%%_d%\egamono.grb
expand %_fd%herc.gr_ %_hd%%_d%\herc.grb
expand %_fd%herc.vi_ %_hd%%_d%\herc.vid
expand %_fd%mono.gr_ %_hd%%_d%\mono.grb
expand %_fd%mono.in_ %_hd%%_d%\mono.ini
copy %_fd%packing.lst %_hd%%_d%\packing.lst > nul
expand %_fd%print.ex_ %_hd%%_d%\print.exe
expand %_fd%vga.gr_ %_hd%%_d%\vga.grb
expand %_fd%vga.vi_ %_hd%%_d%\vga.vid
expand %_fd%vgamono.gr_ %_hd%%_d%\vgamono.grb
expand %_fd%doshelp.hl_ %_hd%%_d%\doshelp.hlp
expand %_fd%dosshell.hl_ %_hd%%_d%\dosshell.hlp
copy %_fd%hdrstore.exe %_hd%%_d%\hdrstore.exe > nul
expand %_fd%help.ex_ %_hd%%_d%\help.exe
expand %_fd%recover.ex_ %_hd%%_d%\recover.exe
expand %_fd%edit.hl_ %_hd%%_d%\edit.hlp
expand %_fd%msherc.co_ %_hd%%_d%\msherc.com
expand %_fd%qbasic.hl_ %_hd%%_d%\qbasic.hlp
copy %_fd%edit.com %_hd%%_d%\edit.com > nul
expand %_fd%qbasic.ex_ %_hd%%_d%\qbasic.exe

:getdsk33
echo Insert DISK 3 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 3 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%4201.cp_ goto copyd33
cls
echo Error: This doesn't look like DISK 3, try again...(press Ctrl-C to exit)
echo .
goto getdsk33

:copyd33
echo Expanding contents of DISK 3 to %_hd%%_d%...
echo .
expand %_fd%4201.cp_ %_hd%%_d%\4201.cpi
expand %_fd%4208.cp_ %_hd%%_d%\4208.cpi
expand %_fd%5202.cp_ %_hd%%_d%\5202.cpi
expand %_fd%append.ex_ %_hd%%_d%\append.exe
expand %_fd%assign.co_ %_hd%%_d%\assign.com
expand %_fd%attrib.ex_ %_hd%%_d%\attrib.exe
expand %_fd%backup.ex_ %_hd%%_d%\backup.exe
expand %_fd%chkdsk.ex_ %_hd%%_d%\chkdsk.exe
expand %_fd%comp.ex_ %_hd%%_d%\comp.exe
expand %_fd%diskcomp.co_ %_hd%%_d%\diskcomp.com
expand %_fd%diskcopy.co_ %_hd%%_d%\diskcopy.com
expand %_fd%driver.sy_ %_hd%%_d%\driver.sys
expand %_fd%fc.ex_ %_hd%%_d%\fc.exe
expand %_fd%find.ex_ %_hd%%_d%\find.exe
expand %_fd%graftabl.co_ %_hd%%_d%\graftabl.com
expand %_fd%graphics.co_ %_hd%%_d%\graphics.com
expand %_fd%gorilla.ba_ %_hd%%_d%\gorilla.bas
expand %_fd%label.ex_ %_hd%%_d%\label.exe
expand %_fd%money.ba_ %_hd%%_d%\money.bas
expand %_fd%more.co_ %_hd%%_d%\more.com
expand %_fd%nibbles.ba_ %_hd%%_d%\nibbles.bas
expand %_fd%remline.ba_ %_hd%%_d%\remline.bas
expand %_fd%restore.ex_ %_hd%%_d%\restore.exe
expand %_fd%sort.ex_ %_hd%%_d%\sort.exe
expand %_fd%wina20.38_ %_hd%%_d%\wina20.386
expand %_fd%exe2bin.ex_ %_hd%%_d%\exe2bin.exe
expand %_fd%graphics.pr_ %_hd%%_d%\graphics.pro
expand %_fd%join.ex_ %_hd%%_d%\join.exe
expand %_fd%lcd.cp_ %_hd%%_d%\lcd.cpi
expand %_fd%loadfix.co_ %_hd%%_d%\loadfix.com
expand %_fd%printer.sy_ %_hd%%_d%\printer.sys
copy %_fd%readme.txt %_hd%%_d%\readme.txt > nul
expand %_fd%replace.ex_ %_hd%%_d%\replace.exe
expand %_fd%subst.ex_ %_hd%%_d%\subst.exe
expand %_fd%tree.co_ %_hd%%_d%\tree.com
copy %_fd%appnotes.txt %_hd%%_d%\appnotes.txt > nul
goto allok

rem Copy files from 5.25" diskettes.
:getdsk51
echo Insert DISK 1 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 1 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%command.co_ goto copyd51
cls
echo Error: This doesn't look like DISK 1, try again...(press Ctrl-C to exit)
echo .
goto getdsk51

:copyd51
echo Expanding contents of DISK 1 to %_hd%%_d%...
echo .
rem Upgrade 360KB Distribution Disk Layout
copy %_fd%autoexec.bat %_hd%%_d%\autoexec.bat > nul
copy %_fd%io.sy_ %_hd%%_d%\io.sy_ > nul
copy %_fd%msdos.sy_ %_hd%%_d%\msdos.sy_ > nul
sattrib -r -s -h %_hd%%_d%\command.com
expand %_fd%command.co_ %_hd%%_d%\command.com
expand %_fd%ega.sy_ %_hd%%_d%\ega.sys 
expand %_fd%format.co_ %_hd%%_d%\format.com
copy %_fd%hdbkup.exe %_hd%%_d%\hdbkup.exe > nul
copy %_fd%setup.exe %_hd%%_d%\setup.exe > nul
copy %_fd%setup.ini %_hd%%_d%\setup.ini > nul
expand %_fd%uninstal.ex_ %_hd%%_d%\uninstal.exe > nul
copy %_fd%readme.1st %_hd%%_d%\readme.1st > nul

:getdsk52
echo Insert DISK 2 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 2 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%country.sy_ goto copyd52
cls
echo Error: This doesn't look like DISK 2, try again...(press Ctrl-C to exit)
echo .
goto getdsk52

:copyd52
echo Expanding contents of DISK 2 to %_hd%%_d%...
echo .
expand %_fd%country.sy_ %_hd%%_d%\country.sys
expand %_fd%display.sy_ %_hd%%_d%\display.sys
expand %_fd%ega.cp_ %_hd%%_d%\ega.cpi
expand %_fd%himem.sy_ %_hd%%_d%\himem.sys
expand %_fd%keyb.co_ %_hd%%_d%\keyb.com
expand %_fd%keyboard.sy_ %_hd%%_d%\keyboard.sys
expand %_fd%mode.co_ %_hd%%_d%\mode.com
expand %_fd%nlsfunc.ex_ %_hd%%_d%\nlsfunc.exe
expand %_fd%setver.ex_ %_hd%%_d%\setver.exe
expand %_fd%ansi.sy_ %_hd%%_d%\ansi.sys
expand %_fd%debug.ex_ %_hd%%_d%\debug.exe
expand %_fd%doskey.co_ %_hd%%_d%\doskey.com
expand %_fd%edlin.ex_ %_hd%%_d%\edlin.exe
expand %_fd%emm386.ex_ %_hd%%_d%\emm386.exe
expand %_fd%fastopen.ex_ %_hd%%_d%\fastopen.exe
expand %_fd%fdisk.ex_ %_hd%%_d%\fdisk.exe
expand %_fd%mem.ex_ %_hd%%_d%\mem.exe
expand %_fd%mirror.co_ %_hd%%_d%\mirror.com
expand %_fd%ramdrive.sy_ %_hd%%_d%\ramdrive.sys
expand %_fd%share.ex_ %_hd%%_d%\share.exe
expand %_fd%smartdrv.sy_ %_hd%%_d%\smartdrv.sys
expand %_fd%sys.co_ %_hd%%_d%\sys.com
expand %_fd%undelete.ex_ %_hd%%_d%\undelete.exe
copy %_fd%unformat.com %_hd%%_d%\unformat.com > nul
expand %_fd%xcopy.ex_ %_hd%%_d%\xcopy.exe
expand %_fd%cga.vi_ %_hd%%_d%\cga.vid

:getdsk53
echo Insert DISK 3 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 3 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%cga.gr_ goto copyd53
cls
echo Error: This doesn't look like DISK 3, try again...(press Ctrl-C to exit)
echo .
goto getdsk53

:copyd53
echo Expanding contents of DISK 3 to %_hd%%_d%...
echo .
expand %_fd%cga.gr_ %_hd%%_d%\cga.grb
expand %_fd%cga.in_ %_hd%%_d%\cga.ini
expand %_fd%dosshell.co_ %_hd%%_d%\dosshell.com
expand %_fd%dosshell.ex_ %_hd%%_d%\dosshell.exe
expand %_fd%dosswap.ex_ %_hd%%_d%\dosswap.exe
expand %_fd%ega.gr_ %_hd%%_d%\ega.grb
expand %_fd%ega.in_ %_hd%%_d%\ega.ini
expand %_fd%ega.vi_ %_hd%%_d%\ega.vid
expand %_fd%egamono.gr_ %_hd%%_d%\egamono.grb
expand %_fd%herc.gr_ %_hd%%_d%\herc.grb
expand %_fd%herc.vi_ %_hd%%_d%\herc.vid
expand %_fd%mono.gr_ %_hd%%_d%\mono.grb
expand %_fd%mono.in_ %_hd%%_d%\mono.ini
copy %_fd%packing.lst %_hd%%_d%\packing.lst > nul
expand %_fd%print.ex_ %_hd%%_d%\print.exe
expand %_fd%vga.gr_ %_hd%%_d%\vga.grb
expand %_fd%vga.vi_ %_hd%%_d%\vga.vid
expand %_fd%vgamono.gr_ %_hd%%_d%\vgamono.grb
expand %_fd%doshelp.hl_ %_hd%%_d%\doshelp.hlp
expand %_fd%dosshell.hl_ %_hd%%_d%\dosshell.hlp
copy %_fd%hdrstore.exe %_hd%%_d%\hdrstore.exe > nul
expand %_fd%help.ex_ %_hd%%_d%\help.exe
expand %_fd%recover.ex_ %_hd%%_d%\recover.exe


:getdsk54
echo Insert DISK 4 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 4 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%edit.hl_ goto copyd54
cls
echo Error: This doesn't look like DISK 4, try again...(press Ctrl-C to exit)
echo .
goto getdsk54

:copyd54
echo Expanding contents of DISK 4 to %_hd%%_d%...
echo .
expand %_fd%edit.hl_ %_hd%%_d%\edit.hlp
expand %_fd%msherc.co_ %_hd%%_d%\msherc.com
expand %_fd%qbasic.hl_ %_hd%%_d%\qbasic.hlp
copy %_fd%edit.com %_hd%%_d%\edit.com > nul
expand %_fd%qbasic.ex_ %_hd%%_d%\qbasic.exe

:getdsk55
echo Insert DISK 5 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 5 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%4201.cp_ goto copyd55
cls
echo Error: This doesn't look like DISK 5, try again...(press Ctrl-C to exit)
echo .
goto getdsk55

:copyd55
echo Expanding contents of DISK 5 to %_hd%%_d%...
echo .
expand %_fd%4201.cp_ %_hd%%_d%\4201.cpi
expand %_fd%4208.cp_ %_hd%%_d%\4208.cpi
expand %_fd%5202.cp_ %_hd%%_d%\5202.cpi
expand %_fd%append.ex_ %_hd%%_d%\append.exe
expand %_fd%assign.co_ %_hd%%_d%\assign.com
expand %_fd%attrib.ex_ %_hd%%_d%\attrib.exe
expand %_fd%backup.ex_ %_hd%%_d%\backup.exe
expand %_fd%chkdsk.ex_ %_hd%%_d%\chkdsk.exe
expand %_fd%comp.ex_ %_hd%%_d%\comp.exe
expand %_fd%diskcomp.co_ %_hd%%_d%\diskcomp.com
expand %_fd%diskcopy.co_ %_hd%%_d%\diskcopy.com
expand %_fd%driver.sy_ %_hd%%_d%\driver.sys
expand %_fd%fc.ex_ %_hd%%_d%\fc.exe
expand %_fd%find.ex_ %_hd%%_d%\find.exe
expand %_fd%graftabl.co_ %_hd%%_d%\graftabl.com
expand %_fd%graphics.co_ %_hd%%_d%\graphics.com
expand %_fd%gorilla.ba_ %_hd%%_d%\gorilla.bas
expand %_fd%label.ex_ %_hd%%_d%\label.exe
expand %_fd%money.ba_ %_hd%%_d%\money.bas
expand %_fd%more.co_ %_hd%%_d%\more.com
expand %_fd%nibbles.ba_ %_hd%%_d%\nibbles.bas
expand %_fd%remline.ba_ %_hd%%_d%\remline.bas
expand %_fd%restore.ex_ %_hd%%_d%\restore.exe
expand %_fd%sort.ex_ %_hd%%_d%\sort.exe
expand %_fd%wina20.38_ %_hd%%_d%\wina20.386
expand %_fd%exe2bin.ex_ %_hd%%_d%\exe2bin.exe
expand %_fd%graphics.pr_ %_hd%%_d%\graphics.pro
expand %_fd%join.ex_ %_hd%%_d%\join.exe
expand %_fd%lcd.cp_ %_hd%%_d%\lcd.cpi
expand %_fd%loadfix.co_ %_hd%%_d%\loadfix.com
expand %_fd%printer.sy_ %_hd%%_d%\printer.sys
copy %_fd%readme.txt %_hd%%_d%\readme.txt > nul
expand %_fd%replace.ex_ %_hd%%_d%\replace.exe
expand %_fd%subst.ex_ %_hd%%_d%\subst.exe
expand %_fd%tree.co_ %_hd%%_d%\tree.com

:getdsk56
echo Insert DISK 6 of your MS-DOS 5 Upgrade in drive %_fd%. >> %_b%\stacdos5.log
echo Insert DISK 6 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%appnotes.txt goto copyd56
cls
echo Error: This doesn't look like DISK 6, try again...(press Ctrl-C to exit)
echo .
goto getdsk56

:copyd56
echo Expanding contents of DISK 6 to %_hd%%_d%...
echo .
copy %_fd%appnotes.txt %_hd%%_d%\appnotes.txt > nul

:allok
rem Delete the .COM files in the DOS directory that are .EXE files in DOS 5.
rem Do this on the Stacker drive.
rem
:comtoexe
if exist %_hd%%_d%\backup.com del %_hd%%_d%\backup.com
if exist %_hd%%_d%\chkdsk.com del %_hd%%_d%\chkdsk.com
if exist %_hd%%_d%\comp.com del %_hd%%_d%\comp.com
if exist %_hd%%_d%\debug.com del %_hd%%_d%\debug.com
if exist %_hd%%_d%\edlin.com del %_hd%%_d%\edlin.com
if exist %_hd%%_d%\fdisk.com del %_hd%%_d%\fdisk.com
if exist %_hd%%_d%\help.com del %_hd%%_d%\help.com
if exist %_hd%%_d%\label.com del %_hd%%_d%\label.com
if exist %_hd%%_d%\print.com del %_hd%%_d%\print.com
if exist %_hd%%_d%\recover.com del %_hd%%_d%\recover.com
if exist %_hd%%_d%\restore.com del %_hd%%_d%\restore.com

rem Do the same for the boot drive.
if exist %_b%%_d%\backup.com del %_b%%_d%\backup.com
if exist %_b%%_d%\chkdsk.com del %_b%%_d%\chkdsk.com
if exist %_b%%_d%\comp.com del %_b%%_d%\comp.com
if exist %_b%%_d%\debug.com del %_b%%_d%\debug.com
copy %_hd%%_d%\edlin.exe %_b%\edlin.exe
if exist %_b%%_d%\edlin.com del %_b%%_d%\edlin.com
if exist %_b%%_d%\fdisk.com del %_b%%_d%\fdisk.com
if exist %_b%%_d%\help.com del %_b%%_d%\help.com
if exist %_b%%_d%\label.com del %_b%%_d%\label.com
if exist %_b%%_d%\print.com del %_b%%_d%\print.com
if exist %_b%%_d%\recover.com del %_b%%_d%\recover.com
if exist %_b%%_d%\restore.com del %_b%%_d%\restore.com
:endctoe
echo .COM files which are now .EXE have been deleted. >> %_b%\stacdos5.log

rem Update the following files on Drive C: and the uncompressed drive:
rem 
rem   HIMEM.SYS, SMARTDRV.SYS, RAMDRIVE.SYS, COUNTRY.SYS, ANSI.SYS,
rem   DRIVER.SYS  
rem   Also copy WINA20.386 to root directory of Stacker and boot drives.
rem
rem   Copy them from the DOS directory to the appropriate destinations.
rem

:updsys
rem Check for a 'STACKER' directory on the user's boot drive.
rem If it doesn't exist, create it.
rem 
copy %_hd%%_d%\command.com %_b%\stacker\command.com > nul
if exist %_b%\stacker\command.com goto dofiles
mkdir %_b%\stacker > nul
copy %_hd%%_d%\command.com %_b%\stacker\command.com > nul
if not exist %_b%\stacker\command.com goto nostroot

:dofiles
del %_b%\stacker\command.com > nul

rem HIMEM.SYS - check root, DOS & Windows directories
if exist \himem.sys copy %_hd%%_d%\himem.sys \himem.sys > nul
if exist \windows\himem.sys copy %_hd%%_d%\himem.sys \windows\himem.sys > nul
rem 
if exist %_b%\himem.sys copy %_hd%%_d%\himem.sys %_b%\stacker\himem.sys > nul
if exist %_b%%_d%\himem.sys copy %_hd%%_d%\himem.sys %_b%\stacker\himem.sys > nul
if exist %_b%\windows\himem.sys copy %_hd%%_d%\himem.sys %_b%\stacker\himem.sys > nul
if exist %_b%\stacker\himem.sys echo HIMEM.SYS updated. >> %_b%\stacdos5.log

rem SMARTDRV.SYS - check root, DOS & Windows directories
if exist \smartdrv.sys copy %_hd%%_d%\smartdrv.sys \smartdrv.sys > nul
if exist \windows\smartdrv.sys copy %_hd%%_d%\smartdrv.sys \windows\smartdrv.sys > nul
rem 
if exist %_b%%_d%\smartdrv.sys copy %_hd%%_d%\smartdrv.sys %_b%\stacker\smartdrv.sys > nul
if exist %_b%\windows\smartdrv.sys copy %_hd%%_d%\smartdrv.sys %_b%\stacker\smartdrv.sys > nul
if exist %_b%\stacker\smartdrv.sys echo SMARTDRV.SYS updated. >> %_b%\stacdos5.log

rem RAMDRIVE.SYS - check root, DOS & Windows directories
if exist \ramdrive.sys copy %_hd%%_d%\ramdrive.sys \ramdrive.sys > nul
if exist \windows\ramdrive.sys copy %_hd%%_d%\ramdrive.sys \windows\ramdrive.sys > nul
if exist %_b%\ramdrive.sys copy %_hd%%_d%\ramdrive.sys %_b%\stacker\ramdrive.sys > nul
if exist %_b%%_d%\ramdrive.sys copy %_hd%%_d%\ramdrive.sys %_b%\stacker\ramdrive.sys > nul
if exist %_b%\windows\ramdrive.sys copy %_hd%%_d%\ramdrive.sys %_b%\stacker\ramdrive.sys > nul
if exist %_b%\stacker\ramdrive.sys echo RAMDRIVE.SYS updated. >> %_b%\stacdos5.log

rem COUNTRY.SYS - check root & DOS directories
if exist \country.sys copy %_hd%%_d%\country.sys \country.sys > nul
if exist %_b%\country.sys copy %_hd%%_d%\country.sys %_b%\stacker\country.sys > nul
if exist %_b%%_d%\country.sys copy %_hd%%_d%\country.sys %_b%\stacker\country.sys > nul
if exist %_b%\stacker\country.sys echo COUNTRY.SYS updated. >> %_b%\stacdos5.log

rem ANSI.SYS - check root & DOS directories
if exist \ansi.sys copy %_hd%%_d%\ansi.sys \ansi.sys > nul
if exist %_b%\ansi.sys copy %_hd%%_d%\ansi.sys %_b%\stacker\ansi.sys > nul
if exist %_b%%_d%\ansi.sys copy %_hd%%_d%\ansi.sys %_b%\stacker\ansi.sys > nul
if exist %_b%\stacker\ANSI.sys echo ANSI.SYS updated. >> %_b%\stacdos5.log

rem DRIVER.SYS - check root & DOS directories
if exist \driver.sys copy %_hd%%_d%\driver.sys \driver.sys > nul
if exist %_b%\driver.sys copy %_hd%%_d%\driver.sys %_b%\stacker\driver.sys > nul
if exist %_b%%_d%\driver.sys copy %_hd%%_d%\driver.sys %_b%\stacker\driver.sys > nul
if exist %_b%\stacker\driver.sys echo DRIVER.SYS updated. >> %_b%\stacdos5.log

rem WINA20.386 - copy to root directory of Stacker and boot drives
copy %_hd%%_d%\wina20.386 \wina20.386 > nul
copy %_hd%%_d%\wina20.386 %_b%\wina20.386 > nul
echo WINA20 copied to root of Stacker and boot drives. >> %_b%\stacdos5.log

rem Update COMMAND.COM in the root of the Stacker drive (the current drive).
:upcmdcom
echo Updating system files on Stacker drive...
if exist \command.com sattrib -h -r -s \command.com
if exist \command.com copy %_hd%%_d%\command.com \command.com > nul
echo COMMAND.COM updated on Stacker drive. >> %_b%\stacdos5.log

rem Update DOS hidden files on Stacker drive (the current drive).
rem Handle both MS-DOS and IBM versions.
if exist \msdos.sys goto st_doms
if exist \ibmdos.com goto st_doibm
goto st_put

:st_doibm
rem Unhide and delete IBM DOS files on Stacker drive.
sattrib -h -r -s \ibmbio.com
sattrib -h -r -s \ibmdos.com
del \ibmbio.com > nul
del \ibmdos.com > nul
goto st_put

:st_doms
rem Unhide MS-DOS files on Stacker drive.
sattrib -h -r -s \io.sys
sattrib -h -r -s \msdos.sys

:st_put
echo System files on drive C: unhidden. >> %_b%\stacdos5.log
expand %_hd%%_d%\io.sy_ \io.sys > nul
expand %_hd%%_d%\msdos.sy_ \msdos.sys > nul
rem Cleanup the mess.
del %_hd%%_d%\io.sy_ 
del %_hd%%_d%\msdos.sy_ 
rem Hide system files on Stacker drive.
sattrib +h +r +s \io.sys
sattrib +h +r +s \msdos.sys
echo Hidden files on Stacker drive updated. >> %_b%\stacdos5.log

rem Determine video type and install appropriate DOSSHELL files.
vidtype
if errorlevel  7 goto MCA
if errorlevel  6 goto HERC
if errorlevel  5 goto VGAMONO
if errorlevel  4 goto VGA
if errorlevel  3 goto EGAMONO
if errorlevel  2 goto EGA
if errorlevel  1 goto CGA

:MONO
echo MONO video. >> %_b%\stacdos5.log
echo DOSSHELL set up for MONO.
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul 
copy %_hd%%_d%\mono.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:CGA
echo CGA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for CGA.
copy %_hd%%_d%\cga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\cga.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\cga.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:EGA
echo EGA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for EGA.
copy %_hd%%_d%\ega.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\ega.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\ega.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:EGAMONO
echo EGAMONO video. >> %_b%\stacdos5.log
echo DOSSHELL set up for EGAMONO.
copy %_hd%%_d%\ega.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\egamono.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:VGA
echo VGA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for VGA.
copy %_hd%%_d%\vga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\ega.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\vga.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:VGAMONO
echo VGAMONO video. >> %_b%\stacdos5.log
echo DOSSHELL set up for VGAMONO.
copy %_hd%%_d%\vga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\vgamono.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:HERC
echo HERC video. >> %_b%\stacdos5.log
echo DOSSHELL set up for HERC.
copy %_hd%%_d%\herc.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\mono.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\herc.grb %_hd%%_d%\dosshell.grb > nul
goto ENDVID

:MCA
echo MCA video. >> %_b%\stacdos5.log
echo DOSSHELL set up for MCA.
copy %_hd%%_d%\cga.vid %_hd%%_d%\dosshell.vid > nul
copy %_hd%%_d%\cga.ini %_hd%%_d%\dosshell.ini > nul
copy %_hd%%_d%\vga.grb %_hd%%_d%\dosshell.grb > nul
:ENDVID

cls
echo .
echo MS-DOS 5 files copied successfully.
echo .
echo You will now enter the MS-DOS 5 SETUP program which will install 
echo the remaining files needed to complete your upgrade to MS-DOS 5.
echo Note that this process will perform a Minimal Installation since
echo we've already copied the files from the MS-DOS 5 Upgrade diskettes.
echo .
echo You will need one or two blank diskettes for this process.  They do
echo not need to be formatted.
echo .
echo  1. The MS-DOS 5 SETUP program will ask you to verify your system
echo     configuration, including the "DOS Path".  
echo .
echo        *** Be sure to accept the default setting of %_b%\DOS. ***
echo .
echo  2. Once you've completed the SETUP process, your system will reboot.
echo     After rebooting you MUST type the following command at the C
echo     prompt to complete the upgrade process.
echo .
echo                           STAC5
echo .
pause
cls
echo .
echo                        **** REMINDER ****
echo .
echo SETUP will create UNINSTALL diskettes, but you will not be able to use
echo the UNINSTALL feature of MS-DOS 5.
echo .
echo The MS-DOS 5 SETUP program will ask you to verify your system
echo configuration, including the "DOS Path".  
echo .
echo     *** Be sure to accept the default setting of %_b%\DOS. ***
echo .
echo Once you've completed the SETUP process, your system will reboot and
echo after rebooting you MUST type the following command at the C prompt to 
echo complete the upgrade process.
echo .
echo                              STAC5
echo .
echo   ***************************************************************
echo   *  **** WRITE THIS INSTRUCTION DOWN.  YOUR UPGRADE WILL ****  *
echo   *  ****  NOT BE COMPLETE UNTIL THIS LAST STEP IS DONE.  ****  *
echo   ***************************************************************
echo .
pause

:getdsk1
echo Insert DISK 1 of your MS-DOS 5 Upgrade in drive %_fd%
pause
if exist %_fd%command.co_ goto setup_m
cls
echo Error: This doesn't look like DISK 1, try again...(press Ctrl-C to exit)
echo .
goto getdsk1

:setup_m
echo Transferring control to Setup /M. >> %_b%\stacdos5.log
echo Copy STACDOS5.BAT to boot drive for PASS 2.  >> %_b%\stacdos5.log

if exist %_b%\stacdos5.bat del %_b%\stacdos5.bat
copy stacdos5.bat %_b%\stacdos5.bat > nul

rem Remove attributes from command.com on boot drive and DOS directory 
rem on boot drive in case either is read-only
sattrib -r -s -h %_b%\command.com
sattrib -r -s -h %_b%%_d%\command.com

rem Create a 1-line batch file for use after Setup /M reboot.
echo STACDOS5 C:%_d% > %_b%\STAC5.BAT
echo Creating STAC5.BAT containing STACDOS5 C:%_d% >> %_b%\stacdos5.log
echo . >> %_b%\STAC5.BAT
echo PASS 1 completed. >> %_b%\stacdos5.log
echo . >> %_b%\stacdos5.log
%_fd%
setup /m
goto alldone

rem =========================================================================
rem PASS 2 Process.

:pass2
set _b=c:
rem 
rem Cleanup the root directory.
rem 
copy \config.$s$ \config.sys > nul
copy \autoexec.$s$ \autoexec.bat > nul
copy \config.$s$ \stacker\config.sys > nul
copy \autoexec.$s$ \stacker\autoexec.bat > nul
del \config.$s$ > nul
del \autoexec.$s$ > nul
echo CONFIG.SYS and AUTOEXEC.BAT restored. >> %_b%\stacdos5.log

set _d=%1
copy c:\command.com %_d% > nul
if exist %_d%\command.com goto copydos
goto direrr_1

rem Copy those DOS files which exist in the DOS & Windows directories.
rem Including himem.sys, smartdrv.sys, ramdrive.sys, ansi.sys, and country.sys
rem For each file, delete it after copying (if present).
:copydos

rem HIMEM.SYS - check root, DOS, & Windows directories
if exist \himem.sys copy \stacker\himem.sys \himem.sys > nul
if exist %_d%\himem.sys copy \stacker\himem.sys %_d%\himem.sys > nul
if exist \windows\himem.sys copy \stacker\himem.sys \windows\himem.sys > nul
if exist \stacker\himem.sys echo HIMEM.SYS updated. >> %_b%\stacdos5.log
if exist \stacker\himem.sys del \stacker\himem.sys > nul

rem SMARTDRV.SYS - check root, DOS & Windows directories
if exist \smartdrv.sys copy \stacker\smartdrv.sys \smartdrv.sys > nul
if exist %_d%\smartdrv.sys copy \stacker\smartdrv.sys %_d%\smartdrv.sys > nul
if exist \windows\smartdrv.sys copy \stacker\smartdrv.sys \windows\smartdrv.sys > nul
if exist \stacker\smartdrv.sys echo SMARTDRV.SYS updated. >> %_b%\stacdos5.log
if exist \stacker\smartdrv.sys del \stacker\smartdrv.sys > nul

rem RAMDRIVE.SYS - check root, DOS & Windows directories
if exist \ramdrive.sys copy \stacker\ramdrive.sys \ramdrive.sys > nul
if exist %_d%\ramdrive.sys copy \stacker\ramdrive.sys %_d%\ramdrive.sys > nul
if exist \windows\ramdrive.sys copy \stacker\ramdrive.sys \windows\ramdrive.sys > nul
if exist \stacker\ramdrive.sys echo RAMDRIVE.SYS updated. >> %_b%\stacdos5.log
if exist \stacker\ramdrive.sys del \stacker\ramdrive.sys > nul

rem COUNTRY.SYS - check root & DOS directories
if exist \country.sys copy \stacker\country.sys \country.sys > nul
if exist %_d%\country.sys copy \stacker\country.sys %_d%\country.sys > nul
if exist \stacker\country.sys echo COUNTRY.SYS updated. >> %_b%\stacdos5.log
if exist \stacker\country.sys del \stacker\country.sys > nul

rem ANSI.SYS - check root & DOS directories
if exist \ansi.sys copy \stacker\ansi.sys \ansi.sys > nul
if exist %_d%\ansi.sys copy \stacker\ansi.sys %_d%\ansi.sys > nul
if exist \stacker\ansi.sys echo ANSI.SYS updated. >> %_b%\stacdos5.log
if exist \stacker\ansi.sys del \stacker\ansi.sys > nul

rem DRIVER.SYS - check root & DOS directories
if exist \driver.sys copy \stacker\driver.sys \driver.sys > nul
if exist %_d%\driver.sys copy \stacker\driver.sys %_d%\driver.sys > nul
if exist \stacker\driver.sys echo DRIVER.SYS updated. >> %_b%\stacdos5.log
if exist \stacker\driver.sys del \stacker\driver.sys > nul

rem Instruct the user to reboot.
cls
echo .
echo Your MS-DOS 5 Upgrade is now complete.
echo .
echo Your CONFIG.SYS and AUTOEXEC.BAT files are the same as when you started
echo this process.  You will need to modify them if you wish to take advantage
echo of the exciting new features offered in MS-DOS 5.  You can find some
echo hints on this by looking at the files CONFIG.NEW and AUTOEXEC.NEW.  Be
echo sure you use the correct path names when adding any new commands to your
echo CONFIG.SYS file.
echo .
echo To access your Stacker drives...
echo .
echo              PRESS CTRL+ALT+DEL TO REBOOT YOUR SYSTEM NOW.
echo .
echo                   THANK YOU FOR CHOOSING STACKER.
echo .
echo PASS 2 completed. >> %_b%\stacdos5.log
echo STACDOS5.BAT complete. >> %_b%\stacdos5.log
copy %_b%\stacdos5.log %_b%\stacker > nul
del %_b%\stacdos5.log > nul
goto alldone

rem =========================================================================
rem Error Displays - All errors which exit after display are here.
rem =========================================================================

:noparm2
:noparm3
cls
echo .
echo ERROR: STACDOS5 requires three command-line parameters.
echo .
goto errexit

:direrr_1
cls
echo .
echo ERROR: Unable to verify the DOS directory.
echo .
goto errexit

:nospace
cls
echo .
echo ERROR: STACDOS5.BAT cannot run.  There are two possible reasons for this.
echo .
echo     1. There is not enough DOS environment space available.
echo        The update process requires very little space, however
echo        there is not enough available.  Please delete one or 
echo        more of your environment variables and run STACDOS5 again.
echo .
echo                              or
echo     2. You are running a version of DOS prior to DOS 3.1.  This
echo        batch file uses features available in DOS 3.1 and later.
echo .
echo        You are running the following DOS version:
echo .
ver
echo .
goto alldone

:notstkr1
cls
echo . 
echo ERROR: This batch file must be run from your Stacker drive, with
echo        the 'STACKER' directory as your current directory.  We're looking
echo        for the SATTRIB, SWAPMAP, and DRVTYPE Stacker utilities to
echo        verify this.  So, if you've deleted SATTRIB.COM, SWAPMAP.COM,
echo        or DRVTYPE.EXE from your 'STACKER' directory, you must copy them
echo        from the Stacker diskette to your 'STACKER' directory before you
echo        can complete this process.
echo .
echo Please copy this batch file, STACDOS5.BAT, to your 'STACKER' directory.  
echo Make the 'STACKER' directory on your Stacker drive the current 
echo directory and run this batch file, STACDOS5.
echo .
echo For example, if drive C: is a Stacker drive, your Stacker directory
echo is named 'STACKER', the DOS directory is named DOS, and you will be
echo installing from drive A:, type the following commands:
echo . 
echo                 COPY A:STACDOS5.BAT C:\STACKER 
echo                 C:
echo                 CD \STACKER
echo                 STACDOS5  A:  C:  \DOS
echo . 
goto alldone

:notstkr2
cls
echo .
echo ERROR: The drive letter you have specified for your DOS directory,
echo        %_hd% is not a Stacker drive.
echo .
goto errexit

:noboot
echo ERROR: Unable to determine boot drive.  
echo        Please contact Stac technical support.
goto alldone

:nodrive
cls
echo .
echo ERROR: You must provide the drive letter of the diskette drive
echo        that you will be installing your MS DOS 5 Upgrade from.  The
echo        drive letter must be A: or B:.
echo .
goto errexit

:direrr1
cls
echo .
echo ERROR: Unable to verify DOS directory.  We're looking for the
echo        CHKDSK command file, CHKDSK.COM, to verify this.
echo .
goto errexit

:nostroot
rem If this doesn't work, we can't operate.
cls
echo .
echo ERROR: Unable to locate or create 'STACKER' directory on your boot 
echo        drive, drive %_b%.
echo
echo Please make sure that a directory named 'STACKER' exists on your boot
echo drive.
goto alldone

:errexit
:noparms
echo Run STACDOS5.BAT from the 'STACKER' directory on your Stacker drive
echo with the following parameters:
echo .
echo                     STACDOS5  d1:  d2:  dosdir 
echo .
echo     d1:  the drive letter of the diskette drive you'll be installing
echo          your MS-DOS 5 Upgrade from.  This must be A: or B:.
echo .
echo     d2:  the drive letter containing the DOS directory.  This drive
echo          MUST be a Stacker drive.
echo .
echo  dosdir  the name of the DOS directory on your Stacker drive,
echo          (for example, \DOS).
echo .
echo For example, if you're installing MS-DOS 5 from drive A: and the DOS
echo directory on drive C:, a Stacker drive, is called DOS, type the
echo following:
echo .
echo                    STACDOS5  A:  C:  \DOS

:alldone
rem Be sure to keep the environment clean on exit.
set _b=
set _d=
set _fd=
set _fs=
set _h=
