; THE 'DB' STMT IS AHEAD OF EACH ROUTINE SO THAT THE ROUTINES MAY BE LOCATED
; WITH DEBUG.
;
; This macro library defines the operating environment for the 8086 small
; memory model, which allows 64Kbytes of data and 64Kbytes of program.
;
;**
MSDOS   EQU     2
;**
;
; The following symbols define the 8086 memory mode being used.  Set LPROG
; to 1 for a large program segment (greater than 64K-bytes), and set LDATA
; to 1 for a large data segment.
;
;**
LPROG   EQU     0
LDATA   EQU     0
;**
;
; The following symbols are established via LPROG and LDATA as follows:
;
;       S8086   set for small model (small prog, small data)
;       D8086   set for model with large data, small prog
;       P8086   set for model with large prog, small data
;       L8086   set for large model
;
;**
        IF      (LPROG EQ 0) AND (LDATA EQ 0)
S8086   EQU     1
D8086   EQU     0
P8086   EQU     0
L8086   EQU     0
        ENDIF
        IF      (LPROG EQ 0) AND (LDATA NE 0)
S8086   EQU     0
D8086   EQU     1
P8086   EQU     0
L8086   EQU     0
        ENDIF
        IF      (LPROG NE 0) AND (LDATA EQ 0)
S8086   EQU     0
D8086   EQU     0
P8086   EQU     1
L8086   EQU     0
        ENDIF
        IF      (LPROG NE 0) AND (LDATA NE 0)
S8086   EQU     0
D8086   EQU     0
P8086   EQU     0
L8086   EQU     1
        ENDIF
;**
;
; The DSEG and PSEG macros are defined to generate the appropriate GROUP
; and SEGMENT statements for the memory model being used.  The ENDDS and
; ENDPS macros are then used to end the segments.
;
;**
DSEG    MACRO   
DGROUP  GROUP   DATA
DATA    SEGMENT WORD PUBLIC 'DATA'
        ASSUME  DS:DATA
        ENDM
ENDDS   MACRO
DATA    ENDS
        ENDM
        IF      S8086
PSEG    MACRO
PGROUP  GROUP   PROG
PROG    SEGMENT BYTE PUBLIC 'PROG'
        ASSUME  CS:PROG
        ENDM
ENDPS   MACRO
PROG    ENDS
        ENDM
        ENDIF
        IF      D8086
PSEG    MACRO
CGROUP  GROUP   CODE
CODE    SEGMENT BYTE PUBLIC 'CODE'
        ASSUME  CS:CODE
        ENDM
ENDPS   MACRO
CODE    ENDS
        ENDM
        ENDIF
        IF      P8086
PSEG    MACRO
_CODE   SEGMENT BYTE
        ASSUME  CS:_CODE
        ENDM
ENDPS   MACRO
_CODE   ENDS
        ENDM
        ENDIF
        IF      L8086
PSEG    MACRO
_PROG   SEGMENT BYTE
        ASSUME  CS:_PROG
        ENDM
ENDPS   MACRO
_PROG   ENDS
        ENDM
        ENDIF
;
        MOVE MACRO MOVETO,MOVEFROM,MOVECNT
        MOV SI,OFFSET MOVEFROM
        MOV DI,OFFSET MOVETO
        MOV CX,MOVECNT
        REPZ MOVSB
        ENDM
;
DSEG ;BEGINNING OF DATA SEGMENT
TRYCNT DB 0
RSTCNT DB 0
MG DB 13,'          CCC H SS BAD DISK COMMAND ',13,'$'
M0 DB 'RESET    '
M2 DB 'READ     '
M3 DB 'WRITE    '
M4 DB 'VERIFY   '
M5 DB 'FORMAT   '
M6 DB 'READ DEL '
M7 DB 'WRITE DEL'
M8 DB 'SET FMT  '
;
ERRTBL EQU $
 DB 000,'GOOD OPERATION  '
 DB 001,'BAD DISK COMMAND'
 DB 002,'TRACK NOT FOUND '
 DB 003,'WRITE PROTECTED '
 DB 004,'SECTOR NOT FOUND'
 DB 008,'DMA OVERRUN     '
 DB 009,'DMA ACROSS 64K  '
 DB 016,'DATA READ ERROR '
 DB 032,'DISK CARD BAD   '
 DB 064,'DISK SEEK FAILED'
 DB 128,'DRIVE NOT READY '
 DB 255,'UNKNOWN ERROR   '
;
TESTREAD DB 2048 DUP(0)
 ENDDS
;
 PSEG ;BEGINNING OF PROGRAM SEGMENT
 PUBLIC READ8,WRITE8,VERIFY8,FORMAT8,RDDEL8,WRTDEL8,RESET8,SET8,FIND8
;
 DB 'READ8 ROUTINE'
;                0   2   4    6   8    10
READ8 PROC NEAR ;DRV,CYL,HEAD,SEC,RECS,BUF
 PUSH BP
 MOV BP,SP
 ADD BP,4 ;POINT TO PARAMETER BEGINNING
 MOVE MG+1,M2,9
 MOV AH,2 ;READ
 JMP STDENT
;
 DB 'WRITE8 ROUTINE'
;                 0   2   4    6   8    10
WRITE8 PROC NEAR ;DRV,CYL,HEAD,SEC,RECS,BUF
 PUSH BP
 MOV BP,SP
 ADD BP,4 ;POINT TO PARAMETER BEGINNING
 MOVE MG+1,M3,9
 MOV AH,3 ;WRITE
 JMP STDENT
;
 DB 'VERIFY8 ROUTINE'
;                  0   2   4    6   8    10
VERIFY8 PROC NEAR ;DRV,CYL,HEAD,SEC,RECS,BUF
 PUSH BP
 MOV BP,SP
 ADD BP,4 ;POINT TO PARAMETER BEGINNING
 MOVE MG+1,M4,9
 MOV AH,4 ;VERIFY
 JMP STDENT
;
 DB 'FORMAT8 ROUTINE'
;                  0   2   4    6   8    10
FORMAT8 PROC NEAR ;DRV,CYL,HEAD,SEC,RECS,BUF
 PUSH BP
 MOV BP,SP
 ADD BP,4 ;POINT TO PARAMETER BEGINNING
 MOVE MG+1,M5,9
 MOV AH,5 ;FORMAT
 JMP STDENT
;
 DB 'RDDEL8 ROUTINE'
;
RDDEL8 PROC NEAR ;DRV,CYL,HEAD,SEC,RECS,BUF
 PUSH BP
 MOV BP,SP
 ADD BP,4
 MOVE MG+1,M6,9
 MOV AH,6 ;READ DELETED SECTORS
 JMP STDENT
;
 DB 'WRTDEL8 ROUTINE'
;
WRTDEL8 PROC NEAR ;DRV,CYL,HEAD,SEC,RECS,BUF
 PUSH BP
 MOV BP,SP
 ADD BP,4
 MOVE MG+1,M7,9
 MOV AH,7 ;WRITE DELETED SECTORS
 JMP STDENT
;
STDENT:
 MOVE MG+20,ERRTBL,16
 MOV AL,BYTE PTR [BP+8] ;NUMBER OF RECORDS (SECTORS)
 MOV BX,WORD PTR [BP+10] ;ADDRESS OF BUFFER
 MOV CH,BYTE PTR [BP+2] ;LOW ORDER 4 BITS OF CYL
 MOV CL,BYTE PTR [BP+3] ;HIGH ORDER 2 BITS OF CYL
 SHL CL,1 ;SHIFT THE 2 BITS TO TOP OF CL
 SHL CL,1
 SHL CL,1
 SHL CL,1
 SHL CL,1
 SHL CL,1
 OR  CL,BYTE PTR [BP+6] ;OR IN THE SECTOR NUMBER
; MOV CH,BYTE PTR [BP+2] ;CYLINDER
; MOV CL,BYTE PTR [BP+6] ;SECTOR
 MOV DH,BYTE PTR [BP+4] ;HEAD
 MOV DL,BYTE PTR [BP]   ;DRIVE
 JMP FUNCTION
;
 DB 'FUNCTION ROUTINE'
;
FUNCTION:      ;PERFORM THE REQUESTED FUNCTION
 MOV RSTCNT,0
FT01:
 MOV TRYCNT,0
FT02:
 PUSH AX
 PUSH BX
 PUSH CX
 PUSH DX
 INT 13H
 POP DX
 POP CX
 POP BX
 POP AX
 JNC FT03 ;ALL OK
 INC TRYCNT
 CMP TRYCNT,3
 JBE FT02
 INC RSTCNT
 CMP RSTCNT,3
 JG  FT04 ;FATAL ERROR
 PUSH AX
 PUSH BX
 PUSH CX
 PUSH DX
 MOV AH,0
 INT 13H
 POP DX
 POP CX
 POP BX
 POP AX
 JMP FT01
FT03:
 CALL MESSAGE
 POP BP
 MOV AX,0
 RET
FT04:
 MOV SI,OFFSET ERRTBL
FT05:
 CMP BYTE PTR [SI],255
 JE  FT06
 CMP BYTE PTR [SI],AH
 JE  FT06
 ADD SI,17
 JMP FT05
FT06:
 INC SI
 MOV DI,OFFSET MG+20
 PUSH CX
 MOV CX,16
 REP MOVSB
 POP CX
 PUSH AX
 CALL MESSAGE
 POP AX
 POP BP
 RET
WRTDEL8 ENDP
RDDEL8 ENDP
FORMAT8 ENDP
VERIFY8 ENDP
WRITE8 ENDP
READ8 ENDP
;
 DB 'RESET8 ROUTINE'
;
RESET8 PROC NEAR ;DRV
 PUSH BP
 MOV BP,SP
 ADD BP,4 ;POINT TO PARAMETER BEGINNING
 MOV DL,BYTE PTR [BP]
 MOV AH,0
 INT 13H
 MOV CX,0
 MOV DX,0
 MOVE MG+1,M0,9
 PUSH BX
 PUSH CX
 MOVE MG+20,ERRTBL,16
 POP CX
 POP BX
 CALL MESSAGE
 POP BP
 MOV AX,0
 RET
RESET8 ENDP
;
 DB 'SET8 ROUTINE'
SET8 PROC NEAR ;DRV,FMT[,BUF]
 PUSH BP
 MOV BP,SP
 ADD BP,4 ;POINT TO PARAMETER BEGINNING
 MOV AH,8
 MOV AL,BYTE PTR [BP+2] ;FORMAT TO SET
 CMP AL,8
 JNE S801
 MOV SI,WORD PTR [BP+4]
S801:
 MOV DL,BYTE PTR [BP]   ;DRIVE
 INT 13H
 MOVE MG+1,M8,9
 MOV CX,0
 MOV DX,0
 PUSH BX
 PUSH DX
 MOVE MG+20,ERRTBL,16
 POP BX
 POP DX
 CALL MESSAGE
 POP BP
 MOV AX,0
 RET
SET8 ENDP
;
 DB 'FIND8 - FIND8 - FIND8 - FIND8'
FIND8 PROC NEAR ;DRV,CYL,HEAD
 PUSH BP
 MOV BP,SP
 ADD BP,4
 MOV CL,1
 MOV CH,BYTE PTR [BP+2] ;CYLINDER
 MOV DL,BYTE PTR [BP]   ;DRIVE
 MOV DH,BYTE PTR [BP+4] ;HEAD
 MOV AL,0 ;FORMAT CODE
 MOV AH,8 ;FUNCTION (SET FORMAT)
 PUSH AX  ;SAVE REGISTERS
 PUSH CX
 PUSH DX
 MOV AH,0 ;RESET DRIVE
 INT 13H
 POP DX
 POP CX
 POP AX
FD01:      ;LOOP TO HERE TO RETRY FORMATS
 PUSH AX
 PUSH CX
 PUSH DX
 INT 13H   ;SET FORMAT
 POP DX
 POP CX
 MOV TRYCNT,3
 LEA BX,TESTREAD
FD02:
 MOV AX,0601H ;READ ONE SECTOR INTO MEMORY
 PUSH BX
 PUSH CX
 PUSH DX
 INT 13H
 POP DX
 POP CX
 POP BX
 JNC FD06 ;FORMAT FOUND
 DEC TRYCNT
 JNZ FD02
 POP AX
 INC AL   ;INC TO NEXT FORMAT
 CMP AL,8
 JB  FD01
FD03:    ;NOT FOUND BY JUST READING
 MOV AH,8
 MOV AL,0
FD04:
 PUSH AX
 PUSH BX
 PUSH CX
 PUSH DX
 INT 13H ;SET FORMAT
 POP DX
 POP CX
 POP BX
 MOV TRYCNT,5
FD05:
 PUSH BX
 PUSH CX
 PUSH DX
 MOV AH,0
 INT 13H ;RESET DRIVE
 POP DX
 POP CX
 POP BX
 PUSH BX
 PUSH CX
 PUSH DX
 MOV AX,0201H
 INT 13H ;READ DATA
 POP DX
 POP CX
 POP BX
 JNC FD06 ;FORMAT FOUND
 DEC TRYCNT
 JNZ FD05
 POP AX
 INC AL   ;INC TO NEXT FORMAT
 CMP AL,8
 JB  FD04
;
 MOV AX,-1 ;FORMAT NOT FOUND
 POP BP
 RET
FD06:
 POP AX
 AND AX,7 ;SET RETURN
 POP BP
 RET
FIND8 ENDP
;
MESSAGE PROC NEAR
 OR DH,30H
 MOV MG+15,DH
 MOV BX,0
 MOV BL,CL ;SAVE SECTOR
 AND BL,3FH ;CLEAR OUT HIGH ORDER BITS OF CYL
 MOV AX,0
 MOV AH,CL
 MOV CL,6
 SHR AX,CL
 OR  AL,CH ;GET CYL
 MOV DX,0
 MOV CX,100
 DIV CX
 OR  AL,30H
 MOV MG+11,AL
 MOV AX,DX
 MOV DX,0
 MOV CX,10
 DIV CX
 OR  AL,30H
 OR  DL,30H
 MOV MG+12,AL
 MOV MG+13,DL
 MOV AX,0
 MOV AL,BL ;RETRIEVE SECTOR
 MOV DX,0
 DIV CX
 OR AL,30H
 OR DL,30H
 MOV MG+17,AL
 MOV MG+18,DL
 LEA DX,MG
 MOV AH,9
 INT 21H
 RET
MESSAGE ENDP
 ENDPS
 END
