C ATG:F.125RGC,ATG:A.125RGC
C....
C.... GENERAL INSTRUMENT CORPORATION
C.... MICROELECTRONICS DIVISION
C.... 600 WEST JOHN STREET
C.... HICKSVILLE, NEW YORK  11802
C....
C.... PUNCH SOURCE FILE IN 8 BIT ASCII CODE
C.... FOR INPUT TO CP1600 TEXT EDITOR AND ASSEMBLERS
C....
      IMPLICIT INTEGER (A-Z)
      DIMENSION IN(16),NAME(8),ACCNT(8)
      DATA KSPC/1H /,KCOMMA/1H,/
      DIMENSION LINE(80),KHR(64)
      DATA KHR /' ','!','"','#','$','%','&',1H','(',')',
     + '*','+',',','-','.','/','0','1','2','3','4','5','6',
     + '7','8','9',':',';','<','=','>','?','@','A','B','C','D',
     + 'E','F','G','H','I','J','K','L','M','N','O','P','Q',
     + 'R','S','T','U','V','W','X','Y','Z','|','\','~','^','_'/
C.... IDENTIFY
      WRITE(2,1000)
 1000 FORMAT(' S16ATG - ASCII TAPE GENERATOR VER. 01C')
C.... CLEAR INPUT BUFFER
   10 DO 12 I = 1,16
      IN(I) = KSPC
   12 CONTINUE
C.... REQUEST FILE NAME, ACCOUNT
      WRITE(2,1020)
 1020 FORMAT(' ENTER FILE NAME,ACCOUNT')
      READ(1,1030) IN
 1030 FORMAT(16A1)
C.... IF NULL FILE NAME, STOP
      IF(IN(1) .EQ. KSPC) STOP
C.... SEPARATE FILE NAME & ACCOUNT
      DO 14 I = 1,8
      NAME(I) = KSPC
      ACCNT(I) = KSPC
   14 CONTINUE
C.... MOVE FILE NAME
      I = 1
      DO 16 K = 1,8
      IF(IN(I) .EQ. KSPC) GO TO 100
      IF(IN(I) .EQ. KCOMMA) GO TO 18
      NAME(I) = IN(I)
      I = I + 1
   16 CONTINUE
      IF(IN(I) .EQ. KSPC) GO TO 100
      IF(IN(I) .NE. KCOMMA) GO TO 50
C.... MOVE ACCOUNT
   18 I = I + 1
      J = 1
      DO 20 K = 1,8
      IF(IN(I) .EQ. KSPC) GO TO 100
      ACCNT(J) = IN(I)
      J = J + 1
      I = I + 1
   20 CONTINUE
      GO TO 100
C.... INPUT STRING ERROR
   50 WRITE(2,1040)
 1040 FORMAT(' STRING ERROR !!')
      GO TO 10
C.... OPEN FILE FOR INPUT
  100 CALL OPNINP(NAME(1),ACCNT(1),K)
C.... CHECK FOR FILE FOUND
      IF(K .EQ. 0) GO TO 150
      WRITE(2,1050)
 1050 FORMAT(' FILE DOES NOT EXIST !!')
      GO TO 10
C.... OPEN PAPER TAPE
  150 CALL OPNTAP
C.... READ INPUT FILE RECORD
  200 READ(3,1060,END=900) LINE
 1060 FORMAT(80A1)
C.... CONVERT TO 8 LEVEL ASCII
      K = 80
  300 IF(LINE(K) .NE. KHR(1)) GO TO 400
      K = K - 1
      IF(K .GT. 1) GO TO 300
  400 DO 700 I = 1,K
      DO 500 J = 1,64
      IF(LINE(I) .EQ. KHR(J)) GO TO 600
  500 CONTINUE
      J = 1
  600 LINE(I) = J + 2Z9F
  700 CONTINUE
C.... PUNCH ASCII RECORD
      DO 800 J = 1,K
      CALL PUNFRM(LINE(J))
  800 CONTINUE
C.... PUNCH CARRIAGE RETURN & LINE FEED
      CALL PUNFRM(2Z8D)
      CALL PUNFRM(2Z8A)
      GO TO 200
C.... CLOSE INPUT FILE
  900 CALL CLSINP
C.... PUNCH FORM FEED (214) END OF FILE
      CALL PUNFRM(2Z8C)
C.... CLOSE PAPER TAPE
      CALL CLSTAP
      GO TO 10
      END
         SYSTEM   SIG9
         SYSTEM   BPM
F:1      DSECT    1
F:1      M:DCB    (DEVICE,'UC')
F:2      DSECT    1
F:2      M:DCB    (DEVICE,'UC')
F:3      DSECT    1
F:3      M:DCB    (FILE)
         END
         SYSTEM   SIG9
          SYSTEM BPM
          REF F:3,9SETUP0,9SETUPN
          DEF OPNINP,CLSINP
          CSECT 1
*
* OPEN INPUT FILE
*
*  CALLING SEQUENCE:
*    CALL OPNINP(FNAME,FACCNT,ERRFLG)
*     ERRFLG = 0 NORMAL
*     ERRFLG = 1 FILE DOES NOT EXIST
*     ERRFLG = 2 ERROR
*
OPNINP    LI,5 3 *3 ARGS
          BAL,6 9SETUPN *TRANSFER ARG ADDRESSES
          DATA FILE,ACCNT,ERR
          STW,15 EXIT *SAVE RETURN ADDRESS
*
          LI,2 0 *COUNT # CHRS IN USER FILE NAME
          LI,14 0
          LW,15 KSPC
FNCNT     CW,15 *FILE,2 *CHK FOR BLANKS
          BE FNMOV *NAME DONE
          AI,2 1
          AI,14 1
          CI,14 8 *8 CHRS MAX
          BL FNCNT
*
FNMOV     STB,14 OPNNAME   ;CHR CNTR TO FPT
          LI,2 0 *FILE NAME WORD INDEX
          LI,3 1 *FILE NAME BYTE INDEX
FNXFR     LB,13 *FILE,2 *MOVE FILE NAME TO FPT
          STB,13 OPNNAME,3 ;WORD TO BTYE
          AI,2 4
          AI,3 1
          BDR,14 FNXFR
*
          LI,14 1 *FPT TERMINATION BYTE
          CW,15 *ACCNT *CHK FOR USER ACCOUNT
          BE SETFPT *NONE
          LI,14 0   ;FPT CONTINUE/TERMINATION FLAG
SETFPT   LI,2     1                 ;INSERT FPT TERM/CONT FLAG
          STB,14 OPNNMHDR,2
*
         CW,15    *ACCNT            ;CHK FOR NO USER ACCNT
          BE FILEOPN   ;NONE
          LI,4 8 *8 CHRS MAX
          LI,2 0
          LI,3 0
ACXFR     LB,13 *ACCNT,2 *TRANSFER USER FILE ACCOUNT
          STB,13 OPNACCN,3
          AI,2 4
          AI,3 1
          BDR,4 ACXFR
*
FILEOPN   CAL1,1 OPNFPT   ;OPEN FILE
          LI,2 0   ;CLR ERR FLG
OPNEXIT   STW,2 *ERR
          B *EXIT
OPNABN    LI,2 1   ;SET FILE NON EXIST FLAG
          B OPNEXIT
OPNERR    LI,2 2   ;SET ERROR FLAG
          B OPNEXIT
*
* CLOSE INPUT FILE
*
CLSINP    BAL,6 9SETUP0
          STW,15 EXIT
          M:CLOSE F:3,(SAVE)
          B *EXIT
KSPC      TEXT '    '
*
*  TEMPORARIES
*
         CSECT    0
FILE      RES 1
ACCNT     RES 1
ERR       RES 1
EXIT      RES 1
*
*  FILE FPT
*
OPNFPT   GEN,8,24 X'14',F:3
OPNFPTCW DATA X'C7400009'  ;FPT CNTRL WORD
         DATA OPNERR,OPNABN
         DATA 1   ;CONSEC
         DATA 1   ;SEQUENTIAL
         DATA 1   ;INPUT
         DATA 2   ;SAVE
OPNNMHDR DATA X'01010303'   ;FILE NAME HDR
OPNNAME  DATA X'08404040'   ;FILE NAME
         DATA X'40404040'
         DATA X'40404040'
         DATA X'02010202'   ;FILE ACCNT HDR
OPNACCN  DATA X'40404040'
         DATA X'40404040'
         END
         SYSTEM   BPM
         SYSTEM   SIG9
         REF      9SETUP0,9SETUP1,M:UC
         CSECT    1
R1       EQU      1
R2       EQU      2
R3       EQU      3
R6       EQU      6
R14      EQU      14
R15      EQU      15
*
*        OPEN PAPER TAPE FOR OUTPUT
*
         DEF      OPNTAP
OPNTAP   BAL,R6   9SETUP0
         STW,R15  EXIT
*        GIVE USER DIRECTIONS
         M:PRINT  (MESS,OPNMES0)
*        WAIT FOR USER RESPONSE
         M:READ   M:UC,(BUF,BYTE),(SIZE,1)
         B        *EXIT
OPNMES0  TEXTC    ' HIT CONTROL C '
*
*        CLOSE PAPER TAPE OUTPUT
*
         DEF      CLSTAP
CLSTAP   BAL,R6   9SETUP0
         STW,R15  EXIT
*        WAIT FOR USER RESPONSE
         M:READ   M:UC,(BUF,BYTE),(SIZE,1)
         B        *EXIT
*
*        PUNCH 100 BLANK FRAMES ON TAPE
*
         DEF      LEADER
LEADER   BAL,R6   9SETUP0
         STW,R15  EXIT1
         LI,R2    100               ;COUNT
         LI,R1    0                 ;ZERO BYTE
         BAL,R15  PUNFRM0
         BDR,R2   $-1
         B        *EXIT1
*
*        PUNCH ONE BYTE ON TAPE
*
         DEF      PUNFRM
PUNFRM   BAL,R6  9SETUP1
         DATA     BYTE
         LW,R1    *BYTE
PUNFRM0  STW,R1   BYTE
         M:DEVICE M:UC,(BIN)
         M:DEVICE M:UC,(DRC)
         M:WRITE  M:UC,(BUF,BYTE),(SIZE,1),(BTD,3)
         M:DEVICE M:UC,(BCD)
         M:DEVICE M:UC,(NODRC)
         B        *R15
         CSECT    0
BYTE     RES      1
EXIT     RES      1
EXIT1    RES      1
         END

!C $ATG.125RGC
!JOB
!LIMIT (CORE,20),(TIME,20)
!ASSIGN M:SI,(FILE,ATG:F)
!FORTRAN SI,LS,GO
!ASSIGN M:SI,(FILE,ATG:A)
!METASYM SI,LO,BA,GO
!LOAD (GO),(LMN,S16ATG),(PERM),(MAP)

