#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:rc 12.1$ 
# $ACIS:rc 12.1$ 
# $Source: /ibm/acis/usr/src/etc/RCS/rc,v $ 

HOME=/; export HOME
PATH=/bin:/usr/bin:/etc

noremount() {
        echo ""
        echo "WARNING - file systems have NOT been remounted read-write."
        echo "Use fsck to fix any file system problems, rebooting the"
        echo "system if any problems are found with a mounted file system."
        echo "After file systems have fsck'ed cleanly, you can remount file"
        echo "systems and finish single-user setup using \"/etc/rc.single\"."
}

intr /etc/mount -n -r /usr
# trust that everything is ok when /fastboot exists
# and skip doing the fsck'ing the file systems.
if [ -r /fastboot ]; then
        echo "Fast boot ... skipping disk checks"
        error=0
else
        if [ $1x = singleuserx ]; then
                echo "checking / and /usr filesystems"
                intr /etc/fsck -p -w / /usr
                error=$?
                what="Fsck"
        else
                echo "checking filesystems"
                intr /etc/fsck -p -w
                error=$?
                what="Reboot"
        fi
fi

case $error in
0|2)
        #
        # Everything looks good.
        #
        # Finish the single user setup which will remount the
        # file systems read-write and do other work which can
        # be done only on a writable root file system.
        #
        sh /etc/rc.single
        #
        # We need to check whether rc.single successfully completed.
        # It can fail, for example, when /etc/fstab has gotten fouled up.
        #
        nerr=$?
        case $nerr in
        0)
                error=$nerr
                ;;
        1)
                echo "Remount of / failed - check /etc/fstab"
                error=$nerr
                ;;
        2)
                echo "Remount of /usr failed - check /etc/fstab"
                error=$nerr
                ;;
        *)
                echo "Unknown error in /etc/rc.single - help!"
                error=$nerr
                ;;
        esac
        ;;
4)
        if [ $1x = singleuserx ]; then
                echo "Mounted FS fixed - rebooting single-user."
                reboot -n -- -s
        else
                echo "Mounted FS fixed - rebooting."
                reboot -n
        fi
        ;;
8)
        echo "$what failed...help!"
        noremount
        ;;
12)
        echo "$what interrupted."
        noremount
        ;;
*)
        echo "Unknown error in reboot fsck."
        noremount
        ;;
esac

#
# exit with error status from fsck
#
exit $error
