/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:bits.c 12.0$ */
/* $ACIS:bits.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/lib/src/RCS/bits.c,v $ */

#ifndef lint
static char *rcsid = "$Header:bits.c 12.0$";
#endif

/*
 * bits.c: a package of bit manipulation routines
 */

/*
 *
 * bits.c: a package of routine to do bit manipulation
 *
 *  NAME
 *
 * bit_test, bit_set: tests and sets bits
 *
 *  SYNOPSIS
 *
 *  #include "itc.h"
 *  #include "stddefs.h"
 *  #include "bits.h"
 *
 *  boolean bit_test (start, offset)
 *  in byte *start;
 *  in natural offset;
 *
 *  bit_set (start, offset, bit)
 *  inout byte *start;
 *  in natural offset;
 *  in boolean bit;
 *
 */

#include "itc.h"
#include "stddefs.h"
byte bit_only[] = {
    0x80,
    0x40,
    0x20,
    0x10,
    0x08,
    0x04,
    0x02,
    0x01
};

byte bit_allbut[] = {
    0x7f,
    0xbf,
    0xdf,
    0xef,
    0xf7,
    0xfb,
    0xfd,
    0xfe
};

boolean bit_test (start, offset)
in byte *start;			/* pointer to first byte */
in natural offset;		/* bit offset (1st bit is at offset 0) */
{
    natural byte_offset;
    natural bit_pos;
    
    byte_offset = offset/8;
    bit_pos = offset%8;
    if (*(start+byte_offset)&bit_only[bit_pos]) {
	return (True);
    } else {
	return (False);
    }
}

bit_set (start, offset, bit)
inout byte *start;
natural offset;
boolean bit;
{
    byte *pos;
    natural bit_pos;
    
    pos = offset/8 + start;
    bit_pos = offset%8;
    if (bit) {
	*pos = *pos | bit_only[bit_pos];
    } else {
	*pos = *pos & bit_allbut[bit_pos];
    }
}

