/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:kbdlock.c 12.0$ */
/* $ACIS:kbdlock.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/RCS/kbdlock.c,v $ */

#ifndef lint
static char *rcsid = "$Header:kbdlock.c 12.0$";
#endif

#include <stdio.h>
#include <sys/file.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <machinecons/kbd_emul.h>

#define STDIN 0

char *table[] = {
	"hd0","hd1","hd2","hd3","fd0","fd1","fd2","fd3","off",0 };
char values[] = {
	 0xd0,0xd1,0xd2,0xd3,0xf0,0xf1,0xf2,0xf3,0, 0 };

main(argc, argv)
	int argc;
	char *argv[];
{
	int fd, i, boot = 0xd0;

	if (argc > 2)
		usage(argv[0]);
	if (argc == 2) { 
		for (i = 0 ; (table[i] != 0) && 
			(strncmp(argv[1],table[i],4) != 0) ; i++)
			/* void */;
		if (table[i] == 0)
			usage(argv[0]);
		boot=values[i];
	}
	/* 
	 * Change the ioctl command when dkio.h has
	 * been finished.
	 */

	fd = STDIN;

	if (ioctl(fd, KBDSSECURE, &boot) != NULL) {
		if ((fd = open("/dev/console", O_WRONLY)) < NULL) {
			perror("/dev/console");
			exit (1);
		} else {
			if (ioctl(fd, KBDSSECURE, &boot) != NULL) {
				perror("/dev/console");
				exit(1);
			}
		close (fd);
		}
	}
	printf("********* Console keyboard is %slocked **********\n",boot ? "" : "un");
}

usage(prog)
	char	*prog;
{
	int i;

	fprintf(stderr, "usage: %s [",prog);
	for (i=0; table[i] != 0; i++) {
		fprintf(stderr,"%s",table[i]);
		if (table[i+1] != 0)
			fprintf(stderr,"|");
		else
			fprintf(stderr,"]\n");
	}
	exit (1);
}
