/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef RP_SEEN
#define RP_SEEN 1
/* $Header:rp.h 12.0$ */
/* $ACIS:rp.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/rp.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidrp = "$Header:rp.h 12.0$";
#endif

extern	int	rp_debug;

extern	int	rp_state;
extern	FONT	*rp_active;
extern	int	rp_x;
extern	int	rp_y;
extern	int	rp_pgwidth;
extern	int	rp_pgheight;
extern	int	rp_display;
extern	int	rp_memory;
extern	int	rp_memused;
extern	int	rp_orient;
extern	FILE	*rp_file;

/***============================================================***/

#define RP_UNKNOWN	0
#define RP_CLEAR	1
#define RP_MARKED	2
#define RP_CLOSED	4

/***===================================================================***/

#define rp_charok(c)	(((c)>=RP_MIN_CHAR)&&((c)<=RP_MAX_CHAR))
extern int rp_init();
extern int rp_activate();
extern int rp_rotate();


#define rp_download(c,fc)	(_rp_isloaded(c)?TRUE:_rp_download(c,fc))
#define rp_mvabsolute(x,y)	(rp_habs(x),rp_vabs(y))
#define rp_mvrelative(x,y)	(rp_hrel(x),rp_vrel(y))
#define rp_habs(x)     	(x!=rp_x?\
		_rp_command(PMP_SET_HORIZONTAL),_rp_word(x),rp_x=x:\
		FALSE)
#define rp_vabs(y)     	(y!=rp_y?\
		_rp_command(PMP_SET_VERTICAL),_rp_word(y),rp_y=y:\
		FALSE)
#define rp_hrel(x)     (x?\
		_rp_command(PMP_MOVE_HORIZONTAL),_rp_word((x)),rp_x+=(x):\
		FALSE)
#define rp_vrel(y)     	(y?\
		_rp_command(PMP_MOVE_VERTICAL),_rp_word(y),rp_y+=y:\
		FALSE)
#define rp_string(s,l,w)	(_rp_byte(l),_rp_block(s,l),rp_x+=(w),\
		rp_state= RP_MARKED)
#define rp_eject(clr,tray)	(_rp_command(PMP_PRINT_PAGE),\
			_rp_byte(clr|tray),\
			(clr==RP_CLEAR_PAGE_MAP?rp_state=RP_CLEAR:FALSE))
extern int rp_clear();
#define rp_set_display(n)	(_rp_command(PMP_SET_DISPLAY),rp_display=(n),\
							_rp_byte(rp_display))
#define rp_ring()	(_rp_command(PMP_RING_BELL))
#define rp_jog()	(_rp_command(PMP_JOG_TRAY))
#define rp_home()	(_rp_parmcmd(PMP_RESTORE_CURSOR,RP_HOME_REG))
#define rp_deactivate()	(rp_active?\
		_rp_command(PMP_DEACTIVATE_FONT),rp_active=NULL:\
		NULL)
#define rp_image(h,w,l,i) (_rp_drw_command(PMP_GENERATE_PATTERN_IMMEDIATE),\
				 _rp_byte(RP_PORTRAIT),\
				 _rp_word(h),_rp_word(w),\
				 _rp_24bits(l),\
				 _rp_block(i,l))
extern int rp_index();

/***===================================================================***/

#define RP_MIN_CHAR	0
#define RP_MAX_CHAR	255
#define RP_NUMBEROFCHARS (1+RP_MAX_CHAR-RP_MIN_CHAR)
#define RP_MIN_FONT	0
#define RP_MAX_FONT	255
#define RP_MIN_DISPLAY	0
#define RP_MAX_DISPLAY	99
#define RP_CLEAR_DISPLAY	PMPARG_CLEAR_DISPLAY

#define RP_NUMBEROFFONTS (1+RP_MAX_FONT-RP_MIN_FONT)
#define RP_MAX_PGWIDTH	2040
#define RP_DFL_PGWIDTH	2040
#define RP_MAX_PGHEIGHT	3360
#define RP_DFL_PGHEIGHT	2640
#define RP_MAX_STRING	127
#define RP_UNMOUNTED	-1
#define RP_PRINTER_MEMORY	110000


#define RP_NO_TRAY		PMPARG_UNDEF_TRAY
#define RP_MAIN_TRAY		PMPARG_MAIN_TRAY
#define RP_ALTERNATE_TRAY	PMPARG_ALTERNATE_TRAY

#define RP_UNDEF_PAGE_MAP	PMPARG_UNDEF_MAP
#define RP_SAVE_PAGE_MAP	PMPARG_SAVE_MAP
#define RP_CLEAR_PAGE_MAP	PMPARG_CLEAR_MAP

#define RP_PORTRAIT		PMPARG_PORTRAIT
#define RP_LEFT_LANDSCAPE	PMPARG_LEFT_LANDSCAPE
#define RP_RIGHT_LANDSCAPE	PMPARG_RIGHT_LANDSCAPE
#define RP_INVERTED		PMPARG_INVERTED

#define RP_MIN_REG		0
#define RP_MAX_REG		15
#define RP_HOME_REG		0
#include <pmp/private_rp.h>

#endif /* RP_SEEN */
