/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:vp.c 12.0$ */
/* $ACIS:vp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/vp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:vp.c 12.0$";
#endif

#include <stdio.h>
#include <utils.h>
#include <pmp_utils.h>
#include <pmp_commands.h>
#include <char.h>
#include <font.h>
#include <vector.h>
#include <vp.h>
#include <rp.h>


int	vp_debug;
FONT	*vp_active;
int	vp_x;
int	vp_y;
int	vp_pgwidth= 2040;
int	vp_pgheight= 2640;
int	vp_orient;
int	vp_fonts;
int	vp_pending;
int	(*vp_flushfun)();

/***============================================================***/

vp_init()
{
    D_ENTRY(vp_debug,"vp_init()\n");
    vp_active=		NULL;
    vp_x=		0;
    vp_y=		0;
    vp_pgwidth=		rp_pgwidth;
    vp_pgheight=	rp_pgheight;
    vp_orient=		RP_PORTRAIT;
    vp_pending=		VP_NONE;
    vp_flushfun=	NULL;
    RETURN(TRUE);
}

/***============================================================***/

int
vp_rotate(new_orient)
register1 int new_orient;
{
register2 int direction;

    D_ENTRY1(vp_debug,"vp_rotate(%d)\n",new_orient);
    direction= u_direction(vp_orient,new_orient);
    if (direction==U_ROT_NOT) 
	RETURN(TRUE);
    if (direction==U_ROT_ILLEGAL)
	RETURN(FALSE);
    vp_flush(VP_NONE);
    u_rotatecoord(direction,vp_pgwidth,vp_pgheight,&vp_x,&vp_y);
    if ((direction==U_ROT_LEFT)||(direction==U_ROT_RIGHT)) {
	register3 int itmp;

	itmp= 		vp_pgwidth;
	vp_pgwidth= 	vp_pgheight;
	vp_pgheight=	itmp;
    }
    vp_orient= new_orient;
    RETURN(TRUE);
}	


/*

*/

/***============================================================***/
/***			VIRTUAL PRINTER VECTORS			***/
/***============================================================***/

	vectors		*vp_vectors=		NULL;
static	int		 vp_vec_last_x;
static	int		 vp_vec_last_y;

/***============================================================***/

static
vp_vec_flush()
{
    D_ENTRY(vp_debug,"vp_vec_flushpending()\n");
    if (vp_vectors) {
	v_flush(vp_vectors);
	v_reset(vp_vectors);
	RETURN(TRUE);
    }
    RETURN(FALSE);
}

/***============================================================***/

#define _v_update()	{\
		if (!vp_vectors)\
		    vp_vectors= v_new();\
		if (vp_pending!=VP_VECTORS) {\
		    vp_mode(VP_VECTORS,vp_vec_flush);\
		    rp_mvabsolute(vp_x,vp_y);\
		    vp_vec_last_x= vp_x;\
		    vp_vec_last_y= vp_y;\
		}\
		else {\
		    if ((vp_x!=vp_vec_last_x)||(vp_y!=vp_vec_last_y)) {\
		        v_move(vp_vectors,vp_x-vp_vec_last_x,vp_y-vp_vec_last_y);\
			vp_vec_last_x=vp_x;\
			vp_vec_last_y= vp_y;\
		} } }

/***============================================================***/

vp_vec_nofill()
{
    D_ENTRY(vp_debug,"vp_vec_nofill()\n");
    if (!vp_vectors) 
	vp_vectors= v_new();
    RETURN(v_nofill(vp_vectors));
}

/***============================================================***/

vp_vec_set_width(width)
register1 int	width;
{
    D_ENTRY1(vp_debug,"vp_vec_set_width(%d)\n",width);
    if (!vp_vectors) 
	vp_vectors= v_new();
    RETURN(v_set_width(vp_vectors,width));
}

/***============================================================***/

vp_vec_set_ends(ends)
register1 int	ends;
{
    D_ENTRY1(vp_debug,"vp_vec_set_ends(0x%x)\n",ends);
    if (!vp_vectors) 
	vp_vectors= v_new();
    RETURN(v_set_ends(vp_vectors,ends));
}

/***============================================================***/

vp_vec_fill(font,pattern,x,y)
register1 FONT	*font;
register2 int	 pattern;
register3 int	 x,y;
{
    D_ENTRY4(vp_debug,"vp_vec_fill(0x%x,%d,%d,%d)\n",font,pattern,x,y);
    if (!vp_vectors) {
	vp_vectors= v_new();
    }
    if (font) {
	rp_activate(font);
	rp_download(pattern,fnt_char(font,pattern));
    }
    RETURN(v_fill(vp_vectors,font,pattern,x,y));
}

/***===================================================================***/

int
vp_vec_absolute(new_x,new_y)
register1 int new_x,new_y;
{
    D_ENTRY2(vp_debug,"vp_vec_absolute(%d,%d)\n",new_x,new_y);
    _v_update();
    if (vp_inpage(vp_x,vp_y)&&vp_inpage(new_x,new_y)) {
	v_draw(vp_vectors,new_x-vp_x,new_y-vp_y);
    }
    else {
	v_move(vp_vectors,new_x-vp_x,new_y-vp_y);
    }
    vp_vec_last_x= vp_x=	new_x;
    vp_vec_last_y= vp_y=	new_y;
    RETURN(TRUE);
}

/***===================================================================***/

int
vp_vec_relative(x_move,y_move)
register1 int x_move,y_move;
{
register2 int inpage;

    D_ENTRY2(vp_debug,"vp_vec_relative(%d,%d)\n",x_move,y_move);
    _v_update();
    inpage= vp_inpage(vp_x,vp_y);
    vp_vec_last_x= vp_x+=	x_move;
    vp_vec_last_y= vp_y+=	y_move;
    if (inpage&&vp_inpage(vp_x,vp_y)) {
	v_draw(vp_vectors,x_move,y_move);
    }
    else {
	v_move(vp_vectors,x_move,y_move);
    }
    RETURN(TRUE);
}

/***===================================================================***/

int
vp_vec_h_absolute(new_x)
register1 int new_x;
{
    D_ENTRY1(vp_debug,"vp_vec_h_absolute(%d)\n",new_x);
    _v_update();
    if (vp_x_inpage(vp_x)&&vp_x_inpage(new_x)) {
	v_draw(vp_vectors,new_x-vp_x,0);
    }
    else {
	v_move(vp_vectors,new_x-vp_x,0);
    }
    vp_vec_last_x= vp_x=	new_x;
    RETURN(TRUE);
}

/***===================================================================***/

int
vp_vec_v_absolute(new_y)
register1 int new_y;
{
    D_ENTRY1(vp_debug,"vp_vec_v_absolute(%d)\n",new_y);
    _v_update();
    if (vp_y_inpage(vp_y)&&vp_y_inpage(new_y)) {
	v_draw(vp_vectors,0,new_y-vp_y);
    }
    else {
	v_move(vp_vectors,0,new_y-vp_y);
    }
    vp_vec_last_y= vp_y=	new_y;
    RETURN(TRUE);
}

/***===================================================================***/

int
vp_vec_h_relative(x_move)
register1 int x_move;
{
register2 int inpage;

    D_ENTRY1(vp_debug,"vp_vec_h_relative(%d)\n",x_move);
    _v_update();
    inpage= vp_x_inpage(vp_x);
    vp_vec_last_x= vp_x+=	x_move;
    if (inpage&&vp_x_inpage(vp_x)) {
	v_draw(vp_vectors,x_move,0);
    }
    else {
	v_move(vp_vectors,x_move,0);
    }
    RETURN(TRUE);
}

/***===================================================================***/

int
vp_vec_v_relative(y_move)
register1 int y_move;
{
register2 int inpage;

    D_ENTRY1(vp_debug,"vp_vec_v_relative(%d)\n",y_move);
    _v_update();
    inpage= vp_y_inpage(vp_y);
    vp_vec_last_y= vp_y+=	y_move;
    if (inpage&&vp_y_inpage(vp_y)) {
	v_draw(vp_vectors,0,y_move);
    }
    else {
	v_move(vp_vectors,0,y_move);
    }
    RETURN(TRUE);
}

/***============================================================***/

vp_draw_vectors(vs)
register1 vectors *vs;
{
    D_ENTRY1(vp_debug,"vp_draw_vectors(0x%x)\n",vs);
    vp_mode(VP_NONE,NULL);
    rp_mvabsolute(vp_x,vp_y);
    v_flush(vs);
    vp_x=	rp_x;
    vp_y=	rp_y;
    RETURN(TRUE);
}
