/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:environ.h 12.0$ */
/* $ACIS:environ.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/tools/RCS/environ.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidenviron = "$Header:environ.h 12.0$";
#endif

/***===================================================================***/

typedef struct EFENUM {
    			char    *ef_ename;
			int	 ef_eval;
		    } env_enum;

typedef struct EFLD {
    			char    *ef_name;
			int      ef_flags;
			union {
			    char *ef_sval;
			    int   ef_ival;
			} ef_val;
		    } env_field;

/***===================================================================***/

/* type of field */
#define EF_INT		0x0001
#define EF_STRING	0x0002
#define EF_ENUM		0x0004
#define EF_SET		0x0008
#define EF_DEFAULT	0x0100

#define ef_Flag(ef,f)	((ef)?(ef)->ef_flags&(f):FALSE)

typedef struct ENV {
			int  env_flags;
			char *env_tokens;
			char *env_name;
    			hashtable *env_fields;
		   } environ;

#define ENV_FOLDDOWN	0x01
#define ENV_FOLDUP	0x02

#define ENV_FIELD_START	0
#define ENV_FIELD_END	1
#define ENV_FIELD_SEP	2
#define ENV_ASSIGN	3
#define ENV_STR_START	4
#define ENV_STR_END	5
#define ENV_STR_QUOTE	6
#define ENV_NO_TOKEN	7

extern int env_debug;

extern environ *env_New();
extern char *env_Parse();
extern int   env_Token();
extern int   env_Int();
extern int   env_Enum();
extern int   env_SetVal();
extern char *env_String();
extern int   env_AddInt();
extern int   env_AddEnum();
extern int   env_AddSet();
extern char *env_AddString();
extern int   env_IsDefault();
#define env_Char(e,t)	((e)?(e)->env_tokens[(t)]:EOF)

