/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:hash.h 12.0$ */
/* $ACIS:hash.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/tools/RCS/hash.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidhash = "$Header:hash.h 12.0$";
#endif

#define hetype int

typedef struct HE {
		    char       *he_key;
		    hetype     *he_elem;
		    struct HE  *he_next;
		  } hashelem;

typedef struct HT {
		    int         ht_size;
		    hashelem    **ht_elems;
		    struct HT   *ht_next;
		  } hashtable;

  /*\
  |* PROVIDES:
  |*    ht_new(size)          -- Creates a new hash table of size
  |*                             'size' and returns a pointer to it.
  |*    ht_free(table)        -- Destroys 'table'
  |*    ht_rehash(table,size) -- Creates a new table of size 'size'
  |*                             and rehashes the contents of table
  |*                             into the newly created table. The
  |*                             original table is freed.
  |*                             to the new table.
  |*    ht_copy(table,size)   -- Creates a new table of size 'size'
  |*                             and rehashes the contents of table
  |*                             into the newly created table. Leaves
  |*                             'table' intact and returns a pointer
  |*                             to the new table.
  |*    ht_put(table,key,item)-- Stores 'item' in 'table' using 'key'
  |*                             If an item was already stored with
  |*                             'key', a pointer is returned to it.
  |*                             If 'key' was previously undefined,
  |*                             NULL is returned.
  |*    ht_get(table,key)     -- Returns the item associated with key
  |*                             in table.
  |*    ht_remove(table,key)  -- Removes item associated with 'key'
  |*                             from 'table' and returns a pointer to
  |*                             it.
  \*/

#ifdef DEBUG_UTILS
extern int ht_debug;
#endif /* DEBUG_UTILS */

extern hashtable *ht_new();
extern hashtable *ht_rehash();
extern hetype    *ht_put();
extern hetype    *ht_get();
extern hetype    *ht_remove();
extern int        ht_iterate();
