/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:pstext.c 12.1$ */
/* $ACIS:pstext.c 12.1$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/pp4216/RCS/pstext.c,v $ */

#ifndef lint
static char *rcsid = "$Header:pstext.c 12.1$";
#endif



#include <fcntl.h>
#include <stdio.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <pwd.h>

#define page_l      11    /* assume page_l inch long page */
#define point       72    /* 1 point = 1/72 of an inch */
#define point_size  11    /* Use a font that is size point_size */
#define tab_width    8    /* Nuber of columns to use for tab stops */
#define page_length 66    /* Default page_length */
#define page_width  80    /* Default page_width  */

char *FONT      = "Courier";
char *PAGEBEGIN = " /%s findfont %d scalefont setfont \n"; 
char *PAGEEND   = " showpage \n" ;
char *LINEBEGIN = " %d %d moveto (";
char *LINEEND   = ") show \n";
char *FONTFILE  = "/.psrc";

int length     = page_length;
int width      = page_width;
int print_ctrl = 0;
int pagex      = 0; 
int pagey      = 0;
int indent     = 0;

int maxy;
int topmargin;
int leftmargin;
char buff[1050];
int ps;

struct passwd *passwd_data;

main(argc, argv)
    int argc;
    char **argv;

{  char linebuff[258], userfont[256], *filename, ch;
   char *host, *acct_file, *argptr, *login = NULL;
   FILE *sd;
   int count = 0;

     while(count++ < argc) {
         if (argv[count][0] == '-') {
             argptr = &(argv[count][2]);
             switch(argv[count][1]) {
                 case 'c': 
                         print_ctrl = 1;
                         break;
                 case 'w':
                         width = atoi(argptr);
                         if (width <= 0) {
                             width = page_width;
                         }
                         break;
                 case 'l': 
                         length = atoi(argptr);
                         if (length <= 0) {
                             length = page_length;
                         }
                         break;
                 case 'i': 
                         indent = atoi(argptr);
                     	 break;
                 case 'n': 
                         login = argv[++count];
                	 break;
                 case 'h': 
                         host = argv[++count];
                         break;
                 default:
                         break;
             }
         }
         else
             acct_file = argv[count];
     }   
                 
 
     ps = 1;

     topmargin  = (page_l * point - (point_size * page_length)) / 2;
     leftmargin = point / 2;
     maxy       = point_size * length + (topmargin * 2);
     pagex = pagey = 0;

     strcpy(userfont, FONT);
     if (login != NULL) {
         passwd_data = getpwnam(login);    
         if (passwd_data != NULL) {
             filename = (char *) malloc(strlen(passwd_data) + 
                        strlen(FONTFILE) + 1);
             strcpy(filename, passwd_data->pw_dir);
             strcat(filename, FONTFILE);
             sd = fopen(filename, "r");
             if (sd != NULL) {
                 fgets(userfont, 256, sd);
                 userfont[strlen(userfont)-1] = '\0'; /* remove '\n' */
             }
             free(filename);
         }
     }
 
     sprintf(buff,PAGEBEGIN, userfont, point_size);
     write(ps, buff, strlen(buff));
     beginpage();
     
     ch = processline(linebuff); 
     while (!feof(stdin)) {
         nextline();
         write(ps, linebuff, strlen(linebuff));
         sprintf(buff,LINEEND);
         write(ps, buff, strlen(buff));
         if (ch == '\f') {
             sprintf(buff,PAGEEND);
             write(ps, buff, strlen(buff));
	     beginpage();         
         }
         ch = processline(linebuff); 
     }
     sprintf(buff,PAGEEND);
     write(ps, buff, strlen(buff));
     exit(0);
}



processline(dst)
   char *dst;

{  char *dp, ch; 
   int   count, tab = 0, col = 0;

   dp = dst;

   ch = getchar();
   while ((!feof(stdin)) && (ch != '\n') && (ch != '\f')) {
	if (dp >= dst + width - tab) {
	    ungetc(ch, stdin);
	    break;
        }
        if ((dp == dst) && (indent != 0)) {
            for (count=1; count <= indent; count++) 
                *dp++ = ' ';
        }
        tab = 0;
        switch(ch) {
        default : 
                  if ((ch >= ' ') || print_ctrl) 
                      *dp++ = ch;
                  break;

        case '\t':
                  col = (int) dp - (int) dst - indent;
                  if (col < width - tab_width - indent) {
                      for (count=1;count <= (tab_width - (col % tab_width)); 
                                                            count++)
                          *dp++=' ';
                  }
                  else {
                      tab = tab_width;
                  }
                  break;

        case '(':
        case ')':
        case '\\':
                  *dp++ = '\\';
                  *dp++   = ch;
                  break;
         
        case '\031':
		  /*
		   * lpd needs to use a different filter to
		   * print data so stop what we are doing and
		   * wait for lpd to restart us.
	  	   */
		   if ((ch = getchar()) == '\1') {
		       fflush(stdout);
		       kill(getpid(), SIGSTOP);
                   }
		   else
			*dp++ = ch;
                   break;
        }
        ch = getchar();
    }
    *dp = '\0';
    return(ch);
}



beginpage()
{
      pagey = maxy - topmargin; 
}


nextline()
{
      if (pagey <= topmargin ) {
          sprintf(buff,PAGEEND);
          write(ps, buff, strlen(buff));
          beginpage();
      }
      pagey -= point_size;
      pagex = leftmargin;
      sprintf(buff,LINEBEGIN, pagex, pagey);
      write(ps, buff, strlen(buff));
}

