/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:ac.c 12.0$ */
/* $ACIS:ac.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/tools/RCS/ac.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ac.c 12.0$";
#endif

#include <stdio.h>
#include <sys/time.h>
#include <utils.h>
#include <ac.h>

/***===================================================================***/

#ifdef DEBUG_UTILS
int ac_debug;
#endif

/***===================================================================***/

ac_record *
ac_Begin(user,host,type)
register2 char *user;
register3 char *host;
register4 char *type;
{
register1 ac_record *ac;
struct timeval  tp;
struct timezone tzp;

    D_ENTRY3(ac_debug,"ac_Begin(%s,%s,%s)\n",user,host,type);
    ac= (ac_record *)u_malloc(sizeof(ac_record));
    ac->ac_user= u_malloc(strlen(user)+1);
    strcpy(ac->ac_user,user);
    ac->ac_host= u_malloc(strlen(host)+1);
    strcpy(ac->ac_host,host);
    ac->ac_jobtype= u_malloc(strlen(type)+1);
    strcpy(ac->ac_jobtype,type);
    ac->ac_pages= 0;
    ac->ac_elapsed= 0;
    gettimeofday(&tp,&tzp);
    ac->ac_start= tp.tv_sec;
    ac->ac_flags= AC_RUNNING;
    RETURN(ac);
}

/***===================================================================***/

int
ac_Pause(ac)
register1 ac_record *ac;
{
struct timeval  tp;
struct timezone tzp;

    D_ENTRY1(ac_debug,"ac_Pause(0x%x)\n",ac);
    if (ac->ac_flags&AC_RUNNING) {
	gettimeofday(&tp,&tzp);
	ac->ac_pause= tp.tv_sec-ac->ac_pause;
	ac->ac_flags|= AC_PAUSED;
	ac->ac_flags&= ~AC_RUNNING;
	RETURN(TRUE);
    }
    else RETURN(FALSE);
}


/***===================================================================***/

int
ac_Restart(ac)
register1 ac_record *ac;
{
struct timeval  tp;
struct timezone tzp;

    D_ENTRY1(ac_debug,"ac_Restart(0x%x)\n",ac);
    if (ac->ac_flags&AC_PAUSED) {
	gettimeofday(&tp,&tzp);
	ac->ac_pause= tp.tv_sec-ac->ac_pause;
	ac->ac_flags|= AC_RUNNING;
	ac->ac_flags&= ~AC_PAUSED;
	RETURN(TRUE);
    }
    else RETURN(FALSE);
}
    
/***===================================================================***/

int
ac_End(ac,pages)
register1 ac_record *ac;
register2 int       pages;
{
struct timeval  tp;
struct timezone tzp;

    D_ENTRY2(ac_debug,"ac_End(0x%x,pages)\n",ac,pages);
    if (ac->ac_flags&AC_RUNNING) {
	gettimeofday(&tp,&tzp);
	ac->ac_elapsed= tp.tv_sec-ac->ac_start-ac->ac_pause;
	ac->ac_flags|= AC_DONE;
	ac->ac_flags&= ~AC_RUNNING;
	ac->ac_pages= pages;
	RETURN(TRUE);
    }
    else RETURN(FALSE);
}
    
/***===================================================================***/

ac_record *
ac_Load(fil)
register2 FILE *fil;
{
register1 ac_record *ac;
char tmp[31];
int  flags,pages;

    D_ENTRY1(ac_debug,"ac_Load(0x%x)\n",fil);
    ac= (ac_record *)u_malloc(sizeof(ac_record));
    fscanf(fil,"%.31s",tmp);
    ac->ac_user= u_malloc(strlen(&tmp[1])+1);
    strcpy(ac->ac_user,&tmp[1]);
    fscanf(fil,"%.31s",tmp);
    ac->ac_host= u_malloc(strlen(&tmp[1])+1);
    strcpy(ac->ac_host,&tmp[1]);
    fscanf(fil,"%.31s",tmp);
    ac->ac_jobtype= u_malloc(strlen(&tmp[1])+1);
    strcpy(ac->ac_jobtype,&tmp[1]);
    fscanf(fil,"%x %d %ld %ld %ld\n",&flags,&pages,&ac->ac_start,
					  &ac->ac_pause,&ac->ac_elapsed);
    ac->ac_flags= flags;
    ac->ac_pages= pages;
    RETURN(ac);
}

/***===================================================================***/

int
ac_Dump(fil,ac)
register1 FILE *fil;
register2 ac_record *ac;
{
    D_ENTRY2(ac_debug,"ac_Dump(0x%x,0x%x)\n",fil,ac);
    fprintf(fil,"%.30s %.30s %.30s ",ac->ac_user,ac->ac_host,ac->ac_jobtype);
    fprintf(fil,"%x %d %ld %ld %ld\n",ac->ac_flags,ac->ac_pages,
			      ac->ac_start,ac->ac_pause,ac->ac_elapsed);
    RETURN(TRUE);
}
