/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:cprintf.c 12.0$ */
/* $ACIS:cprintf.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/cprintf.c,v $ */

#ifndef lint
static char *rcsid = "$Header:cprintf.c 12.0$";
#endif


#ifndef lint
static char rcsid_cprintf_c[] = "$Header:cprintf.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file contains routines to perform canonicalized string functions.
 */

#include	<stdio.h>
#include	<ctype.h>
#include	<varargs.h>

#include	"rvd_types.h"
#include	"ctl_pkt.h"


/*VARARGS1*/
cprintf(form, va_alist)

/* Just like the normal printf, except that string arguments (printed with %s)
 * are canonicallized (space, tab, newline, backslash, and equals appearing
 * in such a string are quoted by preceding them with backslash).
 */

register char	*form;			/* format string */
va_dcl					/* variable arglist as in printf */
{
	register va_list	argp;	/* arg list traversal pointer */
	register char	c;		/* next character */
	register int	ival;		/* integer value */
	register char	*sval;		/* string value */
	double	dval;			/* float or double value */
	static	char	formstring[10];	/* for redoing formats */

	va_start(argp);			/* start the argument pointer */

	while ((c = *form++) != '\0') {
		if (c == '%') {
			switch (c = *form++) {
			case '\0':	/* end of string - error, but ignore */
				return;
			case 'd':
			case 'D':
			case 'o':
			case 'O':
			case 'x':
			case 'X':
			case 'u':
			case 'U':
				ival = va_arg(argp, int);
				formstring[0] = '%';
				formstring[1] = c;
				formstring[2] = '\0';
				printf(formstring, ival);
				break;
			case 'e':
			case 'f':
			case 'g':
				dval = va_arg(argp, double);
				formstring[0] = '%';
				formstring[1] = c;
				formstring[2] = '\0';
				printf(formstring, dval);
				break;
			case 'c':
				ival = va_arg(argp, int);
				cputc(ival, stdout);
				break;
			case 's':
				sval = va_arg(argp, char *);
				cputs(sval, stdout);
				break;
			default:
				(void)putchar(c);
				break;
			}
		} else {
			(void)putchar(c);
		}
	}
	va_end(argp);
}
