/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:whichfpa.c 12.0$ */
/* $ACIS:whichfpa.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/RCS/whichfpa.c,v $ */
#ifndef lint
static char *rcsid = "$Header:whichfpa.c 12.0$";
#endif

/* whichfpa -- print floating point unit in use to stdout */
/* -- can be used to see if setenv FPA advise taken */

#include <stdio.h>
#include <machine/float.h>

#define BZERO(x)	bzero((char *)&x, sizeof x);

void
usage(cmdname)
char *cmdname;
{
	fflush(stdout);
	fprintf(stderr, "\tUsage: %s [-s | -v]\n\n", cmdname);
	exit (-1);
}

main(argc, argv)
int	argc;
char	*argv[];
{
	char *cmdname = argv[0];
	int command_line_errors = 0;
	int verbose = 0;
	int silent = 0;
	int i, fpa, consumed;
	struct floatstate state;

	argv++;
	argc--;
	while (argc > 0) {
		if (strcmp(argv[0], "-v") == 0) {
			consumed = 1;
			verbose++;
		} else if (strcmp(argv[0], "-s") == 0) {
			consumed = 1;
			silent++;
		} else {
			consumed = 1;
			command_line_errors++;
			fflush(stdout);
			fprintf(stderr, "\tunknown %s==>%s<==\n", 
				((argv[0][0]=='-')?"option\t\t":"argument\t"),
				argv[0]);
		}
		argv += consumed;	/* position at next arguments */
		argc -= consumed;
	}

	if (command_line_errors) {
		usage(cmdname);
		/*NOTREACHED*/
	}

	fpa = whichfpa();

	if (silent) {
		exit(fpa);
	}

	/* Find out what is on the system */
	BZERO(state);
	i = sizeof state;
	if (getfloatstate(&state, &i) == -1) {
		fprintf(stderr,
		"Error trying getfloatstate().\n");
		exit(-2);
	}
	if (i != sizeof state) {
		fprintf(stderr,
		"Error getfloatstate: Bad floatstate length %d.\n", i);
		exit(-2);
	}

	if (verbose) {
		i = state.hardware_state;
		printf("FPAs installed:");
		if (float_has_e_afpa(i)) {
			printf(" e_afpa(on line),");
		} else if (float_has_e_afpa_hardware(i)) {
			printf(" e_afpa(marked down),");
		} else if (float_has_afpa(i)) {
			printf(" afpa(on line),");
		} else if (float_has_afpa_hardware(i)) {
			printf(" afpa(marked down),");
		}
		if (float_has_881(i)) {
			printf(" mc881,");
		}
		if (float_has_fpa(i)) {
			printf(" fpa,");
		}
		printf(" emul.\n");

		printf("FPA selected: ");
	}

	switch (fpa) {
	case 1:
		printf("mc881\n");
		break;
	case 2:
		printf("fpa\n");
		break;
	case 4:
		if (float_has_e_afpa(state.hardware_state))
			printf("e_afpa\n");
		else
			printf("afpa\n");
		break;
	case 8:
		printf("emul\n");
		break;
	default:
		printf("unknown??\n");
	}

	exit (fpa);
}
