/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:errorhcpp.c 12.0$ */
/* $ACIS:errorhcpp.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ucb/error/RCS/errorhcpp.c,v $ */

#ifndef lint
static char *rcsid = "$Header:errorhcpp.c 12.0$";
#endif

#ifndef lint
static	char *sccsid = "@(#)errorpi.c	1.3 (Berkeley) 7/2/83";
#endif

#include <stdio.h>
#include <ctype.h>
#include "error.h"

extern	char	*currentfilename;
static	char	*c_linenumber;

/*
 *	Attempt to handle error messages produced by hc and by pp
 *
 *	{E,w} "filename",LyCx: (msg)		hc error format
 *	{E,e,w} "filename",LyCx: (msg)		pp error format
 *	| (msg)					refers to previous line
 *	REPAIR: (msg)				repair for syntactical errors
 *	Object module not generated.		too many compiler errors
 *	x user error(s) y (unprinted) warnings	compiler error summary
 *
 */

extern	int	wordc;
extern	char	**wordv;
static	char	err_type = ' ';
static	int	filetype;

Errorclass hcpp()
{
	char	**nwordv;
	char	*cp1, *cp2;
	int	col;

	if (wordc >= 2)
	{   
	    /*
	     *	have a error message of the form:
	     *		letter "filename",LlinenumberCcolumn:	message
	     *	Turn into form: 
	     *		filename linenumber letter message
	     */
	    if ((strlen(wordv[1]) == 1)
	    && (   (*(wordv[1]) == 'E') 
		|| (*(wordv[1]) == 'w') 
		|| (*(wordv[1]) == 'e') )
	    && (*(wordv[2]) == '"')
	    && (lastchar(wordv[2]) == ':')) {
		cp1 = cp2 = wordv[2] + strlen(wordv[2]) - 1;
		while (isdigit(*--cp1))
			continue;
		if (*cp1 != 'C')
			return(C_UNKNOWN);
		*cp2 = '\0';
		col = atoi(cp1+1);
		*cp2 = ':';
		if (*--cp1 != '/')
			return(C_UNKNOWN);
		cp2 = cp1;
		while (isdigit(*--cp1))
			continue;
		if (  (*cp1 != 'L') 
		    || (*(cp1-1) != ',')
		    || (*(cp1-2) != '"')
		)
			return(C_UNKNOWN);
		*cp2 = '\0';
		c_linenumber = strsave(++cp1);
		*(cp1-3) = '\0';
		wordv[2]++;
		nwordv = wordvsplice(1, wordc, wordv + 1);
		currentfilename = strsave(wordv[2]);
		if ((lastchar(currentfilename) == 'p') &&
		    (next_lastchar(currentfilename) == '.'))
			filetype = INPP;
		else
			filetype = INHC;
		if (wordc == 2) {
		/*
		 *	no 'message' was given, so return synchronization,
		 *	and remember letter in 'err_type'
		 */
		    err_type = *(wordv[1]);
		    language = filetype;
		    return(C_SYNC);
		}
		else
		{
		    err_type = ' ';
		    nwordv[0] = wordv[2];
		    nwordv[1] = cp1;
		    nwordv[2] = wordv[1];
		    wordc += 1;
		    wordv = nwordv - 1;
		    language = filetype;
		    return(C_TRUE);
		}
	    }
	    else
	    if (strcmp(wordv[1],"REPAIR:") == 0)
	    {
	    /*
	     *	have a 'REPAIR:' message; treat it as a continuation
	     *	of the previous line, inserting whole message
	     */
		    nwordv = wordvsplice(2, wordc, wordv+1);
		    nwordv[0] = strsave(currentfilename);
		    nwordv[1] = strsave(c_linenumber);
		    nwordv[2] = wordv[1];
		    wordv = nwordv - 1;
		    wordc += 2;
		    language = filetype;
		    return(C_TRUE);
	    }
	    else 
	    if ((strlen(wordv[1]) == 1) && (*(wordv[1]) == '|'))
	    {
		    /*
		     *	have a continuation error message
		     *	of the form: |	message
		     */
		    if (err_type == ' ')
		    {
		    /*
		     *	Simple continuation, turn into form:
		     *		filename linenumber message
		     */
		    	nwordv = wordvsplice(1, wordc, wordv+1);
		    	wordc += 1;
		    }
		    else
		    {
		    /*
		     *	Previous error line was synchronization only,
		     *	so turn into form:
		     *		filename linenumber letter message
		     */
			nwordv = wordvsplice(2, wordc, wordv+1);
			nwordv[2] = strsave(&err_type);
		    	wordc += 2;
			err_type = ' ';
		    }
		    nwordv[0] = strsave(currentfilename);
		    nwordv[1] = strsave(c_linenumber);
		    wordv = nwordv - 1;
		    language = filetype;
		    return(C_TRUE);
	    }
	}
	if ((wordc == 4)
	    && (strcmp(wordv[1], "Object") == 0)
	    && (strcmp(wordv[2], "module") == 0)
	    && (strcmp(wordv[3], "not") == 0)
	    && (strcmp(wordv[4], "generated.") == 0))
	    {
	    /*
	     *	Compilation had enough serious errors to prevent
	     *	object module from being generated.  This is not
	     *	specific to any one file or line, so return that.
	     */
		language = filetype;
		return(C_NONSPEC);
	    }
	if (((wordc == 5) || (wordc == 6))
	    && (alldigits(wordv[1]))
	    && (alldigits(wordv[4]))
	    && (strcmp(wordv[2], "user") == 0)
	    && ((strcmp(wordv[3], "error") == 0)
	    	|| (strcmp(wordv[3], "errors") == 0)) )
	    {
	    /*
	     *	Compilation summary such as:
	     *		4 user errors 5 unprinted warnings
	     *  This is not specific, so return that.
	     */
		if ((wordc == 6) 
		    && (strcmp(wordv[5], "unprinted") == 0)
		    && ((strcmp(wordv[6], "warning") == 0)
		    	|| (strcmp(wordv[6], "warnings") == 0)) )
		    {
			language = filetype;
			return(C_NONSPEC);
		    }
		else
		if ((wordc == 5)
		    && ((strcmp(wordv[5], "warning") == 0)
		    	|| (strcmp(wordv[5], "warnings") == 0)) )
		    {
			language = filetype;
			return(C_NONSPEC);
		    }
		else
			return(C_UNKNOWN);
	    }
	else
	return(C_UNKNOWN);
}
